/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin.changebill;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.consts.DBRouteConst;
import kd.fi.cas.enums.ChangeStatusEnum;
import kd.fi.cas.enums.PayApplyRecChgStatusEnum;
import kd.fi.cas.helper.SBillTypeHelper;
import kd.fi.cas.util.EmptyUtil;

public class PayApplyRecChgDeletedOp
extends AbstractOperationServicePlugIn {
    private static final String RECCHG = "recchg";
    private static Log logger = LogFactory.getLog(SBillTypeHelper.class);
    private static final String SQL_UPDATE_AGPAYBILL = "update t_cas_agentpaybill_e set fchangestatus = ? where fid = ? and fchangestatus in('changing')";
    private static final String SQL_UPDATE_PAYMENTBILL = "update t_cas_paymentbill_e set fchangestatus = ? where fid = ? and fchangestatus in('changing')";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("id");
        fieldKeys.add("chgtype");
        fieldKeys.add("sourcetype");
        fieldKeys.add("sourcebillid");
        fieldKeys.add("entrys.sourceentryid");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        super.beginOperationTransaction(e);
        for (DynamicObject entity : dataEntities = e.getDataEntities()) {
            String sourceType = entity.getString("sourcetype");
            if ("cas_paybill".equals(sourceType) || "cas_agentpaybill".equals(sourceType)) {
                String changeStaus;
                Long sourcebillid = entity.getLong("sourcebillid");
                Long payChgId = entity.getLong("id");
                DynamicObject payBill = BusinessDataServiceHelper.loadSingle((Object)sourcebillid, (String)sourceType);
                QFilter qFilter = new QFilter("sourcebillid", "=", (Object)sourcebillid);
                qFilter.and("id", "!=", (Object)payChgId);
                DynamicObjectCollection payChgBills = QueryServiceHelper.query((String)"cas_paychgbill", (String)"id,iscashconfirm", (QFilter[])new QFilter[]{qFilter});
                if (EmptyUtil.isEmpty((DynamicObjectCollection)payChgBills)) {
                    changeStaus = ChangeStatusEnum.UNCHANGE.getValue();
                } else {
                    changeStaus = ChangeStatusEnum.CHANGED.getValue();
                    for (DynamicObject payChgBill : payChgBills) {
                        boolean iscashconfirm = payChgBill.getBoolean("iscashconfirm");
                        if (iscashconfirm) continue;
                        changeStaus = ChangeStatusEnum.CHANGING.getValue();
                        break;
                    }
                }
                if ("cas_paybill".equals(sourceType)) {
                    int result = DB.update((DBRoute)DBRouteConst.cas, (String)SQL_UPDATE_PAYMENTBILL, (Object[])new Object[]{changeStaus, sourcebillid});
                    if (result < 1) {
                        logger.error("update agpaybill sql fail,billId:" + sourcebillid + "");
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6e90\u4ee3\u53d1\u5355\u3010%1$s\u3011\u66f4\u65b0\u53d8\u66f4\u72b6\u6001\u4e0d\u6210\u529f\uff0c\u8bf7\u91cd\u8bd5\u3002", (String)"PaySureRecChgOp_1", (String)"fi-cas-opplugin", (Object[])new Object[0]), payBill.getString("billno")));
                    }
                    logger.info("update agpaybill sql succusse,billId:" + sourcebillid + "");
                } else if ("cas_agentpaybill".equals(sourceType)) {
                    int result = DB.update((DBRoute)DBRouteConst.cas, (String)SQL_UPDATE_AGPAYBILL, (Object[])new Object[]{changeStaus, sourcebillid});
                    if (result < 1) {
                        logger.error("update agpaybill sql fail,billId:" + sourcebillid + "");
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6e90\u4ee3\u53d1\u5355\u3010%1$s\u3011\u66f4\u65b0\u53d8\u66f4\u72b6\u6001\u4e0d\u6210\u529f\uff0c\u8bf7\u91cd\u8bd5\u3002", (String)"PaySureRecChgOp_1", (String)"fi-cas-opplugin", (Object[])new Object[0]), payBill.getString("billno")));
                    }
                    logger.info("update agpaybill sql succusse,billId:" + sourcebillid + "");
                }
            }
            DynamicObjectCollection entrys = entity.getDynamicObjectCollection("entrys");
            if (!entity.getString("chgtype").equals(RECCHG) || !entity.getString("sourcetype").equals("cas_payapplybill")) continue;
            for (DynamicObject entry : entrys) {
                QFilter filter = new QFilter("entrys.sourceentryid", "=", (Object)entry.getLong("sourceentryid"));
                DynamicObjectCollection resultdate = QueryServiceHelper.query((String)"cas_paychgbill", (String)"id,entrys.sourceentryid", (QFilter[])filter.toArray(), (String)"createtime DESC");
                Long sourcebillid = entity.getLong("sourcebillid");
                DynamicObject recchgEntity = BusinessDataServiceHelper.loadSingle((Object)sourcebillid, (String)"cas_payapplybill");
                DynamicObjectCollection payapply = recchgEntity.getDynamicObjectCollection("cas_payapplyentry");
                for (DynamicObject object : payapply) {
                    if (!object.getPkValue().equals(entry.getLong("sourceentryid"))) continue;
                    if (resultdate.size() <= 1) {
                        object.set("e_chgstatus", (Object)PayApplyRecChgStatusEnum.NOCHG.getValue());
                        break;
                    }
                    object.set("e_chgstatus", (Object)PayApplyRecChgStatusEnum.CHGED.getValue());
                    break;
                }
                SaveServiceHelper.update((DynamicObject)recchgEntity);
            }
        }
    }
}

