/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin.checkAcct;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.business.balancemodel.log.enums.BalanceType;
import kd.fi.cas.business.service.BalanceCountService;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.helper.BalanceAdjustHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.EntityPropertyHelper;
import kd.fi.cas.helper.ExtendConfigHelper;
import kd.fi.cas.helper.OperateServiceHelper;
import kd.fi.cas.helper.PeriodHelper;
import kd.fi.cas.helper.SystemStatusCtrolHelper;
import kd.fi.cas.util.DateUtils;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.validator.BalanceAdjustValidator;

public class BalanceAdjustSaveOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(BalanceAdjustSaveOp.class);
    private BalanceCountService balanceCountService = new BalanceCountService();

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fields = e.getFieldKeys();
        fields.add("bank_entry");
        fields.add("enter_entry");
        fields.addAll(EntityPropertyHelper.getPropertys((String)"cas_balanceadjust"));
        fields.addAll(EntityPropertyHelper.getEntryPropertys((String)"cas_balanceadjust", (String)"bank_entry"));
        fields.addAll(EntityPropertyHelper.getEntryPropertys((String)"cas_balanceadjust", (String)"enter_entry"));
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new BalanceAdjustValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        boolean useBalanceModel = ExtendConfigHelper.useBalanceModel();
        for (DynamicObject info : dataEntities) {
            Object jourTemp2;
            DynamicObjectCollection jourEntry = info.getDynamicObjectCollection("enter_entry");
            DynamicObjectCollection bankEntry = info.getDynamicObjectCollection("bank_entry");
            info.set("auditor", null);
            info.set("auditdate", null);
            DynamicObject org = info.getDynamicObject("org");
            DynamicObject accountBank = info.getDynamicObject("bankaccount");
            DynamicObject currency = info.getDynamicObject("currency");
            Date bizdate = info.getDate("bizdate");
            long orgId = org.getLong("id");
            long acctId = accountBank.getLong("id");
            long curId = currency.getLong("id");
            DynamicObject initObj = SystemStatusCtrolHelper.loadCashMgtInit((long)orgId);
            DynamicObject startperiod = initObj.getDynamicObject("startperiod");
            DynamicObject currentperiod = initObj.getDynamicObject("currentperiod");
            Date queryEndDate = DateUtils.getBeforeDate((Date)bizdate, (Date)new Date());
            Date startDate = startperiod.getDate("begindate");
            if (this.getOption().getVariables().containsKey("billstatus")) {
                initObj.set("isfinishinit", (Object)"0");
            }
            BigDecimal journalbalamt = BigDecimal.ZERO;
            BigDecimal statmntbalamt = BigDecimal.ZERO;
            if (useBalanceModel) {
                journalbalamt = this.balanceCountService.queryByBalanceModel(BalanceType.JOURNAL, orgId, acctId, curId, startDate, queryEndDate);
                statmntbalamt = this.balanceCountService.queryByBalanceModel(BalanceType.STATE, orgId, acctId, curId, startDate, queryEndDate);
                logger.info("--->>> BalanceAdjustSaveOp.beginOperationTransaction(),query balance from balance-model, journalbalamt={},statmntbalamt={}", (Object)String.valueOf(journalbalamt), (Object)String.valueOf(statmntbalamt));
            } else {
                journalbalamt = this.balanceCountService.getJournalBalanceByAccount(Long.valueOf(acctId), Long.valueOf(curId), queryEndDate);
                statmntbalamt = this.balanceCountService.getStatmBalance(Long.valueOf(orgId), Long.valueOf(acctId), Long.valueOf(curId), queryEndDate);
            }
            QFilter noInitFilter = new QFilter("period", "=", (Object)0);
            QFilter procFilters = new QFilter("accountbank", "=", accountBank.getPkValue()).and(new QFilter("currency", "=", currency.getPkValue())).and(new QFilter("ischeck", "=", (Object)"0")).and(new QFilter("isvalid", "=", (Object)"1"));
            QFilter noReachFilter = procFilters.copy().and(noInitFilter);
            QFilter journalNoReachFilter = procFilters.copy().and(noInitFilter);
            queryEndDate = bizdate;
            DynamicObject period = null;
            if (!this.getOption().getVariables().containsKey("billstatus")) {
                queryEndDate = DateUtils.getBeforeDate((Date)bizdate, (Date)new Date());
                if (initObj.getBoolean("isfinishinit")) {
                    Date currentEndDate = currentperiod.getDate("enddate");
                    if (queryEndDate.before(startDate)) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u7ed3\u675f\u65e5\u671f\u5e94\u665a\u4e8e\u7ec4\u7ec7\u542f\u7528\u671f\u95f4\u7684\u5f00\u59cb\u65e5\u671f\u3002", (String)"BalanceadjustValidator_1", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                    }
                    period = queryEndDate.after(currentEndDate) ? currentperiod : PeriodHelper.getPeriodByDate((long)org.getLong("id"), (Date)queryEndDate);
                    noReachFilter = procFilters.copy().and(new QFilter("bizDate", "<=", (Object)queryEndDate));
                    journalNoReachFilter = procFilters.copy().and(new QFilter("bookdate", "<=", (Object)queryEndDate));
                } else {
                    throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u7ec7\u672a\u7ed3\u675f\u51fa\u7eb3\u5e94\u7528\u6216\u8d44\u91d1\u7ed3\u7b97\u5e94\u7528\u7684\u521d\u59cb\u5316\uff0c\u4e0d\u5141\u8bb8\u751f\u6210\u4f59\u989d\u8c03\u8282\u8868\u3002", (String)"BalanceadjustValidator_2", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                }
            }
            List stateIds = BalanceAdjustHelper.getHasCheckedByDate((Long)orgId, (Long)acctId, (Long)curId, (Date)bizdate, (String)"cas_bankstatement");
            List journalIds = BalanceAdjustHelper.getHasCheckedByDate((Long)orgId, (Long)acctId, (Long)curId, (Date)bizdate, (String)"cas_bankjournal");
            QFilter noReachFilterOther = null;
            QFilter journalNoReachFilterOther = null;
            if (stateIds.size() > 0) {
                ArrayList stateIdsNew = new ArrayList(stateIds.size());
                stateIds.forEach(o -> stateIdsNew.add(Long.parseLong(o)));
                noReachFilterOther = new QFilter("id", "in", stateIdsNew);
            }
            if (journalIds.size() > 0) {
                ArrayList journalIdsNew = new ArrayList(journalIds.size());
                journalIds.forEach(o -> journalIdsNew.add(Long.parseLong(o)));
                journalNoReachFilterOther = new QFilter("id", "in", journalIdsNew);
            }
            Map<Object, String> reasonMap = jourEntry.stream().collect(Collectors.toMap(dyn -> dyn.get("billid"), dyn -> dyn.getString("enter_reason"), (e1, e2) -> e1));
            info = BalanceAdjustHelper.adJustAmount((DynamicObject)info, (BigDecimal)journalbalamt, (String)"cas_bankstatement", (QFilter[])new QFilter[]{noReachFilter, new QFilter("isbank", "=", (Object)"1")}, (boolean)false);
            if (noReachFilterOther != null) {
                BalanceAdjustHelper.adJustAmount((DynamicObject)info, (BigDecimal)journalbalamt, (String)"cas_bankstatement", (QFilter[])new QFilter[]{noReachFilterOther, new QFilter("isbank", "=", (Object)"1")}, (boolean)true);
            }
            DynamicObjectCollection jourTempEntry = info.getDynamicObjectCollection("enter_entry");
            for (Object jourTemp2 : jourTempEntry) {
                jourTemp2.set("enter_reason", (Object)reasonMap.get(jourTemp2.get("billid")));
            }
            reasonMap = bankEntry.stream().collect(Collectors.toMap(dyn -> dyn.get("bankbillid"), dyn -> dyn.getString("bank_reason"), (e1, e2) -> e1));
            info = BalanceAdjustHelper.adJustAmount((DynamicObject)info, (BigDecimal)statmntbalamt, (String)"cas_bankjournal", (QFilter[])new QFilter[]{journalNoReachFilter}, (boolean)false);
            if (journalNoReachFilterOther != null) {
                BalanceAdjustHelper.adJustAmount((DynamicObject)info, (BigDecimal)statmntbalamt, (String)"cas_bankjournal", (QFilter[])new QFilter[]{journalNoReachFilterOther}, (boolean)true);
            }
            DynamicObjectCollection bankTempEntry = info.getDynamicObjectCollection("bank_entry");
            jourTemp2 = bankTempEntry.iterator();
            while (jourTemp2.hasNext()) {
                DynamicObject bankTemp = (DynamicObject)jourTemp2.next();
                bankTemp.set("bank_reason", (Object)reasonMap.get(bankTemp.get("bankbillid")));
            }
            BalanceAdjustHelper.setDiffAndBankCg((DynamicObject)info);
            if (!this.getOption().containsVariable("directsubmit") || CasHelper.isEmpty((Object)this.getOption().getVariableValue("directsubmit"))) continue;
            ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(5);
            qFilterList.add(new QFilter("org", "=", org.getPkValue()));
            qFilterList.add(new QFilter("bankaccount", "=", accountBank.getPkValue()));
            qFilterList.add(new QFilter("currency", "=", currency.getPkValue()));
            qFilterList.add(new QFilter("bizdate", "<=", (Object)DateUtils.getDataFormat((Date)bizdate, (boolean)false)));
            qFilterList.add(new QFilter("billstatus", "=", (Object)BillStatusEnum.SAVE.getValue()));
            DynamicObjectCollection collection = QueryServiceHelper.query((String)"cas_balanceadjust", (String)"id", (QFilter[])qFilterList.toArray(new QFilter[0]));
            if (!EmptyUtil.isNoEmpty((DynamicObjectCollection)collection)) continue;
            Object[] ids = (Long[])collection.stream().map(d -> d.getLong("id")).toArray(Long[]::new);
            OperateServiceHelper.execOperate((String)"delete", (String)"cas_balanceadjust", (Object[])ids, (OperateOption)OperateOption.create());
        }
    }
}

