/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin.checkAcct;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.ReturnOperationArgs;
import kd.bos.entity.plugin.args.RollbackOperationArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.business.helper.BankAutoMatchCheckHelper;
import kd.fi.cas.business.helper.CheckResult;
import kd.fi.cas.compare.result.CompareResult;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.DynamicObjectHelper;
import kd.fi.cas.helper.EntityPropertyHelper;
import kd.fi.cas.helper.MutexServiceHelper;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.opplugin.checkAcct.MatchResult;
import kd.fi.cas.util.DateUtils;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.util.StringUtils;
import kd.fi.cas.validator.checkAcct.BankCheckValidator;

public class BankAutoMatchCheckOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(BankAutoMatchCheckOp.class);
    private static final String[] staticMatchField = new String[]{"id", "entryentity.e_rulesname", "entryentity.e_datafilterdesc_real_TAG"};
    private final Set<String> LOCK_SRC_STATEMENT_IDS = new HashSet<String>(10);
    private final Set<String> LOCK_TAR_JOURNAL_IDS = new HashSet<String>(10);

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        this.autoMatch(e);
    }

    @Deprecated
    private void autoMatch(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        ArrayList dataMap = new ArrayList(dataEntities.length);
        Date bizDate = null;
        Date bizDateend = null;
        for (int i = 0; i < dataEntities.length; ++i) {
            HashMap<String, Comparable<Long>> map = new HashMap<String, Comparable<Long>>();
            DynamicObject data = dataEntities[i];
            long orgId = data.getLong("org.id");
            long currencyId = data.getLong("currency.id");
            long accountbankId = data.getLong("accountbank.id");
            Boolean isUnreach = Boolean.FALSE;
            if (this.getOption().containsVariable("bizdate") && this.getOption().containsVariable("bizdateend")) {
                bizDate = DateUtils.stringToDate((String)this.getOption().getVariableValue("bizdate"), (String)"yyyy-MM-dd HH:mm:ss");
                bizDateend = DateUtils.stringToDate((String)this.getOption().getVariableValue("bizdateend"), (String)"yyyy-MM-dd HH:mm:ss");
                isUnreach = data.getBoolean("unreachdata");
            } else if (this.getOption().containsVariable("checkBeginDate") && this.getOption().getVariableValue("checkBeginDate") != null && this.getOption().containsVariable("checkEndDate") && this.getOption().getVariableValue("checkEndDate") != null) {
                bizDate = DateUtils.stringToDate((String)this.getOption().getVariableValue("checkBeginDate"), (String)"yyyy-MM-dd HH:mm:ss");
                bizDateend = DateUtils.stringToDate((String)this.getOption().getVariableValue("checkEndDate"), (String)"yyyy-MM-dd HH:mm:ss");
                logger.info("\u64cd\u4f5c\u81ea\u52a8\u5bf9\u8d26\u5f00\u59cb\u65e5\u671f\uff1a{}\uff0c\u7ed3\u675f\u65e5\u671f\uff1a{}", (Object)bizDate, (Object)bizDateend);
            }
            if (!data.containsProperty("unreachdata")) {
                isUnreach = Boolean.TRUE;
            }
            if (bizDate == null) {
                bizDate = DateUtils.getFrontDay((Date)new Date(), (int)90);
            }
            if (bizDateend == null) {
                bizDateend = new Date();
            }
            map.put("org", Long.valueOf(orgId));
            map.put("currency", Long.valueOf(currencyId));
            map.put("accountbank", Long.valueOf(accountbankId));
            map.put("bizdate", bizDate);
            map.put("bizdateend", bizDateend);
            map.put("unreachdata", isUnreach);
            dataMap.add(map);
            logger.info(String.format("\u5bf9\u8d26\u53c2\u6570\uff1aorgId:%s\u3001currency:%s\u3001accountbankId:%s\u3001bizdate:%s\u3001bizdateend:%s", orgId, currencyId, accountbankId, map.get("bizdate"), map.get("bizdateend")));
        }
        List results = BankAutoMatchCheckHelper.autoMatchCal(dataMap);
        ArrayList<DynamicObject> resultList = new ArrayList<DynamicObject>();
        ArrayList<Object> successPkIds = new ArrayList<Object>();
        ArrayList<OperateErrorInfo> operateErrors = new ArrayList<OperateErrorInfo>();
        int billCount = 0;
        if (results != null && results.size() > 0) {
            HashSet<Object> srcAllIds = new HashSet<Object>();
            HashSet<Object> tagAllIds = new HashSet<Object>();
            Set<String> srcLockIds = this.getLockIds(results, true);
            Set<String> tarLockIds = this.getLockIds(results, false);
            Map srcLockMap = MutexServiceHelper.batchRequest(new ArrayList<String>(srcLockIds), (String)"cas_checkresult", (String)"check_lock_statement_key");
            Map tarLockMap = MutexServiceHelper.batchRequest(new ArrayList<String>(tarLockIds), (String)"cas_checkresult", (String)"check_lock_journal_key");
            Set srcLockSuccessIds = srcLockMap.entrySet().stream().filter(s -> s.getValue() != null && (Boolean)s.getValue() != false).map(Map.Entry::getKey).collect(Collectors.toSet());
            Set tarLockSuccessIds = tarLockMap.entrySet().stream().filter(t -> t.getValue() != null && (Boolean)t.getValue() != false).map(Map.Entry::getKey).collect(Collectors.toSet());
            this.LOCK_SRC_STATEMENT_IDS.addAll(srcLockSuccessIds);
            this.LOCK_TAR_JOURNAL_IDS.addAll(tarLockSuccessIds);
            Set<String> srcLockFailedIds = srcLockMap.entrySet().stream().filter(s -> s.getValue() != null && (Boolean)s.getValue() == false).map(Map.Entry::getKey).collect(Collectors.toSet());
            Set<String> tarLockFailedIds = tarLockMap.entrySet().stream().filter(t -> t.getValue() != null && (Boolean)t.getValue() == false).map(Map.Entry::getKey).collect(Collectors.toSet());
            for (CheckResult result : results) {
                List rs = result.getCompareResults();
                Long ruleId = result.getRuleId();
                if (EmptyUtil.isEmpty((Collection)rs)) continue;
                for (CompareResult cs : rs) {
                    if (this.haveLockFailedId(srcLockFailedIds, cs.getSrcIdSet())) {
                        logger.info("auto check lock srcIds failed {}", (Object)cs);
                        continue;
                    }
                    if (this.haveLockFailedId(tarLockFailedIds, cs.getTarIdSet())) {
                        logger.info("auto check lock tarIds failed {}", (Object)cs);
                        continue;
                    }
                    ++billCount;
                    HashSet<Object> srcIds = new HashSet<Object>();
                    HashSet<Object> tagIds = new HashSet<Object>();
                    srcIds.addAll(cs.getSrcIdSet());
                    tagIds.addAll(cs.getTarIdSet());
                    Long pk = DB.genLongId((String)EntityMetadataCache.getDataEntityType((String)"cas_checkedresult").getAlias());
                    MatchResult matchResult = this.insertMatchResult(srcIds, tagIds, ruleId, pk, result);
                    if (StringUtils.isEmpty((String)matchResult.getErrorMessage())) {
                        resultList.add(matchResult.getCheckRes());
                        successPkIds.add(matchResult.getCheckRes().getPkValue());
                        srcAllIds.addAll(cs.getSrcIdSet());
                        tagAllIds.addAll(cs.getTarIdSet());
                        continue;
                    }
                    operateErrors.add(this.convertErrors(pk, matchResult));
                }
            }
            if (!resultList.isEmpty()) {
                this.updateIsCheck(srcAllIds, tagAllIds);
                SaveServiceHelper.save((DynamicObject[])resultList.toArray(new DynamicObject[0]));
            }
        }
        if (!CollectionUtils.isEmpty(operateErrors)) {
            this.operationResult.setSuccess(false);
            this.operationResult.setAllErrorInfo(operateErrors);
            this.operationResult.setShowMessage(false);
        } else {
            this.operationResult.setSuccess(true);
        }
        this.operationResult.setSuccessPkIds(successPkIds);
        this.operationResult.setBillCount(billCount);
    }

    private OperateErrorInfo convertErrors(Object pk, MatchResult matchResult) {
        OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
        operateErrorInfo.setLevel(ErrorLevel.Error);
        operateErrorInfo.setMessage(matchResult.getErrorMessage());
        operateErrorInfo.setPkValue(pk);
        return operateErrorInfo;
    }

    private void updateIsCheck(Set<Object> srcAllIds, Set<Object> tagAllIds) {
        String userId = RequestContext.get().getUserId();
        String stateSql = "update t_cas_bankstatement set fischeck=1 where fid in " + StringUtils.setToString(srcAllIds);
        DB.execute((DBRoute)new DBRoute(MetadataServiceHelper.getDataEntityType((String)"cas_bankstatement").getDBRouteKey()), (String)stateSql, (Object[])new Object[0]);
        String journalSql = "update t_cas_bankjournal set fischeck=1 where fid in " + StringUtils.setToString(tagAllIds);
        DB.execute((DBRoute)new DBRoute(MetadataServiceHelper.getDataEntityType((String)"cas_bankjournal").getDBRouteKey()), (String)journalSql, (Object[])new Object[0]);
    }

    private boolean checkAmount(DynamicObjectCollection statms, DynamicObjectCollection journals) {
        BigDecimal debitAmount = BigDecimal.ZERO;
        BigDecimal creditAmount = BigDecimal.ZERO;
        for (DynamicObject statm : statms) {
            debitAmount = debitAmount.add(statm.getBigDecimal("debitamount"));
            creditAmount = creditAmount.add(statm.getBigDecimal("creditamount"));
        }
        for (DynamicObject journal : journals) {
            debitAmount = debitAmount.add(journal.getBigDecimal("debitamount"));
            creditAmount = creditAmount.add(journal.getBigDecimal("creditamount"));
        }
        return debitAmount.compareTo(creditAmount) == 0;
    }

    private MatchResult insertMatchResult(Set<Object> srcIds, Set<Object> tagIds, Object ruleId, Object pk, CheckResult r) {
        Date bizData = r.getBizData();
        Date bizDataEnd = r.getBizDataEnd();
        boolean unReachData = r.getUnReachData();
        ArrayList<Long> srcIdsList = new ArrayList<Long>(10);
        for (String string : srcIds) {
            srcIdsList.add(Long.valueOf(string));
        }
        ArrayList<Long> arrayList = new ArrayList<Long>(10);
        for (String string : tagIds) {
            arrayList.add(Long.valueOf(string));
        }
        QFilter[] qFilterArray = new QFilter[]{new QFilter("id", "in", srcIdsList)};
        QFilter[] tagFilter = new QFilter[]{new QFilter("id", "in", arrayList)};
        DynamicObjectCollection statms = QueryServiceHelper.query((String)"cas_bankstatement", (String)this.getfields("cas_bankstatement"), (QFilter[])qFilterArray);
        DynamicObjectCollection journals = QueryServiceHelper.query((String)"cas_bankjournal", (String)this.getfields("cas_bankjournal"), (QFilter[])tagFilter);
        MatchResult result = new MatchResult();
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)statms) && EmptyUtil.isNoEmpty((DynamicObjectCollection)journals)) {
            logger.info("--->> BankAutoMatchCheckOp.insertMatchResult(): statms.size()={},journals.size()={}", (Object)statms.size(), (Object)journals.size());
            if (!this.checkAmount(statms, journals)) {
                logger.info("<<--- BankAutoMatchCheckOp.insertMatchResult(): checkAmount result=fasle");
                result.setErrorMessage(String.format(ResManager.loadKDString((String)"\u65e0\u81ea\u52a8\u5bf9\u8d26\u7ed3\u679c\u3002%1$s - %2$s \u671f\u95f4\u5185\u65e0\u7b26\u5408\u81ea\u52a8\u5bf9\u8d26\u89c4\u5219\u7684\u6570\u636e\u3002", (String)"BankAutoMatchCheckOp_3", (String)"fi-cas-opplugin", (Object[])new Object[0]), DateUtils.formatString((Date)bizData, (String)"yyyy-MM-dd"), DateUtils.formatString((Date)bizDataEnd, (String)"yyyy-MM-dd")));
                return result;
            }
            DynamicObject statm = (DynamicObject)statms.get(0);
            DynamicObject balance = BankAutoMatchCheckOp.getLastBalanceAdjust(statm);
            if (balance != null) {
                Date bizDate = balance.getDate("bizdate");
                Date stateDate = null;
                Date journalDate = null;
                for (DynamicObject stateColl : statms) {
                    Date tempDateState = stateColl.getDate("bizdate");
                    stateDate = stateDate == null ? tempDateState : (stateDate.before(tempDateState) ? tempDateState : stateDate);
                }
                for (DynamicObject journalColl : journals) {
                    Date tempDateJournal = journalColl.getDate("bookdate");
                    journalDate = journalDate == null ? tempDateJournal : (journalDate.before(tempDateJournal) ? tempDateJournal : journalDate);
                }
                boolean isBoolean = SystemParameterHelper.getParameterBoolean((long)DynamicObjectHelper.getPk((DynamicObject)statm, (String)"org"), (String)"cs095");
                if (!isBoolean && stateDate != null && journalDate != null && stateDate.compareTo(bizDate) <= 0 && journalDate.compareTo(bizDate) <= 0) {
                    String message = "";
                    if (!unReachData) {
                        message = String.format(ResManager.loadKDString((String)"%1$s - %2$s \u671f\u95f4\u5185", (String)"BankAutoMatchCheckOp_2", (String)"fi-cas-opplugin", (Object[])new Object[0]), DateUtils.formatString((Date)bizData, (String)"yyyy-MM-dd"), DateUtils.formatString((Date)bizDataEnd, (String)"yyyy-MM-dd"));
                    }
                    result.setErrorMessage(String.format(ResManager.loadKDString((String)"\u65e0\u81ea\u52a8\u5bf9\u8d26\u7ed3\u679c\u3002%s\u5b58\u5728\u975e\u6682\u5b58\u72b6\u6001\u7684\u4f59\u989d\u8c03\u8282\u8868\uff0c\u65e0\u6cd5\u52fe\u5bf9\u3002", (String)"BankAutoMatchCheckOp_4", (String)"fi-cas-opplugin", (Object[])new Object[0]), message));
                    return result;
                }
            }
            QFilter listFilter = new QFilter("id", "=", ruleId);
            CharSequence[] matchField = staticMatchField;
            DynamicObjectCollection matchs = QueryServiceHelper.query((String)"cas_reconciliationrule", (String)String.join((CharSequence)",", matchField), (QFilter[])new QFilter[]{listFilter});
            DynamicObject checkResult = BusinessDataServiceHelper.newDynamicObject((String)"cas_checkedresult");
            checkResult.set("checktype", (Object)"byauto");
            checkResult.set("id", pk);
            checkResult.set("checkdate", (Object)new Date());
            checkResult.set("accountbank", statm.get("accountbank"));
            checkResult.set("currency", statm.get("currency"));
            checkResult.set("company", statm.get("org"));
            checkResult.set("creator", (Object)CasHelper.getCurrentUser());
            checkResult.set("modifier", (Object)CasHelper.getCurrentUser());
            checkResult.set("createtime", (Object)new Date());
            checkResult.set("batchno", (Object)"1");
            this.setRuleToMatchResult(checkResult, matchs);
            this.addEntryResult(checkResult, statms, journals);
            result.setCheckRes(checkResult);
            return result;
        }
        logger.info("--->> BankAutoMatchCheckOp.insertMatchResult(): statms is null,journals is null");
        result.setErrorMessage(String.format(ResManager.loadKDString((String)"\u65e0\u81ea\u52a8\u5bf9\u8d26\u7ed3\u679c\u3002%1$s - %2$s \u671f\u95f4\u5185\u65e0\u7b26\u5408\u81ea\u52a8\u5bf9\u8d26\u89c4\u5219\u7684\u6570\u636e\u3002", (String)"BankAutoMatchCheckOp_3", (String)"fi-cas-opplugin", (Object[])new Object[0]), DateUtils.formatString((Date)bizData, (String)"yyyy-MM-dd"), DateUtils.formatString((Date)bizDataEnd, (String)"yyyy-MM-dd")));
        return result;
    }

    public static DynamicObject getLastBalanceAdjust(DynamicObject statm) {
        QFilter filter = new QFilter("org", "=", statm.get("org")).and(new QFilter("bankaccount", "=", statm.get("accountbank"))).and(new QFilter("currency", "=", statm.get("currency"))).and("billstatus", "!=", (Object)BillStatusEnum.SAVE.getValue()).and("period", "!=", (Object)0L);
        DynamicObjectCollection balances = QueryServiceHelper.query((String)"cas_balanceadjust", (String)"id,billstatus,bizdate", (QFilter[])new QFilter[]{filter}, (String)"bizdate desc", (int)1);
        if (balances != null && balances.size() > 0) {
            return (DynamicObject)balances.get(0);
        }
        return null;
    }

    private void setRuleToMatchResult(DynamicObject checkResult, DynamicObjectCollection matchs) {
        if (matchs == null || matchs.size() == 0) {
            return;
        }
        StringBuilder ruleTag = new StringBuilder(128);
        matchs.forEach(match -> ruleTag.append(match.get("entryentity.e_datafilterdesc_real_TAG")));
        checkResult.set("matchruleid", ((DynamicObject)matchs.get(0)).get("id"));
        checkResult.set("matchrule_tag", (Object)ruleTag);
    }

    private void addEntryResult(DynamicObject checkResult, DynamicObjectCollection statms, DynamicObjectCollection journals) {
        this.setEntryValue(statms, checkResult, "cas_bankstatement");
        this.setEntryValue(journals, checkResult, "cas_bankjournal");
    }

    private void setEntryValue(DynamicObjectCollection colls, DynamicObject checkResult, String bizObject) {
        BigDecimal amount = BigDecimal.ZERO;
        String direction = null;
        DynamicObjectCollection entry = checkResult.getDynamicObjectCollection("entry");
        for (DynamicObject coll : colls) {
            DynamicObject row = entry.addNew();
            row.set("org", coll.get("org"));
            row.set("bizdate", (Object)coll.getDate("cas_bankstatement".equals(bizObject) ? "bizdate" : "bookdate"));
            row.set("debitamount", (Object)coll.getBigDecimal("debitamount"));
            row.set("creditamount", (Object)coll.getBigDecimal("creditamount"));
            row.set("bizobject", (Object)bizObject);
            row.set("bizobjectid", coll.get("id"));
            row.set("oppunit", (Object)coll.getString("oppunit"));
            row.set("description", (Object)coll.getString("description"));
            row.set("settlementnumber", (Object)coll.getString("settlementnumber"));
            row.set("settlementtype", coll.get("settlementtype"));
            row.set("ischeck", (Object)"1");
            row.set("vouchernumber", (Object)("cas_bankstatement".equals(bizObject) ? coll.getString("vouchernumber") : ""));
            amount = amount.add(coll.getBigDecimal("debitamount").intValue() != 0 ? coll.getBigDecimal("debitamount") : coll.getBigDecimal("creditamount"));
            String string = direction = coll.getBigDecimal("debitamount").intValue() != 0 ? "debit" : "credit";
            if ("cas_bankjournal".equals(bizObject)) {
                row.set("pddate", coll.get("pddate"));
                row.set("avddate", coll.get("avddate"));
                row.set("sysdate", coll.get("createtime"));
                row.set("oppacctnumber", coll.get("oppacctnumber"));
                row.set("sourcebillnumber", coll.get("sourcebillnumber"));
                row.set("source", (Object)("0" + coll.get("source")));
                row.set("cashier", coll.get("cashier"));
                row.set("bankcheckflag_tag", (Object)coll.getString("bankcheckflag_tag"));
                row.set("bankcheckflag", (Object)coll.getString("bankcheckflag"));
                Set props = EntityPropertyHelper.setPropsByEntityExt((DynamicObject)row);
                if (props.size() <= 0) continue;
                props.forEach(p -> row.set(p, coll.get(p)));
                continue;
            }
            row.set("bankcheckflag", (Object)coll.getString("bankcheckflag"));
            row.set("oppacctnumber", coll.get("oppaccountnumber"));
            row.set("balanceamt", coll.get("balanceamt"));
            row.set("tradenumber", coll.get("tradenumber"));
            row.set("bankvouvherno", coll.get("bankvouvherno"));
            row.set("source", coll.get("source"));
        }
        if ("cas_bankstatement".equals(bizObject)) {
            checkResult.set("stateamount", (Object)amount);
            checkResult.set("statedirection", direction);
        } else {
            checkResult.set("journalamount", (Object)amount);
            checkResult.set("journaldirection", direction);
        }
    }

    private String getfields(String entityName) {
        String fields = "id,org,accountbank,currency,bizdate,debitamount,creditamount,oppunit,description,settlementnumber,settlementtype,ischeck,source";
        if ("cas_bankjournal".equals(entityName)) {
            EntryProp prop = (EntryProp)EntityMetadataCache.getDataEntityType((String)"cas_checkedresult").findProperty("entry");
            DynamicObject entryObject = new DynamicObject(prop.getDynamicCollectionItemPropertyType());
            Set props = EntityPropertyHelper.setPropsByEntityExt((DynamicObject)entryObject);
            if (props.size() > 0) {
                fields = fields + "," + String.join((CharSequence)",", props);
            }
            return fields + ",avddate,pddate,feepayer,createtime,oppacctnumber,sourcebillnumber,cashier,bookdate,bankcheckflag,bankcheckflag_tag";
        }
        if ("cas_bankstatement".equals(entityName)) {
            return fields + ",ratesdate,bankvouvherno,tradenumber,oppaccountnumber,balanceamt,vouchernumber,bankcheckflag";
        }
        return fields;
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("accountbank");
        e.getFieldKeys().add("currency");
        e.getFieldKeys().add("bizdate");
        e.getFieldKeys().add("bizdateend");
        e.getFieldKeys().add("org");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new BankCheckValidator());
    }

    public void onReturnOperation(ReturnOperationArgs e) {
        this.releaseLock();
    }

    public void rollbackOperation(RollbackOperationArgs e) {
        this.releaseLock();
    }

    private void releaseLock() {
        if (!this.LOCK_SRC_STATEMENT_IDS.isEmpty()) {
            MutexServiceHelper.batchRelease(new ArrayList<String>(this.LOCK_SRC_STATEMENT_IDS), (String)"cas_checkresult", (String)"check_lock_statement_key");
            this.LOCK_SRC_STATEMENT_IDS.clear();
        }
        if (!this.LOCK_TAR_JOURNAL_IDS.isEmpty()) {
            MutexServiceHelper.batchRelease(new ArrayList<String>(this.LOCK_TAR_JOURNAL_IDS), (String)"cas_checkresult", (String)"check_lock_journal_key");
            this.LOCK_TAR_JOURNAL_IDS.clear();
        }
    }

    private boolean haveLockFailedId(Set<String> lockFailedIds, Set<Object> ids) {
        if (EmptyUtil.isEmpty(lockFailedIds) || EmptyUtil.isEmpty(ids)) {
            return false;
        }
        Set isStrSet = ids.stream().map(Objects::toString).collect(Collectors.toSet());
        for (String lockFailedId : lockFailedIds) {
            if (!isStrSet.contains(lockFailedId)) continue;
            return true;
        }
        return false;
    }

    private Set<String> getLockIds(List<CheckResult> results, boolean isSrc) {
        HashSet<String> idStrSet = new HashSet<String>(10);
        for (CheckResult result : results) {
            List rs = result.getCompareResults();
            if (EmptyUtil.isEmpty((Collection)rs)) continue;
            for (CompareResult r : rs) {
                if (isSrc) {
                    if (!EmptyUtil.isNoEmpty((Object)r.getSrcIdSet())) continue;
                    Set srcIds = r.getSrcIdSet().stream().map(Objects::toString).collect(Collectors.toSet());
                    idStrSet.addAll(srcIds);
                    continue;
                }
                if (!EmptyUtil.isNoEmpty((Object)r.getTarIdSet())) continue;
                Set tarIds = r.getTarIdSet().stream().map(Objects::toString).collect(Collectors.toSet());
                idStrSet.addAll(tarIds);
            }
        }
        return idStrSet;
    }
}

