/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin.entrust;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.helper.CasBotpHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.OperateServiceHelper;
import kd.fi.cas.opplugin.entrust.AbstractEntrustOp;
import kd.fi.cas.validator.entrust.PaymentOrAgentCancelEntrustValidator;

public class AgentCancelEntrustOp
extends AbstractEntrustOp {
    private static final Log logger = LogFactory.getLog(AgentCancelEntrustOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("delegorg");
        fieldKeys.add("billno");
        fieldKeys.add("entrustamt");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new PaymentOrAgentCancelEntrustValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] agentBills = e.getDataEntities();
        Long[] sourceIds = (Long[])Arrays.stream(agentBills).map(ag -> (Long)ag.getPkValue()).toArray(Long[]::new);
        HashMap delTargetIdMap = new HashMap((int)((double)sourceIds.length / 0.75 + 1.0));
        for (Long l : sourceIds) {
            Set targetIdSet = CasBotpHelper.getDestBillBySrcBill((String)"cas_agentpaybill", (Long)l, (String)"cas_agentpaybill");
            Set delTargetIds = targetIdSet.stream().filter(targetId -> {
                QFilter[] filters = new QFilter("id", "=", targetId).and("billstatus", "=", (Object)BillStatusEnum.SAVE.getValue()).toArray();
                return QueryServiceHelper.exists((String)"cas_agentpaybill", (QFilter[])filters);
            }).collect(Collectors.toSet());
            if (!CollectionUtils.isNotEmpty(delTargetIds)) continue;
            delTargetIdMap.put(l, delTargetIds);
        }
        if (!delTargetIdMap.isEmpty()) {
            OperationResult result;
            Object[] delTargetIds = (Long[])delTargetIdMap.values().stream().flatMap(Collection::stream).toArray(Long[]::new);
            try {
                result = OperateServiceHelper.execOperate((String)"delegdelte", (String)"cas_agentpaybill", (Object[])delTargetIds, (OperateOption)OperateOption.create());
            }
            catch (Exception ex) {
                logger.error("agentpaybill cancel entrust delegdelte error", (Throwable)ex);
                String string = ResManager.loadKDString((String)"\u4e0b\u6e38\u5355\u636e: %s", (String)"PaymentCancelEntrustOp_1", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                throw new KDBizException(String.format(string, ex.getMessage()));
            }
            if (!result.isSuccess()) {
                String fmtMsg = ResManager.loadKDString((String)"\u4e0b\u6e38\u5355\u636e: %s", (String)"PaymentCancelEntrustOp_1", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                throw new KDBizException(String.format(fmtMsg, CasHelper.getFailResultMsg((OperationResult)result)));
            }
            for (Map.Entry entry : delTargetIdMap.entrySet()) {
                Long[] sourceIdArr = new Long[]{(Long)entry.getKey()};
                for (Long targetId2 : (Set)entry.getValue()) {
                    CasBotpHelper.deleteRation((String)"cas_agentpaybill", (Long[])sourceIdArr, (Long)targetId2);
                }
            }
        }
        for (Long l : agentBills) {
            l.set("entrustamt", BigDecimal.ZERO);
        }
        SaveServiceHelper.update((DynamicObject[])agentBills);
    }
}

