/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin.init;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.business.balancemodel.log.enums.OperateType;
import kd.fi.cas.business.balancemodel.log.helper.BalanceModelLogHelper;
import kd.fi.cas.helper.DynamicObjectHelper;
import kd.fi.cas.util.EmptyUtil;

public class CasResetInitBalanceAuditOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List keys = e.getFieldKeys();
        keys.add("creator");
        keys.add("createtime");
        keys.add("org");
        keys.add("resetinitbalperiod");
        keys.add("entryentity.type");
        keys.add("entryentity.cash_accountcash");
        keys.add("entryentity.bank_accountbank");
        keys.add("entryentity.initbalance");
        keys.add("entryentity.currency");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] entities = e.getDataEntities();
        ArrayList<DynamicObject> balanceAccount = new ArrayList<DynamicObject>(entities.length);
        ArrayList<DynamicObject> saveBalanceAccount = new ArrayList<DynamicObject>(entities.length);
        ArrayList<DynamicObject> initCas = new ArrayList<DynamicObject>(entities.length);
        ArrayList<DynamicObject> updateBalanceBills = new ArrayList<DynamicObject>(10);
        for (DynamicObject entity : entities) {
            DynamicObject orgDynamic = entity.getDynamicObject("org");
            DynamicObject resetPeriod = entity.getDynamicObject("resetinitbalperiod");
            String mapKey = orgDynamic.getLong("id") + "_" + resetPeriod.getLong("id");
            DynamicObjectCollection accounts = entity.getDynamicObjectCollection("entryentity");
            HashMap<String, List<String>> addResetInitData = new HashMap<String, List<String>>(10);
            QFilter[] filter = new QFilter[]{new QFilter("org", "=", orgDynamic.getPkValue())};
            DynamicObject casInit = BusinessDataServiceHelper.loadSingle((String)"cas_cashmgtinit", (String)"id,resetbalance,resetbalperiod", (QFilter[])filter);
            casInit.set("resetbalance", (Object)true);
            casInit.set("resetbalperiod", (Object)resetPeriod);
            initCas.add(casInit);
            for (DynamicObject account : accounts) {
                this.updateCash(entity, account, balanceAccount, saveBalanceAccount);
                this.updateBank(entity, account, balanceAccount, saveBalanceAccount);
                this.handleResetData(account, addResetInitData, mapKey);
            }
            this.discardDate(entity, addResetInitData, updateBalanceBills);
        }
        if (updateBalanceBills.size() > 0) {
            SaveServiceHelper.update((DynamicObject[])updateBalanceBills.toArray(new DynamicObject[0]));
        }
        if (balanceAccount.size() > 0) {
            SaveServiceHelper.update((DynamicObject[])balanceAccount.toArray(new DynamicObject[0]));
        }
        if (saveBalanceAccount.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])saveBalanceAccount.toArray(new DynamicObject[0]));
        }
        if (initCas.size() > 0) {
            SaveServiceHelper.update((DynamicObject[])initCas.toArray(new DynamicObject[0]));
        }
        BalanceModelLogHelper.doBalanceModelLog((DynamicObject[])entities, (OperateType)OperateType.ADD);
    }

    private void updateCash(DynamicObject entity, DynamicObject account, List<DynamicObject> balanceAccount, List<DynamicObject> saveBalanceAccount) {
        String type = account.getString("type");
        if (!"cash".equals(type)) {
            return;
        }
        DynamicObject orgDynamic = entity.getDynamicObject("org");
        DynamicObject resetPeriod = entity.getDynamicObject("resetinitbalperiod");
        DynamicObject currency = account.getDynamicObject("currency");
        QFilter qFilter = new QFilter("org", "=", orgDynamic.getPkValue()).and(new QFilter("period", "=", resetPeriod.getPkValue()));
        DynamicObject cash = account.getDynamicObject("cash_accountcash");
        qFilter.and(new QFilter("accountcash", "=", cash.getPkValue()));
        qFilter.and(new QFilter("currency", "=", currency.getPkValue()));
        qFilter.and(new QFilter("type", "=", (Object)"1"));
        DynamicObject cashDynamicObject = BusinessDataServiceHelper.loadSingle((String)"cas_journalbalance", (String)"id, accountbank, accountcash, monthstart,monthdebit, monthcredit, monthbalance", (QFilter[])new QFilter[]{qFilter});
        if (EmptyUtil.isNoEmpty((DynamicObject)cashDynamicObject)) {
            BigDecimal monthStart = account.getBigDecimal("initbalance");
            BigDecimal monthDebit = cashDynamicObject.getBigDecimal("monthdebit");
            BigDecimal monthCredit = cashDynamicObject.getBigDecimal("monthcredit");
            cashDynamicObject.set("monthstart", (Object)monthStart);
            cashDynamicObject.set("monthbalance", (Object)monthStart.add(monthDebit).subtract(monthCredit));
            balanceAccount.add(cashDynamicObject);
        } else {
            saveBalanceAccount.add(this.createCash(entity, account));
        }
    }

    private void updateBank(DynamicObject entity, DynamicObject account, List<DynamicObject> balanceAccount, List<DynamicObject> saveBalanceAccount) {
        String type = account.getString("type");
        if (!"bank".equals(type)) {
            return;
        }
        DynamicObject orgDynamic = entity.getDynamicObject("org");
        DynamicObject resetPeriod = entity.getDynamicObject("resetinitbalperiod");
        DynamicObject currency = account.getDynamicObject("currency");
        QFilter qFilter = new QFilter("org", "=", orgDynamic.getPkValue()).and(new QFilter("period", "=", resetPeriod.getPkValue()));
        DynamicObject bank = account.getDynamicObject("bank_accountbank");
        qFilter.and(new QFilter("accountbank", "=", bank.getPkValue()));
        qFilter.and(new QFilter("currency", "=", currency.getPkValue()));
        qFilter.and(new QFilter("type", "=", (Object)"2"));
        DynamicObject bankDynamicObject = BusinessDataServiceHelper.loadSingle((String)"cas_journalbalance", (String)"id, accountbank, accountcash, monthstart,monthdebit, monthcredit, monthbalance", (QFilter[])new QFilter[]{qFilter});
        if (EmptyUtil.isNoEmpty((DynamicObject)bankDynamicObject)) {
            BigDecimal monthStart = account.getBigDecimal("initbalance");
            BigDecimal monthDebit = bankDynamicObject.getBigDecimal("monthdebit");
            BigDecimal monthCredit = bankDynamicObject.getBigDecimal("monthcredit");
            bankDynamicObject.set("monthstart", (Object)monthStart);
            bankDynamicObject.set("monthbalance", (Object)monthStart.add(monthDebit).subtract(monthCredit));
            balanceAccount.add(bankDynamicObject);
        } else {
            saveBalanceAccount.add(this.createBank(entity, account));
        }
    }

    private DynamicObject createCash(DynamicObject entity, DynamicObject entryCash) {
        DynamicObject journalBalance = BusinessDataServiceHelper.newDynamicObject((String)"cas_journalbalance");
        DynamicObjectHelper.setValue((DynamicObject)journalBalance, (String)"type", (Object)"1");
        DynamicObjectHelper.setValue((DynamicObject)journalBalance, (String)"enable", (Object)1);
        DynamicObjectHelper.setValue((DynamicObject)journalBalance, (String)"ctrlstrategy", (Object)5);
        DynamicObjectHelper.setValue((DynamicObject)journalBalance, (String)"creator", (Object)entity.getDynamicObject("creator"));
        DynamicObjectHelper.setValue((DynamicObject)journalBalance, (String)"createtime", (Object)entity.getDate("createtime"));
        DynamicObjectHelper.setValue((DynamicObject)journalBalance, (String)"org", (Object)entity.getDynamicObject("org"));
        DynamicObjectHelper.setValue((DynamicObject)journalBalance, (String)"period", (Object)entity.getDynamicObject("resetinitbalperiod"));
        DynamicObjectHelper.setValue((DynamicObject)journalBalance, (String)"accountcash", (Object)entryCash.getDynamicObject("cash_accountcash"));
        DynamicObjectHelper.setValue((DynamicObject)journalBalance, (String)"currency", (Object)entryCash.getDynamicObject("currency"));
        DynamicObjectHelper.setValue((DynamicObject)journalBalance, (String)"monthstart", (Object)entryCash.getBigDecimal("initbalance"));
        DynamicObjectHelper.setValue((DynamicObject)journalBalance, (String)"monthdebit", (Object)new BigDecimal(0));
        DynamicObjectHelper.setValue((DynamicObject)journalBalance, (String)"monthcredit", (Object)new BigDecimal(0));
        DynamicObjectHelper.setValue((DynamicObject)journalBalance, (String)"monthbalance", (Object)new BigDecimal(0));
        DynamicObjectHelper.setValue((DynamicObject)journalBalance, (String)"yearstart", (Object)new BigDecimal(0));
        DynamicObjectHelper.setValue((DynamicObject)journalBalance, (String)"isbalanced", (Object)0);
        return journalBalance;
    }

    private DynamicObject createBank(DynamicObject entity, DynamicObject entryBank) {
        DynamicObject journalBalance = BusinessDataServiceHelper.newDynamicObject((String)"cas_journalbalance");
        DynamicObjectHelper.setValue((DynamicObject)journalBalance, (String)"type", (Object)"2");
        DynamicObjectHelper.setValue((DynamicObject)journalBalance, (String)"enable", (Object)1);
        DynamicObjectHelper.setValue((DynamicObject)journalBalance, (String)"ctrlstrategy", (Object)5);
        DynamicObjectHelper.setValue((DynamicObject)journalBalance, (String)"creator", (Object)entity.getDynamicObject("creator"));
        DynamicObjectHelper.setValue((DynamicObject)journalBalance, (String)"createtime", (Object)entity.getDate("createtime"));
        DynamicObjectHelper.setValue((DynamicObject)journalBalance, (String)"org", (Object)entity.getDynamicObject("org"));
        DynamicObjectHelper.setValue((DynamicObject)journalBalance, (String)"period", (Object)entity.getDynamicObject("resetinitbalperiod"));
        DynamicObjectHelper.setValue((DynamicObject)journalBalance, (String)"accountbank", (Object)entryBank.getDynamicObject("bank_accountbank"));
        DynamicObjectHelper.setValue((DynamicObject)journalBalance, (String)"currency", (Object)entryBank.getDynamicObject("currency"));
        DynamicObjectHelper.setValue((DynamicObject)journalBalance, (String)"monthstart", (Object)entryBank.getBigDecimal("initbalance"));
        DynamicObjectHelper.setValue((DynamicObject)journalBalance, (String)"monthdebit", (Object)new BigDecimal(0));
        DynamicObjectHelper.setValue((DynamicObject)journalBalance, (String)"monthcredit", (Object)new BigDecimal(0));
        DynamicObjectHelper.setValue((DynamicObject)journalBalance, (String)"monthbalance", (Object)entryBank.getBigDecimal("initbalance"));
        DynamicObjectHelper.setValue((DynamicObject)journalBalance, (String)"yearstart", (Object)entryBank.getBigDecimal("initbalance").subtract(BigDecimal.ZERO).add(BigDecimal.ZERO));
        DynamicObjectHelper.setValue((DynamicObject)journalBalance, (String)"yeardebit", (Object)BigDecimal.ZERO);
        DynamicObjectHelper.setValue((DynamicObject)journalBalance, (String)"yearcredit", (Object)BigDecimal.ZERO);
        DynamicObjectHelper.setValue((DynamicObject)journalBalance, (String)"yearbalance", (Object)entryBank.getBigDecimal("initbalance"));
        DynamicObjectHelper.setValue((DynamicObject)journalBalance, (String)"openorg", (Object)entryBank.getDynamicObject("bank_accountbank").getDynamicObject("openorg"));
        DynamicObjectHelper.setValue((DynamicObject)journalBalance, (String)"isbalanced", (Object)0);
        return journalBalance;
    }

    private void handleResetData(DynamicObject account, Map<String, List<String>> addResetInitData, String mapKey) {
        String type = account.getString("type");
        DynamicObject currency = account.getDynamicObject("currency");
        String mapValue = currency.getLong("id") + "_" + type;
        if ("cash".equals(type)) {
            DynamicObject cashObject = account.getDynamicObject("cash_accountcash");
            mapValue = mapValue + "_" + cashObject.getLong("id");
        } else {
            DynamicObject bankObject = account.getDynamicObject("bank_accountbank");
            mapValue = mapValue + "_" + bankObject.getLong("id");
        }
        List<String> listValue = addResetInitData.get(mapKey);
        if (listValue == null) {
            listValue = new ArrayList<String>(64);
            addResetInitData.put(mapKey, listValue);
        }
        listValue.add(mapValue);
    }

    private void discardDate(DynamicObject entity, Map<String, List<String>> addResetInitData, List<DynamicObject> updateBalanceBills) {
        DynamicObject[] historyBalanceBills;
        QFilter qFilter = new QFilter("org", "in", entity.getDynamicObject("org").getPkValue()).and(new QFilter("billstatus", "=", (Object)"C")).and(new QFilter("resetinitbalperiod", "=", entity.getDynamicObject("resetinitbalperiod").getPkValue()));
        QFilter[] filter = new QFilter[]{qFilter};
        for (DynamicObject history : historyBalanceBills = BusinessDataServiceHelper.load((String)"cas_resetinitbalance", (String)"id, billno, discard,entryentity.cash_accountcash, entryentity.bank_accountbank,org,resetinitbalperiod, entryentity.type, entryentity.currency, entryentity.discarded", (QFilter[])filter)) {
            DynamicObject orgDynamic = history.getDynamicObject("org");
            DynamicObject resetPeriod = history.getDynamicObject("resetinitbalperiod");
            String mapKey = orgDynamic.getLong("id") + "_" + resetPeriod.getLong("id");
            List<String> addNewAccounts = addResetInitData.get(mapKey);
            if (addNewAccounts == null || addNewAccounts.size() == 0) continue;
            DynamicObjectCollection accounts = history.getDynamicObjectCollection("entryentity");
            for (DynamicObject account : accounts) {
                String type = account.getString("type");
                DynamicObject currency = account.getDynamicObject("currency");
                String mapValue = currency.getLong("id") + "_" + type;
                if ("cash".equals(type)) {
                    DynamicObject cashObject = account.getDynamicObject("cash_accountcash");
                    mapValue = mapValue + "_" + cashObject.getLong("id");
                } else {
                    DynamicObject bankObject = account.getDynamicObject("bank_accountbank");
                    mapValue = mapValue + "_" + bankObject.getLong("id");
                }
                if (!addNewAccounts.contains(mapValue)) continue;
                account.set("discarded", (Object)true);
            }
            updateBalanceBills.add(history);
        }
    }
}

