/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin.init;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.fi.cas.enums.BankAcctStatusEnum;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.AccountCashHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.util.EmptyUtil;

public class CashMgtInitBatchSaveOp
extends AbstractOperationServicePlugIn {
    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        Set casInitIds = Arrays.stream(dataEntities).map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toSet());
        DynamicObject[] loadCasInits = BusinessDataServiceHelper.load((Object[])casInitIds.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cas_cashmgtinit"));
        for (int i = 0; i < loadCasInits.length; ++i) {
            long assignOrgId;
            DynamicObject cashMgtInit;
            DynamicObject dataEntity = loadCasInits[i];
            DynamicObject org = dataEntity.getDynamicObject("org");
            if (!EmptyUtil.isNoEmpty((DynamicObject)org) && !EmptyUtil.isNoEmpty((Long)org.getLong("id")) || !CasHelper.isNotEmpty((Object)(cashMgtInit = this.getCashMgtInit(assignOrgId = org.getLong("id"))))) continue;
            this.initLoad(cashMgtInit, dataEntity);
        }
        SaveServiceHelper.save((DynamicObject[])loadCasInits);
        this.operationResult.setSuccess(true);
    }

    private DynamicObject getCashMgtInit(long orgId) {
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)orgId)};
        DynamicObjectCollection cashMgitInitColl = QueryServiceHelper.query((String)"cas_cashmgtinit", (String)"id", (QFilter[])filters);
        if (cashMgitInitColl.isEmpty()) {
            return null;
        }
        return BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)cashMgitInitColl.get(0)).getLong("id"), (String)"cas_cashmgtinit");
    }

    private void initLoad(DynamicObject cashMgtInit, DynamicObject initDynamicObject) {
        DynamicObject startPeriod;
        DynamicObject org = cashMgtInit.getDynamicObject("org");
        long orgId = org.getLong("id");
        boolean isInit = cashMgtInit.getBoolean("isfinishinit");
        DynamicObjectCollection entryCashCollection = initDynamicObject.getDynamicObjectCollection("entrycash");
        entryCashCollection.clear();
        DynamicObjectCollection entryBankCollection = initDynamicObject.getDynamicObjectCollection("entrybank");
        entryBankCollection.clear();
        initDynamicObject.set("startperiod", (Object)cashMgtInit.getDynamicObject("startperiod"));
        if (!isInit) {
            QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("closestatus", "!=", (Object)"1")};
            int cashSeq = 1;
            Map accountCashMap = BusinessDataServiceHelper.loadFromCache((String)"cas_accountcash", (QFilter[])filters);
            for (DynamicObject accountCash : accountCashMap.values()) {
                DynamicObjectCollection currencyList = accountCash.getDynamicObjectCollection("currency");
                for (DynamicObject currency : currencyList) {
                    DynamicObject dynamicObject = entryCashCollection.addNew();
                    dynamicObject.set("cash_accountcash", (Object)accountCash);
                    dynamicObject.set("cash_accountcashnumber", (Object)this.getAccountCashDisplay(accountCash));
                    dynamicObject.set("cash_currency", currency.get("fbasedataid"));
                    dynamicObject.set("cash_yeardebit", (Object)new BigDecimal(0));
                    dynamicObject.set("cash_yearcredit", (Object)new BigDecimal(0));
                    dynamicObject.set("cash_balance", (Object)new BigDecimal(0));
                    dynamicObject.set("seq", (Object)cashSeq++);
                }
            }
            ArrayList<Long> orgIds = new ArrayList<Long>(10);
            orgIds.add(orgId);
            QFilter accountBankFilterByOrg = AccountBankHelper.getAccountBankFilterByOrg(orgIds);
            boolean isShowInnerAccount = (Boolean)SystemParamServiceHelper.getAppParameter((String)AppMetadataCache.getAppInfo((String)"am").getId(), (String)"08", (Long)orgId, (String)"isshowinternalaccount");
            if (!isShowInnerAccount) {
                accountBankFilterByOrg.and(new QFilter("finorgtype", "!=", (Object)Character.valueOf('1')));
            }
            accountBankFilterByOrg.and(new QFilter("acctstatus", "!=", (Object)BankAcctStatusEnum.CLOSED.getValue()));
            Map accountBankMap = BusinessDataServiceHelper.loadFromCache((String)"bd_accountbanks", (QFilter[])new QFilter[]{accountBankFilterByOrg});
            int bankSeq = 1;
            for (DynamicObject accountbank : accountBankMap.values()) {
                DynamicObjectCollection currencyList = accountbank.getDynamicObjectCollection("currency");
                for (DynamicObject currency : currencyList) {
                    if (CasHelper.isEmpty((Object)currency) || CasHelper.isEmpty((Object)currency.get("fbasedataid"))) continue;
                    DynamicObject dynamicObject = entryBankCollection.addNew();
                    dynamicObject.set("bank_accountbank", accountbank.getPkValue());
                    dynamicObject.set("bank_openorg", accountbank.getDynamicObject("openorg").getPkValue());
                    dynamicObject.set("bank_bankaccountnumber", (Object)CashMgtInitBatchSaveOp.getAccountBankDisplay(accountbank));
                    dynamicObject.set("bank_currency", currency.get("fbasedataid"));
                    dynamicObject.set("bank_journaldebit", (Object)new BigDecimal(0));
                    dynamicObject.set("bank_journalcredit", (Object)new BigDecimal(0));
                    dynamicObject.set("bank_journalbalance", (Object)new BigDecimal(0));
                    dynamicObject.set("bank_journalbalanceadj", (Object)new BigDecimal(0));
                    dynamicObject.set("bank_statementdebit", (Object)new BigDecimal(0));
                    dynamicObject.set("bank_statementcredit", (Object)new BigDecimal(0));
                    dynamicObject.set("bank_statementbalance", (Object)new BigDecimal(0));
                    dynamicObject.set("bank_statementbalanceadj", (Object)new BigDecimal(0));
                    dynamicObject.set("bank_journalsumbalanceadj", (Object)new BigDecimal(0));
                    dynamicObject.set("bank_equal", (Object)"1");
                    dynamicObject.set("seq", (Object)bankSeq++);
                }
            }
        } else {
            initDynamicObject.set("currentperiod", (Object)cashMgtInit.getDynamicObject("currentperiod"));
            DynamicObjectCollection cashEntryList = cashMgtInit.getDynamicObjectCollection("entrycash");
            int cashSeq = 1;
            for (DynamicObject cashEntry : cashEntryList) {
                DynamicObject dynamicObject = entryCashCollection.addNew();
                dynamicObject.set("cash_accountcash", (Object)cashEntry.getDynamicObject("cash_accountcash"));
                dynamicObject.set("cash_accountcashnumber", (Object)this.getAccountCashDisplay(cashEntry.getDynamicObject("cash_accountcash")));
                dynamicObject.set("cash_currency", (Object)cashEntry.getDynamicObject("cash_currency"));
                dynamicObject.set("cash_yeardebit", (Object)cashEntry.getBigDecimal("cash_yeardebit"));
                dynamicObject.set("cash_yearcredit", (Object)cashEntry.getBigDecimal("cash_yearcredit"));
                dynamicObject.set("cash_balance", (Object)cashEntry.getBigDecimal("cash_balance"));
                dynamicObject.set("seq", (Object)cashSeq++);
            }
            DynamicObjectCollection bankEntryList = cashMgtInit.getDynamicObjectCollection("entrybank");
            boolean isShowInnerAccount = (Boolean)SystemParamServiceHelper.getAppParameter((String)AppMetadataCache.getAppInfo((String)"am").getId(), (String)"08", (Long)orgId, (String)"isshowinternalaccount");
            int bankSeq = 1;
            for (DynamicObject bankEntry : bankEntryList) {
                if (!isShowInnerAccount && Objects.equals(bankEntry.getDynamicObject("bank_accountbank").getString("finorgtype"), "1")) continue;
                DynamicObject dynamicObject = entryBankCollection.addNew();
                dynamicObject.set("bank_accountbank", (Object)bankEntry.getDynamicObject("bank_accountbank"));
                dynamicObject.set("bank_openorg", (Object)bankEntry.getDynamicObject("bank_openorg"));
                dynamicObject.set("bank_bankaccountnumber", (Object)CashMgtInitBatchSaveOp.getAccountBankDisplay(bankEntry.getDynamicObject("bank_accountbank")));
                dynamicObject.set("bank_currency", (Object)bankEntry.getDynamicObject("bank_currency"));
                dynamicObject.set("bank_journaldebit", (Object)bankEntry.getBigDecimal("bank_journaldebit"));
                dynamicObject.set("bank_journalcredit", (Object)bankEntry.getBigDecimal("bank_journalcredit"));
                dynamicObject.set("bank_journalbalance", (Object)bankEntry.getBigDecimal("bank_journalbalance"));
                dynamicObject.set("bank_journalbalanceadj", (Object)bankEntry.getBigDecimal("bank_journalbalanceadj"));
                dynamicObject.set("bank_statementdebit", (Object)bankEntry.getBigDecimal("bank_statementdebit"));
                dynamicObject.set("bank_statementcredit", (Object)bankEntry.getBigDecimal("bank_statementcredit"));
                dynamicObject.set("bank_statementbalance", (Object)bankEntry.getBigDecimal("bank_statementbalance"));
                dynamicObject.set("bank_statementbalanceadj", (Object)bankEntry.getBigDecimal("bank_statementbalanceadj"));
                dynamicObject.set("bank_journalsumbalanceadj", (Object)bankEntry.getBigDecimal("bank_journalsumbalanceadj"));
                dynamicObject.set("bank_equal", (Object)bankEntry.getString("bank_equal"));
                dynamicObject.set("seq", (Object)bankSeq++);
            }
        }
        if (null == (startPeriod = initDynamicObject.getDynamicObject("startperiod"))) {
            return;
        }
    }

    private String getAccountCashDisplay(DynamicObject accountCash) {
        if (accountCash == null) {
            return "";
        }
        if (accountCash.getString("number") != null && !accountCash.getString("number").trim().equals("")) {
            return accountCash.getString("number") + "\n" + accountCash.getString("name");
        }
        accountCash = AccountCashHelper.getAccountCashById((long)accountCash.getLong("id"));
        return accountCash.getString("number") + "\n" + accountCash.getString("name");
    }

    private static String getAccountBankDisplay(DynamicObject accountBank) {
        if (accountBank == null) {
            return "";
        }
        if (accountBank.getString("bankaccountnumber") != null && !accountBank.getString("bankaccountnumber").trim().equals("")) {
            return accountBank.getString("bankaccountnumber") + "\n" + accountBank.getString("name");
        }
        accountBank = AccountBankHelper.getAccountBankById((long)accountBank.getLong("id"));
        return accountBank.getString("bankaccountnumber") + "\n" + accountBank.getString("name");
    }
}

