/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin.init;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.fi.cas.business.helper.BalanceCountHelper;
import kd.fi.cas.enums.BankAcctStatusEnum;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.AccountCashHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.util.EmptyUtil;

public class RecInitBatchSaveOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(RecInitBatchSaveOp.class);

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        Set casInitIds = Arrays.stream(dataEntities).map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toSet());
        DynamicObject[] loadRecInits = BusinessDataServiceHelper.load((Object[])casInitIds.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cas_rec_init"));
        for (int i = 0; i < loadRecInits.length; ++i) {
            long assignOrgId;
            DynamicObject cashMgtInit;
            DynamicObject dataEntity = loadRecInits[i];
            DynamicObject org = dataEntity.getDynamicObject("org");
            if (!EmptyUtil.isNoEmpty((DynamicObject)org) && !EmptyUtil.isNoEmpty((Long)org.getLong("id")) || !CasHelper.isNotEmpty((Object)(cashMgtInit = this.getCashMgtInit(assignOrgId = org.getLong("id"))))) continue;
            this.initLoad(cashMgtInit, dataEntity, true);
        }
        SaveServiceHelper.save((DynamicObject[])loadRecInits);
        this.operationResult.setSuccess(true);
    }

    private DynamicObject getCashMgtInit(long orgId) {
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)orgId)};
        DynamicObjectCollection cashMgitInitColl = QueryServiceHelper.query((String)"cas_cashmgtinit", (String)"id", (QFilter[])filters);
        if (cashMgitInitColl.isEmpty()) {
            return null;
        }
        return BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)cashMgitInitColl.get(0)).getLong("id"), (String)"cas_cashmgtinit");
    }

    private void initLoad(DynamicObject cashMgtInit, DynamicObject initDynamicObject, boolean isAddNew) {
        Boolean isfinishinit;
        DynamicObject org = initDynamicObject.getDynamicObject("org");
        long orgId = org.getLong("id");
        if (isAddNew) {
            if (EmptyUtil.isEmpty((DynamicObject)cashMgtInit) || !cashMgtInit.getBoolean("isfinishinit")) {
                initDynamicObject.set("org", null);
                return;
            }
            DynamicObject currentperiod = cashMgtInit.getDynamicObject("currentperiod");
            if (cashMgtInit.getDynamicObject("startperiod") != null) {
                initDynamicObject.set("startperiod", (Object)cashMgtInit.getDynamicObject("startperiod").getLong("id"));
            }
            if (currentperiod != null) {
                initDynamicObject.set("initperiod", (Object)currentperiod);
                initDynamicObject.set("currentperiod", (Object)currentperiod);
            }
            initDynamicObject.set("standardcurrency", (Object)cashMgtInit.getDynamicObject("standardcurrency").getLong("id"));
            initDynamicObject.set("exratetable", (Object)cashMgtInit.getDynamicObject("exratetable").getLong("id"));
            initDynamicObject.set("periodtype", (Object)cashMgtInit.getDynamicObject("periodtype").getLong("id"));
            DynamicObject recInit = null;
            if (currentperiod != null) {
                recInit = this.getRecInit(orgId, currentperiod.getLong("id"));
            }
            if (recInit != null) {
                logger.info(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\uff1a%1$s\uff0c\u5df2\u5b58\u5728%2$s\u671f\u95f4\u7684\u5bf9\u8d26\u521d\u59cb\u5316\u6570\u636e\uff0c\u8bf7\u4fee\u6539\u3002", (String)"RecInitEdit_0", (String)"fi-cas-formplugin", (Object[])new Object[0]), CasHelper.getLocalValue((DynamicObject)org, (String)"name"), CasHelper.getLocalValue((DynamicObject)currentperiod, (String)"name")));
            }
        }
        if ((isfinishinit = Boolean.valueOf(initDynamicObject.getBoolean("isfinishinit"))).booleanValue()) {
            DynamicObjectCollection entrybank = initDynamicObject.getDynamicObjectCollection("entrybank");
            int rowCount = entrybank.size();
            for (int i = 0; i < rowCount; ++i) {
                DynamicObject accountbank = ((DynamicObject)entrybank.get(i)).getDynamicObject("bank_accountbank");
                ((DynamicObject)entrybank.get(i)).set("bank_bankaccountnumber", (Object)RecInitBatchSaveOp.getAccountBankDisplay(accountbank));
            }
            DynamicObjectCollection entrycash = initDynamicObject.getDynamicObjectCollection("entrycash");
            int rowCount2 = entrycash.size();
            for (int i = 0; i < rowCount2; ++i) {
                DynamicObject accountcash = ((DynamicObject)entrycash.get(i)).getDynamicObject("cash_accountcash");
                ((DynamicObject)entrycash.get(i)).set("cash_accountcashnumber", (Object)this.getAccountCashDisplay(accountcash));
            }
            return;
        }
        DynamicObject initperiod = initDynamicObject.getDynamicObject("initperiod");
        DynamicObjectCollection entryCashCollection = initDynamicObject.getDynamicObjectCollection("entrycash");
        entryCashCollection.clear();
        DynamicObjectCollection entryBankCollection = initDynamicObject.getDynamicObjectCollection("entrybank");
        entryBankCollection.clear();
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("closestatus", "!=", (Object)"1")};
        Map accountCashMap = BusinessDataServiceHelper.loadFromCache((String)"cas_accountcash", (QFilter[])filters);
        Map cashBalance = BalanceCountHelper.getCashBalance((Long)orgId, (DynamicObject)initperiod);
        int cashSeq = 1;
        for (DynamicObject accountCash : accountCashMap.values()) {
            DynamicObjectCollection currencyList = accountCash.getDynamicObjectCollection("currency");
            for (DynamicObject currency : currencyList) {
                DynamicObject dynamicObject = entryCashCollection.addNew();
                dynamicObject.set("cash_accountcash", (Object)accountCash);
                dynamicObject.set("cash_accountcashnumber", (Object)this.getAccountCashDisplay(accountCash));
                dynamicObject.set("cash_currency", currency.get("fbasedataid"));
                dynamicObject.set("cash_yeardebit", (Object)new BigDecimal(0));
                dynamicObject.set("cash_yearcredit", (Object)new BigDecimal(0));
                String key = BalanceCountHelper.getMapKey((DynamicObject)org, (DynamicObject)accountCash, (DynamicObject)currency.getDynamicObject("fbasedataid"));
                dynamicObject.set("cash_balance", cashBalance.get(key));
                dynamicObject.set("seq", (Object)cashSeq++);
            }
        }
        QFilter accountBankFilterByOrg = new QFilter("createorg", "=", (Object)orgId);
        boolean isShowInnerAccount = (Boolean)SystemParamServiceHelper.getAppParameter((String)AppMetadataCache.getAppInfo((String)"am").getId(), (String)"08", (Long)orgId, (String)"isshowinternalaccount");
        if (!isShowInnerAccount) {
            accountBankFilterByOrg.and(new QFilter("finorgtype", "!=", (Object)Character.valueOf('1')));
        }
        Map accountBankMap = BusinessDataServiceHelper.loadFromCache((String)"bd_accountbanks", (QFilter[])new QFilter[]{accountBankFilterByOrg, new QFilter("acctstatus", "!=", (Object)BankAcctStatusEnum.CLOSED.getValue())});
        Map journalBalance = BalanceCountHelper.getJournalBalance((Long)orgId, (DynamicObject)initperiod);
        int bankSeq = 1;
        for (DynamicObject accountbank : accountBankMap.values()) {
            DynamicObjectCollection currencyList = accountbank.getDynamicObjectCollection("currency");
            for (DynamicObject currency : currencyList) {
                if (CasHelper.isEmpty((Object)currency) || CasHelper.isEmpty((Object)currency.get("fbasedataid"))) continue;
                DynamicObject dynamicObject = entryBankCollection.addNew();
                dynamicObject.set("bank_accountbank", accountbank.getPkValue());
                DynamicObject openorg = accountbank.getDynamicObject("openorg");
                if (openorg != null && EmptyUtil.isNoEmpty((DynamicObject)openorg)) {
                    dynamicObject.set("bank_openorg", openorg.getPkValue());
                }
                dynamicObject.set("bank_bankaccountnumber", (Object)RecInitBatchSaveOp.getAccountBankDisplay(accountbank));
                dynamicObject.set("bank_currency", currency.get("fbasedataid"));
                dynamicObject.set("bank_journaldebit", (Object)new BigDecimal(0));
                dynamicObject.set("bank_journalcredit", (Object)new BigDecimal(0));
                String key = BalanceCountHelper.getMapKey((DynamicObject)org, (DynamicObject)accountbank, (DynamicObject)currency.getDynamicObject("fbasedataid"));
                dynamicObject.set("bank_journalbalance", journalBalance.get(key));
                dynamicObject.set("bank_journalbalanceadj", (Object)new BigDecimal(0));
                dynamicObject.set("bank_statementdebit", (Object)new BigDecimal(0));
                dynamicObject.set("bank_statementcredit", (Object)new BigDecimal(0));
                dynamicObject.set("bank_statementbalance", (Object)new BigDecimal(0));
                dynamicObject.set("bank_statementbalanceadj", (Object)new BigDecimal(0));
                dynamicObject.set("bank_journalsumbalanceadj", (Object)new BigDecimal(0));
                dynamicObject.set("bank_equal", (Object)"1");
                dynamicObject.set("seq", (Object)bankSeq++);
            }
        }
    }

    private String getAccountCashDisplay(DynamicObject accountCash) {
        if (accountCash == null) {
            return "";
        }
        if (accountCash.getString("number") != null && !accountCash.getString("number").trim().equals("")) {
            return accountCash.getString("number") + "\n" + accountCash.getString("name");
        }
        accountCash = AccountCashHelper.getAccountCashById((long)accountCash.getLong("id"));
        return accountCash.getString("number") + "\n" + accountCash.getString("name");
    }

    private static String getAccountBankDisplay(DynamicObject accountBank) {
        if (accountBank == null) {
            return "";
        }
        if (accountBank.getString("bankaccountnumber") != null && !accountBank.getString("bankaccountnumber").trim().equals("")) {
            return accountBank.getString("bankaccountnumber") + "\n" + accountBank.getString("name");
        }
        accountBank = AccountBankHelper.getAccountBankById((long)accountBank.getLong("id"));
        return accountBank.getString("bankaccountnumber") + "\n" + accountBank.getString("name");
    }

    private DynamicObject getRecInit(long orgId, long periodId) {
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("initperiod", "=", (Object)periodId)};
        DynamicObjectCollection recInitInfo = QueryServiceHelper.query((String)"cas_rec_init", (String)"id", (QFilter[])filters);
        if (recInitInfo.size() == 0) {
            return null;
        }
        DynamicObject recInit = BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)recInitInfo.get(0)).getLong("id"), (String)"cas_rec_init");
        return recInit;
    }
}

