/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin.init;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.cas.helper.InitCashHelper;

public class RecInitImportDataOp
extends BatchImportPlugin {
    private static final Log LOGGER = LogFactory.getLog(RecInitImportDataOp.class);

    protected ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        this.saveData(rowdatas, logger);
        return super.save(rowdatas, logger);
    }

    private void saveData(List<ImportBillData> rowdatas, ImportLogger logger) {
        List orgIds = InitCashHelper.getOrgIds(rowdatas);
        if (orgIds.size() == 0) {
            LOGGER.warn("RecInitImportDataOp\uff1a cannot fetch information of origin");
            return;
        }
        Map cashInitMap = InitCashHelper.getCashInit((List)orgIds);
        if (cashInitMap.size() == 0) {
            LOGGER.warn("RecInitImportDataOp\uff1a cannot fetch information of cash");
            return;
        }
        for (ImportBillData data : rowdatas) {
            JSONObject jsonData = data.getData();
            Map org = (Map)jsonData.get((Object)"org");
            String orgNum = (String)org.get("number");
            Map cashInit = (Map)cashInitMap.get(orgNum);
            this.addPeriod(cashInit, jsonData);
            this.addRateTable(cashInit, jsonData);
            this.addPeriodType(cashInit, jsonData);
        }
    }

    private void addPeriod(Map<String, Object> cashInit, JSONObject jsonData) {
        DynamicObject periodDynamic = (DynamicObject)cashInit.get("current");
        HashMap<String, Object> newPeriodImport = new HashMap<String, Object>(4);
        newPeriodImport.put("importprop", "id");
        newPeriodImport.put("id", periodDynamic.getLong("id"));
        jsonData.remove((Object)"initperiod");
        jsonData.remove((Object)"currentperiod");
        jsonData.put("initperiod", newPeriodImport);
        jsonData.put("currentperiod", newPeriodImport);
    }

    private void addRateTable(Map<String, Object> cashInit, JSONObject jsonData) {
        DynamicObject exRateTableDynamic = (DynamicObject)cashInit.get("exratetable");
        HashMap<String, Object> newExRateTable = new HashMap<String, Object>(4);
        newExRateTable.put("importprop", "id");
        newExRateTable.put("id", exRateTableDynamic.getLong("id"));
        jsonData.remove((Object)"exratetable");
        jsonData.put("exratetable", newExRateTable);
    }

    private void addPeriodType(Map<String, Object> cashInit, JSONObject jsonData) {
        DynamicObject periodTypeDynamic = (DynamicObject)cashInit.get("type");
        HashMap<String, Object> newPeriodType = new HashMap<String, Object>(4);
        newPeriodType.put("importprop", "id");
        newPeriodType.put("id", periodTypeDynamic.getLong("id"));
        jsonData.remove((Object)"periodtype");
        jsonData.put("periodtype", newPeriodType);
    }
}

