/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin.journal;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.helper.BalanceAccHelper;
import kd.fi.cas.helper.RecDecInitHelper;
import kd.fi.cas.util.EmptyUtil;

public class BankJournalSaveOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(BankJournalSaveOp.class);

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        logger.info("===BankJournalSaveOp==save bank journal");
        HashSet<Long> acctIds = new HashSet<Long>(e.getDataEntities().length);
        for (DynamicObject info : e.getDataEntities()) {
            Long accId = null;
            if (info.get("accountbank") != null && info.get("accountbank") instanceof DynamicObject) {
                DynamicObject acc = info.getDynamicObject("accountbank");
                accId = acc.getLong("id");
            } else {
                accId = info.getLong("accountbank");
            }
            acctIds.add(accId);
        }
        HashMap<Long, Long> acctId_openOrgId = new HashMap<Long, Long>(acctIds.size());
        if (acctIds.size() > 0) {
            QFilter qFilter = new QFilter("id", "in", acctIds);
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryAcctBank", (String)"bd_accountbanks", (String)"id,openorg", (QFilter[])new QFilter[]{qFilter}, null);){
                while (ds.hasNext()) {
                    Row row = ds.next();
                    acctId_openOrgId.put(row.getLong("id"), row.getLong("openorg"));
                }
            }
        }
        HashMap<Long, DynamicObject> orgId_recEdc = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject info : e.getDataEntities()) {
            DynamicObject balanceAcc;
            Long orgId = null;
            if (info.get("org") != null && info.get("org") instanceof DynamicObject) {
                DynamicObject org = info.getDynamicObject("org");
                orgId = org.getLong("id");
            } else {
                orgId = info.getLong("org");
            }
            Long accId = null;
            if (info.get("accountbank") != null && info.get("accountbank") instanceof DynamicObject) {
                DynamicObject acc = info.getDynamicObject("accountbank");
                accId = acc.getLong("id");
            } else {
                accId = info.getLong("accountbank");
            }
            Date bizDate = info.getDate("bookdate");
            if (accId != null && EmptyUtil.isNoEmpty((Long)((Long)acctId_openOrgId.get(accId)))) {
                orgId = (Long)acctId_openOrgId.get(accId);
            }
            if (orgId_recEdc.containsKey(orgId)) {
                balanceAcc = (DynamicObject)orgId_recEdc.get(orgId);
            } else {
                balanceAcc = BalanceAccHelper.balanceAcc((Long)orgId);
                orgId_recEdc.put(orgId, balanceAcc);
            }
            info.set("isvalid", (Object)RecDecInitHelper.getValidByRecEdc((Long)orgId, (DynamicObject)balanceAcc, (Date)bizDate));
        }
    }
}

