/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin.mqrecord;

import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.property.TextProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.enums.mq.MQMessageStatusEnum;
import kd.fi.cas.validator.mqrecord.MqRecordReplayTimeValidator;

public class MqRecordReplayOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(MqRecordReplayOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("msginfo_tag");
        fieldKeys.add("createtime");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.getValidators().add(new MqRecordReplayTimeValidator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] records;
        super.beforeExecuteOperationTransaction(e);
        for (DynamicObject record : records = e.getDataEntities()) {
            String msgInfo = record.getString("msginfo_tag");
            Map message = (Map)SerializationUtils.fromJsonString((String)msgInfo, Map.class);
            Object recordPk = message.get("recordPk");
            List voucherPks = (List)message.get("voucherPks");
            message.put("voucherPks", voucherPks.toArray(new Long[0]));
            try (MessagePublisher pub = MQFactory.get().createSimplePublisher("fi", "fi.cas.voucherbook");){
                try (TXHandle tx = TX.requiresNew();){
                    pub.publishInDbTranscation("gl", (Object)message);
                }
                this.updateRecordStatus(recordPk, MQMessageStatusEnum.REP, null);
            }
        }
    }

    private void updateRecordStatus(Object recordPk, MQMessageStatusEnum msgstatus, Object errInfo) {
        try {
            DynamicObject mqRecord = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cas_mq_record"));
            mqRecord.set("id", recordPk);
            mqRecord.set("msgstatus", (Object)msgstatus.getValue());
            mqRecord.set("modifytime", (Object)new Date());
            if (errInfo != null) {
                String errormsgTag = SerializationUtils.toJsonString((Object)errInfo);
                TextProp property = (TextProp)mqRecord.getDataEntityType().getProperties().get((Object)"errormsg");
                int maxLenth = property.getMaxLenth();
                String errormsg = "";
                if (errormsgTag != null && errormsgTag.length() > maxLenth) {
                    errormsg = errormsgTag.substring(0, maxLenth);
                }
                mqRecord.set("errormsg", (Object)errormsg);
                mqRecord.set("errormsg_tag", (Object)errormsgTag);
            }
            try (TXHandle tx = TX.requiresNew();){
                SaveServiceHelper.update((DynamicObject)mqRecord);
            }
        }
        catch (Exception e) {
            logger.error("mqRecord updateStatus error:", (Throwable)e);
            throw e;
        }
    }
}

