/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin.overdraft;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDException;
import kd.bos.ext.fi.botp.enums.SettleMentTypeEnum;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.fi.cas.business.errorcode.PaymentErrorCode;
import kd.fi.cas.business.helper.LinkagePaymentHelper;
import kd.fi.cas.business.writeback.PaymentDisposeConsumer;
import kd.fi.cas.business.writeback.WriteBackValidateHelper;
import kd.fi.cas.business.writeback.consts.WriteBackOperateEnum;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.errorcode.EBErrorCode;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.DraftHelper;
import kd.fi.cas.helper.PaymentBillPluginHelper;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.helper.SystemStatusCtrolHelper;
import kd.fi.cas.helper.VoucherBookHelper;
import kd.fi.cas.util.CheckUtils;
import kd.fi.cas.util.EmptyUtil;

public class PaymentPayPreValidator
extends AbstractValidator {
    private static final Log logger = LogFactory.getLog(PaymentPayPreValidator.class);
    private static final Set<String> SETTLEMENT_TYPES = Stream.of(SettleMentTypeEnum.PROMISSORY.getValue(), SettleMentTypeEnum.CHECK.getValue(), SettleMentTypeEnum.DRAFT.getValue(), SettleMentTypeEnum.BUSINESS.getValue(), SettleMentTypeEnum.BANK.getValue()).collect(Collectors.toSet());

    public void validate() {
        List<Object> payBillIds = Arrays.stream(this.dataEntities).filter(Objects::nonNull).map(o -> o.getDataEntity().getPkValue()).collect(Collectors.toList());
        DynamicObject[] payBills = BusinessDataServiceHelper.load((Object[])payBillIds.toArray(new Object[0]), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cas_paybill"));
        Map<Object, List<ExtendedDataEntity>> relationMapping = Arrays.stream(this.dataEntities).filter(Objects::nonNull).collect(Collectors.groupingBy(o -> o.getDataEntity().getPkValue()));
        String pushMsg = this.checkPushRule();
        Set orgIdList = Arrays.stream(payBills).filter(c -> c.getDynamicObject("org") != null).map(c -> c.getDynamicObject("org").getLong("id")).collect(Collectors.toSet());
        Map isPushArApMap = SystemParameterHelper.getSystemParamsByOrgIds(new ArrayList(orgIdList), (String)"cs088");
        Map isDraftFlagMap = SystemParameterHelper.getSystemParamsByOrgIds(new ArrayList(orgIdList), (String)"cs122");
        Map orgInitMap = SystemStatusCtrolHelper.getSystemStatusCtrol(orgIdList);
        Set notSubmitVoucherIds = VoucherBookHelper.batchCheckVoucherNotSubmit(payBillIds, (String)"cas_paybill");
        Set accBankIds = ((Stream)Arrays.stream(payBills).parallel()).filter(d -> EmptyUtil.isNoEmpty((DynamicObject)d.getDynamicObject("payeracctbank")) && EmptyUtil.isNoEmpty((Long)d.getDynamicObject("payeracctbank").getLong("id"))).map(d -> d.getDynamicObject("payeracctbank").getLong("id")).collect(Collectors.toSet());
        Map closedMap = AccountBankHelper.isBatchClosed(accBankIds);
        for (DynamicObject payBill : payBills) {
            this.validate(payBill, relationMapping, pushMsg, orgInitMap, isPushArApMap, isDraftFlagMap, closedMap, notSubmitVoucherIds);
        }
    }

    private void validate(DynamicObject payBill, Map<Object, List<ExtendedDataEntity>> relationMapping, String pushMsg, Map<String, DynamicObject> orgInitMap, Map<String, Object> isPushArApMap, Map<String, Object> isDraftFlagMap, Map<Long, Boolean> closedMap, Set<Long> notSubmitVoucherIds) throws KDException {
        String settlementtype;
        ExtendedDataEntity dataEntity = relationMapping.get(payBill.getPkValue()).get(0);
        Map param = this.getOption().getVariables();
        String billStatus = payBill.getString("billstatus");
        String string = settlementtype = EmptyUtil.isEmpty((DynamicObject)payBill.getDynamicObject("settletype")) ? "" : payBill.getDynamicObject("settletype").getString("settlementtype");
        if (!billStatus.equals(BillStatusEnum.AUDIT.getValue()) && !billStatus.equals(BillStatusEnum.DRAFTING.getValue())) {
            this.addErrorMessage(dataEntity, new PaymentErrorCode().STATUS_CANNOT_PAY().getMessage());
        } else {
            DynamicObject accountBank;
            DynamicObjectCollection draftbills;
            boolean isLinkagePayment = LinkagePaymentHelper.isLinkagePayment((DynamicObject)payBill);
            DynamicObject innerAccount = payBill.getDynamicObject("inneraccount");
            if (isLinkagePayment && innerAccount != null) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e0e\u7ed3\u7b97\u4e2d\u5fc3\u76f8\u5173\u7684\u8054\u52a8\u652f\u4ed8\uff0c\u8bf7\u63d0\u4ea4\u5185\u90e8\u7ed3\u7b97\u3002", (String)"PaymentPayPreValidator_6", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            } else if ("bei".equals(payBill.getString("paymentchannel")) && !SETTLEMENT_TYPES.contains(settlementtype) && PaymentBillPluginHelper.paymentIdentify((DynamicObject)payBill)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u652f\u4ed8\u6e20\u9053\u4e3a\u94f6\u4f01\u4e92\u8054\uff0c\u8bf7\u63d0\u4ea4\u94f6\u4f01\u8fdb\u884c\u4ed8\u6b3e\u3002", (String)"PaymentPayPreValidator_1", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            }
            if (!CasHelper.isEmpty((Object)payBill.get("entrustorg"))) {
                this.addErrorMessage(dataEntity, new PaymentErrorCode().WT_NOT_PAY().getMessage());
            }
            DynamicObject org = payBill.getDynamicObject("org");
            DynamicObject orgInit = orgInitMap.get(org.getString("id"));
            if (org == null || !SystemStatusCtrolHelper.isInitEnable((DynamicObject)orgInit)) {
                this.addErrorMessage(dataEntity, SystemStatusCtrolHelper.getNotInitMsg((String)CasHelper.getLocalValue((DynamicObject)org, (String)"name")));
            }
            boolean isPushArAp = false;
            boolean isDraftFlag = false;
            if (org != null) {
                isPushArAp = SystemParameterHelper.getBoolean((Object)isPushArApMap.get(org.getPkValue().toString()));
                isDraftFlag = SystemParameterHelper.getBoolean((Object)isDraftFlagMap.get(org.getPkValue().toString()));
            }
            if (isPushArAp && !CasHelper.isEmpty((Object)payBill.get("applyorg")) && "cas_paybill".equals(payBill.get("sourcebilltype")) && CasHelper.isNotEmpty((Object)pushMsg)) {
                this.addErrorMessage(dataEntity, pushMsg);
            }
            boolean isAllowCheck = !EmptyUtil.isEmpty((DynamicObjectCollection)(draftbills = payBill.getDynamicObjectCollection("draftbill"))) && !this.isAllPayDrafBill(draftbills);
            logger.info("isAllowCheck:" + isAllowCheck + ",isDraftFlag:" + isDraftFlag);
            if (EmptyUtil.isEmpty((Object)param) || !param.containsKey("draftbillno")) {
                if (isDraftFlag && PaymentBillPluginHelper.needSelectedDraft((DynamicObject)payBill) && param != null && param.get("draftids") == null) {
                    String msg = ResManager.loadKDString((String)"\u7ed3\u7b97\u65b9\u5f0f\u7c7b\u522b\u4e3a\u6c47\u7968\u6216\u652f\u7968\u6216\u672c\u7968\u7684\u4ed8\u6b3e\u5355\u4e0d\u652f\u6301\u6279\u91cf\u786e\u8ba4\u4ed8\u6b3e\uff0c\u8bf7\u9009\u62e9\u5355\u7b14\u6570\u636e\u8fdb\u884c\u786e\u8ba4\u4ed8\u6b3e\u3002", (String)"PaymentPayPreValidator_2", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                    this.addErrorMessage(dataEntity, msg);
                } else if (!isDraftFlag || isAllowCheck) {
                    String key = DraftHelper.getKey((Object)payBill.get("settletype"));
                    String msg = this.getWarnMesg(payBill, key, "cas_paybill");
                    if (!CasHelper.isEmpty((Object)key) && !CasHelper.isEmpty((Object)msg)) {
                        this.addErrorMessage(dataEntity, msg);
                    }
                }
            }
            if (null != (accountBank = payBill.getDynamicObject("payeracctbank")) && closedMap.get(accountBank.getLong("id")).booleanValue()) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8d26\u6237%s\u5f53\u524d\u72b6\u6001\u4e3a\u5df2\u9500\u6237\uff0c\u6682\u65e0\u6cd5\u8fdb\u884c\u4e1a\u52a1\u5904\u7406\u3002", (String)"PaymentPayPreValidator_3", (String)"fi-cas-opplugin", (Object[])new Object[0]), accountBank.getString("number")));
            }
            if (notSubmitVoucherIds.contains(payBill.getLong("id"))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u51ed\u8bc1\u51b2\u9500\u672a\u5b8c\u6210\uff0c\u4e0d\u5141\u8bb8\u786e\u8ba4\u4ed8\u6b3e\u3002", (String)"PaymentPayPreValidator_4", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            }
            CheckUtils.checkAmtEqualEAmt((DynamicObject)payBill, (String)"actpayamt", (String)"e_actamt");
            WriteBackValidateHelper.writeBackValidate((DynamicObject)payBill, (WriteBackOperateEnum)WriteBackOperateEnum.PAYVALIDATE, PaymentDisposeConsumer.class);
        }
    }

    public void initializeConfiguration() {
        super.initializeConfiguration();
        this.setOperationName(ResManager.loadKDString((String)"\u786e\u8ba4\u4ed8\u6b3e", (String)"PaymentPayPreValidator_5", (String)"fi-cas-opplugin", (Object[])new Object[0]));
    }

    private String getWarnMesg(DynamicObject payBill, String key, String entity) {
        if (CasHelper.isEmpty((Object)key)) {
            return "";
        }
        long orgId = (Long)payBill.getDynamicObject("org").getPkValue();
        ArrayList<String> typeList = new ArrayList<String>(3);
        boolean isOpen = SystemParameterHelper.getCdmParameterBoolean((long)orgId, (String)key);
        if (!isOpen) {
            return "";
        }
        if ("cas_paybill".equals(entity) && (BigDecimal.ZERO.compareTo(payBill.getBigDecimal("actpayamt")) > 0 || this.isAllPayDrafBill(payBill.getDynamicObjectCollection("draftbill")))) {
            return "";
        }
        boolean isDraft = SystemParameterHelper.getCdmParameterBoolean((long)orgId, (String)"isdraft");
        boolean isCheck = SystemParameterHelper.getCdmParameterBoolean((long)orgId, (String)"ischeck");
        boolean ispromissorynote = SystemParameterHelper.getCdmParameterBoolean((long)orgId, (String)"ispromissorynote");
        if (isDraft) {
            typeList.add(ResManager.loadKDString((String)"\u6c47\u7968", (String)"PaymentPayPreValidator_7", (String)"fi-cas-opplugin", (Object[])new Object[0]));
        }
        if (isCheck) {
            typeList.add(ResManager.loadKDString((String)"\u652f\u7968", (String)"PaymentPayPreValidator_8", (String)"fi-cas-opplugin", (Object[])new Object[0]));
        }
        if (ispromissorynote) {
            typeList.add(ResManager.loadKDString((String)"\u672c\u7968", (String)"PaymentPayPreValidator_9", (String)"fi-cas-opplugin", (Object[])new Object[0]));
        }
        return String.format(ResManager.loadKDString((String)"\u7ed3\u7b97\u65b9\u5f0f\u7c7b\u522b\u4e3a%s\u7684\u4ed8\u6b3e\u5355\u4e0d\u652f\u6301\u786e\u8ba4\u4ed8\u6b3e\u3002", (String)"PaymentPayPreValidator_10", (String)"fi-cas-opplugin", (Object[])new Object[0]), String.join((CharSequence)", ", typeList));
    }

    private boolean isAllPayDrafBill(DynamicObjectCollection draftBills) {
        if (draftBills == null || draftBills.isEmpty()) {
            return false;
        }
        for (DynamicObject draftBill : draftBills) {
            if ("paybill".equals(((DynamicObject)draftBill.get("fbasedataid")).getString("rptype"))) continue;
            return false;
        }
        return true;
    }

    private String checkPushRule() {
        String[] targetEntitys = new String[]{"ar_finarbill"};
        String sourcebill = "cas_paybill";
        String errMsg = null;
        EBErrorCode ebErrorCode = new EBErrorCode();
        for (String targetEntity : targetEntitys) {
            QFilter[] filter = new QFilter[]{new QFilter("sourceentitynumber", "=", (Object)sourcebill), new QFilter("targetentitynumber", "=", (Object)targetEntity), new QFilter("enabled", "=", (Object)"1")};
            DynamicObject[] rules = BusinessDataServiceHelper.load((String)"botp_crlist", (String)"id", (QFilter[])filter);
            if (rules.length >= 1) continue;
            errMsg = "ar_finarbill".equals(targetEntity) ? ebErrorCode.PUSH_NO_AR().getMessage() : ebErrorCode.PUSH_NO().getMessage();
        }
        return errMsg;
    }
}

