/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin.payapply;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.plugin.args.RollbackOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.business.helper.PayApplyBillHelper;
import kd.fi.cas.business.paysche.bean.DraftLockInfo;
import kd.fi.cas.business.paysche.serive.DraftLockServiceHelper;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.enums.PayApplyRecChgStatusEnum;
import kd.fi.cas.enums.PayStatusEnum;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.validator.payapply.PayApplyInvalidValidator;

public class PayApplyDoInvalidOp
extends AbstractOperationServicePlugIn {
    private static Log logger = LogFactory.getLog(PayApplyDoInvalidOp.class);
    private DraftLockServiceHelper draftLockServiceHelper;
    private Map<Long, List<Long>> payAppIdAndDraftId = new HashMap<Long, List<Long>>(8);

    public PayApplyDoInvalidOp() {
        this.draftLockServiceHelper = new DraftLockServiceHelper();
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("billstatus");
        fieldKeys.add("invalidflag");
        fieldKeys.add("cas_draftinfo");
        fieldKeys.add("billno");
        fieldKeys.add(String.format("%s.%s", "cas_payinfo", "entry_paystatus"));
        fieldKeys.add(String.format("%s.%s", "cas_payinfo", "entry_backbill"));
        fieldKeys.add(String.format("%s.%s", "cas_payinfo", "entry_invalid"));
        fieldKeys.add(String.format("%s.%s", "cas_payinfo", "entry_draftbill"));
        fieldKeys.add(String.format("%s.%s", "cas_payapplyentry", "e_chgstatus"));
        fieldKeys.add(String.join((CharSequence)".", "cas_draftinfo", "draftbillinfo"));
        fieldKeys.add(String.join((CharSequence)".", "cas_draftinfo", "transamount"));
        fieldKeys.add(String.join((CharSequence)".", "cas_draftinfo", "draftbilllogid"));
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.getValidators().add(new PayApplyInvalidValidator());
        e.getValidators().add(new AbstractValidator(){
            final List<String> entry_paystatus = Arrays.asList(PayStatusEnum.PAYMENTSUCCESS.getValue(), PayStatusEnum.PAYING.getValue());

            public void validate() {
                block0: for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    DynamicObject tPayApply = dataEntity.getDataEntity();
                    if (!BillStatusEnum.SAVE.getValue().equals(tPayApply.getString("billstatus")) && !BillStatusEnum.AUDIT.getValue().equals(tPayApply.getString("billstatus"))) {
                        this.showErrorMessage(dataEntity);
                        continue;
                    }
                    DynamicObjectCollection casPayApplyEntrys = tPayApply.getDynamicObjectCollection("cas_payapplyentry");
                    for (DynamicObject casPayApplyEntry : casPayApplyEntrys) {
                        if (!PayApplyRecChgStatusEnum.CHGING.getValue().equals(casPayApplyEntry.getString("e_chgstatus"))) continue;
                        this.showErrorMessage(dataEntity);
                        break;
                    }
                    boolean result = true;
                    List tAllErrorInfo = this.getValidateResult().getAllErrorInfo();
                    for (OperateErrorInfo tErrorInfo : tAllErrorInfo) {
                        if (!tPayApply.getPkValue().equals(tErrorInfo.getPkValue())) continue;
                        result = false;
                        break;
                    }
                    if (!result) continue;
                    DynamicObjectCollection casPayInfos = tPayApply.getDynamicObjectCollection("cas_payinfo");
                    for (DynamicObject casPayInfo : casPayInfos) {
                        if (!this.entry_paystatus.contains(casPayInfo.getString("entry_paystatus")) && !casPayInfo.getBoolean("entry_backbill")) continue;
                        this.showErrorMessage(dataEntity);
                        continue block0;
                    }
                }
            }

            private void showErrorMessage(ExtendedDataEntity dataEntity) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e0d\u6ee1\u8db3\u4f5c\u5e9f\u6761\u4ef6\uff0c\u53ea\u6709\u6682\u5b58\u72b6\u6001\u6216\u8005\u5ba1\u6838\u901a\u8fc7\u4e14\u672a\u4e0b\u63a8\u4ed8\u6b3e\u7684\u7533\u8bf7\u5355\u5141\u8bb8\u4f5c\u5e9f\u3002", (String)"PayApplyInvalidValidator_1", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            }
        });
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] successDataEntities;
        super.beginOperationTransaction(e);
        for (DynamicObject successDataEntity : successDataEntities = e.getDataEntities()) {
            long payApplyId = successDataEntity.getLong("id");
            List lockDraftIds = PayApplyBillHelper.getDraftBillList((DynamicObjectCollection)successDataEntity.getDynamicObjectCollection("cas_payinfo"), (boolean)false);
            this.payAppIdAndDraftId.put(payApplyId, lockDraftIds);
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        String opkey = e.getOperationKey();
        if ("invalid".equals(opkey)) {
            DynamicObject[] successDataEntities = e.getDataEntities();
            ArrayList<DynamicObject> payApplys = new ArrayList<DynamicObject>(successDataEntities.length);
            ArrayList<DraftLockInfo> lockOrReleaseInfoList = new ArrayList<DraftLockInfo>();
            for (DynamicObject successDataEntity : successDataEntities) {
                HashMap draftIdLogIdMap;
                successDataEntity.set("invalidflag", (Object)"true");
                payApplys.add(successDataEntity);
                long payApplyId = successDataEntity.getLong("id");
                List<Long> lockDraftIds = this.payAppIdAndDraftId.get(payApplyId);
                if (EmptyUtil.isEmpty(lockDraftIds)) {
                    logger.info("need deal lock draft is null" + payApplyId);
                    continue;
                }
                DynamicObjectCollection entrys = successDataEntity.getDynamicObjectCollection("cas_draftinfo");
                HashMap draftIdDealAmountMap = entrys.stream().collect(Collectors.toMap(v -> v.getDynamicObject("draftbillinfo").getLong("id"), o -> o.getBigDecimal("transamount"), (o1, o2) -> o1, HashMap::new));
                DraftLockInfo draftLockInfo = this.draftLockServiceHelper.getReleaseLockInfo(successDataEntity, lockDraftIds, draftIdDealAmountMap, draftIdLogIdMap = entrys.stream().collect(Collectors.toMap(v -> v.getDynamicObject("draftbillinfo").getLong("id"), o -> o.getLong("draftbilllogid"), (o1, o2) -> o1, HashMap::new)));
                if (CollectionUtils.isEmpty((Collection)draftLockInfo.getLockSubInfoList())) continue;
                lockOrReleaseInfoList.add(draftLockInfo);
            }
            SaveServiceHelper.save((DynamicObject[])payApplys.toArray(new DynamicObject[0]));
            if (!CollectionUtils.isEmpty(lockOrReleaseInfoList)) {
                logger.info("PayApplyDoInvalidOp updateBillsByLog is start," + JSON.toJSONString(lockOrReleaseInfoList));
                this.draftLockServiceHelper.releaseOrLockDraft(lockOrReleaseInfoList);
                logger.info("PayApplyDoInvalidOp updateBillsByLog is end");
            }
        }
    }

    public void rollbackOperation(RollbackOperationArgs e) {
        this.draftLockServiceHelper.rollback();
    }
}

