/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin.payapply;

import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.enums.AsstActTypeEnum;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.EntityPropertyHelper;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.validator.QuotationEntryOpValidator;
import kd.fi.cas.validator.payapply.PayApplyAmountValidator;
import kd.fi.cas.validator.payapply.PayApplyEntryValidator;
import kd.fi.cas.validator.payapply.PayApplyInfoValidator;
import kd.fi.cas.validator.payapply.PayApplyIsFreezeValidator;
import kd.fi.cas.validator.payapply.PayApplySubmitValidator;

public class PayApplySubmitOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("cas_businessentry");
        fieldKeys.add("cas_payapplyentry");
        fieldKeys.add("paycurrency");
        fieldKeys.add("payeecurrency");
        fieldKeys.add("isdiffcur");
        fieldKeys.add("e_buspayeeamount");
        fieldKeys.add("e_payeeamount");
        fieldKeys.add("cas_payapplyentry.entry_payeraccbank");
        fieldKeys.add("cas_payapplyentry.entry_paymentchannel");
        fieldKeys.add(String.format("%s.%s", "cas_payinfo", "entry_quotation"));
        fieldKeys.addAll(EntityPropertyHelper.getEntryPropertys((String)"cas_payapplybill", (String)"cas_payapplyentry"));
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.getValidators().add(new PayApplySubmitValidator());
        e.getValidators().add(new PayApplyEntryValidator());
        e.getValidators().add(new PayApplyInfoValidator());
        e.getValidators().add(new PayApplyAmountValidator());
        e.getValidators().add(new QuotationEntryOpValidator());
        e.getValidators().add(new PayApplyIsFreezeValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        super.beginOperationTransaction(e);
        for (DynamicObject info : dataEntities = e.getDataEntities()) {
            DynamicObjectCollection payApplyEntry = info.getDynamicObjectCollection("cas_payapplyentry");
            for (int rowIndex = 0; rowIndex < payApplyEntry.size(); ++rowIndex) {
                Set ids;
                QFilter qFilter;
                DynamicObject acc;
                String ePayeeName = ((DynamicObject)payApplyEntry.get(rowIndex)).getString("e_payeename");
                String ePayeeAccBankNum = ((DynamicObject)payApplyEntry.get(rowIndex)).getString("e_payeeaccbanknum");
                if (!this.isCompany(payApplyEntry, rowIndex) || !EmptyUtil.isBlank((CharSequence)ePayeeName) || !EmptyUtil.isNotBlank((CharSequence)ePayeeAccBankNum) || (acc = BusinessDataServiceHelper.loadSingle((String)"am_accountbank", (String)"id,company", (QFilter[])new QFilter[]{qFilter = new QFilter("bankaccountnumber", "=", (Object)ePayeeAccBankNum)})) == null || (ids = AccountBankHelper.getUserAuthorityOrgs((Long)acc.getLong("id"))).size() != 1) continue;
                ((DynamicObject)payApplyEntry.get(rowIndex)).set("e_payeename", acc.get("company.name"));
            }
        }
    }

    private boolean isCompany(DynamicObjectCollection payApplyEntry, int rowIndex) {
        Object payeeType = ((DynamicObject)payApplyEntry.get(rowIndex)).get("e_payeetype");
        return AsstActTypeEnum.COMPANY.getValue().equals(payeeType);
    }
}

