/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin.payment;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.business.helper.PayBillHepler;
import kd.fi.cas.business.paysche.rpc.model.PayBillBackResult;
import kd.fi.cas.business.writeback.PaymentDisposeConsumer;
import kd.fi.cas.business.writeback.consts.WriteBackOperateEnum;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.enums.SettleMentTypeEnum;
import kd.fi.cas.opplugin.model.PayBillBackRequest;
import kd.fi.cas.util.EmptyUtil;

public class PaymentPayScheBackOp
extends AbstractOperationServicePlugIn {
    private static Log logger = LogFactory.getLog(PaymentPayScheBackOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("billstatus");
        fieldKeys.add("iswaitsche");
        fieldKeys.add("sourcebilltype");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public Set<String> preparePropertys() {
                Set selectors = super.preparePropertys();
                selectors.add("iswaitsche");
                return selectors;
            }

            public void validate() {
                try {
                    for (ExtendedDataEntity dataEntity : this.dataEntities) {
                        DynamicObject payBill = dataEntity.getDataEntity();
                        boolean isWaitSche = payBill.getBoolean("iswaitsche");
                        if (!isWaitSche) {
                            String billStatus = payBill.getString("billstatus");
                            if (!BillStatusEnum.SAVE.getValue().equals(billStatus)) {
                                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u975e\u6682\u5b58\u72b6\u6001\u7684\u4ed8\u6b3e\u5355\u4e0d\u652f\u6301\u6392\u7a0b\u5355\u9000\u5355\u5904\u7406\u3002", (String)"PaymentPayScheBackOp_1", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                                continue;
                            }
                            Boolean isSchePay = (Boolean)DispatchServiceHelper.invokeBizService((String)"tmc", (String)"psd", (String)"tmcPayScheService", (String)"isSchePayBill", (Object[])new Object[]{payBill.getLong("id")});
                            if (isSchePay.booleanValue()) continue;
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u975e\u6392\u7a0b\u751f\u6210\u7684\u4ed8\u6b3e\u5355\u4e0d\u652f\u6301\u6392\u7a0b\u5355\u9000\u5355\u5904\u7406\u3002", (String)"PaymentPayScheBackOp_0", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                            continue;
                        }
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f85\u6392\u7a0b\u7684\u4ed8\u6b3e\u5355\u4e0d\u5141\u8bb8\u6392\u7a0b\u5355\u9000\u5355\u3002", (String)"PaymentPayScheBackOp_2", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                    }
                }
                catch (Exception e) {
                    throw new KDBizException(e.getMessage());
                }
            }
        });
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        List pkList = Arrays.stream(dataEntities).map(i -> i.getPkValue()).collect(Collectors.toList());
        DynamicObject[] dbDataArr = BusinessDataServiceHelper.load((Object[])pkList.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cas_paybill"));
        Map dbDataMap = Arrays.stream(dbDataArr).collect(Collectors.toMap(i -> i.getPkValue(), Function.identity()));
        String reason = this.getOption().getVariableValue("reason", "");
        HashMap<Long, BigDecimal> backPayAmount = new HashMap<Long, BigDecimal>(4);
        for (DynamicObject dataEntity : dataEntities) {
            Object pkValue = dataEntity.getPkValue();
            DynamicObject dbData = (DynamicObject)dbDataMap.get(pkValue);
            DynamicObjectCollection entries = dbData.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entries) {
                Long paySchId = entry.getLong("e_scheid");
                if (!backPayAmount.containsKey(paySchId)) {
                    backPayAmount.put(paySchId, BigDecimal.ZERO);
                }
                BigDecimal actAmount = entry.getBigDecimal("e_actamt");
                BigDecimal storeAmount = (BigDecimal)backPayAmount.get(paySchId);
                BigDecimal amount = storeAmount.add(actAmount);
                backPayAmount.put(paySchId, amount);
            }
        }
        for (DynamicObject dataEntity : dataEntities) {
            ArrayList<DynamicObject> needUpdatePayBillList = new ArrayList<DynamicObject>(10);
            Object pkValue = dataEntity.getPkValue();
            DynamicObject dbData = (DynamicObject)dbDataMap.get(pkValue);
            DynamicObjectCollection entry = dbData.getDynamicObjectCollection("entry");
            List<Object> schIdList = entry.stream().map(i -> i.get("e_scheid")).collect(Collectors.toList());
            String settType = dbData.getString(String.join((CharSequence)".", "settletype", "settlementtype"));
            DynamicObjectCollection drafts = dbData.getDynamicObjectCollection("draftbill");
            List<Long> draftIds = drafts.stream().filter(o -> o.getDynamicObject("fbasedataid") != null).map(o -> o.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
            logger.info(String.format("\u8c03\u7528psd\u9000\u5355\u5fae\u670d\u52a1\uff0c\u4ed8\u6b3e\u5355id\uff1a{%s}\uff0c\u7ed3\u7b97\u65b9\u5f0f\uff1a{%s}\uff0c\u7968\u636eid\uff1a{%s}\uff0c\u6392\u7a0b\u5355id\uff1a{%s}", pkValue, settType, JSON.toJSONString(draftIds), JSON.toJSONString(schIdList)));
            PayBillBackRequest payBillBackRequest = new PayBillBackRequest();
            payBillBackRequest.setBackPayBillId(Long.valueOf(pkValue.toString()));
            payBillBackRequest.setPayBillType(settType);
            payBillBackRequest.setDraftIds(draftIds);
            payBillBackRequest.setSchDataIdList(schIdList);
            payBillBackRequest.setReason(reason);
            payBillBackRequest.setBackPayAmount(backPayAmount);
            String request = JSON.toJSONString((Object)payBillBackRequest);
            String resultStr = (String)DispatchServiceHelper.invokeBizService((String)"tmc", (String)"psd", (String)"tmcPayScheService", (String)"backPayBillRollBackSchedule", (Object[])new Object[]{request});
            PayBillBackResult payBillBackResult = (PayBillBackResult)JSON.parseObject((String)resultStr, PayBillBackResult.class);
            if (!payBillBackResult.getSuccess().booleanValue()) {
                logger.error(String.format("\u8c03\u7528psd\u9000\u5355\u5fae\u670d\u52a1\u5f02\u5e38\uff0c{%s}", payBillBackResult.getErrMsg()));
                throw new KDBizException(payBillBackResult.getErrMsg());
            }
            DynamicObjectCollection otherPayBillColl = QueryServiceHelper.query((String)"cas_paybill", (String)"id", (QFilter[])new QFilter[]{new QFilter(String.join((CharSequence)".", "entry", "e_scheid"), "in", schIdList), new QFilter("iswaitsche", "=", (Object)"0"), new QFilter("id", "!=", pkValue)});
            List otherPayBillIdList = otherPayBillColl.stream().map(i -> i.get("id")).collect(Collectors.toList());
            logger.error(String.format("\u51fa\u7eb3\u9000\u5355-\u5f53\u524d\u6240\u9000\u4ed8\u6b3e\u5355\u5bf9\u5e94\u6392\u7a0b\u5355\u6240\u6709\u4e0b\u63a8\u7684\u4ed8\u6b3e\u5355\uff0c\u5176\u4ed6\u4ed8\u6b3e\u5355id{%s}", JSON.toJSONString(otherPayBillIdList)));
            DynamicObject[] otherPayBillArr = BusinessDataServiceHelper.load((Object[])otherPayBillIdList.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cas_paybill"));
            dbData.set("iswaitsche", (Object)"1");
            dbData.set("billstatus", (Object)BillStatusEnum.SAVE.getValue());
            dbData.set("reason", (Object)reason);
            dbData.set("backuser", (Object)Long.valueOf(RequestContext.get().getUserId()));
            dbData.set("backdate", (Object)new Date());
            List newPaySchBillIdList = payBillBackResult.getNewPaySchBillIdList();
            List oldPaySchBillIdList = payBillBackResult.getOldPaySchBillIdList();
            needUpdatePayBillList.add(dbData);
            if (SettleMentTypeEnum.CHECK.getValue().equals(settType) || SettleMentTypeEnum.BUSINESS.getValue().equals(settType) || SettleMentTypeEnum.BANK.getValue().equals(settType) || SettleMentTypeEnum.CREDIT.getValue().equals(settType)) {
                if (otherPayBillArr.length > 0) {
                    List oldPsySchEntryList = otherPayBillArr[0].getDynamicObjectCollection("entry").stream().filter(i -> oldPaySchBillIdList.contains(i.getLong("e_scheid"))).collect(Collectors.toList());
                    for (int i2 = 0; i2 < oldPsySchEntryList.size(); ++i2) {
                        ((DynamicObject)oldPsySchEntryList.get(i2)).set("e_scheid", newPaySchBillIdList.get(i2));
                    }
                    needUpdatePayBillList.add(otherPayBillArr[0]);
                }
                dbData.set("draftbill", null);
                DynamicObjectCollection draftInfo = dbData.getDynamicObjectCollection("cas_draftinfo");
                if (draftInfo != null && EmptyUtil.isNoEmpty((DynamicObjectCollection)draftInfo)) {
                    draftInfo.clear();
                }
            } else if (otherPayBillArr.length > 0) {
                DynamicObjectCollection payBillEntry = dbData.getDynamicObjectCollection("entry");
                List oldPsySchEntryList = payBillEntry.stream().filter(i -> oldPaySchBillIdList.contains(i.getLong("e_scheid"))).collect(Collectors.toList());
                for (int i3 = 0; i3 < oldPsySchEntryList.size(); ++i3) {
                    ((DynamicObject)oldPsySchEntryList.get(i3)).set("e_scheid", newPaySchBillIdList.get(i3));
                }
            }
            try (TXHandle h = TX.requiresNew((String)"backPayBill.tx");){
                try {
                    if (PayBillHepler.isLCSettlement((DynamicObject)dbData)) {
                        PayBillHepler.payApplyBillWriteBackArrival((DynamicObject)dbData, (WriteBackOperateEnum)WriteBackOperateEnum.CHARGEBACK, PaymentDisposeConsumer.class);
                        dbData.set("settletnumber", null);
                    }
                    SaveServiceHelper.save((DynamicObject[])needUpdatePayBillList.toArray(new DynamicObject[0]));
                }
                catch (Exception exception) {
                    h.markRollback();
                    logger.error("\u4ed8\u6b3e\u5355\u4fdd\u5b58\u5f02\u5e38,%s", (Throwable)exception);
                    try {
                        DispatchServiceHelper.invokeBizService((String)"tmc", (String)"psd", (String)"tmcPayScheService", (String)"backPayBillRollBack", (Object[])new Object[]{Long.valueOf(pkValue.toString())});
                    }
                    catch (Exception except) {
                        logger.error(String.format("\u51fa\u7eb3\u9000\u5355\u56de\u6eda\u5f02\u5e38\uff0c\u3010%s\u3011", except));
                    }
                }
            }
        }
    }
}

