/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin.payment;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.plugin.args.RollbackOperationArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.business.helper.PayBillHepler;
import kd.fi.cas.business.paysche.bean.DraftAmountLockSubInfo;
import kd.fi.cas.business.paysche.bean.DraftLockInfo;
import kd.fi.cas.business.paysche.serive.DraftLockServiceHelper;
import kd.fi.cas.enums.LogBizStatusEnum;
import kd.fi.cas.enums.LogBizTypeEnum;
import kd.fi.cas.enums.LogOperateTypeEnum;
import kd.fi.cas.helper.BaseDataHelper;
import kd.fi.cas.validator.freeze.PaymentBillMatchValidator;

public class PaymentPayScheInvalidOp
extends AbstractOperationServicePlugIn {
    private static Log logger = LogFactory.getLog(PaymentPayScheInvalidOp.class);
    private DraftLockServiceHelper draftLockServiceHelper = new DraftLockServiceHelper();

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("draftbill");
        fieldKeys.add("sourcebilltype");
        fieldKeys.add("sourcebillid");
        fieldKeys.add("matchflag");
        fieldKeys.add("cas_draftinfo");
        fieldKeys.add("billno");
        fieldKeys.add("sourcebilltype");
        fieldKeys.add("sourcebillid");
        fieldKeys.add("settletype");
        fieldKeys.add("entry");
        fieldKeys.add(String.join((CharSequence)".", "cas_draftinfo", "draftbillinfo"));
        fieldKeys.add(String.join((CharSequence)".", "cas_draftinfo", "transamount"));
        fieldKeys.add(String.join((CharSequence)".", "cas_draftinfo", "draftbilllogid"));
        fieldKeys.add(String.join((CharSequence)".", "entry", "e_sourcebillid"));
        fieldKeys.add("billno");
        fieldKeys.add("settletnumber");
        fieldKeys.add("dpcurrency");
        fieldKeys.add("actpayamt");
        fieldKeys.add("bizdate");
        fieldKeys.add("org");
        fieldKeys.add("payerbank");
        fieldKeys.add("payeetype");
        fieldKeys.add("payeename");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.getValidators().add(new PaymentBillMatchValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        PayBillHepler.payBillOpDelRela((OperateOption)this.getOption(), (DynamicObject[])e.getDataEntities());
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        logger.info("deal billlog start");
        super.endOperationTransaction(e);
        String operationKey = e.getOperationKey();
        DynamicObject[] dataEntities = e.getDataEntities();
        ArrayList<DraftLockInfo> lockInfoList = new ArrayList<DraftLockInfo>(0);
        ArrayList<DraftLockInfo> changeLockInfoList = new ArrayList<DraftLockInfo>(0);
        for (DynamicObject info : dataEntities) {
            Long draftLogId;
            BigDecimal dealAmount;
            DraftAmountLockSubInfo draftAmountLockInfo;
            String sourceBillType = info.getString("sourcebilltype");
            DynamicObject settleType = info.getDynamicObject("settletype");
            boolean isDraftSettleType = BaseDataHelper.isSettleTypeDraft((DynamicObject)settleType);
            boolean checkDraft = BaseDataHelper.isSettleTypeCheck((DynamicObject)settleType);
            if ("cdm_drafttradebill".equals(sourceBillType) || !isDraftSettleType && !checkDraft) {
                logger.info("is not draftType or is from cdm" + info.getString("billno"));
                continue;
            }
            List<Object> lockDraftIds = new ArrayList(8);
            Map<Object, Object> draftIdDealAmountMap = new HashMap(8);
            Map draftIdLogIdMap = new HashMap(8);
            DynamicObjectCollection draftbillColl = info.getDynamicObjectCollection("cas_draftinfo");
            if (draftbillColl.size() > 0) {
                lockDraftIds = draftbillColl.stream().map(v -> v.getDynamicObject("draftbillinfo").getLong("id")).collect(Collectors.toList());
                draftIdDealAmountMap = draftbillColl.stream().collect(Collectors.toMap(v -> v.getDynamicObject("draftbillinfo").getLong("id"), o -> o.getBigDecimal("transamount"), (o1, o2) -> o1, HashMap::new));
                draftIdLogIdMap = draftbillColl.stream().collect(Collectors.toMap(v -> v.getDynamicObject("draftbillinfo").getLong("id"), o -> o.getLong("draftbilllogid"), (o1, o2) -> o1, HashMap::new));
            } else {
                draftbillColl = info.getDynamicObjectCollection("draftbill");
                if (draftbillColl.size() == 0) continue;
                lockDraftIds = draftbillColl.stream().map(v -> v.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
                DynamicObject[] draftBills = BusinessDataServiceHelper.load((String)"cdm_draftbillf7", (String)"amount", (QFilter[])new QFilter[]{new QFilter("id", "in", lockDraftIds)});
                draftIdDealAmountMap = Arrays.stream(draftBills).collect(Collectors.toMap(e1 -> e1.getLong("id"), e1 -> e1.getBigDecimal("amount")));
            }
            DraftLockInfo draftLockInfo = new DraftLockInfo();
            draftLockInfo.setSourceBillId(Long.valueOf(info.getLong("id")));
            draftLockInfo.setSourceBillType(info.getDataEntityType().getName());
            String sourcebilltype = info.getString("sourcebilltype");
            if ("cas_payapplybill".equals(sourcebilltype) && PayBillHepler.checkDraftAllInPayApplyBill((DynamicObject)info, new ArrayList(lockDraftIds))) {
                draftLockInfo.setTargetBillId(Long.valueOf(info.getLong("sourcebillid")));
                draftLockInfo.setTargetBillType(sourcebilltype);
                draftLockInfo.setSourceBillType(info.getDataEntityType().getName());
                draftLockInfo.setBizBillNo(info.getString("billno"));
                draftLockInfo.setSourceBillId(Long.valueOf(info.getLong("id")));
                for (Long l : lockDraftIds) {
                    draftAmountLockInfo = new DraftAmountLockSubInfo();
                    draftAmountLockInfo.setBillTradeStatus(LogBizStatusEnum.PROCESS.getValue());
                    draftAmountLockInfo.setBillId(l);
                    dealAmount = draftIdDealAmountMap.get(l) == null ? BigDecimal.ZERO : (BigDecimal)draftIdDealAmountMap.get(l);
                    draftAmountLockInfo.setDealAmount(dealAmount);
                    draftLogId = draftIdLogIdMap.get(l) == null ? Long.valueOf(0L) : (Long)draftIdLogIdMap.get(l);
                    draftAmountLockInfo.setBillLogId(draftLogId);
                    draftLockInfo.getLockSubInfoList().add(draftAmountLockInfo);
                }
                if (CollectionUtils.isEmpty((Collection)draftLockInfo.getLockSubInfoList())) continue;
                changeLockInfoList.add(draftLockInfo);
                continue;
            }
            if ("cdm_drafttradebill".equals(sourcebilltype) && "chargeback".equals(operationKey)) continue;
            for (Long l : lockDraftIds) {
                draftAmountLockInfo = new DraftAmountLockSubInfo();
                draftAmountLockInfo.setBillId(l);
                dealAmount = draftIdDealAmountMap.get(l) == null ? BigDecimal.ZERO : (BigDecimal)draftIdDealAmountMap.get(l);
                draftAmountLockInfo.setDealAmount(dealAmount);
                draftLogId = draftIdLogIdMap.get(l) == null ? Long.valueOf(0L) : (Long)draftIdLogIdMap.get(l);
                draftAmountLockInfo.setBillLogId(draftLogId);
                draftAmountLockInfo.setBillTrade(LogBizTypeEnum.ENDORSE.getValue());
                draftAmountLockInfo.setOperateType(LogOperateTypeEnum.DELETE.getValue());
                draftLockInfo.getLockSubInfoList().add(draftAmountLockInfo);
            }
            if (CollectionUtils.isEmpty((Collection)draftLockInfo.getLockSubInfoList())) continue;
            lockInfoList.add(draftLockInfo);
        }
        if (!CollectionUtils.isEmpty(changeLockInfoList)) {
            this.draftLockServiceHelper.changeDraftLock(changeLockInfoList);
        }
        if (!CollectionUtils.isEmpty(lockInfoList)) {
            this.draftLockServiceHelper.releaseOrLockDraft(lockInfoList);
        }
        logger.info("deal billlog end");
    }

    public void rollbackOperation(RollbackOperationArgs e) {
        this.draftLockServiceHelper.rollback();
    }
}

