/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin.payment;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.validator.paymentbill.PaymentSchePassiveCanclePayValidator;

public class PaymentSchePassiveCanclePayOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("billstatus");
        fieldKeys.add("iswaitsche");
        fieldKeys.add("settletype");
        fieldKeys.add("sourcebilltype");
        fieldKeys.add("entry");
        fieldKeys.add("e_payableamt");
        fieldKeys.add("entrustorg");
        fieldKeys.add("isheadpush");
        fieldKeys.add("isdiffcur");
        fieldKeys.add("currency");
        fieldKeys.add("exchangerate");
        fieldKeys.add("exratedate");
        fieldKeys.add("draftbill");
        fieldKeys.add("paymentchannel");
        fieldKeys.add("payee");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new PaymentSchePassiveCanclePayValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] payBills = e.getDataEntities();
        List payBillIds = Arrays.stream(payBills).map(DataEntityBase::getPkValue).collect(Collectors.toList());
        payBills = BusinessDataServiceHelper.load((Object[])payBillIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cas_paybill"));
        String isrollback = (String)this.getOption().getVariables().get("isrollback");
        String iswaitsche = EmptyUtil.isNoEmpty((String)isrollback) ? "0" : "1";
        for (DynamicObject payBill : payBills) {
            payBill.set("iswaitsche", (Object)iswaitsche);
            payBill.set("billstatus", (Object)BillStatusEnum.SAVE.getValue());
            payBill.set("draftbill", null);
        }
        SaveServiceHelper.save((DynamicObject[])payBills);
    }
}

