/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin.recbill;

import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.helper.OperateServiceHelper;
import kd.fi.cas.validator.receivingbill.ReceivingBillReturnMoneyIfmValidator;

public class ReceivingBillReturnMoneyIfmOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(ReceivingBillReturnMoneyIfmOp.class);
    private static final String select = "id,paidstatus,acrefundamt,actpayamt,acrefundreson,recbill";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("entryentity");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] bills;
        super.beginOperationTransaction(e);
        String reBillId = this.getOption().getVariableValue("rebillid");
        List seqList = (List)SerializationUtils.fromJsonString((String)this.getOption().getVariableValue("selected"), List.class);
        DynamicObject[] dataEntities = e.getDataEntities();
        DynamicObjectCollection dynamicObjectCollection = dataEntities[0].getDynamicObjectCollection("entryentity");
        List ids = dynamicObjectCollection.stream().filter(f -> seqList.contains(f.getInt("seq") - 1)).map(d -> d.getLong("id")).collect(Collectors.toList());
        DynamicObject recBill = BusinessDataServiceHelper.loadSingle((Object)reBillId, (String)"cas_recbill");
        DynamicObjectCollection recCol = recBill.getDynamicObjectCollection("entry");
        BigDecimal recAmtSum = recCol.stream().map(o -> o.getBigDecimal("e_receivableamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
        QFilter qFilter = new QFilter("id", "in", ids);
        for (DynamicObject bill : bills = BusinessDataServiceHelper.load((String)"ifm_transhandlebill", (String)select, (QFilter[])qFilter.toArray())) {
            String txtDescription = recBill.getString("txt_description");
            if (txtDescription != null && txtDescription.length() > 256) {
                txtDescription = txtDescription.substring(0, 255);
            }
            bill.set("acrefundreson", (Object)txtDescription);
            bill.set("acrefundamt", (Object)recAmtSum);
            bill.set("paidstatus", (Object)"F");
            bill.set("recbill", (Object)recBill);
        }
        OperationResult operationResult = OperateServiceHelper.execOperate((String)"refundwriteback", (String)"ifm_transhandlebill", (DynamicObject[])bills, (OperateOption)OperateOption.create());
        if (!operationResult.isSuccess()) {
            throw new KDBizException(operationResult.getMessage());
        }
        this.saveRecBill(recBill, bills[0].getBigDecimal("actpayamt"));
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.getValidators().add(new ReceivingBillReturnMoneyIfmValidator());
    }

    private void saveRecBill(DynamicObject recBill, BigDecimal actpayamt) {
        recBill.set("isrefund", (Object)true);
        recBill.set("isfullrefund", (Object)true);
        BigDecimal actrecamt = recBill.getBigDecimal("actrecamt");
        BigDecimal actRecAmtFee = actrecamt.add(recBill.getBigDecimal("fee"));
        if (actRecAmtFee.compareTo(actpayamt) != 0) {
            recBill.set("isfullrefund", (Object)false);
        }
        try (TXHandle tx = TX.requiresNew();){
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{recBill});
        }
    }
}

