/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin.recbill;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.RollbackOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.JSONUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.business.refund.RefundOpHelper;
import kd.fi.cas.business.writeback.AgentWriteBackConsumer;
import kd.fi.cas.business.writeback.WriteBackTaskHelper;
import kd.fi.cas.business.writeback.consts.WriteBackOperateEnum;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.helper.AgentPayBillHelper;
import kd.fi.cas.helper.CasBotpHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.OperateServiceHelper;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.validator.ReceivingRefundValidate;
import kd.fi.cas.validator.receivingbill.ReceivingRefundAndReturnMoneyBackValidator;
import kd.fi.cas.validator.receivingbill.ReceivingRefundAndReturnMoneyContainIfmBackValidator;

public class ReceivingRefundBackOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(ReceivingRefundBackOp.class);
    private static final String selectFields = "sourcebilltype,entry.sourceentryid,entry.e_issuccess,entry.e_amount,entry.e_isrefund,entry.e_refundamt,entry.e_refunddes,entry.refundbillid,entry.refundtype";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("id");
        fieldKeys.add("actrecamt");
        fieldKeys.add("settletype");
        fieldKeys.add("entry");
        fieldKeys.add("entry.e_receivableamt");
        fieldKeys.add("txt_description");
        fieldKeys.add("fee");
        fieldKeys.add("payername");
        fieldKeys.add("receivingtype");
        fieldKeys.add("ispartreceivable");
        fieldKeys.add("receivingtype.ispartreceivable");
        fieldKeys.add("payer");
        fieldKeys.add("currency.id");
        fieldKeys.add("receivingtype.biztype");
        fieldKeys.add("inneraccount.company.id");
        fieldKeys.add("accountbank.id");
        fieldKeys.add("payeracctbanknum");
        fieldKeys.add("org.id");
        fieldKeys.add("refundbatchseqid");
        fieldKeys.add("entry.e_settledamt");
        fieldKeys.add("isrefund");
        fieldKeys.add("isfullrefund");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new ReceivingRefundAndReturnMoneyContainIfmBackValidator());
        e.addValidator((AbstractValidator)new ReceivingRefundValidate());
        e.addValidator((AbstractValidator)new ReceivingRefundAndReturnMoneyBackValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        Map variables = this.getOption().getVariables();
        String billType = (String)variables.get("billtype");
        Long billId = Long.valueOf(variables.get("billid") == null ? "0" : (String)variables.get("billid"));
        DynamicObject recbill = e.getDataEntities()[0];
        long rebillid = recbill.getLong("id");
        String description = recbill.getString("txt_description");
        DynamicObjectCollection recCol = recbill.getDynamicObjectCollection("entry");
        BigDecimal recAmtSum = recCol.stream().map(o -> o.getBigDecimal("e_receivableamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
        if ("cas_paybill".equals(billType)) {
            DynamicObject payMent;
            DynamicObject payBill = BusinessDataServiceHelper.loadSingle((Object)billId, (String)billType);
            payBill.set("refundbillid", (Object)rebillid);
            this.payRefund(payBill, recAmtSum, description);
            logger.info("\u9000\u7968\uff0c\u4ed8\u6b3e\u5355\u4fe1\u606f\uff1a" + SerializationUtils.toJsonString((Object)payBill));
            if (!CasHelper.isEmpty((Object)payBill.get("applyorg")) && "cas_paybill".equals(payBill.get("sourcebilltype")) && !CasHelper.isEmpty((Object)payBill.get("sourcebillid")) && !CasHelper.isEmpty((Object)(payMent = BusinessDataServiceHelper.loadSingle((Object)payBill.get("sourcebillid"), (String)"cas_paybill")))) {
                this.payRefund(payMent, recAmtSum, description);
            }
            CasBotpHelper.saveRelation((String)"cas_recbill", (Long)rebillid, (String)"cas_paybill", (Long)billId);
            this.saveRecBill(recbill);
            OperateOption create = OperateOption.create();
            create.setVariableValue("ishasright", "true");
            OperateServiceHelper.execOperate((String)"paywritebackap", (String)"cas_recbill", (Object[])new Object[]{rebillid}, (OperateOption)create);
        } else if ("cas_agentpaybill".equals(billType)) {
            Set sourceAgentBillIds;
            Long entryId = Long.valueOf((String)variables.get("entryid"));
            DynamicObject agenBill = BusinessDataServiceHelper.loadSingle((Object)billId, (String)billType, (String)selectFields);
            Long sourceEntryId = RefundOpHelper.agentRefund((DynamicObject)agenBill, (Long)entryId, (BigDecimal)recAmtSum, (String)description, (Long)rebillid, (String)WriteBackOperateEnum.RENOTE.getValue(), (Boolean)true);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{agenBill});
            if (AgentPayBillHelper.isDelegPush((DynamicObject)agenBill) && (sourceAgentBillIds = CasBotpHelper.getSrcBillByDestBill((Long)billId, (String)"cas_agentpaybill", (String)"cas_agentpaybill")) != null) {
                DynamicObject[] sourceAgentBills = BusinessDataServiceHelper.load((String)billType, (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)sourceAgentBillIds)});
                ArrayList<DynamicObject> needSaveBills = new ArrayList<DynamicObject>(10);
                for (DynamicObject sourceAgentBill : sourceAgentBills) {
                    RefundOpHelper.agentRefund((DynamicObject)sourceAgentBill, (Long)sourceEntryId, (BigDecimal)recAmtSum, (String)description, null, (String)WriteBackOperateEnum.RENOTE.getValue(), (Boolean)true);
                    needSaveBills.add(sourceAgentBill);
                }
                SaveServiceHelper.save((DynamicObject[])needSaveBills.toArray(new DynamicObject[0]));
            }
            CasBotpHelper.saveRelation((String)"cas_recbill", (Long)rebillid, (String)"cas_agentpaybill", (Long)billId);
            this.saveRecBill(recbill);
        }
        logger.info("\u9000\u7968\u6267\u884c\u5b8c\u6bd5!");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        Map variables = this.getOption().getVariables();
        String billType = (String)variables.get("billtype");
        Long billId = Long.valueOf((String)variables.get("billid"));
        if ("cas_agentpaybill".equals(billType)) {
            Set sourceAgentBillIds;
            Long entryId = Long.valueOf((String)variables.get("entryid"));
            DynamicObject agenBill = BusinessDataServiceHelper.loadSingle((Object)billId, (String)billType, (String)selectFields);
            Long sourceEntryId = this.agentWriteBack(agenBill, entryId);
            if (AgentPayBillHelper.isDelegPush((DynamicObject)agenBill) && (sourceAgentBillIds = CasBotpHelper.getSrcBillByDestBill((Long)billId, (String)"cas_agentpaybill", (String)"cas_agentpaybill")) != null) {
                DynamicObject[] sourceAgentBills;
                for (DynamicObject sourceAgentBill : sourceAgentBills = BusinessDataServiceHelper.load((String)billType, (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)sourceAgentBillIds)})) {
                    this.agentWriteBack(sourceAgentBill, sourceEntryId);
                }
            }
        }
        try {
            logger.info("\u9000\u7968\uff0cafterExecuteOperationTransaction\uff1a" + JSONUtils.toString((Object)e));
        }
        catch (IOException e1) {
            logger.info("\u9000\u7968\uff0cafterExecuteOperationTransaction\u6253\u5370\u5931\u8d25");
        }
    }

    public void rollbackOperation(RollbackOperationArgs e) {
        super.rollbackOperation(e);
        try {
            logger.info("\u9000\u7968\uff0crollbackOperation\uff1a" + JSONUtils.toString((Object)e));
        }
        catch (IOException e1) {
            logger.info("\u9000\u7968\uff0cafterExecuteOperationTransaction\u6253\u5370\u5931\u8d25");
        }
    }

    private void saveRecBill(DynamicObject recbill) {
        recbill.set("isrefund", (Object)true);
        recbill.set("isfullrefund", (Object)true);
        Object[] save = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{recbill});
        logger.info("\u9000\u7968\uff0c\u6536\u6b3e\u5355\u4fe1\u606f\uff1a" + SerializationUtils.toJsonString((Object)recbill));
        if (null != save) {
            logger.info("\u9000\u7968\uff0c\u6536\u6b3e\u5355\u4fe1\u606fSaveServiceHelper.save\uff1a" + SerializationUtils.toJsonString((Object)save));
        }
    }

    private void payRefund(DynamicObject payBill, BigDecimal refundAmt, String description) {
        BigDecimal e_refundamt_i;
        payBill.set("billstatus", (Object)BillStatusEnum.RENOTE.getValue());
        DynamicObject feeBill = RefundOpHelper.resetPayAndFeeStatusForRefund((DynamicObject)payBill, (String)BillStatusEnum.RENOTE.getValue());
        DynamicObjectCollection entry = payBill.getDynamicObjectCollection("entry");
        List sortEntry = entry.stream().sorted(Comparator.comparing(dynamicObject -> dynamicObject.getBigDecimal("e_payableamt"))).collect(Collectors.toList());
        HashMap<Long, BigDecimal> regundAmtMap = new HashMap<Long, BigDecimal>(sortEntry.size());
        for (DynamicObject d : sortEntry) {
            e_refundamt_i = d.getBigDecimal("e_payableamt");
            if (e_refundamt_i.compareTo(refundAmt) <= 0) {
                refundAmt = refundAmt.subtract(e_refundamt_i);
                regundAmtMap.put(d.getLong("id"), e_refundamt_i);
                continue;
            }
            regundAmtMap.put(d.getLong("id"), refundAmt);
            break;
        }
        for (DynamicObject d : entry) {
            e_refundamt_i = (BigDecimal)regundAmtMap.get(d.getLong("id"));
            if (e_refundamt_i == null) continue;
            d.set("e_refundamt", (Object)e_refundamt_i);
            d.set("e_refunddes", (Object)description);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{payBill});
        if (EmptyUtil.isNoEmpty((DynamicObject)feeBill)) {
            try (TXHandle h = TX.requiresNew();){
                try {
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{feeBill});
                }
                catch (Throwable e) {
                    h.markRollback();
                    throw e;
                }
            }
        }
        OperateServiceHelper.execOperate((String)"confirmrefund", (String)"cas_paybill", (Object[])new Object[]{payBill.getPkValue()}, (OperateOption)OperateOption.create());
    }

    private Long agentWriteBack(DynamicObject agentBill, Long entryId) {
        long sourceEntryId = 0L;
        if (CasHelper.isNotEmpty((Object)agentBill.getString("sourcebilltype"))) {
            DynamicObjectCollection entrys = agentBill.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entrys) {
                if (!entryId.equals(entry.getLong("id"))) continue;
                sourceEntryId = entry.getLong("sourceentryid");
                HashMap<String, List<Long>> param = new HashMap<String, List<Long>>();
                param.put("entryPks", Collections.singletonList(entryId));
                WriteBackTaskHelper.addRealtimeTask((DynamicObject)agentBill, (String)agentBill.getString("sourcebilltype"), (WriteBackOperateEnum)WriteBackOperateEnum.RENOTE, AgentWriteBackConsumer.class, param);
                break;
            }
        }
        OperateServiceHelper.execOperate((String)"synctrigger", (String)agentBill.getDataEntityType().getName(), (Object[])new Object[]{agentBill.getPkValue()}, (OperateOption)OperateOption.create());
        return sourceEntryId;
    }
}

