/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin.recchg;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.ai.DapVoucherUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.helper.OperateServiceHelper;
import kd.fi.cas.util.DateUtils;

public class RecBillChangeVoucherOp
extends AbstractOperationServicePlugIn {
    public static final String PARA_VOUCHERSMAP = "vouchersMap";
    public static final String PARA_SRCBILLMAP = "srcBillMap";
    private Log logger = LogFactory.getLog(RecBillChangeVoucherOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("sourcebilltype");
        fieldKeys.add("sourcebillnumber");
        fieldKeys.add("ischgvoucher");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public void validate() {
                List operateData = Arrays.stream(this.getDataEntities()).map(ExtendedDataEntity::getDataEntity).collect(Collectors.toList());
                HashMap<String, Long> vouchersMap = new HashMap<String, Long>(operateData.size());
                Map<String, List<DynamicObject>> srcTypeMap = operateData.stream().collect(Collectors.groupingBy(v -> v.getString("sourcebilltype")));
                HashMap srcBillMap = new HashMap();
                for (Map.Entry<String, List<DynamicObject>> entrySet : srcTypeMap.entrySet()) {
                    String srcBillType = entrySet.getKey();
                    List<DynamicObject> recBills = entrySet.getValue();
                    if (CollectionUtils.isEmpty(recBills)) continue;
                    List srcNumbers = recBills.stream().map(v -> v.getString("sourcebillnumber")).collect(Collectors.toList());
                    DynamicObject[] srcBills = BusinessDataServiceHelper.load((String)srcBillType, (String)"billno", (QFilter[])new QFilter[]{new QFilter("billno", "in", srcNumbers)});
                    Arrays.stream(srcBills).forEach(v -> srcBillMap.put(srcBillType + v.getString("billno"), v.getPkValue()));
                }
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    DynamicObject recBill = dataEntity.getDataEntity();
                    String billType = recBill.getString("sourcebilltype");
                    String srcNumber = recBill.getString("sourcebillnumber");
                    boolean isChgvoucher = recBill.getBoolean("ischgvoucher");
                    if (isChgvoucher) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u51ed\u8bc1\u5df2\u53d8\u66f4\uff0c\u8bf7\u52ff\u91cd\u590d\u6267\u884c\u3002", (String)"RecBillChangeVoucherOp_0", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                    Object srcBilId = srcBillMap.get(billType + srcNumber);
                    Set vouchers = DapVoucherUtil.getBuildVch(Collections.singleton(srcBilId), (String)billType);
                    if (CollectionUtils.isEmpty((Collection)vouchers)) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u539f\u6536\u6b3e\u5355\u6ca1\u6709\u751f\u6210\u51ed\u8bc1\uff0c\u65e0\u9700\u53d8\u66f4\u51ed\u8bc1\u3002", (String)"RecBillChangeVoucherOp_1", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                    DynamicObject[] voucherObjs = BusinessDataServiceHelper.load((String)"gl_voucher", (String)"id,createtime,isreverse,hasreverse", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)vouchers), new QFilter("isreverse", "=", (Object)"0"), new QFilter("hasreverse", "=", (Object)"0")}, (String)"createtime desc");
                    if (null == voucherObjs || voucherObjs.length == 0) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u6821\u9a8c\u5230\u53d8\u66f4\u524d\u6536\u6b3e\u5355\u51ed\u8bc1\u5df2\u7ecf\u88ab\u51b2\u9500\uff0c\u65e0\u9700\u518d\u6b21\u51b2\u9500\uff0c\u5982\u9700\u7ee7\u7eed\u751f\u6210\u51ed\u8bc1\uff0c\u8bf7\u901a\u8fc7\u6536\u6b3e\u5355\u751f\u6210\u51ed\u8bc1\u529f\u80fd\u5b9e\u73b0", (String)"RecBillChangeVoucherOp_3", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                    vouchersMap.put(srcNumber, voucherObjs[0].getLong("id"));
                }
                this.getOption().setVariableValue(RecBillChangeVoucherOp.PARA_VOUCHERSMAP, JSON.toJSONString(vouchersMap));
                this.getOption().setVariableValue(RecBillChangeVoucherOp.PARA_SRCBILLMAP, JSON.toJSONString(srcBillMap));
            }
        });
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        Map vouchersMap = (Map)JSON.parseObject((String)((String)this.getOption().getVariables().get(PARA_VOUCHERSMAP)), (TypeReference)new TypeReference<Map<Object, Long>>(){}, (Feature[])new Feature[0]);
        Map srcBillMap = (Map)JSON.parseObject((String)((String)this.getOption().getVariables().get(PARA_SRCBILLMAP)), (TypeReference)new TypeReference<Map<String, Object>>(){}, (Feature[])new Feature[0]);
        try (TXHandle tx = TX.requiresNew();){
            try {
                for (DynamicObject recBill : dataEntities) {
                    String srcBillNumber = recBill.getString("sourcebillnumber");
                    String srcBillType = recBill.getString("sourcebilltype");
                    Object srcBillId = srcBillMap.get(srcBillType + srcBillNumber);
                    Long voucherId = (Long)vouchersMap.get(srcBillNumber);
                    OperateOption operate = OperateOption.create();
                    operate.setVariableValue("handtype", Boolean.FALSE.toString());
                    OperateServiceHelper.execOperate((String)"voucheragainst", (String)"gl_voucher", (Object[])new Object[]{voucherId}, (OperateOption)operate);
                    DynamicObject[] againstVoucher = BusinessDataServiceHelper.load((String)"gl_voucher", (String)"id,org,period,booktype", (QFilter[])new QFilter[]{new QFilter("isreverse", "=", (Object)"1"), new QFilter("sourcebill", "=", (Object)voucherId)}, (String)"createtime desc");
                    if (null == againstVoucher || againstVoucher.length == 0) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u53d8\u66f4\u51ed\u8bc1\u5931\u8d25\u3002\u672a\u751f\u6210\u7ea2\u51b2\u51ed\u8bc1\u3002", (String)"RecBillChangeVoucherOp_2", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                    }
                    this.saveDapTracker(againstVoucher[0], voucherId);
                    OperateOption option = OperateOption.create();
                    option.setVariableValue("ignoretemplateunique", "true");
                    option.setVariableValue("multidap", "true");
                    OperateServiceHelper.execOperate((String)"generatevoucher", (String)srcBillType, (Object[])new Object[]{srcBillId}, (OperateOption)option);
                }
            }
            catch (Exception e2) {
                tx.markRollback();
                this.logger.error(String.format("change voucher fail, errorInfo[%s]", e2));
                throw new KDBizException(e2.getMessage());
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        List pkList = Arrays.stream(dataEntities).map(DataEntityBase::getPkValue).collect(Collectors.toList());
        DynamicObject[] recChanges = BusinessDataServiceHelper.load((Object[])pkList.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cas_recchgbill"));
        Arrays.stream(recChanges).forEach(v -> v.set("ischgvoucher", (Object)true));
        SaveServiceHelper.save((DynamicObject[])recChanges);
    }

    private void saveDapTracker(DynamicObject againstVoucher, Long voucherId) {
        DynamicObject againstDaptracker = BusinessDataServiceHelper.newDynamicObject((String)"ai_daptracker");
        DynamicObject daptracker = BusinessDataServiceHelper.load((String)"ai_daptracker", (String)"billtype,vchtemplateid,sourcebillid", (QFilter[])new QFilter[]{new QFilter("voucherid", "=", (Object)voucherId)})[0];
        againstDaptracker.set("billtype", daptracker.getDynamicObject("billtype").getPkValue());
        againstDaptracker.set("sourcebillid", (Object)daptracker.getLong("sourcebillid"));
        againstDaptracker.set("createdate", (Object)DateUtils.getCurrentDate());
        againstDaptracker.set("voucherid", againstVoucher.getPkValue());
        againstDaptracker.set("vchtemplateid", (Object)daptracker.getLong("vchtemplateid"));
        againstDaptracker.set("org", againstVoucher.getDynamicObject("org").getPkValue());
        againstDaptracker.set("booktype", againstVoucher.getDynamicObject("booktype").getPkValue());
        againstDaptracker.set("period", againstVoucher.getDynamicObject("period").getPkValue());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{againstDaptracker});
    }
}

