/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin.recchg;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlParameter;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.property.CreateDateProp;
import kd.bos.entity.property.CreaterProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.ModifierProp;
import kd.bos.entity.property.ModifyDateProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.Param;
import kd.bos.kdtx.sdk.session.DTX;
import kd.bos.kdtx.sdk.session.DTXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.business.helper.RecBillHepler;
import kd.fi.cas.business.helper.RecBillOverAmountHelper;
import kd.fi.cas.business.opservice.helper.RecSaleServiceHelper;
import kd.fi.cas.business.writeback.consts.WriteBackOperateEnum;
import kd.fi.cas.consts.DBRouteConst;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.enums.HotAccountEnum;
import kd.fi.cas.helper.CasBankJournalHelper;
import kd.fi.cas.helper.CasBotpHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.CodeRuleHelper;
import kd.fi.cas.helper.EntityPropertyHelper;
import kd.fi.cas.helper.OperateServiceHelper;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.validator.OrgFinishinitValidator;

public class RecbillchangeAuditOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(RecbillchangeAuditOp.class);
    private DynamicObject cancelRecBill;
    private DynamicObject blueRecBill;
    private DynamicObject redRecBill;
    private DynamicObject newDelRecBill;
    private List<DynamicObject> oldRecBilList = new ArrayList<DynamicObject>(10);
    private List<DynamicObject> recBilList = new ArrayList<DynamicObject>(10);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("sourcebillid");
        fieldKeys.add("sourcebilltype");
        fieldKeys.add("hotaccount");
        fieldKeys.add("bankcheckentity.ebankcheckflag");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.getValidators().add(new OrgFinishinitValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        for (DynamicObject data : e.getDataEntities()) {
            DynamicObject recChgBill = BusinessDataServiceHelper.loadSingle((Object)data.getPkValue(), (String)"cas_recbill_change");
            DynamicObject firstBill = BusinessDataServiceHelper.loadSingle((Object)recChgBill.get("sourcebillid"), (String)"cas_recbill");
            DynamicObject oldRecBill = (DynamicObject)OrmUtils.clone((Object)firstBill, (IDataEntityType)firstBill.getDataEntityType(), (boolean)true, (boolean)false);
            this.oldRecBilList.add(oldRecBill);
            if (HotAccountEnum.HOTBILL.getValue().equals(recChgBill.getString("hotaccount"))) {
                this.recBillHotChange(recChgBill, firstBill);
                continue;
            }
            this.recBillChange(recChgBill, firstBill);
            this.recBilList.add(firstBill);
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        logger.info("RecbillchangeAuditOp afterExecuteOperationTransaction start");
        if (this.cancelRecBill != null) {
            OperationResult operate;
            RecBillOverAmountHelper.getWriteBackVad((DynamicObject)this.cancelRecBill, (WriteBackOperateEnum)WriteBackOperateEnum.CANCELRECEIVE, (boolean)false);
            boolean isVoucher = this.cancelRecBill.getBoolean("isvoucher");
            if (isVoucher && this.newDelRecBill != null && ((operate = OperateServiceHelper.execOperateWithoutThrow((String)"hotbillgeneratevoucher", (String)"cas_recbill", (Object[])new Object[]{this.newDelRecBill.getPkValue()}, (OperateOption)OperateOption.create())) == null || !operate.isSuccess())) {
                logger.info("[\u6536\u6b3e\u4e1a\u52a1\u53d8\u66f4]\u6e90\u5355\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u8c03\u7528\u7ea2\u51b2\u5355\u751f\u6210\u51ed\u8bc1\u64cd\u4f5c\u5931\u8d25\uff0c\u539f\u56e0\uff1a{}", (Object)(operate == null ? "\u64cd\u4f5c\u7ed3\u679c\u4e3anull" : operate.getMessage()));
            }
        }
        if (this.blueRecBill != null && this.redRecBill != null) {
            this.blueRecBill = BusinessDataServiceHelper.loadSingle((Object)this.blueRecBill.getPkValue(), (String)"cas_recbill");
            logger.info("RecClaimToAccountOp autoSettle blueRecBill:" + this.blueRecBill.getPkValue());
            try {
                Object result = DispatchServiceHelper.invokeBizService((String)"fi", (String)"ar", (String)"recself", (String)"autoSettle", (Object[])new Object[]{new DynamicObject[]{this.blueRecBill}, new DynamicObject[]{this.redRecBill}});
                String message = SerializationUtils.toJsonString((Object)result);
                logger.info("RecClaimToAccountOp autoSettle result:" + message);
            }
            catch (Exception exc) {
                logger.error("RecClaimToAccountOp autoSettle error:", (Throwable)exc);
            }
        }
    }

    private void recBillHotChange(DynamicObject recChgBill, DynamicObject firstBill) {
        boolean isNotice;
        if (firstBill == null) {
            return;
        }
        DynamicObject recType = firstBill.getDynamicObject("receivingtype");
        DynamicObject newRecBill3 = (DynamicObject)OrmUtils.clone((Object)firstBill, (IDataEntityType)firstBill.getDataEntityType(), (boolean)true, (boolean)true);
        String generateNumber = CodeRuleHelper.generateNumber((String)"cas_recbill", (DynamicObject)newRecBill3, null, null);
        if (StringUtils.isEmpty((CharSequence)generateNumber)) {
            generateNumber = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
        }
        newRecBill3.set("billno", (Object)generateNumber);
        this.cancelRecBill = firstBill;
        DynamicObject newRecBill2 = RecBillHepler.dealReverse((DynamicObject)firstBill, (Date)recChgBill.getDate("bizdate"));
        if (newRecBill2 == null) {
            return;
        }
        String entity = firstBill.getDataEntityType().getName();
        Long pk = (Long)firstBill.getPkValue();
        String sourceBillType = firstBill.getString("sourcebilltype");
        Map sourceBills = BFTrackerServiceHelper.findSourceBills((String)entity, (Long[])new Long[]{pk});
        if (CasHelper.isNotEmpty((Object)sourceBillType) && CasHelper.isNotEmpty((Object)sourceBills) && sourceBills.size() > 0) {
            HashSet sourceBillIds = (HashSet)sourceBills.get(sourceBillType);
            CasBotpHelper.saveRelation((String)sourceBillType, (Collection)sourceBillIds, (String)"cas_recbill", (Long)newRecBill2.getLong("id"));
        }
        this.newDelRecBill = newRecBill2;
        if (recType != null && recType.getBoolean("ispartreceivable")) {
            this.blueRecBill = firstBill;
            this.redRecBill = newRecBill2;
        }
        if (!(isNotice = "cas_claimcenterbill".equals(newRecBill3.getString("sourcebilltype")))) {
            newRecBill3.set("sourcebilltype", (Object)"cas_recbill");
            newRecBill3.set("sourcebillid", (Object)String.valueOf(newRecBill2.getPkValue()));
        }
        newRecBill3.set("hotedrecvnum", (Object)firstBill.getString("billno"));
        newRecBill3.set("hotedrecvid", (Object)firstBill.getLong("id"));
        newRecBill3.set("isvoucher", (Object)false);
        this.dealRecBillHot(recChgBill, newRecBill3);
        firstBill.set("billstatus", (Object)"D");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{firstBill});
        if (CasHelper.isNotEmpty((Object)sourceBillType) && CasHelper.isNotEmpty((Object)sourceBills) && sourceBills.size() > 0) {
            HashSet sourceBillIds = (HashSet)sourceBills.get(sourceBillType);
            CasBotpHelper.saveRelation((String)sourceBillType, (Collection)sourceBillIds, (String)"cas_recbill", (Long)newRecBill3.getLong("id"));
        }
    }

    private void recBillChange(DynamicObject recChgBill, DynamicObject firstBill) {
        this.dealRecBill(recChgBill, firstBill, recChgBill.getString("bbillstatus"), Boolean.FALSE);
        this.updateJournal(firstBill);
    }

    private void dealRecBill(DynamicObject recChgBill, DynamicObject firstBill, String billStatus, Boolean isHot) {
        MainEntityType transEntityType = EntityMetadataCache.getDataEntityType((String)"cas_recbill_change");
        List transFields = new EntityTypeUtil().getFilterFields((IDataEntityType)transEntityType);
        MainEntityType recEntityType = EntityMetadataCache.getDataEntityType((String)"cas_recbill");
        List recFields = new EntityTypeUtil().getFilterFields((IDataEntityType)recEntityType);
        HashSet<String> fieldSet = new HashSet<String>(recFields.size());
        for (FilterField field : recFields) {
            fieldSet.add(field.getSrcFieldKey());
        }
        HashSet<String> hasSetValue = new HashSet<String>(transFields.size());
        String itemPayer = "";
        for (FilterField transField : transFields) {
            if (transField.getFullFieldName().startsWith("entry") || transField.getFullFieldName().startsWith("infoentry")) continue;
            String fieldName = transField.getSrcFieldKey();
            IDataEntityProperty fieldProp = transField.getSrcFieldProp();
            if ((this.removeFields().contains(fieldName) || hasSetValue.contains(fieldName) || fieldProp instanceof DateProp || fieldProp instanceof TimeProp || fieldProp instanceof DateTimeProp || fieldProp instanceof ModifyDateProp || fieldProp instanceof CreateDateProp || fieldProp instanceof CreaterProp || fieldProp instanceof ModifierProp) && !"bizdate".equals(fieldName) && !fieldName.equals("exratedate")) continue;
            if (fieldSet.contains(fieldName) && !"biztype".equals(fieldName) && firstBill.containsProperty(fieldName) && recChgBill.containsProperty(fieldName)) {
                firstBill.set(fieldName, recChgBill.get(fieldName));
                hasSetValue.add(fieldName);
            }
            if (!"payer".equals(fieldName)) continue;
            itemPayer = firstBill.getString("payer");
        }
        if (CasHelper.isNotEmpty((Object)itemPayer)) {
            firstBill.set("itempayer", (Object)itemPayer);
        }
        DynamicObjectCollection recChgEntrys = recChgBill.getDynamicObjectCollection("entry");
        if (isHot.booleanValue()) {
            firstBill.set("entry", null);
        }
        DynamicObjectCollection recFirstEntrys = firstBill.getDynamicObjectCollection("entry");
        Set chgFields = EntityPropertyHelper.getEntryPropertys((String)"cas_recbill_change", (String)"entry.");
        Set changeFields = EntityPropertyHelper.getEntryPropertys((String)"cas_recbill", (String)"entry.");
        if (isHot.booleanValue()) {
            recChgEntrys.forEach(entry -> {
                DynamicObject newEntry = recFirstEntrys.addNew();
                for (String chgField : chgFields) {
                    if (!changeFields.contains(chgField)) continue;
                    newEntry.set(chgField, entry.get(chgField));
                }
            });
        } else {
            Set recChgEntryIds = recChgEntrys.stream().map(v -> v.getLong("e_sourcerecbillentryid")).collect(Collectors.toSet());
            Iterator iterator = recFirstEntrys.iterator();
            while (iterator.hasNext()) {
                Iterator nextDt = (DynamicObject)iterator.next();
                Long recEntryId = nextDt.getLong("id");
                if (recChgEntryIds.contains(recEntryId)) continue;
                iterator.remove();
            }
            for (DynamicObject recFirstEntry : recFirstEntrys) {
                for (DynamicObject recChgEntry : recChgEntrys) {
                    Long recChgEntryLong = recChgEntry.getLong("e_sourcerecbillentryid");
                    if (Long.compare(recChgEntryLong, recFirstEntry.getLong("id")) != 0) continue;
                    for (String chgField : chgFields) {
                        if (!changeFields.contains(chgField)) continue;
                        recFirstEntry.set(chgField, recChgEntry.get(chgField));
                    }
                }
            }
            for (DynamicObject recChgEntry : recChgEntrys) {
                Long recChgEntryLong = recChgEntry.getLong("e_sourcerecbillentryid");
                if (!EmptyUtil.isEmpty((Long)recChgEntryLong)) continue;
                DynamicObject newEntry = recFirstEntrys.addNew();
                for (String chgField : chgFields) {
                    if (!changeFields.contains(chgField)) continue;
                    newEntry.set(chgField, recChgEntry.get(chgField));
                }
            }
        }
        firstBill.set("billstatus", (Object)billStatus);
        firstBill.set("hotaccount", (Object)" ");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{firstBill});
        String updateStr = "UPDATE T_CAS_ReceivingBillEntry SET FSEQ =? WHERE FENTRYID=?";
        DynamicObject firstBillNew = BusinessDataServiceHelper.loadSingle((Object)recChgBill.get("sourcebillid"), (String)"cas_recbill");
        DynamicObjectCollection recEntrys = firstBillNew.getDynamicObjectCollection("entry");
        ArrayList<SqlParameter[]> updateParams = new ArrayList<SqlParameter[]>(recEntrys.size());
        for (int i = 0; i < recEntrys.size(); ++i) {
            SqlParameter[] params = new SqlParameter[]{new SqlParameter(":FSEQ", -5, (Object)(i + 1)), new SqlParameter(":FENTRYID", -5, ((DynamicObject)recEntrys.get(i)).get("id"))};
            updateParams.add(params);
        }
        DB.executeBatch((DBRoute)DBRouteConst.cas, (String)updateStr, updateParams);
    }

    private void dealRecBillHot(DynamicObject recChgBill, DynamicObject firstBill) {
        MainEntityType transEntityType = EntityMetadataCache.getDataEntityType((String)"cas_recbill_change");
        List transFields = new EntityTypeUtil().getFilterFields((IDataEntityType)transEntityType);
        MainEntityType recEntityType = EntityMetadataCache.getDataEntityType((String)"cas_recbill");
        List recFields = new EntityTypeUtil().getFilterFields((IDataEntityType)recEntityType);
        HashSet<String> fieldSet = new HashSet<String>(recFields.size());
        for (FilterField field : recFields) {
            fieldSet.add(field.getSrcFieldKey());
        }
        HashSet<String> hasSetValue = new HashSet<String>(transFields.size());
        String itemPayer = "";
        for (FilterField transField : transFields) {
            if (transField.getFullFieldName().startsWith("entry") || transField.getFullFieldName().startsWith("infoentry")) continue;
            String fieldName = transField.getSrcFieldKey();
            IDataEntityProperty fieldProp = transField.getSrcFieldProp();
            if ((this.removeFields().contains(fieldName) || hasSetValue.contains(fieldName) || fieldProp instanceof DateProp || fieldProp instanceof TimeProp || fieldProp instanceof DateTimeProp || fieldProp instanceof ModifyDateProp || fieldProp instanceof CreateDateProp || fieldProp instanceof CreaterProp || fieldProp instanceof ModifierProp) && !"bizdate".equals(fieldName) && !fieldName.equals("exratedate")) continue;
            if (fieldSet.contains(fieldName) && !"biztype".equals(fieldName) && firstBill.containsProperty(fieldName) && recChgBill.containsProperty(fieldName)) {
                firstBill.set(fieldName, recChgBill.get(fieldName));
                hasSetValue.add(fieldName);
            }
            if (!"payer".equals(fieldName)) continue;
            itemPayer = firstBill.getString("payer");
        }
        if (CasHelper.isNotEmpty((Object)itemPayer)) {
            firstBill.set("itempayer", (Object)itemPayer);
        }
        DynamicObjectCollection recChgEntrys = recChgBill.getDynamicObjectCollection("entry");
        firstBill.set("entry", null);
        DynamicObjectCollection recFirstEntrys = firstBill.getDynamicObjectCollection("entry");
        Set chgFields = EntityPropertyHelper.getEntryPropertys((String)"cas_recbill_change", (String)"entry.");
        Set changeFields = EntityPropertyHelper.getEntryPropertys((String)"cas_recbill", (String)"entry.");
        recChgEntrys.forEach(entry -> {
            DynamicObject newEntry = recFirstEntrys.addNew();
            for (String chgField : chgFields) {
                if (!changeFields.contains(chgField)) continue;
                newEntry.set(chgField, entry.get(chgField));
            }
        });
        firstBill.set("hotaccount", (Object)" ");
        firstBill.set("billstatus", (Object)"A");
        OperateOption option = OperateOption.create();
        option.setVariableValue("customsign", "cas_recbill_copy");
        OperateServiceHelper.execOperate((String)"save", (String)"cas_recbill", (DynamicObject[])new DynamicObject[]{firstBill}, (OperateOption)option);
    }

    public void updateJournal(DynamicObject bill) {
        if (!BillStatusEnum.PAY.getValue().equals(bill.getString("billstatus"))) {
            return;
        }
        DynamicObject[] journals = null;
        QFilter filters = new QFilter("sourcebilltype", "=", (Object)"cas_recbill").and("sourcebillid", "=", bill.getPkValue());
        if (bill.getDynamicObject("accountbank") != null) {
            journals = BusinessDataServiceHelper.load((String)"cas_bankjournal", (String)String.join((CharSequence)",", EntityPropertyHelper.getEntryPropertys((String)"cas_bankjournal", (String)"")), (QFilter[])new QFilter[]{filters});
        } else if (bill.getDynamicObject("accountcash") != null) {
            journals = BusinessDataServiceHelper.load((String)"cas_cashjournal", (String)"id,settlementtype,settlementnumber,direction,bizdate,bookdate,oppunit,oppacctnumber,oppbank,org,accountbank,entry.e_amount,entry.e_localamount,entry.e_fundflowitem", (QFilter[])new QFilter[]{filters});
        }
        if (journals == null) {
            return;
        }
        for (DynamicObject journal : journals) {
            journal.set("settlementtype", bill.get("settletype"));
            journal.set("settlementnumber", bill.get("settletnumber"));
            journal.set("bizdate", bill.get("bizdate"));
            int CS104 = SystemParameterHelper.getParameterInteger((long)bill.getDynamicObject("org").getLong("id"), (String)"cs104");
            if (1 == CS104) {
                journal.set("bookdate", bill.get("bizdate"));
            }
            journal.set("oppunit", bill.get("payername"));
            journal.set("oppacctnumber", bill.get("payeracctbanknum"));
            DynamicObject payerBank = bill.getDynamicObject("f7_payerbank");
            if (payerBank != null) {
                journal.set("oppbank", (Object)payerBank.getString("name"));
            } else {
                journal.set("oppbank", (Object)bill.getString("payerbankname"));
            }
            DynamicObjectCollection entry = bill.getDynamicObjectCollection("entry");
            DynamicObjectCollection journalEntrys = journal.getDynamicObjectCollection("entry");
            journalEntrys.clear();
            for (int i = 0; i < entry.size(); ++i) {
                DynamicObject journalEntry = journalEntrys.addNew();
                DynamicObject recentryInfo = (DynamicObject)entry.get(i);
                journalEntry.set("e_amount", (Object)recentryInfo.getBigDecimal("e_actamt"));
                journalEntry.set("e_localamount", (Object)recentryInfo.getBigDecimal("e_localamt"));
                journalEntry.set("e_fundflowitem", (Object)recentryInfo.getDynamicObject("e_fundflowitem"));
            }
        }
        SaveServiceHelper.save((DynamicObject[])journals);
        CasBankJournalHelper.updateBillValue((DynamicObject[])journals);
    }

    public Set<String> removeFields() {
        HashSet<String> sets = new HashSet<String>();
        sets.add("billno");
        sets.add("billstatus");
        sets.add("sourcebillid");
        sets.add("sourcebilltype");
        sets.add("sourcebillnumber");
        sets.add("auditor");
        sets.add("contractnumber");
        sets.add("recamount");
        sets.add("category");
        sets.add("settleremark");
        sets.add("isvoucher");
        sets.add("isorgsdivide");
        sets.add("issupplecontract");
        sets.add("vouchernum");
        sets.add("hotaccount");
        return sets;
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        ArrayList<DynamicObject> recBillChangeList = new ArrayList<DynamicObject>(10);
        ArrayList<Long> recBillIdList = new ArrayList<Long>(10);
        HashMap<Long, String> recBillMap = new HashMap<Long, String>(8);
        for (DynamicObject dynamicObject : e.getDataEntities()) {
            if (!EmptyUtil.isEmpty((String)dynamicObject.getString("hotaccount"))) continue;
            recBillChangeList.add(dynamicObject);
            recBillIdList.add(dynamicObject.getLong("sourcebillid"));
        }
        QFilter qFilter = new QFilter("id", "in", recBillIdList);
        DynamicObjectCollection recbills = QueryServiceHelper.query((String)"cas_recbill", (String)"id,billstatus", (QFilter[])new QFilter[]{qFilter});
        for (DynamicObject dynamicObject : recbills) {
            recBillMap.put(dynamicObject.getLong("id"), dynamicObject.getString("billstatus"));
        }
        Throwable throwable = null;
        try (DTXHandle dtx = DTX.requiresNew((String)"ar_recbillchangedaudit", (DBRoute)DBRoute.of((String)"ar"));){
            try {
                for (DynamicObject recbillChange : recBillChangeList) {
                    String billstatus = (String)recBillMap.get(recbillChange.getLong("sourcebillid"));
                    if (!BillStatusEnum.PAY.getValue().equals(billstatus)) continue;
                    CommonParam param = new CommonParam();
                    param.put((Object)"recBillIdList", Collections.singletonList(recbillChange.getLong("sourcebillid")));
                    param.put((Object)"recChangedBillId ", (Object)recbillChange.getLong("id"));
                    dtx.register("fi", "ar", "RecBillChangedEC", (Param)param);
                }
            }
            catch (Exception ex) {
                dtx.markRollback();
                throw ex;
            }
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throw throwable2;
        }
        RecSaleServiceHelper.convertSaleAndContract((DynamicObject[])this.oldRecBilList.toArray(new DynamicObject[0]), (boolean)false);
        Object[] ids = this.recBilList.stream().map(o -> o.getPkValue()).toArray();
        DynamicObject[] dynamicObjectArray = BusinessDataServiceHelper.load((Object[])ids, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cas_recbill"));
        RecSaleServiceHelper.convertSaleAndContract((DynamicObject[])dynamicObjectArray, (boolean)true);
    }
}

