/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin.recchg;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlParameter;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.validator.ReceivingBillDeleteValidator;

public class RecbillchangeDeleteOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("sourcebillid");
        fieldKeys.add("sourcebilltype");
        fieldKeys.add("bbillstatus");
        fieldKeys.add("billstatus");
        fieldKeys.add("isdelete");
        fieldKeys.add("id");
        fieldKeys.add("sourcebillid");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        ReceivingBillDeleteValidator validator = new ReceivingBillDeleteValidator();
        validator.setEntityKey("cas_recchgbill");
        e.addValidator((AbstractValidator)validator);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] datas = e.getDataEntities();
        DynamicObject[] recDatas = new DynamicObject[datas.length];
        int i = 0;
        for (DynamicObject data : datas) {
            recDatas[i] = BusinessDataServiceHelper.loadSingle((Object)data.get("sourcebillid"), (String)data.getString("sourcebilltype"));
            recDatas[i].set("billstatus", data.get("bbillstatus"));
            ++i;
        }
        if (i > 0) {
            SaveServiceHelper.save((DynamicObject[])recDatas);
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] datas;
        for (DynamicObject data : datas = e.getDataEntities()) {
            Long id = data.getLong("id");
            Long sourceBillId = data.getLong("sourcebillid");
            RecbillchangeDeleteOp.deleteRation(sourceBillId, id);
        }
    }

    private static void deleteRation(Long sourceBillId, Long id) {
        String sBuilder = "";
        ArrayList<SqlParameter> params = new ArrayList<SqlParameter>();
        sBuilder = "delete from T_BOTP_BillTracker where FSBillId= ? and FTBillId= ?";
        params.add(new SqlParameter(":FSBillId", -5, (Object)sourceBillId));
        params.add(new SqlParameter(":FTBillId", -5, (Object)id));
        DB.execute((DBRoute)DBRoute.basedata, (String)sBuilder, (Object[])params.toArray(new SqlParameter[params.size()]));
    }
}

