/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin.recchg;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.enums.ChangeTypeEnum;
import kd.fi.cas.enums.HotAccountEnum;
import kd.fi.cas.enums.SourceSysEnum;
import kd.fi.cas.helper.CasBotpHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.EntityPropertyHelper;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.util.SerializeHelper;
import kd.fi.cas.validator.QuotationOpValidator;

public class RecbillchangeSaveOp
extends AbstractOperationServicePlugIn {
    private static Log log = LogFactory.getLog(RecbillchangeSaveOp.class);

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.getValidators().add(new QuotationOpValidator());
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("id");
        fieldKeys.add("sourcebillid");
        fieldKeys.add("sourcebilltype");
        fieldKeys.add("billstatus");
        fieldKeys.add("bbillstatus");
        fieldKeys.add("chgreson");
        fieldKeys.add("payerformid");
        fieldKeys.add("isdelete");
        fieldKeys.add("actrecamt");
        fieldKeys.add("isdelete");
        fieldKeys.add("bbillstatus");
        fieldKeys.add("receivingtype");
        fieldKeys.add("quotation");
        fieldKeys.add("basecurrency");
        fieldKeys.add("payertype");
        fieldKeys.add("itempayer");
        fieldKeys.add("itempayertype");
        fieldKeys.add("payer");
        fieldKeys.add("hotaccount");
        fieldKeys.addAll(EntityPropertyHelper.getEntryPropertys((String)"cas_recbill_change", (String)"entry"));
        fieldKeys.addAll(EntityPropertyHelper.getEntryPropertys((String)"cas_recbill_change", (String)"bentry"));
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        DynamicObject recBill = BusinessDataServiceHelper.loadSingle((Object)dataEntities[0].get("sourcebillid"), (String)dataEntities[0].getString("sourcebilltype"));
        String serializeRecListStr = this.getOption().getVariableValue("serializeRecList", null);
        List serializeRecList = new ArrayList(10);
        ArrayList<DynamicObject> recBillObjBeforeList = new ArrayList<DynamicObject>(10);
        if (null != serializeRecListStr) {
            serializeRecList = (List)SerializationUtils.fromJsonString((String)serializeRecListStr, List.class);
        }
        for (String serializeRec : serializeRecList) {
            DynamicObject recBillObjBefore = SerializeHelper.deserializeDynamicObj((String)"cas_recbill", (String)serializeRec);
            recBillObjBeforeList.add(recBillObjBefore);
        }
        Map<Long, List<DynamicObject>> recBillObjBeforeMap = recBillObjBeforeList.stream().collect(Collectors.groupingBy(o -> o.getLong("id")));
        String source = this.getOption().getVariableValue("source", null);
        String operate = this.getOption().getVariableValue("operate", null);
        for (DynamicObject data : dataEntities) {
            data.set("itempayertype", data.get("payertype"));
            data.set("itempayer", data.get("payer"));
            data.set("itempayer_id", data.get("payer"));
            if (!EmptyUtil.isEmpty((String)source) && "sm".equals(source)) {
                data.set("sourcesys", (Object)SourceSysEnum.SM.getValue());
                data.set("changetype", (Object)ChangeTypeEnum.BUSINESS.getValue());
                List<DynamicObject> recListBefore = recBillObjBeforeMap.get(data.get("sourcebillid"));
                if (CasHelper.isNotEmpty(recListBefore) && recListBefore.size() > 0) {
                    DynamicObject recBefore = recListBefore.get(0);
                    data.set("bentry", null);
                    DynamicObjectCollection recEntryCol = recBefore.getDynamicObjectCollection("entry");
                    DynamicObjectCollection changeEntryCol = data.getDynamicObjectCollection("bentry");
                    Set changeFields = EntityPropertyHelper.getEntryPropertys((String)"cas_recbill_change", (String)"bentry.");
                    Set recFields = EntityPropertyHelper.getEntryPropertys((String)"cas_recbill", (String)"entry.");
                    for (DynamicObject recEntry : recEntryCol) {
                        DynamicObject changeEntry = changeEntryCol.addNew();
                        for (String recField : recFields) {
                            if (!changeFields.contains(recField + "b")) continue;
                            changeEntry.set(recField + "b", recEntry.get(recField));
                        }
                    }
                }
                if ("sallMatch".equals(operate)) {
                    data.set("chgreson", (Object)ResManager.loadKDString((String)"\u9500\u552e\u4e1a\u52a1\u5339\u914d\u6536\u6b3e", (String)"RecbillchangeSaveOp_0", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                } else {
                    data.set("chgreson", (Object)ResManager.loadKDString((String)"\u9500\u552e\u4e1a\u52a1\u53d6\u6d88\u5339\u914d\u6536\u6b3e", (String)"RecbillchangeSaveOp_1", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                }
                data.set("billstatus", (Object)"C");
                continue;
            }
            if (!EmptyUtil.isEmpty((String)source) && "claim".equals(source)) {
                recBill.set("billstatus", (Object)"E");
                data.set("sourcesys", (Object)SourceSysEnum.CAS.getValue());
                data.set("changetype", (Object)ChangeTypeEnum.CLAIM.getValue());
                continue;
            }
            int changeType = SystemParameterHelper.getParameterInteger((long)data.getDynamicObject("org").getLong("id"), (String)"cs113");
            if (changeType == 1) {
                data.set("hotaccount", (Object)HotAccountEnum.HOTBILL.getValue());
            }
            recBill.set("billstatus", (Object)"E");
            data.set("sourcesys", (Object)SourceSysEnum.CAS.getValue());
            data.set("changetype", (Object)ChangeTypeEnum.HAND.getValue());
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{recBill});
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        Long recBillChangeId = (Long)dataEntities[0].getPkValue();
        Long sourcebillid = (Long)dataEntities[0].get("sourcebillid");
        String source = this.getOption().getVariableValue("source", null);
        if (!EmptyUtil.isEmpty((String)source) && ("sm".equals(source) || "claim".equals(source))) {
            try (TXHandle h = TX.requiresNew((String)"updateRation");){
                try {
                    CasBotpHelper.deleteRation((Long)sourcebillid, (Long)recBillChangeId);
                }
                catch (Exception e1) {
                    log.error("e", (Object)("RecbillchangeSaveOp----" + e1.getMessage()));
                }
            }
        }
        CasBotpHelper.saveRelation((String)"cas_recbill", (Long)sourcebillid, (String)"cas_recchgbill", (Long)recBillChangeId);
    }
}

