/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin.recchg;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.enums.ChangeTypeEnum;
import kd.fi.cas.enums.HotAccountEnum;
import kd.fi.cas.enums.SourceSysEnum;
import kd.fi.cas.helper.CasBotpHelper;
import kd.fi.cas.helper.EntityPropertyHelper;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.validator.ReceivingBillSubmitValidator;
import kd.fi.cas.validator.recchg.ReceivingBillChgValidator;
import org.apache.commons.lang3.StringUtils;

public class RecbillchangeSubmitOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("id");
        fieldKeys.add("sourcebillid");
        fieldKeys.add("sourcebilltype");
        fieldKeys.add("billstatus");
        fieldKeys.add("bbillstatus");
        fieldKeys.add("chgreson");
        fieldKeys.add("payerformid");
        fieldKeys.add("isdelete");
        fieldKeys.add("actrecamt");
        fieldKeys.add("isdelete");
        fieldKeys.add("actrecamtsour");
        fieldKeys.add("fee");
        fieldKeys.add("settletype");
        fieldKeys.add("accountbank");
        fieldKeys.add("receivingtype");
        fieldKeys.add("payertype");
        fieldKeys.add("payername");
        fieldKeys.add("changetype");
        fieldKeys.add("sourcesys");
        fieldKeys.add("payertype");
        fieldKeys.add("itempayer");
        fieldKeys.add("itempayertype");
        fieldKeys.add("payer");
        fieldKeys.add("hotaccount");
        fieldKeys.addAll(EntityPropertyHelper.getEntryPropertys((String)"cas_recbill_change", (String)"entry"));
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        ReceivingBillSubmitValidator validator = new ReceivingBillSubmitValidator();
        ReceivingBillChgValidator validatorChg = new ReceivingBillChgValidator();
        validator.setEntityKey("cas_recbill_change");
        e.addValidator((AbstractValidator)validator);
        e.addValidator((AbstractValidator)validatorChg);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        super.beginOperationTransaction(e);
        String source = this.getOption().getVariableValue("source", null);
        for (DynamicObject data : dataEntities = e.getDataEntities()) {
            int changeType = SystemParameterHelper.getParameterInteger((long)data.getDynamicObject("org").getLong("id"), (String)"cs113");
            if (changeType == 1) {
                data.set("hotaccount", (Object)HotAccountEnum.HOTBILL.getValue());
            }
            data.set("itempayertype", data.get("payertype"));
            data.set("itempayer", data.get("payer"));
            data.set("itempayer_id", data.get("payer"));
        }
        DynamicObject data = e.getDataEntities()[0];
        DynamicObject recBill = BusinessDataServiceHelper.loadSingle((Object)data.get("sourcebillid"), (String)data.getString("sourcebilltype"));
        recBill.set("billstatus", (Object)"E");
        if (StringUtils.equals((CharSequence)"claim", (CharSequence)source)) {
            recBill.set("isunclaim", (Object)false);
        }
        if (EmptyUtil.isEmpty((Object)data.get("sourcesys"))) {
            data.set("sourcesys", (Object)SourceSysEnum.CAS.getValue());
        }
        if (EmptyUtil.isEmpty((Object)data.get("changetype"))) {
            data.set("changetype", (Object)ChangeTypeEnum.HAND.getValue());
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{recBill});
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        for (DynamicObject data : e.getDataEntities()) {
            int changeType = SystemParameterHelper.getParameterInteger((long)data.getDynamicObject("org").getLong("id"), (String)"cs113");
            String source = this.getOption().getVariableValue("source", null);
            if (changeType != 2 || EmptyUtil.isEmpty((String)source) || !"sm".equals(source) && !"claim".equals(source)) continue;
            Long recBillChangeId = (Long)data.getPkValue();
            Long sourcebillid = (Long)data.get("sourcebillid");
            if (!EmptyUtil.isEmpty((String)source) && "claim".equals(source)) {
                try (TXHandle h = TX.requiresNew((String)"updateRation");){
                    try {
                        CasBotpHelper.deleteRation((Long)sourcebillid, (Long)recBillChangeId);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            CasBotpHelper.saveRelation((String)"cas_recbill", (Long)sourcebillid, (String)"cas_recchgbill", (Long)recBillChangeId);
        }
    }
}

