/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin.recclaim;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.ReturnOperationArgs;
import kd.bos.entity.plugin.args.RollbackOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.business.helper.RecBillOverAmountHelper;
import kd.fi.cas.business.writeback.consts.WriteBackOperateEnum;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.EntityPropertyHelper;
import kd.fi.cas.helper.RecClaimHelper;
import kd.fi.cas.mutex.impl.DataLocker;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.validator.ClaimBillSaveSubmitValidator;
import kd.fi.cas.validator.claimbill.ClaimBillAutoRenoteValidator;
import kd.fi.cas.validator.recclaim.ClaimBillSubmitValidator;

public class ClaimBillClaimSubmitOp
extends AbstractOperationServicePlugIn {
    DataLocker dataLocker = new DataLocker();
    ClaimBillSubmitValidator validator = new ClaimBillSubmitValidator();

    public void onPreparePropertys(PreparePropertysEventArgs args) {
        super.onPreparePropertys(args);
        List lst = args.getFieldKeys();
        lst.addAll(EntityPropertyHelper.getPropertys((String)"cas_claimbill"));
        lst.addAll(EntityPropertyHelper.getEntryPropertys((String)"cas_claimbill", (String)"entryentity"));
        lst.addAll(EntityPropertyHelper.getEntryPropertys((String)"cas_claimbill", (String)"payentity"));
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        this.validator.setEntityKey("cas_claimbill");
        e.addValidator((AbstractValidator)new ClaimBillSaveSubmitValidator());
        e.addValidator((AbstractValidator)this.validator);
        e.addValidator((AbstractValidator)new ClaimBillAutoRenoteValidator());
        super.onAddValidators(e);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] infos = e.getDataEntities();
        List sourceClaimIdList = Arrays.stream(infos).map(o -> o.getLong("sourceclaimid")).collect(Collectors.toList());
        List claimIdList = Arrays.stream(infos).map(o -> o.getLong("id")).collect(Collectors.toList());
        claimIdList.addAll(sourceClaimIdList);
        Map sourceClaimBillMap = null;
        if (claimIdList.size() > 0) {
            DynamicObject[] sourceClaimBill = BusinessDataServiceHelper.load((String)"cas_claimbill", (String)"id,entryentity.e_corebilltype,entryentity.claimdimension,entryentity.claimcomtrol,entryentity.e_corebillid,entryentity.e_corebillentryid,entryentity.e_receivableamt", (QFilter[])new QFilter[]{new QFilter("id", "in", claimIdList)});
            sourceClaimBillMap = Arrays.stream(sourceClaimBill).collect(Collectors.toMap(o -> o.getLong("id"), Function.identity()));
        }
        ArrayList claimCoreInfoList = new ArrayList(10);
        for (DynamicObject info : infos) {
            DynamicObject dbClaimBill;
            info.set("rejectreason", null);
            info.set("isnoticemerge", (Object)false);
            BigDecimal claimamount = BigDecimal.ZERO;
            BigDecimal payAmount = info.getBigDecimal("payamount");
            if (payAmount.compareTo(BigDecimal.ZERO) != 0) {
                DynamicObjectCollection payentityColl = info.getDynamicObjectCollection("payentity");
                if (EmptyUtil.isNoEmpty((DynamicObjectCollection)payentityColl)) {
                    for (DynamicObject dynamicObject : payentityColl) {
                        claimamount = claimamount.add(dynamicObject.getBigDecimal("e_payableamt"));
                    }
                }
            } else {
                DynamicObjectCollection entryentity = info.getDynamicObjectCollection("entryentity");
                if (EmptyUtil.isNoEmpty((DynamicObjectCollection)entryentity)) {
                    for (DynamicObject dynamicObject : entryentity) {
                        claimamount = claimamount.add(dynamicObject.getBigDecimal("e_receivableamt"));
                    }
                }
            }
            info.set("claimamount", null);
            info.set("claimamount", (Object)claimamount);
            if (null == sourceClaimBillMap) {
                RecClaimHelper.getClaimCoreInfo((DynamicObject)info, null, claimCoreInfoList);
                continue;
            }
            Long sourceclaimid = info.getLong("sourceclaimid");
            if (EmptyUtil.isNoEmpty((Long)sourceclaimid)) {
                dbClaimBill = (DynamicObject)sourceClaimBillMap.get(info.getLong("id"));
                if (CasHelper.isNotEmpty((Object)dbClaimBill)) {
                    RecClaimHelper.getClaimCoreInfo((DynamicObject)info, (DynamicObject)dbClaimBill, claimCoreInfoList);
                    continue;
                }
                DynamicObject sourceclaim = (DynamicObject)sourceClaimBillMap.get(sourceclaimid);
                RecClaimHelper.getClaimCoreInfo((DynamicObject)info, (DynamicObject)sourceclaim, claimCoreInfoList);
                continue;
            }
            dbClaimBill = (DynamicObject)sourceClaimBillMap.get(info.getLong("id"));
            if (CasHelper.isNotEmpty((Object)dbClaimBill)) {
                RecClaimHelper.getClaimCoreInfo((DynamicObject)info, (DynamicObject)dbClaimBill, claimCoreInfoList);
                continue;
            }
            RecClaimHelper.getClaimCoreInfo((DynamicObject)info, null, claimCoreInfoList);
        }
        RecClaimHelper.writeBackAmt(claimCoreInfoList);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        for (DynamicObject info : e.getDataEntities()) {
            if (!this.isNeedValidate(info)) continue;
            RecBillOverAmountHelper.getWriteBackVad((DynamicObject)info, (WriteBackOperateEnum)WriteBackOperateEnum.SUBMIT, (boolean)false);
        }
    }

    private boolean isNeedValidate(DynamicObject info) {
        DynamicObjectCollection entrys = info.getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : entrys) {
            if ("fr_glreim_paybill".equals(entry.getString("e_corebilltype")) || "fr_glreim_recbill".equals(entry.getString("e_corebilltype"))) {
                return true;
            }
            if (!"ar_finarbill".equals(entry.getString("e_corebilltype"))) continue;
            return true;
        }
        return false;
    }

    public void onReturnOperation(ReturnOperationArgs e) {
        this.dataLocker.batchRelease(this.validator.getSuccessLatKeys(), "cas_claimannounce", "ClaimBillClaimSubmitOp");
        super.onReturnOperation(e);
    }

    public void rollbackOperation(RollbackOperationArgs e) {
        this.dataLocker.batchRelease(this.validator.getSuccessLatKeys(), "cas_claimannounce", "ClaimBillClaimSubmitOp");
    }
}

