/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin.recclaim;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.business.helper.RecBillOverAmountHelper;
import kd.fi.cas.business.writeback.consts.WriteBackOperateEnum;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.enums.ClaimStatusEnum;
import kd.fi.cas.enums.ClaimTypeEnum;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.EntityPropertyHelper;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.validator.recclaim.ClaimBillUnAuditValidator;

public class ClaimBillClaimUnAuditOp
extends AbstractOperationServicePlugIn {
    private List<HashMap<Object, String>> updateClaimList = new ArrayList<HashMap<Object, String>>();
    private Set<String> updateClaimNoSet = new HashSet<String>();

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List lst = e.getFieldKeys();
        lst.addAll(EntityPropertyHelper.getPropertys((String)"cas_claimbill"));
        lst.addAll(EntityPropertyHelper.getEntryPropertys((String)"cas_claimbill", (String)"entryentity"));
        lst.addAll(EntityPropertyHelper.getEntryPropertys((String)"cas_claimbill", (String)"payentity"));
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        ClaimBillUnAuditValidator validator = new ClaimBillUnAuditValidator();
        validator.setEntityKey("cas_claimbill");
        e.addValidator((AbstractValidator)validator);
        super.onAddValidators(e);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] claimbills = e.getDataEntities();
        QFilter qFilter = new QFilter("biztype", "=", (Object)"110").and(new QFilter("default", "=", (Object)"1")).and(new QFilter("enable", "=", (Object)"1"));
        DynamicObject[] paymentBillType = BusinessDataServiceHelper.load((String)"cas_paymentbilltype", (String)"id,biztype,ispartpayment", (QFilter[])new QFilter[]{qFilter});
        DynamicObject[] receivingBillType = BusinessDataServiceHelper.load((String)"cas_receivingbilltype", (String)"id,biztype,ispartreceivable", (QFilter[])new QFilter[]{qFilter});
        DynamicObjectCollection claimFieldExtCfgs = QueryServiceHelper.query((String)"cas_claimfieldextcfg", (String)"extendname, datatype, tarfieldname", null);
        HashSet<String> claimNos = new HashSet<String>(e.getDataEntities().length);
        HashMap<String, DynamicObject> no_claimCenterBill = new HashMap<String, DynamicObject>(e.getDataEntities().length);
        for (DynamicObject dynamicObject : e.getDataEntities()) {
            String claimno = dynamicObject.getString("claimno");
            claimNos.add(claimno);
        }
        if (claimNos.size() > 0) {
            QFilter billnoQf = new QFilter("billno", "in", claimNos);
            HashSet<Long> ids = new HashSet<Long>(claimNos.size());
            Throwable throwable = null;
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryId", (String)"cas_claimcenterbill", (String)"id", (QFilter[])new QFilter[]{billnoQf}, null);){
                while (ds.hasNext()) {
                    ids.add(ds.next().getLong("id"));
                }
            }
            catch (Throwable claimno) {
                Throwable throwable2 = claimno;
                throw claimno;
            }
            if (ids.size() > 0) {
                DynamicObject[] bills;
                for (DynamicObject one : bills = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cas_claimcenterbill"))) {
                    no_claimCenterBill.put(one.getString("billno"), one);
                }
            }
        }
        for (DynamicObject dynamicObject : e.getDataEntities()) {
            Object[] sourceclaims;
            Long sourceclaimid;
            BigDecimal payAmount = dynamicObject.getBigDecimal("payamount");
            String claimno = dynamicObject.getString("claimno");
            String claimbillno = dynamicObject.getString("billno");
            DynamicObject claimcenterbill = (DynamicObject)no_claimCenterBill.get(claimno);
            if (EmptyUtil.isEmpty((DynamicObject)claimcenterbill)) {
                return;
            }
            String oldclaimstatus = claimcenterbill.getString("claimstatus");
            String claimType = dynamicObject.getString("claimType");
            DynamicObjectCollection entryentity = claimcenterbill.getDynamicObjectCollection("entryentity");
            DynamicObjectCollection payentity = claimcenterbill.getDynamicObjectCollection("payentity");
            if (StringUtils.equals((CharSequence)claimType, (CharSequence)ClaimTypeEnum.CHANGE.getValue()) && EmptyUtil.isNoEmpty((Long)(sourceclaimid = Long.valueOf(dynamicObject.getLong("sourceclaimid")))) && EmptyUtil.isNoEmpty((Object[])(sourceclaims = BusinessDataServiceHelper.load((String)"cas_claimbill", (String)"billno,billstatus", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)sourceclaimid)})))) {
                Object sourceclaim = sourceclaims[0];
                sourceclaim.set("billstatus", (Object)BillStatusEnum.AUDIT.getValue());
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{sourceclaim});
                entryentity.forEach(arg_0 -> ClaimBillClaimUnAuditOp.lambda$beginOperationTransaction$0((DynamicObject)sourceclaim, arg_0));
            }
            Iterator iterator = entryentity.iterator();
            while (iterator.hasNext()) {
                DynamicObject entry = (DynamicObject)iterator.next();
                if (!StringUtils.equals((CharSequence)claimbillno, (CharSequence)entry.getString("e_claimbill"))) continue;
                iterator.remove();
            }
            Iterator payIterator = payentity.iterator();
            while (payIterator.hasNext()) {
                DynamicObject entry = (DynamicObject)payIterator.next();
                if (!StringUtils.equals((CharSequence)claimbillno, (CharSequence)entry.getString("e_payclaimbill"))) continue;
                payIterator.remove();
            }
            if (payAmount.compareTo(BigDecimal.ZERO) != 0) {
                Boolean singleStream = claimcenterbill.getBoolean("singlestream");
                BigDecimal unclaimamount = BigDecimal.ZERO;
                BigDecimal payableamt = payentity.stream().filter(dy -> !dy.getBoolean("e_paybillstatus")).map(dy -> dy.getBigDecimal("e_payableamt")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                BigDecimal payactamt = payentity.stream().filter(dy -> !dy.getBoolean("e_paybillstatus")).map(dy -> dy.getBigDecimal("e_payactamt")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                unclaimamount = payAmount.subtract(claimcenterbill.getBigDecimal("fee")).add(payableamt).subtract(payactamt).subtract(payableamt);
                if (singleStream.booleanValue()) {
                    unclaimamount = unclaimamount.add(claimcenterbill.getBigDecimal("fee"));
                }
                claimcenterbill.set("unclaimamount", (Object)unclaimamount);
                claimcenterbill.set("claimedamount", (Object)payableamt);
                String claimstatus = oldclaimstatus;
                if (payableamt.compareTo(BigDecimal.ZERO) == 0) {
                    claimstatus = ClaimStatusEnum.WAIT.getValue();
                    claimcenterbill.set("paytype", null);
                    claimcenterbill.set("payeetype", null);
                    claimcenterbill.set("recpayee", null);
                    claimcenterbill.set("recbasepayee", null);
                    claimcenterbill.set("recbasetype", null);
                    claimcenterbill.set("recviewpayer", null);
                } else {
                    claimstatus = payableamt.compareTo(BigDecimal.ZERO) > 0 && unclaimamount.compareTo(BigDecimal.ZERO) <= 0 || payableamt.compareTo(BigDecimal.ZERO) < 0 && unclaimamount.compareTo(BigDecimal.ZERO) >= 0 ? ClaimStatusEnum.CLAIMED.getValue() : ClaimStatusEnum.PART.getValue();
                }
                claimcenterbill.set("claimstatus", (Object)claimstatus);
                dynamicObject.set("claimstatus", (Object)claimstatus);
                long disTypeNum = payentity.stream().map(o -> o.getDynamicObject("e_paymenttype")).distinct().count();
                if (disTypeNum == 1L) {
                    claimcenterbill.set("multipaymenttype", (Object)Boolean.FALSE);
                    DynamicObject ePaymentType = ((DynamicObject)payentity.get(0)).getDynamicObject("e_paymenttype");
                    claimcenterbill.set("paytype", (Object)ePaymentType);
                } else if (disTypeNum > 1L) {
                    claimcenterbill.set("multipaymenttype", (Object)Boolean.TRUE);
                    if (paymentBillType != null && paymentBillType.length != 0) {
                        claimcenterbill.set("paytype", (Object)paymentBillType[0]);
                    }
                } else if (disTypeNum == 0L) {
                    claimcenterbill.set("multipaymenttype", (Object)Boolean.FALSE);
                    claimcenterbill.set("paytype", null);
                }
            } else {
                BigDecimal oldrec = entryentity.stream().filter(dy -> !dy.getBoolean("e_billstatus")).map(dy -> dy.getBigDecimal("e_receivableamt")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                BigDecimal olddis = entryentity.stream().filter(dy -> !dy.getBoolean("e_billstatus")).map(dy -> dy.getBigDecimal("e_discountamt")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                BigDecimal oldfee = entryentity.stream().filter(dy -> !dy.getBoolean("e_billstatus")).map(dy -> dy.getBigDecimal("e_fee")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                BigDecimal reamount = claimcenterbill.getBigDecimal("reamount");
                if (!claimcenterbill.getBoolean("isaddfee")) {
                    claimcenterbill.set("fee", (Object)oldfee);
                }
                reamount = reamount.add(claimcenterbill.getBigDecimal("fee"));
                reamount = reamount.add(olddis);
                BigDecimal claimedamount = oldrec;
                claimcenterbill.set("claimedamount", (Object)claimedamount);
                claimcenterbill.set("unclaimamount", (Object)reamount.subtract(claimedamount));
                String claimstatus = oldclaimstatus;
                if (StringUtils.equals((CharSequence)ClaimStatusEnum.WAIT.getValue(), (CharSequence)oldclaimstatus) || StringUtils.equals((CharSequence)ClaimStatusEnum.CLAIMED.getValue(), (CharSequence)oldclaimstatus) || StringUtils.equals((CharSequence)ClaimStatusEnum.PART.getValue(), (CharSequence)oldclaimstatus)) {
                    if (claimedamount.compareTo(BigDecimal.ZERO) == 0) {
                        claimstatus = ClaimStatusEnum.WAIT.getValue();
                        claimcenterbill.set("recpaytype", null);
                        claimcenterbill.set("paymenttype", null);
                        claimcenterbill.set("recpayer", null);
                        claimcenterbill.set("recbasepayer", null);
                        claimcenterbill.set("paymentbasetype", null);
                    } else {
                        claimstatus = reamount.compareTo(BigDecimal.ZERO) > 0 && claimedamount.compareTo(reamount) >= 0 || reamount.compareTo(BigDecimal.ZERO) < 0 && claimedamount.compareTo(reamount) <= 0 ? ClaimStatusEnum.CLAIMED.getValue() : ClaimStatusEnum.PART.getValue();
                    }
                } else if (StringUtils.equals((CharSequence)claimType, (CharSequence)ClaimTypeEnum.CHANGE.getValue()) || StringUtils.equals((CharSequence)claimType, (CharSequence)ClaimTypeEnum.APPEAL.getValue())) {
                    claimstatus = ClaimStatusEnum.SURE.getValue();
                }
                claimcenterbill.set("claimstatus", (Object)claimstatus);
                dynamicObject.set("claimstatus", (Object)claimstatus);
                long disTypeNum = entryentity.stream().map(o -> o.getDynamicObject("e_receivingtype")).distinct().count();
                if (disTypeNum == 1L) {
                    claimcenterbill.set("multireceivingtype", (Object)Boolean.FALSE);
                    DynamicObject eReceivingType = ((DynamicObject)entryentity.get(0)).getDynamicObject("e_receivingtype");
                    claimcenterbill.set("recpaytype", (Object)eReceivingType);
                } else if (disTypeNum > 1L) {
                    claimcenterbill.set("multireceivingtype", (Object)Boolean.TRUE);
                    if (receivingBillType != null && receivingBillType.length != 0) {
                        claimcenterbill.set("recpaytype", (Object)receivingBillType[0]);
                    }
                } else if (disTypeNum == 0L) {
                    claimcenterbill.set("multireceivingtype", (Object)Boolean.FALSE);
                    claimcenterbill.set("recpaytype", null);
                }
            }
            HashMap<String, String> ClaimStatusMap = new HashMap<String, String>();
            this.updateClaimList.removeIf(o -> CasHelper.isNotEmpty(o.get("billno")) && ((String)o.get("billno")).equals(claimcenterbill.getString("billno")));
            ClaimStatusMap.put("billno", claimcenterbill.getString("billno"));
            ClaimStatusMap.put("claimbillbillno", claimbillno);
            ClaimStatusMap.put("id", claimcenterbill.getString("id"));
            ClaimStatusMap.put("claimstatus", claimcenterbill.getString("claimstatus"));
            this.updateClaimList.add(ClaimStatusMap);
            this.updateClaimNoSet.add(claimcenterbill.getString("billno"));
            this.clearFieldExtValues(claimcenterbill, claimFieldExtCfgs);
            dynamicObject.set("billstatus", (Object)BillStatusEnum.SAVE.getValue());
        }
        SaveServiceHelper.save((DynamicObject[])claimbills);
        if (no_claimCenterBill.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])no_claimCenterBill.values().toArray(new DynamicObject[0]));
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        QFilter qFilter;
        DynamicObject[] claimAnnouncesArr;
        super.afterExecuteOperationTransaction(e);
        for (DynamicObject info : e.getDataEntities()) {
            if (!ClaimBillClaimUnAuditOp.isNeedValidate(info)) continue;
            RecBillOverAmountHelper.getWriteBackVad((DynamicObject)info, (WriteBackOperateEnum)WriteBackOperateEnum.UNSUBMIT, (boolean)false);
        }
        HashSet<Long> mergeIdSet = new HashSet<Long>(this.updateClaimList.size());
        HashMap<String, String> idMapClaimStatus = new HashMap<String, String>(this.updateClaimList.size());
        if (this.updateClaimNoSet.size() > 0) {
            QFilter qFilter2 = new QFilter("claimno", "in", this.updateClaimNoSet);
            DynamicObject[] colls = BusinessDataServiceHelper.load((String)"cas_claimbill", (String)"id,billno,claimno,claimstatus", (QFilter[])new QFilter[]{qFilter2});
            Map<String, List<DynamicObject>> no_claimBill = Arrays.stream(colls).collect(Collectors.groupingBy(o -> o.getString("claimno")));
            for (HashMap<Object, String> updateClaimMap : this.updateClaimList) {
                mergeIdSet.add(Long.parseLong(updateClaimMap.get("id")));
                idMapClaimStatus.put(updateClaimMap.get("id"), updateClaimMap.get("claimstatus"));
                String key = updateClaimMap.get("billno");
                String claimStatus = updateClaimMap.get("claimstatus");
                List<DynamicObject> tempList = no_claimBill.get(key);
                for (DynamicObject one : tempList) {
                    if (one.getString("billno").equals(updateClaimMap.get("claimbillbillno")) || claimStatus.equals(one.getString("claimstatus"))) continue;
                    one.set("claimstatus", (Object)claimStatus);
                }
            }
            SaveServiceHelper.save((DynamicObject[])colls);
        }
        if ((claimAnnouncesArr = BusinessDataServiceHelper.load((String)"cas_claimannounce", (String)"id,claimstatus,margeid", (QFilter[])(qFilter = new QFilter("margeid", "in", mergeIdSet)).toArray())) != null && claimAnnouncesArr.length > 0) {
            for (DynamicObject claimAnnounces : claimAnnouncesArr) {
                String mergeId = claimAnnounces.getString("margeid");
                claimAnnounces.set("claimstatus", idMapClaimStatus.get(mergeId));
            }
            SaveServiceHelper.save((DynamicObject[])claimAnnouncesArr);
        }
    }

    public static boolean isNeedValidate(DynamicObject info) {
        DynamicObjectCollection entrys = info.getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : entrys) {
            if ("fr_glreim_paybill".equals(entry.getString("e_corebilltype")) || "fr_glreim_recbill".equals(entry.getString("e_corebilltype"))) {
                return true;
            }
            if (!"ar_finarbill".equals(entry.getString("e_corebilltype"))) continue;
            return true;
        }
        return false;
    }

    private void clearFieldExtValues(DynamicObject cas_claimnoticebill, DynamicObjectCollection claimFieldExtCfgs) {
        claimFieldExtCfgs.stream().forEach(fieldExtCfg -> {
            String tarFieldName = fieldExtCfg.getString("tarfieldname");
            if (cas_claimnoticebill.containsProperty(tarFieldName)) {
                cas_claimnoticebill.set(tarFieldName, null);
            }
        });
    }

    private static /* synthetic */ void lambda$beginOperationTransaction$0(DynamicObject sourceclaim, DynamicObject dy) {
        if (StringUtils.equals((CharSequence)dy.getString("e_claimbill"), (CharSequence)sourceclaim.getString("billno"))) {
            dy.set("e_billstatus", (Object)false);
        }
    }
}

