/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin.recclaim;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.business.helper.RecBillHepler;
import kd.fi.cas.business.helper.RecBillOverAmountHelper;
import kd.fi.cas.business.opservice.helper.RecSaleServiceHelper;
import kd.fi.cas.business.paysche.bean.DraftAmountLockSubInfo;
import kd.fi.cas.business.paysche.bean.DraftLockInfo;
import kd.fi.cas.business.paysche.serive.DraftLockServiceHelper;
import kd.fi.cas.business.writeback.consts.WriteBackOperateEnum;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.enums.ClaimHandleStatusEnum;
import kd.fi.cas.enums.ClaimStatusEnum;
import kd.fi.cas.enums.ClaimTypeEnum;
import kd.fi.cas.enums.LogBizTypeEnum;
import kd.fi.cas.enums.LogOperateTypeEnum;
import kd.fi.cas.helper.BaseDataHelper;
import kd.fi.cas.helper.CasBotpHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.EntityPropertyHelper;
import kd.fi.cas.helper.OperateServiceHelper;
import kd.fi.cas.helper.RecClaimHelper;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.validator.recclaim.RecClaimToAccountValidator;

public class RecClaimToAccountOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(RecClaimToAccountOp.class);
    private List<DynamicObject> cancelRecBillList = new ArrayList<DynamicObject>(10);
    private List<DynamicObject> blueRecBillList = new ArrayList<DynamicObject>(10);
    private Map<Object, DynamicObject> blueRedMap = new HashMap<Object, DynamicObject>(10);
    private List<DynamicObject> delRecBillList = new ArrayList<DynamicObject>(10);
    private List<DynamicObject> newDelRecBillList = new ArrayList<DynamicObject>(10);
    private List<DynamicObject> recBilHotList = new ArrayList<DynamicObject>(10);

    public void onPreparePropertys(PreparePropertysEventArgs args) {
        super.onPreparePropertys(args);
        List lst = args.getFieldKeys();
        lst.add("billno");
        lst.add("claimstatus");
        lst.add("e_handlestatus");
        lst.add("sourceid");
        lst.add("entryentity");
        lst.add("reamount");
        lst.add("claimedamount");
        lst.add("billno");
        lst.add("currency");
        lst.add("bizdate");
        lst.add("recpaytype");
        lst.add("paymenttype");
        lst.add("recpayer");
        lst.add("confirmuser");
        lst.add("fee");
        lst.add("org");
        lst.add("isaddfee");
        lst.add("sourcetype");
        lst.add("payamount");
        lst.add("inneraccount");
        lst.add("sourceid");
        lst.add("margeid");
        lst.addAll(EntityPropertyHelper.getEntryPropertys((String)"cas_claimcenterbill", (String)"entryentity"));
        lst.addAll(EntityPropertyHelper.getEntryPropertys((String)"cas_claimcenterbill", (String)"payentity"));
        lst.add("draftbill");
        lst.add("isunclaim");
        lst.add("hotaccount");
        lst.add("receivingtype");
        lst.add("sourcebillid");
        lst.add("sourcebilltype");
        lst.add("settletype");
        lst.add("sourcebilltype");
        lst.add("txt_description");
        lst.add("txt_description_tag");
        lst.add("billno");
        lst.add("cas_draftinfo");
        lst.add("cas_draftinfo.transamount");
        lst.add("cas_draftinfo.draftbilllogid");
        lst.add("cas_draftinfo.draftbillinfo");
        lst.add("draftbillinfo");
        lst.add("draftbilllogid");
        lst.add("transamount");
        lst.add("refunddetailid");
        lst.add("billstatus");
        lst.add("sourcetype");
        lst.add("actrecamt");
        lst.add("isvoucher");
        lst.add("org");
        lst.add("e_receivableamt");
        lst.add("e_actAmt");
        lst.add("e_sourcebillid");
        lst.add("e_sourcebillentryid");
        lst.add("matchflag");
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        super.onAddValidators(args);
        args.addValidator((AbstractValidator)new RecClaimToAccountValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        OperationResult executeOperate;
        super.beginOperationTransaction(e);
        List claimIdList = Arrays.stream(e.getDataEntities()).map(o -> o.getPkValue()).collect(Collectors.toList());
        DynamicObject[] claimNoticeDts = BusinessDataServiceHelper.load((Object[])claimIdList.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cas_claimcenterbill"));
        Map claimNoticeMap = Arrays.stream(claimNoticeDts).collect(Collectors.toMap(o -> o.getPkValue(), Function.identity()));
        QFilter filter = new QFilter("sourcetype", "=", (Object)"cas_claimcenterbill").and(new QFilter("sourceid", "in", claimIdList.stream().map(String::valueOf).collect(Collectors.toList())));
        DynamicObject[] claimDts = BusinessDataServiceHelper.load((String)"cas_claimbill", (String)"id,sourceid,tradetime,creator,inneraccount,claimtype,handlestatus,billstatus,currency,reamount,claimedamount,unclaimamount,bizdate,billno,recpaytype,paymenttype,recpayer,fee,claimstatus,entryentity.e_fee,entryentity.e_actamt", (QFilter[])new QFilter[]{filter}, (String)" auditdate asc ");
        Map<String, List<DynamicObject>> claimGroupMap = Arrays.stream(claimDts).collect(Collectors.groupingBy(o -> o.getString("sourceid")));
        QFilter qFilter = new QFilter("sourcebilltype", "=", (Object)"cas_claimcenterbill").and(new QFilter("sourcebillid", "in", claimIdList)).and(new QFilter("hotaccount", "=", (Object)" ")).and(new QFilter("billstatus", "!=", (Object)BillStatusEnum.CHARGEBANK.getValue()));
        DynamicObject[] recBillDtTemps = BusinessDataServiceHelper.load((String)"cas_recbill", (String)"id", (QFilter[])new QFilter[]{qFilter});
        List recBillIdList = Arrays.stream(recBillDtTemps).map(o -> o.getPkValue()).collect(Collectors.toList());
        DynamicObject[] recBillDts = BusinessDataServiceHelper.load((Object[])recBillIdList.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cas_recbill"));
        Map<Object, List<DynamicObject>> recBillGroupMap = Arrays.stream(recBillDts).collect(Collectors.groupingBy(o -> o.get("sourcebillid")));
        List orgIdList = Arrays.stream(e.getDataEntities()).map(o -> o.getDynamicObject("org").getLong("id")).collect(Collectors.toList());
        Map pushMap = SystemParameterHelper.getSystemParamsByOrgIds(orgIdList, (String)"cs113");
        HashMap allChildNoticeBatchBill = RecClaimHelper.getAllChildNoticeBatchBill((DynamicObject[])claimNoticeDts);
        ArrayList<DynamicObject> claimList = new ArrayList<DynamicObject>(10);
        HashSet<DynamicObject> needPushRecClaimBill = new HashSet<DynamicObject>(10);
        ArrayList<DynamicObject> recBilChangeList = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> claimNoticeAllList = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> needPushCasPayList = new ArrayList<DynamicObject>(10);
        for (DynamicObject info : e.getDataEntities()) {
            DynamicObjectCollection entrys;
            BigDecimal payAmount = info.getBigDecimal("payamount");
            DynamicObject recPayType = info.getDynamicObject("recpaytype");
            info = (DynamicObject)claimNoticeMap.get(info.getPkValue());
            String oldclaimstatus = info.getString("claimstatus");
            info.set("claimstatus", (Object)ClaimStatusEnum.SURE.getValue());
            info.set("confirmuser", (Object)RequestContext.get().getCurrUserId());
            info.set("confirmdate", (Object)new Date());
            info.set("chargereason", null);
            if (recPayType != null && EmptyUtil.isNoEmpty((DynamicObject)recPayType)) {
                info.set("recpaytype", (Object)recPayType);
            }
            if (payAmount.compareTo(BigDecimal.ZERO) != 0) {
                entrys = info.getDynamicObjectCollection("payentity");
                entrys.forEach(entry -> entry.set("e_payhandlestatus", (Object)ClaimHandleStatusEnum.CLAIMED.getValue()));
                List<DynamicObject> claimPayList = claimGroupMap.get(info.getPkValue().toString());
                if (claimPayList != null && claimPayList.size() > 0) {
                    for (DynamicObject claim : claimPayList) {
                        claim.set("claimstatus", (Object)ClaimStatusEnum.SURE.getValue());
                    }
                    claimList.addAll(claimPayList);
                }
                claimNoticeAllList.add(info);
                needPushCasPayList.add(info);
                continue;
            }
            entrys = info.getDynamicObjectCollection("entryentity");
            entrys.forEach(entry -> entry.set("e_handlestatus", (Object)ClaimHandleStatusEnum.CLAIMED.getValue()));
            Boolean isaddfee = info.getBoolean("isaddfee");
            BigDecimal allfee = info.getBigDecimal("fee");
            HashMap<Long, BigDecimal[]> updateFeeClaimNo = new HashMap<Long, BigDecimal[]>(entrys.size());
            DynamicObjectCollection entrysTemp = null;
            if (isaddfee.booleanValue() && EmptyUtil.isNoEmpty((DynamicObjectCollection)entrys)) {
                entrysTemp = entrys.stream().filter(dy -> !dy.getBoolean("e_billstatus")).collect(Collectors.toCollection(DynamicObjectCollection::new));
                entrysTemp.sort((dy1, dy2) -> dy1.getLong("id") - dy2.getLong("id") > 0L ? 1 : -1);
                DynamicObject currency = info.getDynamicObject("currency");
                DynamicObject entry2 = null;
                Object fee = BigDecimal.ZERO;
                BigDecimal totolfee = BigDecimal.ZERO;
                BigDecimal actamt = BigDecimal.ZERO;
                BigDecimal totolamt = entrysTemp.stream().map(dy -> dy.getBigDecimal("e_receivableamt")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                BigDecimal[] fees = null;
                for (int i = 0; i < entrysTemp.size(); ++i) {
                    entry2 = (DynamicObject)entrysTemp.get(i);
                    BigDecimal tempFee = entry2.getBigDecimal("e_fee");
                    fee = entry2.getBigDecimal("e_receivableamt");
                    fee = ((BigDecimal)fee).multiply(allfee).divide(totolamt, currency.getInt("amtprecision"), RoundingMode.DOWN);
                    if (i == entrysTemp.size() - 1) {
                        fee = allfee.subtract(totolfee);
                    } else {
                        totolfee = totolfee.add((BigDecimal)fee);
                    }
                    entry2.set("e_fee", fee);
                    actamt = entry2.getBigDecimal("e_actamt").add(tempFee).subtract((BigDecimal)fee);
                    entry2.set("e_actamt", (Object)actamt);
                    fees = new BigDecimal[]{fee, actamt};
                    updateFeeClaimNo.put(entry2.getLong("e_sourceentryid"), fees);
                }
            }
            List<DynamicObject> claimRecList = claimGroupMap.get(info.getPkValue().toString());
            DynamicObjectCollection dycoll = null;
            for (DynamicObject claim : claimRecList) {
                if (StringUtils.equals((CharSequence)ClaimHandleStatusEnum.NOTCLAIM.getValue(), (CharSequence)claim.getString("handlestatus")) && StringUtils.equals((CharSequence)claim.getString("billstatus"), (CharSequence)BillStatusEnum.AUDIT.getValue())) {
                    claim.set("handlestatus", (Object)ClaimHandleStatusEnum.CLAIMED.getValue());
                    if (StringUtils.equals((CharSequence)claim.getString("claimtype"), (CharSequence)ClaimTypeEnum.APPEAL.getValue()) || StringUtils.equals((CharSequence)claim.getString("claimtype"), (CharSequence)ClaimTypeEnum.CHANGE.getValue())) {
                        info.set("recpaytype", claim.get("recpaytype"));
                        info.set("paymenttype", claim.get("paymenttype"));
                        info.set("recpayer", claim.get("recpayer"));
                        info.set("bizdate", claim.get("bizdate"));
                        info.set("inneraccount", claim.get("inneraccount"));
                    }
                }
                claim.set("claimstatus", (Object)ClaimStatusEnum.SURE.getValue());
                dycoll = claim.getDynamicObjectCollection("entryentity");
                for (DynamicObject dy3 : dycoll) {
                    if (!updateFeeClaimNo.containsKey(dy3.getLong("id"))) continue;
                    dy3.set("e_fee", (Object)((BigDecimal[])updateFeeClaimNo.get(dy3.getLong("id")))[0]);
                    dy3.set("e_actamt", (Object)((BigDecimal[])updateFeeClaimNo.get(dy3.getLong("id")))[1]);
                }
            }
            if (StringUtils.equals((CharSequence)oldclaimstatus, (CharSequence)ClaimStatusEnum.CHANGE.getValue())) {
                for (DynamicObject claim : claimRecList) {
                    if (!StringUtils.equals((CharSequence)claim.getString("claimtype"), (CharSequence)ClaimTypeEnum.CLAIM.getValue()) || !StringUtils.equals((CharSequence)claim.getString("billstatus"), (CharSequence)BillStatusEnum.AUDIT.getValue())) continue;
                    claim.set("recpaytype", info.get("recpaytype"));
                    claim.set("paymenttype", info.get("paymenttype"));
                    claim.set("recpayer", info.get("recpayer"));
                    claim.set("bizdate", info.get("bizdate"));
                    claim.set("inneraccount", claim.get("inneraccount"));
                }
            }
            claimList.addAll(claimRecList);
            List<DynamicObject> recBills = recBillGroupMap.get(info.getPkValue());
            String changeType = (String)pushMap.get(info.getDynamicObject("org").getString("id"));
            needPushRecClaimBill.add(info);
            if (!CasHelper.isEmpty(recBills)) {
                for (DynamicObject recBill : recBills) {
                    if (BillStatusEnum.SAVE.getValue().equals(recBill.getString("billstatus"))) {
                        if (info.getBoolean("isunclaim") && (ClaimStatusEnum.WAIT.getValue().equals(oldclaimstatus) || ClaimStatusEnum.PART.getValue().equals(oldclaimstatus) || ClaimStatusEnum.CLAIMED.getValue().equals(oldclaimstatus))) {
                            info.set("isunclaim", (Object)false);
                        }
                        this.delRecBillList.add(recBill);
                        continue;
                    }
                    if (!"2".equals(changeType)) {
                        List transIdList = (List)allChildNoticeBatchBill.get(info.getPkValue());
                        this.dealPayBillMent(recBill, info, transIdList);
                        this.recBilHotList.add(recBill);
                        continue;
                    }
                    recBilChangeList.add(recBill);
                    needPushRecClaimBill.remove(info);
                }
            }
            claimNoticeAllList.add(info);
        }
        if (!(needPushCasPayList.isEmpty() || (executeOperate = OperateServiceHelper.executeOperate((String)"pushpayment", (String)"cas_claimcenterbill", (DynamicObject[])needPushCasPayList.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create())).isSuccess() || executeOperate.getAllErrorInfo().isEmpty())) {
            throw new KDBizException(((OperateErrorInfo)executeOperate.getAllErrorInfo().get(0)).getMessage());
        }
        this.dealChangeType(recBilChangeList);
        this.releseLock();
        OperateServiceHelper.execOperate((String)"deletenotvalidate", (String)"cas_recbill", (DynamicObject[])this.delRecBillList.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        if (needPushRecClaimBill.size() > 0) {
            OperateOption create = OperateOption.create();
            create.setVariableValue("confirm", "pushandsave");
            OperationResult executeOperate2 = OperateServiceHelper.executeOperate((String)"pushandsave", (String)"cas_claimcenterbill", (DynamicObject[])needPushRecClaimBill.toArray(new DynamicObject[0]), (OperateOption)create);
            if (!executeOperate2.isSuccess() && executeOperate2.getAllErrorInfo().size() > 0) {
                throw new KDBizException(((OperateErrorInfo)executeOperate2.getAllErrorInfo().get(0)).getMessage());
            }
        }
        SaveServiceHelper.save((DynamicObject[])claimNoticeAllList.toArray(new DynamicObject[0]));
        if (!claimList.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])claimList.toArray(new DynamicObject[0]));
        }
    }

    private void releseLock() {
        ArrayList<DraftLockInfo> lockInfoList = new ArrayList<DraftLockInfo>(10);
        for (DynamicObject recBill : this.delRecBillList) {
            DynamicObject settleType = recBill.getDynamicObject("settletype");
            String sourcebilltype = recBill.getString("sourcebilltype");
            boolean isFromcdm = "cdm_drafttradebill".equals(sourcebilltype);
            boolean isFromclaim = "cas_claimcenterbill".equals(sourcebilltype);
            boolean typeDraft = BaseDataHelper.isSettleTypeDraft((DynamicObject)settleType);
            boolean checkDraft = BaseDataHelper.isSettleTypeCheck((DynamicObject)settleType);
            String txt_description = recBill.getString("txt_description");
            boolean isAlloc = ResManager.loadKDString((String)"\u7968\u636e\u6c60\u5185\u80cc\u4e66", (String)"ReceivRecOp_1", (String)"fi-cas-opplugin", (Object[])new Object[0]).equals(txt_description);
            if (!typeDraft && !checkDraft || isFromcdm || isAlloc) {
                logger.info("is not draftType or is from cdm" + recBill.getString("billno"));
                continue;
            }
            DynamicObjectCollection draftbillColl = recBill.getDynamicObjectCollection("draftbill");
            DynamicObjectCollection draftInfoEntrys = recBill.getDynamicObjectCollection("cas_draftinfo");
            if (draftbillColl.size() <= 0) continue;
            List draftBillIds = draftbillColl.stream().map(v -> v.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
            DynamicObject[] draftBills = BusinessDataServiceHelper.load((String)"cdm_draftbillf7", (String)"amount,availableamount", (QFilter[])new QFilter[]{new QFilter("id", "in", draftBillIds)});
            HashMap draftIdTranAmountAmountMap = draftInfoEntrys.stream().collect(Collectors.toMap(v -> v.getDynamicObject("draftbillinfo").getLong("id"), o -> o.getBigDecimal("transamount"), (o1, o2) -> o1, HashMap::new));
            HashMap draftIdAvailableAmountMap = Arrays.stream(draftBills).collect(Collectors.toMap(v -> v.getLong("id"), o -> o.getBigDecimal("availableamount"), (o1, o2) -> o1, HashMap::new));
            Map draftIdLogIdMap = draftInfoEntrys.stream().collect(Collectors.toMap(v -> v.getDynamicObject("draftbillinfo").getLong("id"), o -> o.getLong("draftbilllogid"), (o1, o2) -> o1, HashMap::new));
            DraftLockInfo draftLockInfo = new DraftLockInfo();
            draftLockInfo.setOperateType(LogOperateTypeEnum.DELETE.getValue());
            draftLockInfo.setSourceBillType(recBill.getDataEntityType().getName());
            draftLockInfo.setBizBillNo(recBill.getString("billno"));
            draftLockInfo.setSourceBillId(Long.valueOf(recBill.getLong("id")));
            ArrayList<DraftAmountLockSubInfo> subInfoList = new ArrayList<DraftAmountLockSubInfo>(8);
            for (Long lockDraftId : draftBillIds) {
                Long draftLogId;
                DraftAmountLockSubInfo draftAmountLockInfo = new DraftAmountLockSubInfo();
                draftAmountLockInfo.setBillId(lockDraftId);
                BigDecimal availableAmount = draftIdAvailableAmountMap.get(lockDraftId) == null ? BigDecimal.ZERO : (BigDecimal)draftIdAvailableAmountMap.get(lockDraftId);
                BigDecimal transAmount = draftIdTranAmountAmountMap.get(lockDraftId) == null ? availableAmount : (BigDecimal)draftIdTranAmountAmountMap.get(lockDraftId);
                draftAmountLockInfo.setDealAmount(transAmount);
                Long l = draftLogId = draftIdLogIdMap.get(lockDraftId) == null ? Long.valueOf(0L) : (Long)draftIdLogIdMap.get(lockDraftId);
                if (EmptyUtil.isEmpty((Long)draftLogId) && isFromclaim) continue;
                draftAmountLockInfo.setBillLogId(draftLogId);
                draftAmountLockInfo.setBillTrade(LogBizTypeEnum.ENDORSE.getValue());
                draftAmountLockInfo.setOperateType(LogOperateTypeEnum.DELETE.getValue());
                subInfoList.add(draftAmountLockInfo);
            }
            if (!EmptyUtil.isNoEmpty(subInfoList) || subInfoList.size() <= 0) continue;
            draftLockInfo.setLockSubInfoList(subInfoList);
            lockInfoList.add(draftLockInfo);
        }
        if (!CollectionUtils.isEmpty(lockInfoList)) {
            logger.info("ReceivingDeleteOp updateBillsByLog is start," + JSON.toJSONString(lockInfoList));
            DraftLockServiceHelper draftLockServiceHelper = new DraftLockServiceHelper();
            draftLockServiceHelper.releaseOrLockDraft(lockInfoList);
            logger.info("ReceivingDeleteOp updateBillsByLog is end");
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        Object[] ids = this.recBilHotList.stream().map(o -> o.getPkValue()).toArray();
        DynamicObject[] newRecBills = BusinessDataServiceHelper.load((Object[])ids, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cas_recbill"));
        RecSaleServiceHelper.convertSaleAndContract((DynamicObject[])newRecBills, (boolean)false);
    }

    private void dealPayBillMent(DynamicObject recBill, DynamicObject info, List<Object> transIdList) {
        boolean isVoucher;
        if (!BillStatusEnum.PAY.getValue().equals(recBill.getString("billstatus"))) {
            return;
        }
        DynamicObject recType = recBill.getDynamicObject("receivingtype");
        DynamicObject oldRecBill = recBill;
        if (oldRecBill == null) {
            return;
        }
        this.cancelRecBillList.add(oldRecBill);
        DynamicObject newRecBill = RecBillHepler.dealReverse((DynamicObject)oldRecBill, (Date)info.getDate("bizdate"));
        if (newRecBill == null) {
            return;
        }
        if (EmptyUtil.isNoEmpty(transIdList) && "bei_transdetail".equals(info.getString("sourcetype"))) {
            HashMap map = new HashMap(transIdList.size());
            HashMap<String, String> transFerInfo = new HashMap<String, String>(8);
            transFerInfo.put("recedbilltype", recBill.getDataEntityType().getName());
            transFerInfo.put("recedbillnumber", recBill.getString("billno"));
            transIdList.forEach(o -> map.put((Long)o, transFerInfo));
        }
        if (isVoucher = oldRecBill.getBoolean("isvoucher")) {
            this.newDelRecBillList.add(newRecBill);
        }
        CasBotpHelper.saveRelation((String)"cas_claimcenterbill", (Long)info.getLong("id"), (String)"cas_recbill", (Long)newRecBill.getLong("id"));
        if (recType != null && recType.getBoolean("ispartreceivable")) {
            this.blueRecBillList.add(oldRecBill);
            this.blueRedMap.put(oldRecBill.getPkValue(), newRecBill);
        }
    }

    private void dealChangeType(List<DynamicObject> recBilChangeList) {
        OperateOption create = OperateOption.create();
        create.setVariableValue("source", "claim");
        OperationResult executeOperate = OperateServiceHelper.executeOperate((String)"recinfochgsave", (String)"cas_recbill", (DynamicObject[])recBilChangeList.toArray(new DynamicObject[0]), (OperateOption)create);
        if (!executeOperate.isSuccess() && executeOperate.getAllErrorInfo().size() > 0) {
            throw new KDBizException(((OperateErrorInfo)executeOperate.getAllErrorInfo().get(0)).getMessage());
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        List<DynamicObject> needWriteBack;
        logger.error("RecClaimToAccountOp afterExecuteOperationTransaction start");
        if (this.delRecBillList.size() > 0 && (needWriteBack = this.isNeedWriteBack(this.delRecBillList)).size() > 0) {
            this.delDeadClaimBill(needWriteBack);
        }
        if (this.cancelRecBillList.size() > 0) {
            List<DynamicObject> cancelNeedWriteBack = this.isNeedWriteBack(this.cancelRecBillList);
            if (cancelNeedWriteBack.size() > 0) {
                this.delDeadClaimBill(cancelNeedWriteBack);
            }
            for (DynamicObject cancelRecBill : this.cancelRecBillList) {
                RecBillOverAmountHelper.getWriteBackVad((DynamicObject)cancelRecBill, (WriteBackOperateEnum)WriteBackOperateEnum.CANCELRECEIVE, (boolean)false);
            }
        }
        if (this.newDelRecBillList.size() > 0) {
            List<Object> recIdList = this.newDelRecBillList.stream().map(o -> o.getPkValue()).collect(Collectors.toList());
            OperationResult operate = OperateServiceHelper.execOperateWithoutThrow((String)"generatevoucher", (String)"cas_recbill", (Object[])recIdList.toArray(new Object[0]), (OperateOption)OperateOption.create());
            if (operate != null && !operate.isSuccess()) {
                logger.error("RecClaimToAccountOp generatevoucher error:" + operate.getMessage());
            }
            if (operate == null) {
                logger.error("RecClaimToAccountOp generatevoucher error: operate is null");
            }
        }
        if (this.blueRecBillList.size() > 0) {
            for (DynamicObject blueRecBill : this.blueRecBillList) {
                DynamicObject redRecBill = this.blueRedMap.get(blueRecBill.getPkValue());
                if (!CasHelper.isNotEmpty((Object)redRecBill)) continue;
                try {
                    Object result = DispatchServiceHelper.invokeBizService((String)"fi", (String)"ar", (String)"recself", (String)"autoSettle", (Object[])new Object[]{new DynamicObject[]{blueRecBill}, new DynamicObject[]{redRecBill}});
                    String message = SerializationUtils.toJsonString((Object)result);
                    logger.error("RecClaimToAccountOp autoSettle result:" + message);
                }
                catch (Exception exc) {
                    logger.error("RecClaimToAccountOp autoSettle error:", (Throwable)exc);
                }
            }
        }
    }

    private List<DynamicObject> isNeedWriteBack(List<DynamicObject> recBill) {
        ArrayList<DynamicObject> needWriteBackRecBillList = new ArrayList<DynamicObject>();
        for (DynamicObject info : recBill) {
            String sourcebilltype = info.getString("sourcebilltype");
            if (CasHelper.isNotEmpty((Object)sourcebilltype) && !"cas_claimcenterbill".equals(sourcebilltype)) continue;
            DynamicObjectCollection entrys = info.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entrys) {
                if ("fr_glreim_paybill".equals(entry.getString("e_corebilltype")) || "fr_glreim_recbill".equals(entry.getString("e_corebilltype"))) {
                    needWriteBackRecBillList.add(info);
                }
                if ("ar_finarbill".equals(entry.getString("e_corebilltype"))) {
                    needWriteBackRecBillList.add(info);
                }
                if (!"sm_salorder".equals(entry.getString("e_corebilltype"))) continue;
                needWriteBackRecBillList.add(info);
            }
        }
        return needWriteBackRecBillList;
    }

    private void delDeadClaimBill(List<DynamicObject> needWriteBack) {
        HashSet<String> claimBillNos = new HashSet<String>(10);
        for (DynamicObject recBill : needWriteBack) {
            DynamicObjectCollection entry = recBill.getDynamicObjectCollection("entry");
            for (DynamicObject row : entry) {
                String claimBillNo = row.getString("e_claimbill");
                if (!StringUtils.isNotBlank((CharSequence)claimBillNo)) continue;
                claimBillNos.add(claimBillNo);
            }
        }
        if (claimBillNos.size() > 0) {
            QFilter filter = new QFilter("billno", "in", claimBillNos).and(new QFilter("billstatus", "=", (Object)BillStatusEnum.DEAD.getValue()));
            DynamicObject[] claims = BusinessDataServiceHelper.load((String)"cas_claimbill", (String)"id", (QFilter[])new QFilter[]{filter});
            if (claims.length > 0) {
                DynamicObject[] claimBills;
                HashSet<Object> claimIds = new HashSet<Object>(claims.length);
                for (DynamicObject claim : claims) {
                    claimIds.add(claim.getPkValue());
                }
                for (DynamicObject claimBill : claimBills = BusinessDataServiceHelper.load((Object[])claimIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cas_claimbill"))) {
                    RecBillOverAmountHelper.getWriteBackVad((DynamicObject)claimBill, (WriteBackOperateEnum)WriteBackOperateEnum.UNSUBMIT, (boolean)false);
                }
            }
        }
    }
}

