/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin.recclaim;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.fi.cas.business.recpayrule.api.impl.RecPayRuleApiServiceImpl;
import kd.fi.cas.business.recpayrule.bean.MatchResultBean;
import kd.fi.cas.helper.OperateServiceHelper;
import kd.fi.cas.helper.RecClaimHelper;
import kd.fi.cas.helper.TmcAppCache;
import kd.fi.cas.param.ClaimNoticeMesParam;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.validator.recclaim.RecNoticeClaimValidator;
import org.apache.commons.lang3.StringUtils;

public class RecNoticeClaimOp
extends AbstractOperationServicePlugIn {
    private static final IAppCache cache = TmcAppCache.get((String)"cas", (String)"intelrec", (String)"claim");
    private static final Log LOGGER = LogFactory.getLog(RecNoticeClaimOp.class);
    private List<Object> successPkIdList = new ArrayList<Object>(10);

    public void onPreparePropertys(PreparePropertysEventArgs args) {
        super.onPreparePropertys(args);
        List lst = args.getFieldKeys();
        lst.add("receredtype");
        lst.add("claimnoticebillno");
        lst.add("debitamount");
        lst.add("creditamount");
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        super.onAddValidators(args);
        args.addValidator((AbstractValidator)new RecNoticeClaimValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        super.beginOperationTransaction(args);
        DynamicObject[] dataEntities = args.getDataEntities();
        ArrayList<DynamicObject> successIds = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> failIds = new ArrayList<DynamicObject>(10);
        HashMap<String, String> ruleNotice = new HashMap<String, String>(16);
        Object[] unNoticeIds = Arrays.stream(dataEntities).map(DataEntityBase::getPkValue).toArray();
        RecPayRuleApiServiceImpl recPayRuleApiService = new RecPayRuleApiServiceImpl();
        List matchResultBeanList = recPayRuleApiService.matchNoticeClaim(unNoticeIds);
        Set entryRuleIdSet = matchResultBeanList.stream().map(MatchResultBean::getEntryRuleId).collect(Collectors.toSet());
        Map<Object, MatchResultBean> matchResultBeanMap = matchResultBeanList.stream().collect(Collectors.toMap(MatchResultBean::getId, e -> e, (v1, v2) -> v2));
        DynamicObjectCollection ruleList = QueryServiceHelper.query((String)"cas_recpayrule", (String)"entryentity.id,entryentity.e_savenotifi_TAG", (QFilter[])new QFilter[]{new QFilter("entryentity.id", "in", entryRuleIdSet)});
        Map<Object, DynamicObject> ruleMap = ruleList.stream().collect(Collectors.toMap(e -> e.get("entryentity.id"), e -> e, (v1, v2) -> v2));
        for (DynamicObject dataEntity : dataEntities) {
            Object id = dataEntity.getPkValue();
            DynamicObject ruleResult = null;
            MatchResultBean matchResultBean = matchResultBeanMap.get(id);
            String ruleName = " ";
            if (matchResultBean != null) {
                ruleResult = ruleMap.get(matchResultBean.getEntryRuleId());
                ruleName = matchResultBean.getNewRuleName();
            }
            if (ruleResult != null) {
                String notify = ruleResult.getString("entryentity.e_savenotifi_TAG");
                if (StringUtils.isNotBlank((CharSequence)notify)) {
                    successIds.add(dataEntity);
                    cache.put(id.toString(), (Object)notify);
                    ruleNotice.put(id.toString(), notify);
                    cache.put(id + "rulesname", (Object)ruleName);
                    continue;
                }
                failIds.add(dataEntity);
                continue;
            }
            failIds.add(dataEntity);
        }
        if (!successIds.isEmpty()) {
            LOGGER.info("pushandsave:{}", successIds);
            OperationResult operationResult = OperateServiceHelper.execOperateWithoutThrow((String)"pushandsave", (String)"bei_transdetail_cas", (Object[])successIds.stream().map(e -> e.get("id")).toArray(), (OperateOption)OperateOption.create());
            this.successPkIdList = operationResult.getSuccessPkIds();
            LOGGER.info("notice");
            this.noticeMessage(ruleNotice);
        }
        StringBuilder recPayRuleFailMessage = new StringBuilder();
        if (!failIds.isEmpty()) {
            StringBuilder failIdBuilder = new StringBuilder();
            failIds.stream().forEach(detail -> {
                recPayRuleFailMessage.append(String.format(ResManager.loadKDString((String)"%s\uff1a\u65e0\u6cd5\u6309\u65b9\u6848\u901a\u77e5\u8ba4\u9886\uff0c\u53ef\u80fd\u662f\u672a\u8fdb\u884c\u89c4\u5219\u8bbe\u7f6e\uff0c\u6216\u672a\u9002\u914d\u5230\u65b9\u6848\u3002\u53ef\u6307\u5b9a\u53c2\u4e0e\u8ba4\u9886\u7528\u6237\u4fe1\u606f\u540e\u53d1\u8d77\u901a\u77e5\u3002\r\n", (String)"ClaimRecWorkbenchList_1", (String)"", (Object[])new Object[0]), detail.get("billno")));
                failIdBuilder.append(detail.getPkValue()).append(",");
            });
            OperateErrorInfo errorInfo = new OperateErrorInfo();
            errorInfo.setLevel(ErrorLevel.Error);
            errorInfo.setMessage(recPayRuleFailMessage.toString());
            this.operationResult.addErrorInfo(errorInfo);
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        this.operationResult.setSuccessPkIds(this.successPkIdList);
    }

    private void noticeMessage(Map<String, String> ruleNotice) {
        ArrayList ruleList = new ArrayList(ruleNotice.size());
        HashSet allUserId = new HashSet();
        for (Map.Entry<String, String> rule : ruleNotice.entrySet()) {
            int i;
            Map map = (Map)SerializationUtils.fromJsonString((String)rule.getValue(), Map.class);
            List userGroupids = (List)map.get("usergroupids");
            Iterator orgids = (List)map.get("orgids");
            List list = (List)map.get("roleids");
            List userids = (List)map.get("userids");
            HashSet userIds = new HashSet();
            if (!EmptyUtil.isEmpty((Collection)userGroupids)) {
                for (i = 0; i < userGroupids.size(); ++i) {
                    DynamicObjectCollection query = QueryServiceHelper.query((String)"fbd_usergroup", (String)"entryentity.userfield", (QFilter[])new QFilter[]{new QFilter("id", "=", userGroupids.get(i)).and("enable", "=", (Object)"1")}, null);
                    userIds.addAll(query.stream().map(o -> o.getLong("entryentity.userfield")).collect(Collectors.toList()));
                }
            }
            if (!EmptyUtil.isEmpty(orgids)) {
                userIds.addAll(UserServiceHelper.getAllUsersOfOrg((int)0, orgids, (boolean)true, (boolean)false));
            }
            if (!EmptyUtil.isEmpty((Collection)list)) {
                for (i = 0; i < list.size(); ++i) {
                    userIds.addAll(PermissionServiceHelper.getUsersByRoleID((String)String.valueOf(list.get(i))));
                }
            }
            if (!EmptyUtil.isEmpty((Collection)userids)) {
                userIds.addAll(userids.stream().filter(EmptyUtil::isNoEmpty).map(u -> Long.valueOf(u.toString())).collect(Collectors.toList()));
            }
            ruleList.add(userIds);
            allUserId.addAll(userIds);
        }
        HashMap<Long, Integer> userCount = new HashMap<Long, Integer>(allUserId.size());
        int count = 0;
        for (Long userId : allUserId) {
            count = 0;
            for (Set set : ruleList) {
                if (!set.contains(userId)) continue;
                ++count;
            }
            userCount.put(userId, count);
        }
        HashMap noticeUsers = new HashMap(userCount.size());
        HashSet users = null;
        for (Map.Entry entry : userCount.entrySet()) {
            users = (HashSet)noticeUsers.get(entry.getValue());
            if (EmptyUtil.isEmpty((Collection)users)) {
                users = new HashSet();
            }
            users.add(entry.getKey());
            noticeUsers.put(entry.getValue(), users);
        }
        ClaimNoticeMesParam param = null;
        for (Map.Entry notice : noticeUsers.entrySet()) {
            param = new ClaimNoticeMesParam();
            param.setTag(ResManager.loadKDString((String)"\u6536\u4ed8\u8ba4\u9886", (String)"RecNoticeClaimOp_1", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            param.setTitle(String.format(ResManager.loadKDString((String)"%s\u7b14\u6b3e\u9879\u9700\u8981\u8ba4\u9886\uff0c\u8bf7\u5c3d\u5feb\u5904\u7406", (String)"RecNoticeClaimOp_0", (String)"fi-cas-opplugin", (Object[])new Object[0]), notice.getKey()));
            param.setContent(ResManager.loadKDString((String)"\u8bf7\u8fdb\u5165\u201c\u8d44\u91d1\u7ed3\u7b97\u201d\u6216\u201c\u51fa\u7eb3\u201d\u5e94\u7528\uff0c\u201c\u6536\u4ed8\u8ba4\u9886->\u8ba4\u9886\u516c\u544a\u201d\u83dc\u5355\u8fdb\u884c\u5904\u7406", (String)"RecNoticeClaimOp_2", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            param.setUserIds((Set)notice.getValue());
            param.setNoticeType("notice");
            RecClaimHelper.sendNoticeMessage((ClaimNoticeMesParam)param);
        }
    }
}

