/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin.recinit;

import java.util.ArrayList;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.business.balancemodel.log.enums.OperateType;
import kd.fi.cas.business.balancemodel.log.helper.BalanceModelLogHelper;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.helper.OperateServiceHelper;

public class RecEdcStopOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List keyList = e.getFieldKeys();
        keyList.add("org");
        keyList.add("startperiod");
        keyList.add("currentperiod");
        keyList.add("recperiod");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] infos = e.getDataEntities();
        ArrayList<DynamicObject> addStopLogs = new ArrayList<DynamicObject>(infos.length);
        for (DynamicObject info : infos) {
            DynamicObject stopEdc = BusinessDataServiceHelper.newDynamicObject((String)"cas_rec_stopedclog");
            stopEdc.set("org", info.get("org"));
            stopEdc.set("billstatus", (Object)BillStatusEnum.SAVE.getValue());
            stopEdc.set("startperiod", info.get("startperiod"));
            stopEdc.set("currentperiod", info.get("currentperiod"));
            stopEdc.set("recperiod", info.get("recperiod"));
            stopEdc.set("creator", (Object)RequestContext.get().getCurrUserId());
            addStopLogs.add(stopEdc);
            Object orgId = info.getDynamicObject("org").getPkValue();
            DynamicObject recperiod = info.getDynamicObject("recperiod");
            QFilter orgFilter = new QFilter("org", "=", orgId);
            QFilter periodFilter = new QFilter("initperiod", "=", recperiod.getPkValue());
            QFilter initFilter = new QFilter("isfinishinit", "=", (Object)"1");
            boolean exists = QueryServiceHelper.exists((String)"cas_rec_init", (QFilter[])new QFilter[]{orgFilter, periodFilter, initFilter});
            if (!exists) continue;
            this.updateOutDatas(orgId, recperiod.getPkValue(), "cas_bankstatement");
            this.updateOutDatas(orgId, recperiod.getPkValue(), "cas_bankjournal");
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        OperateServiceHelper.execOperate((String)"save", (String)"cas_rec_stopedclog", (DynamicObject[])addStopLogs.toArray(new DynamicObject[0]), (OperateOption)option);
        OperateServiceHelper.execOperate((String)"delete", (String)"cas_rec_edc", (DynamicObject[])infos, (OperateOption)option);
        BalanceModelLogHelper.doBalanceModelLog((DynamicObject[])infos, (OperateType)OperateType.DELETE);
    }

    private void updateOutDatas(Object orgId, Object initPeriodId, String outDataEntity) {
        QFilter recperiodFilter;
        QFilter oFilter = new QFilter("org", "=", orgId);
        QFilter pFilter = new QFilter("period", "=", (Object)0L);
        DynamicObject[] outDatas = BusinessDataServiceHelper.load((String)outDataEntity, (String)"id,isvalid", (QFilter[])new QFilter[]{oFilter, pFilter, recperiodFilter = new QFilter("recinitperiod", "=", initPeriodId)});
        if (outDatas != null && outDatas.length > 0) {
            for (DynamicObject outData : outDatas) {
                outData.set("isvalid", (Object)"0");
            }
            SaveServiceHelper.save((DynamicObject[])outDatas);
        }
    }
}

