/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin.recinit;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.helper.InitCashHelper;

public class RecInitImportDataOp
extends BatchImportPlugin {
    private static final Log LOGGER = LogFactory.getLog(RecInitImportDataOp.class);
    private static final Integer COLLECTION_CAPACITY = 4;

    protected ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        this.saveData(rowdatas, logger);
        return super.save(rowdatas, logger);
    }

    protected void saveData(List<ImportBillData> rowdatas, ImportLogger logger) {
        List orgIds = InitCashHelper.getOrgIds(rowdatas);
        if (orgIds.size() == 0) {
            LOGGER.warn("RecInitImportDataOp\uff1a cannot fetch information of origin");
            return;
        }
        Map cashInitMap = InitCashHelper.getCashInit((List)orgIds);
        if (cashInitMap.size() == 0) {
            LOGGER.warn("RecInitImportDataOp\uff1a cannot fetch information of cash");
            return;
        }
        for (ImportBillData data : rowdatas) {
            JSONObject jsonData = data.getData();
            Map org = (Map)jsonData.get((Object)"org");
            String orgNum = (String)org.get("number");
            Map cashInit = (Map)cashInitMap.get(orgNum);
            this.addPeriod(cashInit, jsonData);
            this.addRateTable(cashInit, jsonData);
            this.addPeriodType(cashInit, jsonData);
        }
        Map option = this.ctx.getOption();
        Object importType = option.get("importtype");
        if (!StringUtils.equals((CharSequence)"new", (CharSequence)importType.toString())) {
            this.deleteEntry(rowdatas);
        }
    }

    private void deleteEntry(List<ImportBillData> rowdatas) {
        ImportAccount importAccount;
        HashSet<String> recInitBillNos = new HashSet<String>(rowdatas.size());
        for (ImportBillData data : rowdatas) {
            JSONObject jsonData = data.getData();
            String billNo = jsonData.getString("billno");
            recInitBillNos.add(billNo);
        }
        QFilter qFilter = new QFilter("billno", "in", recInitBillNos);
        DynamicObject[] recInits = BusinessDataServiceHelper.load((String)"cas_rec_init", (String)"id,billno,org,entrybank,entrybank.bank_currency,entrybank.bank_accountbank", (QFilter[])new QFilter[]{qFilter});
        HashMap billNoAccounts = new HashMap(recInits.length);
        for (DynamicObject recInit : recInits) {
            String billNo = recInit.getString("billno");
            HashSet<ImportAccount> accounts = (HashSet<ImportAccount>)billNoAccounts.get(billNo);
            if (accounts == null) {
                accounts = new HashSet<ImportAccount>(16);
                billNoAccounts.put(billNo, accounts);
            }
            DynamicObjectCollection entrybank = recInit.getDynamicObjectCollection("entrybank");
            for (DynamicObject bank : entrybank) {
                DynamicObject currency = bank.getDynamicObject("bank_currency");
                String currencyNumber = currency.getString("number");
                DynamicObject accountBank = bank.getDynamicObject("bank_accountbank");
                String accountBankNumber = accountBank.getString("bankaccountnumber");
                importAccount = new ImportAccount(bank.getLong("id"), currencyNumber, accountBankNumber);
                accounts.add(importAccount);
            }
        }
        for (ImportBillData data : rowdatas) {
            JSONObject jsonData = data.getData();
            String billNo = jsonData.getString("billno");
            Set accounts = (Set)billNoAccounts.get(billNo);
            if (accounts == null || accounts.size() <= 0) continue;
            JSONArray entryBanks = jsonData.getJSONArray("entrybank");
            for (int i = 0; i < entryBanks.size(); ++i) {
                JSONObject bank = entryBanks.getJSONObject(i);
                JSONObject bankCurrency = bank.getJSONObject("bank_currency");
                String currencyNumber = bankCurrency.getString("number");
                JSONObject bankAccount = bank.getJSONObject("bank_accountbank");
                String bankNumber = bankAccount.getString("bankaccountnumber");
                String accountCurrency = bankNumber + "_" + currencyNumber;
                importAccount = new ImportAccount(currencyNumber, bankNumber);
                if (!accounts.contains(importAccount)) continue;
                for (ImportAccount ia : accounts) {
                    String bankNum = ia.getBankNumber();
                    String currencyNum = ia.getCurrencyNumber();
                    String compareStr = bankNum + "_" + currencyNum;
                    if (!accountCurrency.equals(compareStr)) continue;
                    bank.put("id", (Object)ia.getEntryId());
                }
            }
        }
    }

    private void addPeriod(Map<String, Object> cashInit, JSONObject jsonData) {
        DynamicObject periodDynamic = (DynamicObject)cashInit.get("current");
        HashMap<String, Object> newPeriodImport = new HashMap<String, Object>(COLLECTION_CAPACITY);
        newPeriodImport.put("importprop", "id");
        newPeriodImport.put("id", periodDynamic.getLong("id"));
        jsonData.remove((Object)"initperiod");
        jsonData.remove((Object)"currentperiod");
        jsonData.put("initperiod", newPeriodImport);
        jsonData.put("currentperiod", newPeriodImport);
    }

    private void addRateTable(Map<String, Object> cashInit, JSONObject jsonData) {
        DynamicObject exRateTableDynamic = (DynamicObject)cashInit.get("exratetable");
        HashMap<String, Object> newExRateTable = new HashMap<String, Object>(COLLECTION_CAPACITY);
        newExRateTable.put("importprop", "id");
        newExRateTable.put("id", exRateTableDynamic.getLong("id"));
        jsonData.remove((Object)"exratetable");
        jsonData.put("exratetable", newExRateTable);
    }

    private void addPeriodType(Map<String, Object> cashInit, JSONObject jsonData) {
        DynamicObject periodTypeDynamic = (DynamicObject)cashInit.get("type");
        HashMap<String, Object> newPeriodType = new HashMap<String, Object>(COLLECTION_CAPACITY);
        newPeriodType.put("importprop", "id");
        newPeriodType.put("id", periodTypeDynamic.getLong("id"));
        jsonData.remove((Object)"periodtype");
        jsonData.put("periodtype", newPeriodType);
    }

    static class ImportAccount {
        Long entryId;
        String currencyNumber;
        String bankNumber;

        public ImportAccount(Long entryId, String currencyNumber, String bankNumber) {
            this.entryId = entryId;
            this.currencyNumber = currencyNumber;
            this.bankNumber = bankNumber;
        }

        public ImportAccount(String currencyNumber, String bankNumber) {
            this.currencyNumber = currencyNumber;
            this.bankNumber = bankNumber;
        }

        public Long getEntryId() {
            return this.entryId;
        }

        public void setEntryId(Long entryId) {
            this.entryId = entryId;
        }

        public String getCurrencyNumber() {
            return this.currencyNumber;
        }

        public void setCurrencyNumber(String currencyNumber) {
            this.currencyNumber = currencyNumber;
        }

        public String getBankNumber() {
            return this.bankNumber;
        }

        public void setBankNumber(String bankNumber) {
            this.bankNumber = bankNumber;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ImportAccount)) {
                return false;
            }
            ImportAccount that = (ImportAccount)o;
            return Objects.equals(this.currencyNumber, that.currencyNumber) && Objects.equals(this.bankNumber, that.bankNumber);
        }

        public int hashCode() {
            return Objects.hash(this.currencyNumber, this.bankNumber);
        }
    }
}

