/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin.refund;

import java.util.Collections;
import kd.bos.dataentity.OperateOption;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.fi.cas.business.refund.RefundService;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.validator.refund.DetailRenoteValidator;

public class DetailRenoteOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new DetailRenoteValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        OperationResult result;
        OperateOption option = this.getOption();
        String billType = option.getVariableValue("billType");
        Long billId = Long.parseLong(option.getVariableValue("billId"));
        Long transDetailId = Long.parseLong(option.getVariableValue("detailId"));
        RefundService refundService = new RefundService();
        if ("cas_paybill".equals(billType)) {
            result = refundService.autoRenote(billId, billType, transDetailId);
        } else {
            Long entryId = Long.parseLong(option.getVariableValue("entryId"));
            result = refundService.autoRenote(billId, billType, Collections.singletonList(entryId), transDetailId);
        }
        if (!result.isSuccess()) {
            throw new KDBizException(CasHelper.getFailResultMsg((OperationResult)result));
        }
    }
}

