/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin.refund;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.cas.business.opservice.helper.PaymentServiceHelper;
import kd.fi.cas.business.writeback.WriteBackConfigInvoker;
import kd.fi.cas.business.writeback.WriteBackTaskHelper;
import kd.fi.cas.business.writeback.ar.bean.Result;
import kd.fi.cas.business.writeback.consts.WriteBackOperateEnum;
import kd.fi.cas.business.writeback.refund.CancelRefundWriteBackConsumer;
import kd.fi.cas.helper.AgentPayBillHelper;
import kd.fi.cas.helper.CasBotpHelper;

public class RefundWriteBackHelper {
    public static void agentWriteBack(Long revId, WriteBackOperateEnum operate, DynamicObject[] agentBills) {
        Map<String, List<DynamicObject>> agentBillBySourceMap = Arrays.stream(agentBills).filter(b -> !"repay".equals(b.getString("sourcebilltype"))).collect(Collectors.groupingBy(b -> b.getString("sourcebilltype")));
        for (Map.Entry<String, List<DynamicObject>> billEntry : agentBillBySourceMap.entrySet()) {
            Result sourceValidatorResult;
            String sourceBillType = billEntry.getKey();
            List<DynamicObject> billList = billEntry.getValue();
            try {
                CancelRefundWriteBackConsumer consumer = new CancelRefundWriteBackConsumer(revId, billList);
                Object sourceValidatorRes = WriteBackTaskHelper.batchAddWriteBackTask((DynamicObject[])billList.toArray(new DynamicObject[0]), (String)sourceBillType, (WriteBackOperateEnum)operate, (WriteBackConfigInvoker)consumer, null);
                sourceValidatorResult = (Result)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)sourceValidatorRes), Result.class);
            }
            catch (Exception ex) {
                throw new KDBizException(ex.getMessage());
            }
            if (sourceValidatorResult == null || "0".equals(sourceValidatorResult.getCode())) continue;
            throw new KDBizException(sourceValidatorResult.getErrorInfo());
        }
    }

    public static Map<Long, DynamicObject> getEntrustSourceBills(DynamicObject[] bills) {
        HashMap<Long, DynamicObject> entrustSourceBills = new HashMap<Long, DynamicObject>((int)((double)bills.length / 0.75 + 1.0));
        for (DynamicObject bill : bills) {
            Set sourceAgentIds;
            Long billId = (Long)bill.getPkValue();
            String entityType = bill.getDataEntityType().getName();
            DynamicObject sourceBill = null;
            if ("cas_paybill".equals(entityType) && PaymentServiceHelper.isEntrustTargetPayBill((DynamicObject)bill)) {
                Long sourcePayBillId = bill.getLong("sourcebillid");
                sourceBill = BusinessDataServiceHelper.loadSingle((Object)sourcePayBillId, (String)"cas_paybill");
            } else if ("cas_agentpaybill".equals(entityType) && AgentPayBillHelper.isEntrustPush((DynamicObject)bill) && CollectionUtils.isNotEmpty((Collection)(sourceAgentIds = CasBotpHelper.getSrcBillByDestBill((Long)billId, (String)"cas_agentpaybill", (String)"cas_agentpaybill")))) {
                Long sourceAgentBillId = (Long)sourceAgentIds.iterator().next();
                sourceBill = BusinessDataServiceHelper.loadSingle((Object)sourceAgentBillId, (String)"cas_agentpaybill");
            }
            if (sourceBill == null) continue;
            entrustSourceBills.put(billId, sourceBill);
        }
        return entrustSourceBills;
    }
}

