/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin.smartmatch;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.IOperationService;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.business.helper.CasFlowConfirmLogHelper;
import kd.fi.cas.enums.AutoMatchBillTypeEnum;
import kd.fi.cas.enums.MatchRelEnum;
import kd.fi.cas.enums.ReceredWayEnum;
import kd.fi.cas.enums.ResultSaveAutoMatchStatus;
import kd.fi.cas.param.AutoMatchInfoParam;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.validator.smartmatch.ConfirmMatchValidator;

public class ConfirmMatchOp
extends AbstractOperationServicePlugIn
implements IOperationService {
    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new ConfirmMatchValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        String[] selectedPkDatas = new String[]{};
        if (this.getOption().containsVariable("selectedRowsData")) {
            String selectedRowsDatas = this.getOption().getVariableValue("selectedRowsData");
            selectedPkDatas = selectedRowsDatas.split(",");
        }
        this.doConfirmMatchOp(selectedPkDatas);
    }

    private void doConfirmMatchOp(String[] selectedPkDatas) {
        ArrayList<Long> pkList = new ArrayList<Long>(selectedPkDatas.length);
        for (int i = 0; i < selectedPkDatas.length; ++i) {
            pkList.add(Long.valueOf(selectedPkDatas[i]));
        }
        Object[] resultObjArr = BusinessDataServiceHelper.load((Object[])pkList.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cas_autocalresult"));
        if (!EmptyUtil.isEmpty((Object[])resultObjArr) && resultObjArr.length > 0) {
            ArrayList<AutoMatchInfoParam> tAutoMatchInfoList = new ArrayList<AutoMatchInfoParam>(resultObjArr.length);
            HashSet<Long> autoRecOrPayBizBillSet = new HashSet<Long>(resultObjArr.length);
            HashMap<Long, String> detailRuleNameMap = new HashMap<Long, String>(resultObjArr.length);
            ArrayList<Long> detailIds = new ArrayList<Long>(resultObjArr.length);
            String sourceEntityKey = "bei_intelrec";
            String billFlag = "cas_recbill";
            block5: for (Object resultObj : resultObjArr) {
                Long ruleEntryId = resultObj.getLong("ruleentry");
                DynamicObject smartmatchDO = resultObj.getDynamicObject("smartmatch");
                String direction = smartmatchDO.getString("direction");
                sourceEntityKey = direction.equals("rec") ? "bei_intelrec" : "bei_intelpay";
                DynamicObjectCollection smartMatchEntrys = smartmatchDO.getDynamicObjectCollection("entryentity");
                String matchRel = MatchRelEnum.ONE_TO_ONE.getValue();
                for (DynamicObject smartEntry : smartMatchEntrys) {
                    if (smartEntry.getLong("id") != ruleEntryId.longValue()) continue;
                    matchRel = smartEntry.getString("e_matchrel");
                }
                resultObj.set("matchstatus", (Object)ResultSaveAutoMatchStatus.AlMATCH.getValue());
                DynamicObjectCollection entryentity = resultObj.getDynamicObjectCollection("entryentity");
                MatchRelEnum matchRelEnum = MatchRelEnum.getByValue((String)matchRel);
                switch (matchRelEnum) {
                    case ONE_TO_ONE: 
                    case ONE_TO_MANY: {
                        DynamicObject detailEntry = (DynamicObject)entryentity.get(0);
                        Long detailId = detailEntry.getLong("billid");
                        detailIds.add(detailId);
                        detailRuleNameMap.put(detailId, resultObj.getString("rulename"));
                        for (int i = 1; i < entryentity.size(); ++i) {
                            DynamicObject bizEntry = (DynamicObject)entryentity.get(i);
                            AutoMatchBillTypeEnum billTypeEnum = AutoMatchBillTypeEnum.getByValue((String)bizEntry.getString("record"));
                            billFlag = billTypeEnum.getBillEntity();
                            String traceType = billTypeEnum == AutoMatchBillTypeEnum.EXCHANGEBILL ? ("rec".equals(direction) ? "buy" : "sell") : "";
                            Long bizBillid = bizEntry.getLong("billid");
                            if (smartmatchDO.getBoolean("autoconfirm")) {
                                autoRecOrPayBizBillSet.add(bizBillid);
                            }
                            BigDecimal amt = EmptyUtil.isEmpty((BigDecimal)bizEntry.getBigDecimal("payamount")) ? bizEntry.getBigDecimal("amount") : bizEntry.getBigDecimal("payamount");
                            tAutoMatchInfoList.add(new AutoMatchInfoParam(sourceEntityKey, detailEntry.getString("num"), Long.valueOf(detailEntry.getLong("billid")), billFlag, bizEntry.getString("num"), Long.valueOf(bizEntry.getLong("billid")), Long.valueOf(bizEntry.getLong("billentryid")), Long.valueOf(resultObj.getLong("currency.id")), traceType, amt, null, null, resultObj.getString("number"), direction, resultObj.getString("rulename"), MatchRelEnum.ONE_TO_MANY.getValue()));
                        }
                        continue block5;
                    }
                    case MANY_TO_ONE: {
                        Long detailId;
                        DynamicObject detailEntry;
                        DynamicObject bizEntry = entryentity.stream().filter(o -> !"0".equals(o.getString("record"))).findFirst().get();
                        AutoMatchBillTypeEnum billTypeEnum = AutoMatchBillTypeEnum.getByValue((String)bizEntry.getString("record"));
                        billFlag = billTypeEnum.getBillEntity();
                        String traceType = billTypeEnum == AutoMatchBillTypeEnum.EXCHANGEBILL ? ("rec".equals(direction) ? "buy" : "sell") : "";
                        Long bizBillid = bizEntry.getLong("billid");
                        if (smartmatchDO.getBoolean("autoconfirm")) {
                            autoRecOrPayBizBillSet.add(bizBillid);
                        }
                        for (int i = 0; i < entryentity.size(); ++i) {
                            detailEntry = (DynamicObject)entryentity.get(i);
                            detailId = detailEntry.getLong("billid");
                            detailIds.add(detailId);
                            detailRuleNameMap.put(detailId, resultObj.getString("rulename"));
                            String record = detailEntry.getString("record");
                            String amountProp = "rec".equals(direction) ? "amount" : "payamount";
                            if (!"0".equals(record)) continue;
                            tAutoMatchInfoList.add(new AutoMatchInfoParam(sourceEntityKey, detailEntry.getString("num"), Long.valueOf(detailEntry.getLong("billid")), billFlag, bizEntry.getString("num"), Long.valueOf(bizEntry.getLong("billid")), Long.valueOf(bizEntry.getLong("billentryid")), Long.valueOf(resultObj.getLong("currency.id")), traceType, detailEntry.getBigDecimal(amountProp), null, null, resultObj.getString("number"), direction, resultObj.getString("rulename"), MatchRelEnum.MANY_TO_ONE.getValue()));
                        }
                        continue block5;
                    }
                }
            }
            DynamicObjectCollection transactionDetails = QueryServiceHelper.query((String)"bei_transdetail_cas", (String)"id,currency,bankcheckflag,bizdate", (QFilter[])new QFilter("id", "in", detailIds).toArray());
            Map<Long, DynamicObject> transactionDetailsMap = transactionDetails.stream().collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
            tAutoMatchInfoList.forEach(item -> {
                DynamicObject tradeObj = (DynamicObject)transactionDetailsMap.get(item.getTransDetailId());
                item.setCurrency(Long.valueOf(tradeObj.getLong("currency")));
                item.setBankCheckFlag(tradeObj.getString("bankcheckflag"));
                item.setBizDate(tradeObj.getDate("bizdate"));
            });
            DispatchServiceHelper.invokeBizService((String)"tmc", (String)"bei", (String)"AutoMatchHelperService", (String)"excute", (Object[])new Object[]{tAutoMatchInfoList, ReceredWayEnum.AUTOMATCH.getValue(), detailRuleNameMap, true, autoRecOrPayBizBillSet});
            SaveServiceHelper.save((DynamicObject[])resultObjArr);
            CasFlowConfirmLogHelper.saveMatchLog(tAutoMatchInfoList, (String)ReceredWayEnum.AUTOMATCH.getValue());
        }
    }
}

