/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin.voucher;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.fi.cas.business.journal.IBookJournalBuilder;
import kd.fi.cas.business.journal.JournalServiceAdapter;
import kd.fi.cas.business.journal.VoucherBookJournalBuilder;
import kd.fi.cas.helper.CasHelper;

public class VoucherBookOp
extends AbstractOperationServicePlugIn {
    private JournalServiceAdapter journalServiceAdapter = new JournalServiceAdapter();
    private DynamicObject[] vouchers = null;

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("sourcebillid");
        fieldKeys.add("businesstype");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public void validate() {
                for (ExtendedDataEntity dataEntite : this.dataEntities) {
                    DynamicObject data = dataEntite.getDataEntity();
                    String businessType = data.getString("businesstype");
                    VoucherBookOp.access$002(VoucherBookOp.this, BusinessDataServiceHelper.load((Object[])new Object[]{data.getLong("sourcebillid")}, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"gl_voucher")));
                    if (CasHelper.isEmpty((DynamicObject[])VoucherBookOp.this.vouchers)) continue;
                    Arrays.asList(VoucherBookOp.this.vouchers).stream().forEach(v -> {
                        if ("BOOK".equals(businessType)) {
                            VoucherBookOp.this.journalServiceAdapter.validateBook((IBookJournalBuilder)new VoucherBookJournalBuilder(), v);
                        } else {
                            this.addErrorMessage(dataEntite, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u767b\u8d26\u4e1a\u52a1\u7c7b\u578b\u7684\u6570\u636e\u3002", (String)"VoucherBookOp_1", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                        }
                    });
                }
            }
        });
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] datas = e.getDataEntities();
        ArrayList<Long> dataPks = new ArrayList<Long>(datas.length);
        for (DynamicObject data : datas) {
            dataPks.add(data.getLong("id"));
        }
        if (!CasHelper.isEmpty((DynamicObject[])this.vouchers)) {
            Arrays.asList(this.vouchers).stream().forEach(v -> this.journalServiceAdapter.book(v));
        }
        if (dataPks.size() > 0) {
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"cas_voucherbook"), (Object[])dataPks.toArray());
        }
    }

    static /* synthetic */ DynamicObject[] access$002(VoucherBookOp x0, DynamicObject[] x1) {
        x0.vouchers = x1;
        return x1;
    }
}

