/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator;

import java.util.HashSet;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class AccountCashSaveValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject dynamicObject = dataEntity.getDataEntity();
            long id = dynamicObject.getLong("id");
            Long orgId = (Long)dynamicObject.getDynamicObject("org").getPkValue();
            String orgname = dynamicObject.getString("org.name");
            DynamicObjectCollection currencyCol = dynamicObject.getDynamicObjectCollection("currency");
            Long defaultCurrencyId = (Long)dynamicObject.getDynamicObject("defaultcurrency").getPkValue();
            HashSet<Long> currencyIDs = new HashSet<Long>();
            for (DynamicObject prop : currencyCol) {
                currencyIDs.add((Long)((DataEntityBase)prop.get("fbasedataid")).getPkValue());
            }
            if (!currencyIDs.contains(defaultCurrencyId)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201c\u9ed8\u8ba4\u5e01\u79cd\u201d\u4e0d\u5728\u5e01\u79cd\u8303\u56f4\u5185\u3002", (String)"AccountCashSaveValidator_4", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            }
            boolean isdefaultpayee = dynamicObject.getBoolean("isdefaultpayee");
            String name = this.getExistAccount(orgId, "isdefaultpayee", id);
            if (isdefaultpayee && this.isExistAccount(name)) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u8bbe\u7f6e\u591a\u4e2a\u9ed8\u8ba4\u6536\u6b3e\u6237\uff0c\u5f53\u524d\u8d44\u91d1\u7ec4\u7ec7\u201c%1$s\u201d\u7684\u73b0\u91d1\u8d26\u6237\u201c%2$s\u201d\u5df2\u8bbe\u7f6e\u4e3a\u9ed8\u8ba4\u6536\u6b3e\u6237\u3002", (String)"AccountCashSaveValidator_0", (String)"fi-cas-opplugin", (Object[])new Object[0]), orgname, name));
            }
            boolean isdefaultpayer = dynamicObject.getBoolean("isdefaultpayer");
            name = this.getExistAccount(orgId, "isdefaultpayer", id);
            if (!isdefaultpayer || !this.isExistAccount(name)) continue;
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u8bbe\u7f6e\u591a\u4e2a\u9ed8\u8ba4\u4ed8\u6b3e\u6237\uff0c\u5f53\u524d\u8d44\u91d1\u7ec4\u7ec7\u201c%1$s\u201d\u7684\u73b0\u91d1\u8d26\u6237\u201c%2$s\u201d\u5df2\u8bbe\u7f6e\u4e3a\u9ed8\u8ba4\u4ed8\u6b3e\u6237\u3002", (String)"AccountCashSaveValidator_1", (String)"fi-cas-opplugin", (Object[])new Object[0]), orgname, name));
        }
    }

    private boolean isExistAccount(String name) {
        return name != null;
    }

    private String getExistAccount(Long orgId, String propertie, long id) {
        QFilter qFilter = new QFilter("org", "=", (Object)orgId);
        qFilter.and(new QFilter("id", "<>", (Object)id));
        qFilter.and(new QFilter(propertie, "=", (Object)"1"));
        DynamicObject accountcash = BusinessDataServiceHelper.loadSingle((String)"cas_accountcash", (String)("number,name," + propertie), (QFilter[])new QFilter[]{qFilter});
        String anyMatch = null;
        if (null != accountcash) {
            anyMatch = accountcash.getString("name");
        }
        return anyMatch;
    }
}

