/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.fi.cas.helper.SystemStatusCtrolHelper;
import kd.fi.cas.util.AccountBalanceUtils;

public class AcctCashCloseValidator
extends AbstractValidator {
    public void validate() {
        int i = 0;
        for (ExtendedDataEntity acctCashObject : this.dataEntities) {
            DynamicObject acctCash = acctCashObject.getDataEntity();
            if (acctCash.getInt("closestatus") == 1) {
                String msg = ResManager.loadKDString((String)"\u73b0\u91d1\u8d26\u6237\u5df2\u5904\u4e8e\u9500\u6237\u72b6\u6001\uff0c\u65e0\u9700\u518d\u6b21\u9500\u6237\u3002", (String)"AcctCashCloseValidator_0", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                this.addMessage(this.dataEntities[i], msg, ErrorLevel.Error);
                ++i;
                continue;
            }
            long orgId = acctCash.getDynamicObject("org").getLong("id");
            if (!SystemStatusCtrolHelper.isFinishInit((long)orgId)) {
                String msgInit = ResManager.loadKDString((String)"\u5f00\u6237\u7ec4\u7ec7\u672a\u7ed3\u675f\u51fa\u7eb3\u6216\u8d44\u91d1\u7ed3\u7b97\u521d\u59cb\u5316\uff0c\u4e0d\u5141\u8bb8\u9500\u6237\u3002", (String)"AcctCashCloseValidator_1", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                this.addMessage(this.dataEntities[i], msgInit, ErrorLevel.Error);
                ++i;
                continue;
            }
            DynamicObject period = SystemStatusCtrolHelper.getCurrentPeriod((long)orgId);
            if (period == null) {
                ++i;
                continue;
            }
            Boolean isZero = AccountBalanceUtils.accountBalance((long)orgId, (long)((Long)period.getPkValue()), (long)((Long)acctCash.getPkValue()), (String)"cas_accountcash");
            if (!isZero.booleanValue()) {
                String msg = ResManager.loadKDString((String)"\u73b0\u91d1\u8d26\u6237\u4f59\u989d\u4e0d\u4e3a0\uff0c\u65e0\u6cd5\u9500\u6237\u3002", (String)"AcctCashCloseValidator_2", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                this.addMessage(this.dataEntities[i], msg, ErrorLevel.Error);
            }
            ++i;
        }
    }
}

