/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator;

import java.math.BigDecimal;
import java.util.HashSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.business.helper.VisibleVirtualAcctHelper;
import kd.fi.cas.helper.BaseDataHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.util.EmptyUtil;

public class AgentBillVirtualValidator
extends AbstractValidator {
    public void validate() {
        HashSet<Long> virtualIds = new HashSet<Long>(this.dataEntities.length);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryVirtual", (String)"bd_accountbanks", (String)"id", (QFilter[])new QFilter[]{VisibleVirtualAcctHelper.virtualAcctQf()}, null);){
            while (ds.hasNext()) {
                Row r = ds.next();
                virtualIds.add(r.getLong("id"));
            }
        }
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject agentBIll = dataEntity.getDataEntity();
            DynamicObject org = agentBIll.getDynamicObject("org");
            if (CasHelper.isEmpty((Object)org)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u4ed8\u6b3e\u4eba\u3002", (String)"ReceivingBillSaveValidator_8", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            }
            BigDecimal sumAmt = agentBIll.getBigDecimal("payamount");
            if (BigDecimal.valueOf(Math.pow(10.0, 13.0)).compareTo(sumAmt) <= 0) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u91d1\u989d\u8d85\u8fc7\u6700\u5927\u503c\u3002", (String)"MainTransferValidator_1", (String)"fi-cas-opplugin", (Object[])new Object[0]), new Object[0]));
            }
            BigDecimal localAmt = agentBIll.getBigDecimal("localamt");
            if (BigDecimal.valueOf(Math.pow(10.0, 13.0)).compareTo(localAmt) <= 0) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u91d1\u989d\u6298\u672c\u4f4d\u5e01\u8d85\u8fc7\u6700\u5927\u503c\u3002", (String)"MainTransferValidator_5", (String)"fi-cas-opplugin", (Object[])new Object[0]), new Object[0]));
            }
            DynamicObject settletype = agentBIll.getDynamicObject("settletype");
            DynamicObject accountbank = agentBIll.getDynamicObject("payeracctbank");
            if (accountbank == null || !BaseDataHelper.isSettleTypeVirtual((DynamicObject)settletype) || !EmptyUtil.isEmpty(virtualIds) && virtualIds.contains(accountbank.getLong("id"))) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u865a\u62df\u7ed3\u7b97\u65b9\u5f0f\u53ea\u80fd\u9009\u62e9\u865a\u62df\u94f6\u884c\u8d26\u6237\u3002", (String)"AgentBillVirtualValidator_1", (String)"fi-cas-opplugin", (Object[])new Object[0]));
        }
    }
}

