/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.param.AppParam;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.fi.cas.business.errorcode.AgentPayErrorCode;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.enums.PayBusinessTypeEnum;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.AgentPayBillHelper;
import kd.fi.cas.helper.BaseDataHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.helper.SystemStatusCtrolHelper;
import kd.fi.cas.util.CheckUtils;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.validator.PaymentBeiValidator;
import org.apache.commons.lang3.StringUtils;

public class AgentPayBillCommitBEValidator
extends AbstractValidator {
    private static Log logger = LogFactory.getLog(PaymentBeiValidator.class);

    public Set<String> preparePropertys() {
        Set selectors = super.preparePropertys();
        selectors.add("billstatus");
        selectors.add("payamount");
        selectors.add("org");
        selectors.add("payeracctbank");
        selectors.add("settletype");
        selectors.add("paymentchannel");
        selectors.add("entry");
        selectors.add("iscrosspay");
        selectors.add("isencryption");
        selectors.add("delegorg");
        selectors.add("payeebanknumber");
        selectors.add("recprovince");
        selectors.add("reccity");
        selectors.add("e_remark");
        selectors.add("e_encryptamount");
        selectors.add("e_amount");
        selectors.add("businesstype");
        return selectors;
    }

    public void validate() {
        AgentPayErrorCode agentPayErrorCode = new AgentPayErrorCode();
        Map variables = this.getOption().getVariables();
        String provincevalidate = (String)variables.get("provincevalidate");
        Boolean provinceBool = true;
        if (EmptyUtil.isNoEmpty((String)provincevalidate) && "true".equals(provincevalidate)) {
            provinceBool = false;
        }
        HashMap<Long, Map> org_param = new HashMap<Long, Map>(this.dataEntities.length);
        for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
            DynamicObject payOrg;
            String checkMsg;
            DynamicObject info = dataEntity.getDataEntity();
            if (!SystemStatusCtrolHelper.isInitEnable((long)info.getDynamicObject("org").getLong("id"))) {
                throw new KDBizException(SystemStatusCtrolHelper.getNotInitMsg((String)CasHelper.getLocalValue((DynamicObject)info.getDynamicObject("org"), (String)"name")));
            }
            String billStatus = info.getString("billstatus");
            if (!billStatus.equals(BillStatusEnum.AUDIT.getValue())) {
                throw new KDBizException(agentPayErrorCode.STATUS_CANNOT_COMMITBE(), new Object[0]);
            }
            if (AgentPayBillHelper.isDelegAgent((DynamicObject)info)) {
                throw new KDBizException(agentPayErrorCode.DELEG_AGENTPAY(), new Object[0]);
            }
            if (info.getBigDecimal("payamount").compareTo(BigDecimal.ZERO) < 0) {
                throw new KDBizException(agentPayErrorCode.AMOUNT_MUST_MORETHANZERO(), new Object[0]);
            }
            DynamicObject payerAcctBank = info.getDynamicObject("payeracctbank");
            DynamicObject settleType = info.getDynamicObject("settletype");
            String msg = AccountBankHelper.commitBeiValidate((Long)payerAcctBank.getLong("id"));
            if (StringUtils.isNotBlank((CharSequence)msg)) {
                this.addMessage(dataEntity, msg);
                continue;
            }
            if (CasHelper.isEmpty((Object)settleType)) {
                throw new KDBizException(agentPayErrorCode.EMPTYSETTLETYEP_CANNOT_COMMITBE(), new Object[0]);
            }
            if (!"bei".equalsIgnoreCase(info.getString("paymentchannel"))) {
                throw new KDBizException(agentPayErrorCode.SETTLETYEP_MUSTSUPPORT_PAYTHROUGHBE(), new Object[0]);
            }
            if (null != payerAcctBank && AccountBankHelper.isClosed((long)payerAcctBank.getLong("id"))) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8d26\u6237%s\u5f53\u524d\u72b6\u6001\u4e3a\u5df2\u9500\u6237\uff0c\u6682\u65e0\u6cd5\u8fdb\u884c\u4e1a\u52a1\u5904\u7406\u3002", (String)"PaymentErrorCode_47", (String)"fi-cas-business", (Object[])new Object[0]), payerAcctBank.getString("number")));
            }
            Boolean isCrossPay = info.getBoolean("iscrosspay");
            DynamicObjectCollection entry = info.getDynamicObjectCollection("entry");
            String appIdName = EntityMetadataCache.getDataEntityType((String)this.entityKey).getAppId();
            String appId = AppMetadataCache.getAppInfo((String)appIdName).getId();
            String businessType = info.getString("businesstype");
            boolean isDcep = BaseDataHelper.isSettleTypeDcep((DynamicObject)settleType);
            boolean isCheckDcep = !isDcep || PayBusinessTypeEnum.WALLETESSAY.getValue().equals(businessType);
            DynamicObject company = info.getDynamicObject("org");
            long orgId = company.getLong("id");
            Map params = (Map)org_param.get(orgId);
            if (params == null) {
                params = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)new AppParam(null, appId, "08", Long.valueOf(orgId), Long.valueOf(0L), Long.valueOf(0L)));
                org_param.put(orgId, params);
            }
            boolean isNotCheckBeBankNumb = (Boolean)params.get("cs125");
            for (int i = 0; i < entry.size(); ++i) {
                String remark;
                DynamicObject row = (DynamicObject)entry.get(i);
                String bankNum = row.getString("payeebanknumber");
                if (!(isCrossPay.booleanValue() || bankNum != null && !bankNum.trim().isEmpty() || isNotCheckBeBankNumb)) {
                    throw new KDBizException(agentPayErrorCode.EMPTYBANKNUM_CANNOT_COMMITBE(), new Object[]{i + 1});
                }
                if (!isCrossPay.booleanValue() && provinceBool.booleanValue()) {
                    String province = row.getString("recprovince");
                    if (isCheckDcep && (province == null || province.trim().isEmpty())) {
                        throw new KDBizException(agentPayErrorCode.EMPTYPROVINCE_CANNOT_COMMITBE(), new Object[]{i + 1});
                    }
                    String city = row.getString("reccity");
                    if (isCheckDcep && (city == null || city.trim().isEmpty())) {
                        throw new KDBizException(agentPayErrorCode.EMPTYCITY_CANNOT_COMMITBE(), new Object[]{i + 1});
                    }
                }
                if ((remark = row.getString("e_remark")) != null && !remark.trim().isEmpty()) continue;
                throw new KDBizException(agentPayErrorCode.EMPTYREMARK_CANNOT_COMMITBE(), new Object[]{i + 1});
            }
            boolean tm018 = SystemParameterHelper.isBizBillCommitBe((Map)params);
            if (tm018 && payerAcctBank != null && !EmptyUtil.isEmpty((String)(checkMsg = AccountBankHelper.checkAccount((DynamicObject)(payOrg = info.getDynamicObject("org")), (DynamicObject)payerAcctBank)))) {
                throw new KDBizException(checkMsg);
            }
            if (info.getBoolean("isencryption")) {
                CheckUtils.checkAmtEqualEAmt((DynamicObject)info, (String)"payamount", (String)"e_encryptamount");
                continue;
            }
            CheckUtils.checkAmtEqualEAmt((DynamicObject)info, (String)"payamount", (String)"e_amount");
        }
    }
}

