/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.fi.cas.business.errorcode.AgentPayErrorCode;
import kd.fi.cas.business.errorcode.PaymentErrorCode;
import kd.fi.cas.enums.PayBusinessTypeEnum;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.BaseDataHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.CountryHelper;
import kd.fi.cas.helper.ExtendConfigHelper;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.helper.SystemStatusCtrolHelper;
import kd.fi.cas.util.EmptyUtil;

public class AgentPayBillSubmitValidator
extends AbstractValidator {
    public void validate() {
        Set orgIdList = Arrays.stream(this.dataEntities).map(c -> c.getDataEntity().getDynamicObject("org").getLong("id")).collect(Collectors.toSet());
        Map params = SystemParameterHelper.getBatchTm018(new ArrayList(orgIdList));
        HashMap checkMap = new HashMap(16);
        Map orgParamMap = new HashMap();
        Map casInitMap = new HashMap();
        if (EmptyUtil.isNoEmpty(orgIdList)) {
            orgParamMap = SystemParameterHelper.getSystemParamsByOrgIds(new ArrayList(orgIdList), (String)"cs103");
            casInitMap = SystemStatusCtrolHelper.getCurrentPeriod(orgIdList);
        }
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            String paymentChannel;
            DynamicObject org;
            DynamicObject accountBank;
            boolean tm018;
            DynamicObject info = dataEntity.getDataEntity();
            AgentPayErrorCode agentPayErrorCode = new AgentPayErrorCode();
            Long orgId = info.getDynamicObject("org").getLong("id");
            boolean bl = tm018 = (Integer)params.get(String.valueOf(orgId)) == 0;
            if (tm018 && null != (accountBank = info.getDynamicObject("payeracctbank"))) {
                Set<Long> accountBankIdList;
                if (checkMap.get(orgId) == null) {
                    accountBankIdList = new HashSet<Long>();
                    accountBankIdList.add(accountBank.getLong("id"));
                    checkMap.put(orgId, accountBankIdList);
                } else {
                    accountBankIdList = (Set)checkMap.get(orgId);
                    accountBankIdList.add(accountBank.getLong("id"));
                    checkMap.put(orgId, accountBankIdList);
                }
            }
            DynamicObject settleType = info.getDynamicObject("settletype");
            Object delegOrg = info.get("delegorg");
            if (CasHelper.isEmpty((Object)settleType) && CasHelper.isEmpty((Object)delegOrg)) {
                this.addErrorMessage(dataEntity, String.format(new PaymentErrorCode().BILL_CANNOT_NULL().getMessage(), ResManager.loadKDString((String)"\u7ed3\u7b97\u65b9\u5f0f", (String)"PaymentSubmitImpl_8", (String)"fi-cas-business", (Object[])new Object[0])));
            }
            if (EmptyUtil.isNoEmpty((DynamicObject)(org = info.getDynamicObject("org"))) && EmptyUtil.isNoEmpty((Long)orgId)) {
                Date beginDate;
                DynamicObject currentperiod;
                Date bizDate = info.getDate("bizDate");
                Object orgParam = orgParamMap.get(String.valueOf(orgId));
                DynamicObject casInit = (DynamicObject)casInitMap.get(orgId);
                DynamicObject dynamicObject = EmptyUtil.isEmpty((DynamicObject)casInit) ? null : (currentperiod = EmptyUtil.isEmpty((DynamicObject)casInit.getDynamicObject("currentperiod")) ? null : casInit.getDynamicObject("currentperiod"));
                if (currentperiod == null && !EmptyUtil.isEmpty((DynamicObject)casInit) && ExtendConfigHelper.isInitOnlySet()) {
                    currentperiod = casInit.getDynamicObject("startperiod");
                }
                Date date = beginDate = currentperiod == null ? null : currentperiod.getDate("beginDate");
                if (EmptyUtil.isNoEmpty(orgParam) && !((Boolean)orgParam).booleanValue() && EmptyUtil.isNoEmpty((Object)bizDate) && EmptyUtil.isNoEmpty((Object)beginDate) && bizDate.before(beginDate)) {
                    KDBizException e = new KDBizException(agentPayErrorCode.BIZDATE_BEFORE_CURRENTPERIOD(), new Object[0]);
                    this.exceptionProcess(dataEntity, (Exception)((Object)e), ErrorLevel.Error);
                    continue;
                }
            }
            if (!"bei".equalsIgnoreCase(paymentChannel = info.getString("paymentchannel"))) continue;
            String businessType = info.getString("businesstype");
            boolean isDcep = BaseDataHelper.isSettleTypeDcep((DynamicObject)settleType);
            boolean isCheckDcep = !isDcep || PayBusinessTypeEnum.WALLETESSAY.getValue().equals(businessType);
            boolean isCrossPay = info.getBoolean("iscrosspay");
            DynamicObjectCollection entryDoc = info.getDynamicObjectCollection("entry");
            if (!isCheckDcep || entryDoc == null || entryDoc.size() <= 0) continue;
            for (DynamicObject entryDo : entryDoc) {
                String beBankNumber = entryDo.getString("payeebanknumber");
                if (EmptyUtil.isEmpty((String)beBankNumber)) continue;
                DynamicObject country = entryDo.getDynamicObject("reccountry");
                boolean isChinaMainland = CountryHelper.isChina((DynamicObject)country);
                String provinceTxt = entryDo.getString("recprovince");
                String cityTxt = entryDo.getString("reccity");
                if (isChinaMainland && !isCrossPay) {
                    if (!EmptyUtil.isEmpty((String)provinceTxt) && !EmptyUtil.isEmpty((String)cityTxt)) continue;
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u6536\u6b3e\u884c\u884c\u53f7\u3010%1$s\u3011\u7684\u7701\u4efd\uff08\u94f6\u4f01\uff09\u3001\u57ce\u5e02\uff08\u94f6\u4f01\uff09\u4fe1\u606f\u4e0d\u5b8c\u5584\uff0c\u8bf7\u5230\u3010\u884c\u540d\u884c\u53f7\u3011\u53ca\u65f6\u7ef4\u62a4\u3002", (String)"AgentPayBillSubmint_Err00", (String)"fi-cas-opplugin", (Object[])new Object[0]), beBankNumber));
                    continue;
                }
                if (!EmptyUtil.isEmpty((String)cityTxt) || isCrossPay) continue;
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u6536\u6b3e\u884c\u884c\u53f7\u3010%1$s\u3011\u7684\u57ce\u5e02\uff08\u94f6\u4f01\uff09\u4fe1\u606f\u4e0d\u5b8c\u5584\uff0c\u8bf7\u5230\u3010\u884c\u540d\u884c\u53f7\u3011\u53ca\u65f6\u7ef4\u62a4\u3002", (String)"AgentPayBillSubmint_Err01", (String)"fi-cas-opplugin", (Object[])new Object[0]), beBankNumber));
            }
        }
        String checkMsg = AccountBankHelper.batchCanUseAccount(checkMap);
        if (EmptyUtil.isNoEmpty((String)checkMsg)) {
            throw new KDBizException(checkMsg);
        }
    }

    protected void exceptionProcess(ExtendedDataEntity dataEntity, Exception e, ErrorLevel error) {
        this.addMessage(dataEntity, e.getMessage(), error);
        this.getValidateResult().setSuccess(false);
    }
}

