/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator;

import java.math.BigDecimal;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.login.utils.StringUtils;
import kd.fi.cas.business.opservice.factory.AgentPayBillFactory;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.errorcode.EBErrorCode;
import kd.fi.cas.helper.AgentPayBillHelper;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.util.EmptyUtil;

public class AgentPayChargeBackValidator
extends AbstractValidator {
    public void validate() throws KDBizException {
        EBErrorCode ebErrorCode = new EBErrorCode();
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            boolean matched;
            boolean isrepay;
            String billStatus;
            DynamicObject info = dataEntity.getDataEntity();
            long orgId = (Long)info.getDynamicObject("org").getPkValue();
            Set cs108 = SystemParameterHelper.getParameterComboxs((long)orgId, (String)"cs108");
            if (!cs108.contains(billStatus = info.getString("billstatus"))) {
                this.addErrorMessage(dataEntity, ebErrorCode.BACK_STATUS_ERROR().getMessage());
                continue;
            }
            if (BillStatusEnum.SUBMIT.getValue().equals(billStatus)) {
                AgentPayBillFactory.getUnSubmitService().validate(info);
            } else if (BillStatusEnum.AUDIT.getValue().equals(billStatus)) {
                AgentPayBillFactory.getUnAuditService().validate(info);
            }
            String sourcebilltype = info.getString("sourcebilltype");
            if (StringUtils.isEmpty((String)sourcebilltype)) {
                this.addErrorMessage(dataEntity, ebErrorCode.AGENBACK_NO_LINK().getMessage());
            }
            if (EmptyUtil.isNoEmpty((Object)info.get("delegorg")) && info.getBigDecimal("entrustamt").compareTo(BigDecimal.ZERO) != 0) {
                String entrustMsg = ResManager.loadKDString((String)"\u5355\u636e[%s]\u5df2\u751f\u6210\u59d4\u6258\u4ee3\u53d1\u5355\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u9000\u5355\uff0c\u8bf7\u53d6\u6d88\u59d4\u6258\u6216\u5c06\u59d4\u6258\u4ee3\u53d1\u5355\u9000\u5355\u540e\u518d\u64cd\u4f5c\u3002", (String)"PaymentChargeBackValidator_2", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(dataEntity, String.format(entrustMsg, info.getString("billno")));
            }
            if ((isrepay = info.getBoolean("isrepay")) && !"CmpAgentPayBill".equals(sourcebilltype) && !"er_dailyreimbursebill".equals(sourcebilltype) && !"hsas_agencypaybill".equals(sourcebilltype)) {
                this.addErrorMessage(dataEntity, ebErrorCode.AGENCY_ISREPAY_NOBACK().getMessage());
            }
            if (!(matched = AgentPayBillHelper.isMatched((DynamicObject)info))) continue;
            this.addErrorMessage(dataEntity, ebErrorCode.AGENCY_MATCHED_NOBACK().getMessage());
        }
    }
}

