/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator;

import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.helper.AgentPayBillHelper;

public class AgentPayUnAuditValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            Map targetBills;
            DynamicObject info = dataEntity.getDataEntity();
            String status = info.getString("billstatus");
            if (!BillStatusEnum.AUDIT.getValue().equals(status)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53ea\u6709\u5df2\u5ba1\u6838\u72b6\u6001\u7684\u5355\u636e\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"AgentPayErrorCode_3", (String)"fi-cas-business", (Object[])new Object[0]));
            }
            if (!AgentPayBillHelper.isDelegAgent((DynamicObject)info) || (targetBills = BFTrackerServiceHelper.findTargetBills((String)"cas_agentpaybill", (Long[])new Long[]{(Long)info.getPkValue()})) == null || this.canUnAudit(targetBills)) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u4e0b\u63a8\u59d4\u6258\u4ee3\u53d1\u5355\uff0c\u8bf7\u53d6\u6d88\u59d4\u6258\u540e\u518d\u8fdb\u884c\u53cd\u5ba1\u6838\u3002", (String)"AgentPayUnAuditValidator_1", (String)"fi-cas-business", (Object[])new Object[0]));
        }
    }

    private boolean canUnAudit(Map<String, HashSet<Long>> targetBills) {
        for (Map.Entry<String, HashSet<Long>> entry : targetBills.entrySet()) {
            QFilter filter;
            boolean exists;
            String targetKey = entry.getKey();
            HashSet<Long> targetPks = entry.getValue();
            if (!"cas_agentpaybill".equals(targetKey) || !(exists = QueryServiceHelper.exists((String)targetKey, (QFilter[])(filter = new QFilter("id", "in", (Object)targetPks.toArray()).and("billstatus", "!=", (Object)BillStatusEnum.CHARGEBANK.getValue())).toArray()))) continue;
            return false;
        }
        return true;
    }
}

