/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.cas.business.writeback.AgentWriteBackConsumer;
import kd.fi.cas.business.writeback.WriteBackValidateHelper;
import kd.fi.cas.business.writeback.consts.WriteBackOperateEnum;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.AgentPayBillHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.SystemStatusCtrolHelper;

public class AgentPayValidator
extends AbstractValidator {
    protected static final Log log = LogFactory.getLog(AgentPayValidator.class);
    private static final String KEY_ACCOUNTBANK = "accountbank";
    private static final String KEY_PAYER = "payer";

    public void validate() {
        Map<String, Set<Long>> needQueryDatas = this.getNeedQueryDatas(this.dataEntities);
        Map<Long, Boolean> isClosedBatch = this.getisClosed(needQueryDatas.get(KEY_ACCOUNTBANK));
        Map isEnableBatch = SystemStatusCtrolHelper.isInitEnable(needQueryDatas.get(KEY_PAYER));
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            String message;
            Boolean isEnable;
            DynamicObject info = dataEntity.getDataEntity();
            if (!BillStatusEnum.AUDIT.getValue().equals(info.getString("billstatus"))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53ea\u6709\u5df2\u5ba1\u6838\u72b6\u6001\u7684\u5355\u636e\u5141\u8bb8\u4ed8\u6b3e\u3002", (String)"AgentPayErrorCode_6", (String)"fi-cas-business", (Object[])new Object[0]));
                continue;
            }
            if ("bei".equals(info.getString("paymentchannel"))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u652f\u4ed8\u6e20\u9053\u4e3a\u94f6\u4f01\u4e92\u8054\uff0c\u8bf7\u63d0\u4ea4\u94f6\u4f01\u8fdb\u884c\u4ed8\u6b3e\u3002", (String)"PaymentErrorCode_53", (String)"fi-cas-business", (Object[])new Object[0]));
            }
            if ((isEnable = (Boolean)isEnableBatch.get(info.getDynamicObject("org").getLong("id"))) != null && !isEnable.booleanValue()) {
                this.addErrorMessage(dataEntity, SystemStatusCtrolHelper.getNotInitMsg((String)CasHelper.getLocalValue((DynamicObject)info.getDynamicObject("org"), (String)"name")));
                continue;
            }
            if (AgentPayBillHelper.isDelegAgent((DynamicObject)info)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u59d4\u6258\u5176\u4ed6\u7ec4\u7ec7\u4ed8\u6b3e\uff0c\u7531\u53d7\u7406\u65b9\u5b8c\u6210\u4ed8\u6b3e\u3002", (String)"AgentPayErrorCode_31", (String)"fi-cas-business", (Object[])new Object[0]));
                continue;
            }
            DynamicObject accountBank = info.getDynamicObject("payeracctbank");
            Boolean isClosed = null;
            if (null != accountBank) {
                Boolean bl = isClosed = isClosedBatch == null ? Boolean.valueOf(false) : isClosedBatch.get(accountBank.getLong("id"));
            }
            if (null != accountBank && isClosed != null && isClosed.booleanValue()) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8d26\u6237%s\u5f53\u524d\u72b6\u6001\u4e3a\u5df2\u9500\u6237\uff0c\u6682\u65e0\u6cd5\u8fdb\u884c\u4e1a\u52a1\u5904\u7406\u3002", (String)"PaymentErrorCode_47", (String)"fi-cas-business", (Object[])new Object[0]), accountBank.getString("number")));
                continue;
            }
            if (info.getBoolean("isencryption")) {
                message = AgentPayValidator.checkAmtEqualEAmt(dataEntity, "payamount", "e_encryptamount");
                if (null != message) {
                    this.addErrorMessage(dataEntity, message);
                    continue;
                }
            } else {
                message = AgentPayValidator.checkAmtEqualEAmt(dataEntity, "payamount", "e_amount");
                if (null != message) {
                    this.addErrorMessage(dataEntity, message);
                    continue;
                }
            }
            try {
                WriteBackValidateHelper.writeBackValidate((DynamicObject)info, (WriteBackOperateEnum)WriteBackOperateEnum.PAYVALIDATE, AgentWriteBackConsumer.class);
            }
            catch (Exception e) {
                this.addErrorMessage(dataEntity, e.getMessage());
            }
        }
    }

    public static String checkAmtEqualEAmt(ExtendedDataEntity dataEntity, String amount, String e_amount) {
        DynamicObject billObject = dataEntity.getDataEntity();
        BigDecimal e_amountSum = BigDecimal.ZERO;
        e_amountSum = "cas_agentpaybill".equals(billObject.getDataEntityType().getName()) && billObject.getBoolean("isencryption") ? billObject.getDynamicObjectCollection("entry").stream().map(v -> AgentPayBillHelper.decodeAmount((String)v.getString(e_amount))).reduce(BigDecimal.ZERO, BigDecimal::add) : billObject.getDynamicObjectCollection("entry").stream().map(v -> v.getBigDecimal(e_amount)).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (e_amountSum.compareTo(billObject.getBigDecimal(amount)) != 0) {
            return ResManager.loadKDString((String)"\u4ed8\u6b3e\u91d1\u989d\u4e0e\u660e\u7ec6\u5206\u5f55\u4e2d\u91d1\u989d\u4e4b\u548c\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u4fee\u6539\u540e\u518d\u63d0\u4ea4\u3002", (String)"CheckUtils_8", (String)"fi-cas-common", (Object[])new Object[0]);
        }
        return null;
    }

    private Map<String, Set<Long>> getNeedQueryDatas(ExtendedDataEntity[] dataEntities) {
        HashMap<String, Set<Long>> returns = new HashMap<String, Set<Long>>();
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject info = dataEntity.getDataEntity();
            Set orgs = returns.computeIfAbsent(KEY_PAYER, k -> new HashSet(dataEntities.length));
            orgs.add(info.getDynamicObject("org").getLong("id"));
            Set accounts = returns.computeIfAbsent(KEY_ACCOUNTBANK, k -> new HashSet(dataEntities.length));
            DynamicObject accountBank = info.getDynamicObject("payeracctbank");
            if (null == accountBank) continue;
            accounts.add(accountBank.getLong("id"));
        }
        return returns;
    }

    private Map<Long, Boolean> getisClosed(Set<Long> accounts) {
        if (accounts == null || accounts.size() == 0) {
            return new HashMap<Long, Boolean>();
        }
        return AccountBankHelper.isBatchClosed(accounts);
    }
}

