/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator;

import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.DynamicObjectHelper;

public class BankStatementDeleteValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] datas = this.dataEntities;
        String errorMessage = "";
        for (int i = 0; i < datas.length; ++i) {
            DynamicObject data = datas[i].getDataEntity();
            String selector = "id,ischeck,org,bizdate,tradenumber,accountbank,currency";
            DynamicObject bankStatement = QueryServiceHelper.queryOne((String)"cas_bankstatement", (String)selector, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)data.getLong("id"))});
            if (bankStatement.getBoolean("ischeck")) {
                this.addMessage(datas[i], bankStatement, ResManager.loadKDString((String)"\u65e0\u6cd5\u5220\u9664\u5df2\u52fe\u5bf9\u7684\u94f6\u884c\u5bf9\u8d26\u5355\u3002", (String)"BankStatementDeleteValidator_0", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                continue;
            }
            Date bizDate = bankStatement.getDate("bizdate");
            Long orgId = bankStatement.getLong("org");
            errorMessage = AccountBankHelper.checkBalanceAdjustOfStatement((Long)orgId, (Long)DynamicObjectHelper.getPk((DynamicObject)bankStatement, (String)"accountbank"), (Long)DynamicObjectHelper.getPk((DynamicObject)bankStatement, (String)"currency"), (Date)bizDate, (boolean)false, (boolean)false);
            if (CasHelper.isEmpty((Object)errorMessage)) continue;
            this.addMessage(datas[i], bankStatement, errorMessage);
        }
    }

    private void addMessage(ExtendedDataEntity data, DynamicObject bankStatement, String message) {
        this.addMessage(data, String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u53c2\u8003\u53f7 %1$s \u7684\u8bb0\u5f55\u5220\u9664\u5931\u8d25\uff0c\u539f\u56e0\u662f\uff1a%2$s\u3002", (String)"BankStatementDeleteValidator_2", (String)"fi-cas-opplugin", (Object[])new Object[0]), bankStatement.getString("tradenumber"), message), ErrorLevel.Error);
    }
}

