/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator;

import java.util.Date;
import java.util.Iterator;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.DynamicObjectHelper;
import kd.fi.cas.util.EmptyUtil;

public class BankStatementManualSaveValidator
extends AbstractValidator {
    public void validate() {
        String errorMessage = "";
        String balancErrorMessage = "";
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            Long currency;
            DynamicObject info = dataEntity.getDataEntity();
            DynamicObjectCollection entryentitys = info.getDynamicObjectCollection("entryentity");
            Iterator iterator = entryentitys.iterator();
            if (entryentitys.size() == 0) {
                errorMessage = ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff1a\u5206\u5f55\u672a\u68c0\u6d4b\u5230\u6570\u636e\u5f55\u5165\u3002", (String)"BankStatementManualCommitValidator_8", (String)"fi-cas-opplugin", (Object[])new Object[0]);
            }
            Long org = DynamicObjectHelper.getPk((DynamicObject)info, (String)"org");
            Long accountbank = DynamicObjectHelper.getPk((DynamicObject)info, (String)"accountbank");
            if (null == accountbank) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u94f6\u884c\u8d26\u6237\u3002", (String)"BankStatementManualCommitValidator_9", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            }
            if (null == (currency = DynamicObjectHelper.getPk((DynamicObject)info, (String)"currency"))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5e01\u79cd\u3002", (String)"BankStatementManualCommitValidator_10", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            }
            String isModify = this.getOption().getVariableValue("isModify");
            while (iterator.hasNext()) {
                QFilter qFilter;
                boolean exists;
                DynamicObject entrydy = (DynamicObject)iterator.next();
                if (entrydy.getDate("bizdate") == null) {
                    errorMessage = String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u7b2c%s", (String)"BankStatementManualCommitValidator_1", (String)"fi-cas-opplugin", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"%s\u884c\uff1a\u8bf7\u586b\u5199\u65e5\u671f\u4fe1\u606f\u3002", (String)"BankStatementManualCommitValidator_6", (String)"fi-cas-opplugin", (Object[])new Object[0]), entrydy.get("seq")));
                    break;
                }
                if (!(!CasHelper.isEmpty((Object)entrydy.getBigDecimal("debitamount")) || !CasHelper.isEmpty((Object)entrydy.getBigDecimal("creditamount")) || CasHelper.isEmpty((Object)entrydy.getString("description")) && CasHelper.isEmpty((Object)entrydy.getString("oppunitname")) && CasHelper.isEmpty((Object)entrydy.getString("oppbank")) && CasHelper.isEmpty((Object)entrydy.getString("oppaccountnumber")) && CasHelper.isEmpty((Object)entrydy.getString("settlementtype")) && CasHelper.isEmpty((Object)entrydy.getString("settlementnumber")) && CasHelper.isEmpty((Object)entrydy.getString("bankcheckflag")) && CasHelper.isEmpty((Object)entrydy.getString("bankvouvherno")) && CasHelper.isEmpty((Object)entrydy.getString("sequencenumber")) && CasHelper.isEmpty((Object)entrydy.getString("cashier")) && CasHelper.isEmpty((Object)entrydy.getString("tradenumber")) && CasHelper.isEmpty((Object)entrydy.getString("vouchernumber")))) {
                    errorMessage = String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u7b2c%s", (String)"BankStatementManualCommitValidator_1", (String)"fi-cas-opplugin", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"%s\u884c\uff1a\u501f\u65b9\u91d1\u989d\u4e0e\u8d37\u65b9\u91d1\u989d\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\u3002", (String)"BankStatementManualCommitValidator_2", (String)"fi-cas-opplugin", (Object[])new Object[0]), entrydy.get("seq")));
                    break;
                }
                balancErrorMessage = AccountBankHelper.checkBalanceAdjustOfStatement((Long)org, (Long)accountbank, (Long)currency, (Date)entrydy.getDate("bizdate"), (boolean)true, (EmptyUtil.isNotEmpty((String)isModify) && "true".equals(isModify) ? 1 : 0) != 0);
                if (!CasHelper.isEmpty((Object)balancErrorMessage)) {
                    errorMessage = String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u7b2c%s", (String)"BankStatementManualCommitValidator_1", (String)"fi-cas-opplugin", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"%1$s\u884c\uff1a%2$s", (String)"BankStatementManualCommitValidator_4", (String)"fi-cas-opplugin", (Object[])new Object[0]), entrydy.get("seq"), balancErrorMessage));
                    break;
                }
                String bankVourherNo = entrydy.getString("bankvouvherno");
                if (!CasHelper.isNotEmpty((Object)bankVourherNo) || !(exists = QueryServiceHelper.exists((String)"cas_bankstatement", (QFilter[])(qFilter = new QFilter("bankvouvherno", "=", (Object)bankVourherNo)).toArray()))) continue;
                errorMessage = String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u7b2c%1$s\u884c\uff1a\u94f6\u884c\u5bf9\u8d26\u5355\u660e\u7ec6\u6d41\u6c34\u53f7[%2$s]\u5df2\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"BankStatementManualCommitValidator_11", (String)"fi-cas-opplugin", (Object[])new Object[0]), entrydy.get("seq"), bankVourherNo);
                break;
            }
            if (CasHelper.isEmpty((Object)errorMessage)) continue;
            this.addErrorMessage(dataEntity, errorMessage);
        }
    }
}

