/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.business.service.BalanceCountService;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.GLBusinessHelper;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.util.NumberUtils;
import kd.fi.cas.util.StringUtils;

public class CashMgtInitFinishInitValidator
extends AbstractValidator {
    public void validate() {
        Map<Long, ExtendedDataEntity> idExtendData = this.validateBatch();
        this.validateGL(idExtendData);
        for (ExtendedDataEntity extendedDataEntity : idExtendData.values()) {
            DynamicObject cashMgtInit = extendedDataEntity.getDataEntity();
            Long orgId = cashMgtInit.getDynamicObject("org").getLong("id");
            DynamicObjectCollection entryBankList = cashMgtInit.getDynamicObjectCollection("entrybank");
            Map<String, Map<String, BigDecimal>> statementMap = this.getBankStatement(orgId, 0L, 0L);
            int rowCount = entryBankList.size();
            for (int i = 0; i < rowCount; ++i) {
                this.calcJournalBalanceAdj(entryBankList, i, statementMap, cashMgtInit, idExtendData.keySet());
            }
            Map<String, Map<String, BigDecimal>> journalMap = this.getBankJournal(orgId, 0L, 0L);
            int rowCount2 = entryBankList.size();
            for (int i = 0; i < rowCount2; ++i) {
                if (!AccountBankHelper.isAuthorityAccount((DynamicObject)((DynamicObject)entryBankList.get(i)).getDynamicObject("bank_accountbank"), (DynamicObject)cashMgtInit.getDynamicObject("org"))) continue;
                this.calcStatementBalanceAdj(entryBankList, i, journalMap, cashMgtInit);
            }
            for (DynamicObject entryBank : entryBankList) {
                BigDecimal journalBalance = entryBank.getBigDecimal("bank_journalbalance").setScale(10, 4);
                BigDecimal journaldebit = entryBank.getBigDecimal("bank_journaldebit").setScale(10, 4);
                BigDecimal journalcredit = entryBank.getBigDecimal("bank_journalcredit").setScale(10, 4);
                if (AccountBankHelper.isAuthorityAccount((DynamicObject)entryBank.getDynamicObject("bank_accountbank"), (DynamicObject)cashMgtInit.getDynamicObject("org"))) continue;
                ArrayList<QFilter> lstFilters = new ArrayList<QFilter>();
                lstFilters.add(new QFilter("org", "=", (Object)entryBank.getDynamicObject("bank_accountbank").getDynamicObject("createorg").getLong("id")));
                lstFilters.add(new QFilter("isfinishinit", "=", (Object)"1"));
                DynamicObject[] cashmgtInitDy = BusinessDataServiceHelper.load((String)"cas_cashmgtinit", (String)"id", (QFilter[])lstFilters.toArray(new QFilter[0]));
                if (cashmgtInitDy == null || cashmgtInitDy.length <= 0 || journalBalance.compareTo(BigDecimal.ZERO) == 0 && journaldebit.compareTo(BigDecimal.ZERO) == 0 && journalcredit.compareTo(BigDecimal.ZERO) == 0) continue;
                String msg = StringUtils.formatMessage((String)ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u6237\u201c{0}{1}\u201d\u7684\u521b\u5efa\u7ec4\u7ec7\u5df2\u7ecf\u7ed3\u675f\u521d\u59cb\u5316\uff0c\u65e5\u8bb0\u8d26\u672c\u5e74\u7d2f\u8ba1\u501f\u65b9\u3001\u65e5\u8bb0\u8d26\u672c\u5e74\u7d2f\u8ba1\u8d37\u65b9\u3001\u65e5\u8bb0\u8d26\u521d\u59cb\u4f59\u989d\u90fd\u5e94\u8bbe\u7f6e\u4e3a0\u3002", (String)"CashMgtInitFinishInitValidator_1", (String)"fi-cas-opplugin", (Object[])new Object[0]), (Object[])new Object[]{entryBank.getDynamicObject("bank_accountbank").getString("name"), entryBank.getDynamicObject("bank_currency").getString("name")});
                this.addMessage(extendedDataEntity, msg, ErrorLevel.Error);
                this.getValidateResult().setSuccess(false);
            }
        }
    }

    private void calcJournalBalanceAdj(DynamicObjectCollection entryBankList, int entryIndex, Map<String, Map<String, BigDecimal>> statementMap, DynamicObject cashMgtInit, Set<Long> chechedIds) {
        Long rowAcctbankId = ((DynamicObject)entryBankList.get(entryIndex)).getDynamicObject("bank_accountbank").getLong("id");
        Long rowCurrencyId = ((DynamicObject)entryBankList.get(entryIndex)).getDynamicObject("bank_currency").getLong("id");
        BigDecimal journalBalance = ((DynamicObject)entryBankList.get(entryIndex)).getBigDecimal("bank_journalbalance");
        BigDecimal debitAmount = new BigDecimal(0);
        BigDecimal creditAmount = new BigDecimal(0);
        if (statementMap.get(rowAcctbankId + "-" + rowCurrencyId) != null) {
            debitAmount = statementMap.get(rowAcctbankId + "-" + rowCurrencyId).get("debitamount");
            creditAmount = statementMap.get(rowAcctbankId + "-" + rowCurrencyId).get("creditamount");
        }
        BigDecimal journalBalanceAdj = journalBalance.add(creditAmount).subtract(debitAmount);
        ((DynamicObject)entryBankList.get(entryIndex)).set("bank_journalbalanceadj", (Object)journalBalanceAdj);
        BigDecimal sumBalanceAdj = this.getUseOrgJournalAmount(entryIndex, entryBankList, cashMgtInit, chechedIds);
        BigDecimal statementBalanceAdj = ((DynamicObject)entryBankList.get(entryIndex)).getBigDecimal("bank_statementbalanceadj");
        if (AccountBankHelper.isAuthorityAccount((DynamicObject)((DynamicObject)entryBankList.get(entryIndex)).getDynamicObject("bank_accountbank"), (DynamicObject)cashMgtInit.getDynamicObject("org"))) {
            ((DynamicObject)entryBankList.get(entryIndex)).set("bank_journalsumbalanceadj", (Object)sumBalanceAdj);
            ((DynamicObject)entryBankList.get(entryIndex)).set("bank_equal", (Object)(NumberUtils.equals((BigDecimal)sumBalanceAdj, (BigDecimal)statementBalanceAdj) ? "1" : "0"));
        } else {
            ((DynamicObject)entryBankList.get(entryIndex)).set("bank_journalsumbalanceadj", (Object)BigDecimal.ZERO);
            ((DynamicObject)entryBankList.get(entryIndex)).set("bank_equal", (Object)"0");
        }
    }

    private BigDecimal getUseOrgJournalAmount(int entryIndex, DynamicObjectCollection entryBankList, DynamicObject dataEntity, Set<Long> chechedIds) {
        BigDecimal totalAmount = new BigDecimal(0);
        DynamicObject org = dataEntity.getDynamicObject("org");
        DynamicObject createOegStartPeriod = dataEntity.getDynamicObject("startperiod");
        long accountbankId = ((DynamicObject)entryBankList.get(entryIndex)).getDynamicObject("bank_accountbank").getLong("id");
        long currencyId = ((DynamicObject)entryBankList.get(entryIndex)).getDynamicObject("bank_currency").getLong("id");
        DynamicObject[] cashmgtInitDy = BusinessDataServiceHelper.load((String)"cas_cashmgtinit", (String)"id,org,startperiod,currentperiod,isfinishinit,entrybank.bank_accountbank,entrybank.bank_currency,entrybank.bank_journalbalance,bank_journalbalanceadj", (QFilter[])new QFilter[]{new QFilter("entrybank.bank_accountbank", "=", (Object)accountbankId)});
        boolean isSave = false;
        for (DynamicObject dyObj : cashmgtInitDy) {
            if (dyObj.getDynamicObject("org").getLong("id") == org.getLong("id")) {
                isSave = true;
                BigDecimal jornalBalance = EmptyUtil.isEmpty((BigDecimal)((DynamicObject)entryBankList.get(entryIndex)).getBigDecimal("bank_journalbalanceadj")) ? ((DynamicObject)entryBankList.get(entryIndex)).getBigDecimal("bank_journalbalance") : ((DynamicObject)entryBankList.get(entryIndex)).getBigDecimal("bank_journalbalanceadj");
                totalAmount = totalAmount.add(jornalBalance);
                continue;
            }
            if (!dyObj.getBoolean("isfinishinit") && !chechedIds.contains(dyObj.getLong("id"))) continue;
            DynamicObjectCollection bankCollection = dyObj.getDynamicObjectCollection("entrybank");
            for (DynamicObject dyObj1 : bankCollection) {
                Date createOrgBeginDate;
                long accountBankId1 = dyObj1.getDynamicObject("bank_accountbank").getLong("id");
                long currencyId10 = dyObj1.getDynamicObject("bank_currency").getLong("id");
                if (accountBankId1 != accountbankId || currencyId10 != currencyId) continue;
                DynamicObject useorgStartPeriod = dyObj.getDynamicObject("startperiod");
                Date useOrgBeginDate = useorgStartPeriod.getDate("begindate");
                if (useOrgBeginDate.compareTo(createOrgBeginDate = createOegStartPeriod.getDate("begindate")) < 0) {
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(createOrgBeginDate);
                    calendar.add(5, -1);
                    Date endDate = calendar.getTime();
                    BalanceCountService balanceCountService = new BalanceCountService();
                    BigDecimal accountBalance = balanceCountService.getJournalBalance(dyObj, Long.valueOf(dyObj.getDynamicObject("org").getLong("id")), Long.valueOf(accountBankId1), Long.valueOf(currencyId10), endDate);
                    totalAmount = totalAmount.add(accountBalance);
                    continue;
                }
                BigDecimal journalbalance1 = EmptyUtil.isEmpty((BigDecimal)dyObj1.getBigDecimal("bank_journalbalanceadj")) ? dyObj1.getBigDecimal("bank_journalbalance") : dyObj1.getBigDecimal("bank_journalbalanceadj");
                totalAmount = totalAmount.add(journalbalance1);
            }
        }
        if (!isSave) {
            BigDecimal jornalBalance = EmptyUtil.isEmpty((BigDecimal)((DynamicObject)entryBankList.get(entryIndex)).getBigDecimal("bank_journalbalanceadj")) ? ((DynamicObject)entryBankList.get(entryIndex)).getBigDecimal("bank_journalbalance") : ((DynamicObject)entryBankList.get(entryIndex)).getBigDecimal("bank_journalbalanceadj");
            totalAmount = totalAmount.add(jornalBalance);
        }
        return totalAmount;
    }

    private void calcStatementBalanceAdj(DynamicObjectCollection entryBankList, int entryIndex, Map<String, Map<String, BigDecimal>> journalMap, DynamicObject cashMgtInit) {
        Long rowAcctbankId = ((DynamicObject)entryBankList.get(entryIndex)).getDynamicObject("bank_accountbank").getLong("id");
        Long rowCurrencyId = ((DynamicObject)entryBankList.get(entryIndex)).getDynamicObject("bank_currency").getLong("id");
        BigDecimal statementBalance = ((DynamicObject)entryBankList.get(entryIndex)).getBigDecimal("bank_statementbalance");
        BigDecimal debitAmount = new BigDecimal(0);
        BigDecimal creditAmount = new BigDecimal(0);
        if (journalMap.get(rowAcctbankId + "-" + rowCurrencyId) != null) {
            debitAmount = journalMap.get(rowAcctbankId + "-" + rowCurrencyId).get("debitamount");
            creditAmount = journalMap.get(rowAcctbankId + "-" + rowCurrencyId).get("creditamount");
        }
        BigDecimal statementBalanceAdj = statementBalance.add(debitAmount).subtract(creditAmount);
        ((DynamicObject)entryBankList.get(entryIndex)).set("bank_statementbalanceadj", (Object)statementBalanceAdj);
        BigDecimal journalBalanceAdj = ((DynamicObject)entryBankList.get(entryIndex)).getBigDecimal("bank_journalsumbalanceadj");
        if (AccountBankHelper.isAuthorityAccount((DynamicObject)((DynamicObject)entryBankList.get(entryIndex)).getDynamicObject("bank_accountbank"), (DynamicObject)cashMgtInit.getDynamicObject("org"))) {
            ((DynamicObject)entryBankList.get(entryIndex)).set("bank_statementbalanceadj", (Object)statementBalanceAdj);
            ((DynamicObject)entryBankList.get(entryIndex)).set("bank_equal", (Object)(NumberUtils.equals((BigDecimal)journalBalanceAdj, (BigDecimal)statementBalanceAdj) ? "1" : "0"));
        } else {
            ((DynamicObject)entryBankList.get(entryIndex)).set("bank_statementbalanceadj", (Object)BigDecimal.ZERO);
            ((DynamicObject)entryBankList.get(entryIndex)).set("bank_equal", (Object)"0");
        }
    }

    private Map<String, Map<String, BigDecimal>> getBankJournal(long orgId, long bankacctId, long currencyId) {
        return this.getBusData(orgId, bankacctId, currencyId, "cas_bankjournal");
    }

    private Map<String, Map<String, BigDecimal>> getBankStatement(long orgId, long bankacctId, long currencyId) {
        return this.getBusData(orgId, bankacctId, currencyId, "cas_bankstatement");
    }

    private Map<String, Map<String, BigDecimal>> getBusData(long orgId, long bankacctId, long currencyId, String dataType) {
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter periodFilter = new QFilter("period", "=", (Object)0);
        QFilter accountFilter = new QFilter("accountbank", "=", (Object)bankacctId);
        QFilter currencyFilter = new QFilter("currency", "=", (Object)currencyId);
        QFilter[] filters = null;
        filters = bankacctId != 0L ? new QFilter[]{orgFilter, periodFilter, accountFilter, currencyFilter} : new QFilter[]{orgFilter, periodFilter};
        HashMap<String, Map<String, BigDecimal>> mapStatement = new HashMap<String, Map<String, BigDecimal>>();
        try (DataSet rawDataSet = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + "." + dataType), (String)dataType, (String)"accountbank as faccountbankid,currency as fcurrencyid,debitamount,creditamount", (QFilter[])filters, null);
             DataSet bankStatementGroupByDataSet = rawDataSet.groupBy(new String[]{"faccountbankid", "fcurrencyid"}).sum("debitamount").sum("creditamount").finish();){
            bankStatementGroupByDataSet.forEach(row -> {
                Long rowAcctbankId = row.getLong("faccountbankid");
                Long rowCurrencyId = row.getLong("fcurrencyid");
                BigDecimal debitamount = row.getBigDecimal("debitamount");
                BigDecimal creditamount = row.getBigDecimal("creditamount");
                HashMap<String, BigDecimal> rowData = new HashMap<String, BigDecimal>();
                rowData.put("debitamount", debitamount);
                rowData.put("creditamount", creditamount);
                mapStatement.put(rowAcctbankId + "-" + rowCurrencyId, rowData);
            });
        }
        return mapStatement;
    }

    private Map<Long, ExtendedDataEntity> validateBatch() {
        String message;
        String orgName;
        DynamicObject org;
        DynamicObject data;
        HashMap<Long, ExtendedDataEntity> idExtendData = new HashMap<Long, ExtendedDataEntity>(this.dataEntities.length);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject data2 = dataEntity.getDataEntity();
            Long id = data2.getLong("id");
            idExtendData.put(id, dataEntity);
        }
        HashSet<Long> removeId = new HashSet<Long>(this.dataEntities.length);
        HashSet<Long> isFinishIds = new HashSet<Long>(this.dataEntities.length);
        QFilter qfilter = new QFilter("id", "in", idExtendData.keySet());
        DynamicObject[] infoArr = BusinessDataServiceHelper.load((String)"cas_cashmgtinit", (String)"id,org,standardcurrency,periodtype,startperiod,exratetable, isfinishinit", (QFilter[])new QFilter[]{qfilter});
        for (DynamicObject info : infoArr) {
            Long id = info.getLong("id");
            if (info != null && info.getDynamicObject("standardcurrency") != null && info.getDynamicObject("periodtype") != null && info.getDynamicObject("startperiod") != null && info.getDynamicObject("exratetable") != null) {
                if (!info.getBoolean("isfinishinit")) continue;
                isFinishIds.add(id);
                continue;
            }
            removeId.add(id);
        }
        for (Long id : removeId) {
            ExtendedDataEntity extendedDataEntity = (ExtendedDataEntity)idExtendData.remove(id);
            data = extendedDataEntity.getDataEntity();
            org = data.getDynamicObject("org");
            orgName = org.getString("name");
            message = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%1$s\u201d\u8bf7\u5148\u8fdb\u884c\u521d\u59cb\u8bbe\u7f6e\uff0c\u4e4b\u540e\u518d\u8fdb\u884c\u521d\u59cb\u5316\u64cd\u4f5c\u3002", (String)"CashMgtInitFinishInitValidator_3", (String)"fi-cas-opplugin", (Object[])new Object[0]), orgName);
            this.addErrorMessage(extendedDataEntity, message);
            this.getValidateResult().setSuccess(false);
        }
        for (Long id : isFinishIds) {
            ExtendedDataEntity extendedDataEntity = (ExtendedDataEntity)idExtendData.remove(id);
            data = extendedDataEntity.getDataEntity();
            org = data.getDynamicObject("org");
            orgName = org.getString("name");
            message = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%1$s\u201d\u5df2\u7ed3\u675f\u521d\u59cb\u5316\u3002", (String)"CashMgtInitFinishInitValidator_4", (String)"fi-cas-opplugin", (Object[])new Object[0]), orgName);
            this.addErrorMessage(extendedDataEntity, message);
            this.getValidateResult().setSuccess(false);
        }
        return idExtendData;
    }

    private void validateGL(Map<Long, ExtendedDataEntity> idExtendData) {
        for (ExtendedDataEntity dataEntity : idExtendData.values()) {
            List message;
            DynamicObject cashMgtInit = dataEntity.getDataEntity();
            Long orgId = cashMgtInit.getDynamicObject("org").getLong("id");
            Long periodId = cashMgtInit.getDynamicObject("startperiod").getLong("id");
            if (!GLBusinessHelper.needCheckWithGL((long)orgId) || (message = GLBusinessHelper.getCheckWithGL((Long)orgId, (Long)periodId, (Boolean)Boolean.TRUE)).size() <= 0) continue;
            this.addErrorMessage(dataEntity, (String)message.get(0));
            this.getValidateResult().setSuccess(false);
        }
    }
}

