/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.cas.business.service.BalanceCalculateService;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.FinalCheckOutHelper;
import kd.fi.cas.helper.GLBusinessHelper;
import kd.fi.cas.helper.OrgHelper;
import kd.fi.cas.util.StringUtils;

public class FinalCheckOutCheckValidator
extends AbstractValidator {
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("finalCheckOutRegion");
    private BalanceCalculateService balanceCalculateService;
    private static final Log logger = LogFactory.getLog(FinalCheckOutCheckValidator.class);

    public FinalCheckOutCheckValidator(BalanceCalculateService service) {
        this.balanceCalculateService = service;
    }

    public void validate() {
        Long orgId;
        ExtendedDataEntity[] dataEntities = this.dataEntities;
        boolean isClosePeriod = this.getOption().containsVariable("closeCacheKey");
        ArrayList<Long> orgIdList = new ArrayList<Long>(dataEntities.length);
        HashMap<Long, DynamicObject> orgDyObjMap = new HashMap<Long, DynamicObject>(dataEntities.length);
        HashMap<Long, ExtendedDataEntity> orgExDataMap = new HashMap<Long, ExtendedDataEntity>(dataEntities.length);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject finalCheckout = dataEntity.getDataEntity();
            orgId = finalCheckout.getDynamicObject("org").getLong("id");
            cache.put(orgId + "", (Object)"", 60);
            Boolean checkBalance = FinalCheckOutHelper.getInstance().toCreateBalanceAdjust(finalCheckout, isClosePeriod);
            if (!checkBalance.booleanValue()) continue;
            if (!FinalCheckOutHelper.getInstance().isFinishInit(finalCheckout, isClosePeriod).booleanValue()) {
                String msg = ResManager.loadKDString((String)"\u5f53\u524d\u7ed3\u8d26\u671f\u95f4\u5df2\u542f\u7528\u94f6\u4f01\u5bf9\u8d26\u5e76\u4e14\u94f6\u4f01\u5bf9\u8d26\u5e73\u8861\u540e\u624d\u5141\u8bb8\u7ed3\u8d26\uff0c\u8bf7\u5148\u5b8c\u6210\u5bf9\u8d26\u521d\u59cb\u5316\u518d\u7ed3\u8d26\u3002", (String)"FinalCheckOutCheckValidator_1", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                if (isClosePeriod) {
                    cache.put(orgId + "", (Object)msg, 60);
                    continue;
                }
                this.addMessage(dataEntity, msg, ErrorLevel.FatalError);
                continue;
            }
            orgIdList.add(orgId);
            orgDyObjMap.put(orgId, finalCheckout);
            orgExDataMap.put(orgId, dataEntity);
        }
        this.balanceCalculateService.setOrgList(orgIdList);
        this.balanceCalculateService.setOrgDynamic(orgDyObjMap);
        List adjustList = this.balanceCalculateService.calc();
        if (!this.balanceCalculateService.getErrorMsgs().isEmpty()) {
            for (Map.Entry entry : this.balanceCalculateService.getErrorMsgs().entrySet()) {
                List errorList = (List)entry.getValue();
                long orgId2 = (Long)entry.getKey();
                String msg = errorList.stream().collect(Collectors.joining("\r\n"));
                if (isClosePeriod) {
                    cache.put(orgId2 + "", (Object)msg, 60);
                    continue;
                }
                this.addMessage((ExtendedDataEntity)orgExDataMap.get(orgId2), msg, ErrorLevel.FatalError);
            }
        } else {
            HashSet<Long> removeAdjustOrgIds = new HashSet<Long>(adjustList.size());
            for (int i = 0; i < adjustList.size(); ++i) {
                BigDecimal adjustJournalAmt = ((DynamicObject)adjustList.get(i)).getBigDecimal("adjustjournalamt");
                BigDecimal adjustStatementAmt = ((DynamicObject)adjustList.get(i)).getBigDecimal("adjuststatementamt");
                orgId = ((DynamicObject)adjustList.get(i)).getDynamicObject("org").getLong("id");
                if (adjustStatementAmt.compareTo(new BigDecimal("0")) == 0) {
                    adjustStatementAmt = new BigDecimal("0");
                }
                if (adjustJournalAmt.compareTo(new BigDecimal("0")) == 0) {
                    adjustJournalAmt = new BigDecimal("0");
                }
                logger.info("=======\u7ed3\u8d26\u5e73\u4e0d\u5e73\uff1aadjustJournalAmt\uff1a{}\uff0c adjustStatementAmt\uff1a{}", (Object)adjustJournalAmt, (Object)adjustStatementAmt);
                if (adjustJournalAmt.compareTo(adjustStatementAmt) == 0) continue;
                String curMes = "";
                Long bankAccountId = ((DynamicObject)adjustList.get(i)).getLong("bankaccount_id");
                DynamicObject bankAccount = AccountBankHelper.getAccountBankById((long)bankAccountId);
                Long currency = ((DynamicObject)adjustList.get(i)).getLong("currency_id");
                DynamicObjectCollection currencyCol = bankAccount.getDynamicObjectCollection("currency");
                for (DynamicObject cur : currencyCol) {
                    Long currencyId = cur.getDynamicObject("fbasedataid").getLong("id");
                    if (currency.compareTo(currencyId) != 0) continue;
                    curMes = cur.getDynamicObject("fbasedataid").getLocaleString("name").getLocaleValue();
                }
                DynamicObject org = OrgHelper.getOrgById((long)orgId);
                String msg = StringUtils.formatMessage((String)ResManager.loadKDString((String)"\u7ec4\u7ec7\uff1a{0}\u3001\u8d26\u6237\uff1a{1}\u3001\u5e01\u79cd\uff1a{2}\u5bf9\u5e94\u7684\u4f59\u989d\u8c03\u8282\u8868\u8c03\u6574\u540e\u4f59\u989d\u4e0d\u5e73\uff0c\u4e0d\u80fd\u7ed3\u8d26\u3002", (String)"FinalCheckOutCheckValidator_0", (String)"fi-cas-opplugin", (Object[])new Object[0]), (Object[])new Object[]{org.getString("name"), bankAccount.getString("bankaccountnumber"), curMes});
                logger.info("=======\u65e5\u8bb0\u8d26\u4f59\u989d" + adjustJournalAmt + "---\u5bf9\u8d26\u5355" + adjustStatementAmt);
                if (isClosePeriod) {
                    cache.put(orgId + "", (Object)msg, 60);
                } else {
                    this.addMessage((ExtendedDataEntity)orgExDataMap.get(orgId), msg, ErrorLevel.FatalError);
                }
                removeAdjustOrgIds.add(orgId);
                this.removeAdjust(adjustList, removeAdjustOrgIds);
                return;
            }
            this.removeAdjust(adjustList, removeAdjustOrgIds);
        }
        if (!isClosePeriod) {
            for (ExtendedDataEntity dataEntity : this.dataEntities) {
                DynamicObject finalcheckout = dataEntity.getDataEntity();
                long orgId3 = finalcheckout.getDynamicObject("org").getLong("id");
                DynamicObject period = finalcheckout.getDynamicObject("period");
                if (!GLBusinessHelper.isCheckWithGl((Long)orgId3)) continue;
                logger.info("gl check start");
                GLBusinessHelper.checkWithGL((Long)orgId3, (Long)period.getLong("id"), (Boolean)Boolean.FALSE);
            }
        }
    }

    private void removeAdjust(List<DynamicObject> adjustList, Set<Long> removeAdjustOrgIds) {
        if (removeAdjustOrgIds.size() == 0) {
            return;
        }
        HashSet<DynamicObject> removeAdjust = new HashSet<DynamicObject>(removeAdjustOrgIds.size());
        for (int i = 0; i < adjustList.size(); ++i) {
            DynamicObject adjust = adjustList.get(i);
            Long orgId = adjustList.get(i).getDynamicObject("org").getLong("id");
            if (!removeAdjustOrgIds.contains(orgId)) continue;
            removeAdjust.add(adjust);
        }
        if (removeAdjust.size() > 0) {
            adjustList.removeAll(removeAdjust);
        }
    }
}

