/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator;

import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.SystemStatusCtrolHelper;
import kd.fi.cas.util.EmptyUtil;

public class OrgFinishinitValidator
extends AbstractValidator {
    private static Log logger = LogFactory.getLog(OrgFinishinitValidator.class);

    public void validate() {
        logger.info("OrgFinishinitValidator validate start");
        Set orgIdList = Arrays.stream(this.dataEntities).filter(c -> c.getDataEntity().getDynamicObject("org") != null).map(c -> c.getDataEntity().getDynamicObject("org").getLong("id")).collect(Collectors.toSet());
        if (EmptyUtil.isEmpty(orgIdList)) {
            return;
        }
        Map orgInitMap = SystemStatusCtrolHelper.getSystemStatusCtrol(orgIdList);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject info = dataEntity.getDataEntity();
            DynamicObject org = info.getDynamicObject("org");
            DynamicObject orgInit = (DynamicObject)orgInitMap.get(org.getString("id"));
            if (org != null && SystemStatusCtrolHelper.isInitEnable((DynamicObject)orgInit)) continue;
            this.addErrorMessage(dataEntity, SystemStatusCtrolHelper.getNotInitMsg((String)CasHelper.getLocalValue((DynamicObject)org, (String)"name")));
        }
        logger.info("OrgFinishinitValidator validate end");
    }
}

