/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.fi.cas.enums.PaymentChannelEnum;

public class PayInfoChgSubmitValidator
extends AbstractValidator {
    public Set<String> preparePropertys() {
        Set preparePropertys = super.preparePropertys();
        preparePropertys.add("aftersettletype");
        preparePropertys.add("settletype");
        preparePropertys.add("afterpaychannel");
        return preparePropertys;
    }

    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject data = dataEntity.getDataEntity();
            DynamicObjectCollection entry = data.getDynamicObjectCollection("entrys");
            StringBuilder sb = new StringBuilder();
            for (DynamicObject row : entry) {
                List paymentChannels;
                DynamicObject settlementType = row.getDynamicObject("aftersettletype");
                if (settlementType == null) {
                    settlementType = row.getDynamicObject("settletype");
                }
                if (settlementType == null) continue;
                String paymentChannel = settlementType.getString("paymentchannel");
                String currentPaymentChannel = row.getString("afterpaychannel");
                if (!StringUtils.isNotEmpty((CharSequence)paymentChannel) || !StringUtils.isNotEmpty((CharSequence)currentPaymentChannel) || (paymentChannels = Arrays.stream(paymentChannel.split(",")).filter(StringUtils::isNotEmpty).collect(Collectors.toList())).contains(currentPaymentChannel)) continue;
                List channelNames = paymentChannels.stream().map(PaymentChannelEnum::getName).collect(Collectors.toList());
                String join = String.join((CharSequence)",", channelNames);
                String error = String.format(ResManager.loadKDString((String)"\u7ed3\u7b97\u65b9\u5f0f\u3010%1$s\u3011\u7684\u9650\u5b9a\u652f\u4ed8\u6e20\u9053\u4e3a\u3010%2$s\u3011\uff0c\u8bf7\u4fee\u6539\u540e\u63d0\u4ea4\u3002", (String)"PayInfoChgSubmitValidator_0", (String)"fi-cas-opplugin", (Object[])new Object[0]), settlementType.getString("name"), join);
                if (sb.toString().contains(error)) continue;
                sb.append(error);
            }
            if (sb.length() <= 0) continue;
            this.addErrorMessage(dataEntity, sb.toString());
        }
    }
}

