/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator;

import java.math.BigDecimal;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.fi.cas.business.errorcode.CasErrorCode;
import kd.fi.cas.business.errorcode.PaymentErrorCode;
import kd.fi.cas.business.helper.LinkagePaymentHelper;
import kd.fi.cas.business.helper.PayBillHepler;
import kd.fi.cas.enums.AutoMatchFlagEnum;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.enums.PayBusinessTypeEnum;
import kd.fi.cas.enums.ProceedsTypeEnum;
import kd.fi.cas.enums.SettleMentTypeEnum;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.BaseDataHelper;
import kd.fi.cas.helper.CasBotpHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.DraftHelper;
import kd.fi.cas.helper.PaymentBillPluginHelper;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.helper.SystemStatusCtrolHelper;
import kd.fi.cas.util.CheckUtils;
import kd.fi.cas.util.EmptyUtil;
import org.apache.commons.lang3.StringUtils;

public class PayentBillCommitBEValidator
extends AbstractValidator {
    public Set<String> preparePropertys() {
        Set preparePropertys = super.preparePropertys();
        preparePropertys.add("billstatus");
        preparePropertys.add("settletype");
        preparePropertys.add("entrustorg");
        preparePropertys.add("org");
        preparePropertys.add("applyorg");
        preparePropertys.add("sourcebilltype");
        preparePropertys.add("actpayamt");
        preparePropertys.add("sourcebillid");
        preparePropertys.add("paymentchannel");
        preparePropertys.add("payeracctbank");
        preparePropertys.add("usage");
        preparePropertys.add("payeename");
        preparePropertys.add("recaccbankname");
        preparePropertys.add("payeebanknum");
        preparePropertys.add("iscrosspay");
        preparePropertys.add("recprovince");
        preparePropertys.add("reccity");
        preparePropertys.add("reccountry");
        preparePropertys.add("paymentidentify");
        preparePropertys.add("paymentterm");
        preparePropertys.add("inneraccount");
        preparePropertys.add("matchflag");
        preparePropertys.add("entry");
        preparePropertys.add("e_actamt");
        preparePropertys.add("businesstype");
        return preparePropertys;
    }

    public void validate() {
        PaymentErrorCode paymentErrorCode = new PaymentErrorCode();
        CasErrorCode casErrorCode = new CasErrorCode();
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject innerAccount;
            DynamicObject info = dataEntity.getDataEntity();
            String billStatus = info.getString("billstatus");
            if (!billStatus.equals(BillStatusEnum.AUDIT.getValue())) {
                this.addMessage(dataEntity, paymentErrorCode.STATUS_CANNOT_COMMITBE().getMessage());
                continue;
            }
            if (PaymentBillPluginHelper.payIdentify((DynamicObject)info)) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u88ab\u52a8\u4ed8\u6b3e\u4e1a\u52a1\u4e0d\u5141\u8bb8\u63d0\u4ea4\u94f6\u4f01\uff0c\u8bf7\u64cd\u4f5c\u786e\u8ba4\u4ed8\u6b3e\u3002", (String)"PayentBillCommitBEValidator_9", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                continue;
            }
            if (DraftHelper.isSettlePromise((Object)info.get("settletype"))) {
                this.addMessage(dataEntity, paymentErrorCode.CDM_CANNO_COMMITBE().getMessage());
                continue;
            }
            if (!CasHelper.isEmpty((Object)info.get("entrustorg"))) {
                this.addMessage(dataEntity, paymentErrorCode.WT_NOT_BEICOMMIT().getMessage());
                continue;
            }
            boolean isPushArAp = SystemParameterHelper.getParameterBoolean((long)info.getDynamicObject("org").getLong("id"), (String)"cs088");
            if (isPushArAp && !CasHelper.isEmpty((Object)info.get("applyorg")) && "cas_paybill".equals(info.get("sourcebilltype"))) {
                CasBotpHelper.checkPushRule((String)"cas_paybill", (String[])new String[]{"ar_finarbill"});
            }
            if (!SystemStatusCtrolHelper.isInitEnable((long)info.getDynamicObject("org").getLong("id"))) {
                this.addMessage(dataEntity, SystemStatusCtrolHelper.getNotInitMsg((String)CasHelper.getLocalValue((DynamicObject)info.getDynamicObject("org"), (String)"name")));
                continue;
            }
            if (info.getBigDecimal("actpayamt").compareTo(BigDecimal.ZERO) <= 0) {
                this.addMessage(dataEntity, paymentErrorCode.MINUS_CANNOT_COMMITBE().getMessage());
                continue;
            }
            if (!CasHelper.isEmpty((Object)info.get("sourcebillid")) && (info.getString("sourcebilltype").equals("bei_transdetail_cas") || info.getString("sourcebilltype").equals("bei_transdetail") || info.getString("sourcebilltype").equals("bei_intelpay"))) {
                this.addMessage(dataEntity, paymentErrorCode.TRANSDETAILGEN_CANNOT_COMMITBE().getMessage());
                continue;
            }
            DynamicObject settleType = info.getDynamicObject("settletype");
            if (settleType == null) {
                this.addMessage(dataEntity, String.format(paymentErrorCode.BILL_CANNOT_NULL().getMessage(), ResManager.loadKDString((String)"\u7ed3\u7b97\u65b9\u5f0f", (String)"PayentBillCommitBEValidator_0", (String)"fi-cas-opplugin", (Object[])new Object[0])));
                continue;
            }
            boolean isLinkagePayment = LinkagePaymentHelper.isLinkagePayment((DynamicObject)info);
            if (isLinkagePayment && (innerAccount = info.getDynamicObject("inneraccount")) != null) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e0e\u7ed3\u7b97\u4e2d\u5fc3\u76f8\u5173\u7684\u8054\u52a8\u652f\u4ed8\uff0c\u8bf7\u63d0\u4ea4\u5185\u90e8\u7ed3\u7b97\u3002", (String)"PaymentPayPreValidator_6", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            }
            if (PayBillHepler.isLCSettlement((DynamicObject)settleType, (SettleMentTypeEnum)SettleMentTypeEnum.CREDITOPEN)) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u4ed8\u6b3e\u5904\u7406\u5355\u7ed3\u7b97\u65b9\u5f0f\u7c7b\u522b\u662f\u4fe1\u7528\u8bc1\u5f00\u7acb\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u94f6\u4f01\u6216\u63d0\u4ea4\u5185\u90e8\u7ed3\u7b97\u3002", (String)"PaymentPayPushIfmValidator_16", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                continue;
            }
            if (!"bei".equalsIgnoreCase(info.getString("paymentchannel"))) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u672c\u5355\u9009\u62e9\u7684\u652f\u4ed8\u6e20\u9053\u4e0d\u652f\u6301\u63d0\u4ea4\u94f6\u4f01\u4ed8\u6b3e\u3002", (String)"PaymentErrorCode_20", (String)"fi-cas-business", (Object[])new Object[0]));
                continue;
            }
            boolean isCash = BaseDataHelper.isSettleTypeCash((DynamicObject)settleType);
            if (isCash) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u63d0\u793a\u4e3a\u8be5\u672c\u5355\u9009\u62e9\u7684\u652f\u4ed8\u6e20\u9053\u4e0d\u652f\u6301\u63d0\u4ea4\u94f6\u4f01\u4ed8\u6b3e\u3002", (String)"PayentBillCommitBEValidator_1", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                continue;
            }
            DynamicObject payerAcctBank = info.getDynamicObject("payeracctbank");
            if (payerAcctBank == null) {
                this.addMessage(dataEntity, String.format(paymentErrorCode.BILL_CANNOT_NULL().getMessage(), ResManager.loadKDString((String)"\u4ed8\u6b3e\u8d26\u6237", (String)"PayentBillCommitBEValidator_2", (String)"fi-cas-opplugin", (Object[])new Object[0])));
                continue;
            }
            String msg = AccountBankHelper.commitBeiValidate((Long)payerAcctBank.getLong("id"));
            if (StringUtils.isNotBlank((CharSequence)msg)) {
                this.addMessage(dataEntity, msg);
                continue;
            }
            if (AccountBankHelper.isClosed((long)payerAcctBank.getLong("id"))) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8d26\u6237%s\u5f53\u524d\u72b6\u6001\u4e3a\u5df2\u9500\u6237\uff0c\u6682\u65e0\u6cd5\u8fdb\u884c\u4e1a\u52a1\u5904\u7406\u3002", (String)"PaymentErrorCode_47", (String)"fi-cas-business", (Object[])new Object[0]), payerAcctBank.getString("number")));
            }
            String term = info.getString("paymentterm");
            if (CasHelper.isEmpty((Object)info.getString("usage"))) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u8f6c\u8d26\u9644\u8a00\u7a7a\uff0c\u4e0d\u80fd\u63d0\u4ea4\u94f6\u4f01\u3002", (String)"PayentBillCommitBEValidator_3", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            }
            if (CasHelper.isEmpty((Object)info.getString("payeename"))) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u6536\u6b3e\u4eba\u540d\u79f0\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u63d0\u4ea4\u94f6\u4f01\u3002", (String)"PayentBillCommitBEValidator_11", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            }
            if (CasHelper.isEmpty((Object)info.getString("recaccbankname"))) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u6536\u6b3e\u4eba\u5b9e\u540d\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u63d0\u4ea4\u94f6\u4f01\u3002", (String)"PayentBillCommitBEValidator_4", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            }
            if (CasHelper.isEmpty((Object)info.getString("payeebanknum")) && this.checkFps(term)) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u6536\u6b3e\u8d26\u53f7\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u63d0\u4ea4\u94f6\u4f01\u3002", (String)"PayentBillCommitBEValidator_5", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            }
            if (!info.getBoolean("iscrosspay")) {
                boolean isCheckDcep;
                String businessType = info.getString("businesstype");
                boolean isDcep = BaseDataHelper.isSettleTypeDcep((DynamicObject)settleType);
                boolean bl = isCheckDcep = !isDcep || PayBusinessTypeEnum.WALLETESSAY.getValue().equals(businessType);
                if (isCheckDcep && CasHelper.isEmpty((Object)info.getString("recprovince"))) {
                    this.addMessage(dataEntity, ResManager.loadKDString((String)"\u6536\u6b3e\u65b9\u7701\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u63d0\u4ea4\u94f6\u4f01\u3002", (String)"PayentBillCommitBEValidator_6", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                }
                if (isCheckDcep && CasHelper.isEmpty((Object)info.getString("reccity"))) {
                    this.addMessage(dataEntity, ResManager.loadKDString((String)"\u6536\u6b3e\u65b9\u5e02\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u63d0\u4ea4\u94f6\u4f01\u3002", (String)"PayentBillCommitBEValidator_7", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                }
                if (CasHelper.isEmpty((Object)info.getString("reccountry"))) {
                    this.addMessage(dataEntity, ResManager.loadKDString((String)"\u6536\u6b3e\u65b9\u56fd\u5bb6\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u63d0\u4ea4\u94f6\u4f01\u3002", (String)"PayentBillCommitBEValidator_8", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                }
            }
            if (this.isGeneratedByRecBill(info)) {
                this.addMessage(dataEntity, paymentErrorCode.HASSRCBILL_CANNOT_COMMITBE().getMessage());
                continue;
            }
            boolean tm018 = SystemParameterHelper.isBizBillCommitBe((long)info.getDynamicObject("org").getLong("id"));
            if (tm018) {
                DynamicObject accountBank = info.getDynamicObject("payeracctbank");
                DynamicObject org = info.getDynamicObject("org");
                String msg2 = AccountBankHelper.checkAccount((DynamicObject)org, (DynamicObject)accountBank);
                if (EmptyUtil.isNoEmpty((String)msg2)) {
                    this.addMessage(dataEntity, msg2);
                    continue;
                }
            }
            if (PayBillHepler.getViewSettle((DynamicObject)info).size() > 0) {
                String msg3 = String.format(ResManager.loadKDString((String)"\u5b58\u5728\u7ed3\u7b97\u8bb0\u5f55\uff0c\u4e0d\u80fd\u63d0\u4ea4\u94f6\u4f01\u3002\u5982\u9700\u7ee7\u7eed\u6267\u884c\u64cd\u4f5c\uff0c\u8bf7\u5148\u53cd\u7ed3\u7b97\u3002", (String)"PayentBillCommitBEValidator_10", (String)"fi-cas-opplugin", (Object[])new Object[0]), "");
                this.addMessage(dataEntity, msg3);
                continue;
            }
            CheckUtils.checkAmtEqualEAmt((DynamicObject)info, (String)"actpayamt", (String)"e_actamt");
            if (AutoMatchFlagEnum.NONE.getValue().equals(info.getString("matchflag"))) continue;
            this.addMessage(dataEntity, paymentErrorCode.ISMATCH_CANNOT_COMMITBE().getMessage());
        }
    }

    private boolean checkFps(String term) {
        return !ProceedsTypeEnum.ONE.getValue().equals(term) && !ProceedsTypeEnum.TWO.getValue().equals(term) && !ProceedsTypeEnum.three.getValue().equals(term);
    }

    private boolean isGeneratedByRecBill(DynamicObject info) {
        boolean isFromReceivingBill = false;
        String srcFormID = info.getString("sourcebilltype");
        if (!CasHelper.isEmpty((Object)srcFormID) && srcFormID.lastIndexOf("recbill") != -1) {
            isFromReceivingBill = true;
        }
        return isFromReceivingBill;
    }
}

