/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.cas.business.errorcode.PaymentErrorCode;
import kd.fi.cas.business.helper.LinkagePaymentHelper;
import kd.fi.cas.business.helper.PaymentFillPropHelper;
import kd.fi.cas.consts.BillTypeConstants;
import kd.fi.cas.enums.AsstActTypeEnum;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.enums.PayBusinessTypeEnum;
import kd.fi.cas.enums.ProceedsTypeEnum;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.AccountCashHelper;
import kd.fi.cas.helper.BaseDataHelper;
import kd.fi.cas.helper.BotpFixLinkHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.ExtendConfigHelper;
import kd.fi.cas.helper.PayBillCrossHelper;
import kd.fi.cas.helper.PaymentBillPluginHelper;
import kd.fi.cas.helper.PaymentQueryHelper;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.helper.SystemStatusCtrolHelper;
import kd.fi.cas.params.ParamMap;
import kd.fi.cas.util.CheckUtils;
import kd.fi.cas.util.EmptyUtil;

public class PaymentBeforeSubmitValidator
extends AbstractValidator {
    private ParamMap param = new ParamMap();
    private static final List<String> BIZ_TYPES = Arrays.asList("cas_paybill", "cas_agentpaybill");
    private static final List<String> SRCBILL_TYPES = Arrays.asList("cas_claimcenterbill", "fca_transdownbill", "bei_intelpay", "bei_transdetail");
    private static Log logger = LogFactory.getLog(PaymentBeforeSubmitValidator.class);

    public Set<String> preparePropertys() {
        Set preparePropertys = super.preparePropertys();
        preparePropertys.add("bilfieldKeysatus");
        preparePropertys.add("bizdate");
        preparePropertys.add("paymenttype");
        preparePropertys.add("payeetype");
        preparePropertys.add("description");
        preparePropertys.add("issingle");
        preparePropertys.add("org");
        preparePropertys.add("payeracctcash");
        preparePropertys.add("payeracctbank");
        preparePropertys.add("payerbank");
        preparePropertys.add("payeeformid");
        preparePropertys.add("payeeaccformid");
        preparePropertys.add("payeebank");
        preparePropertys.add("payeebankname");
        preparePropertys.add("billno");
        preparePropertys.add("inneraccount");
        preparePropertys.add("actpayamt");
        preparePropertys.add("currency");
        preparePropertys.add("localamt");
        preparePropertys.add("fundflowitem");
        preparePropertys.add("usage");
        preparePropertys.add("expectdate");
        preparePropertys.add("reccountry");
        preparePropertys.add("recprovince");
        preparePropertys.add("reccity");
        preparePropertys.add("recaccbankname");
        preparePropertys.add("sourcetype");
        preparePropertys.add("entrance");
        preparePropertys.add("sourcebillnumber");
        preparePropertys.add("draftbill");
        preparePropertys.add("e_payableAmt");
        preparePropertys.add("e_lockAmt");
        preparePropertys.add("e_unlockAmt");
        preparePropertys.add("e_sourcebillid");
        preparePropertys.add("e_sourcebillentryid");
        preparePropertys.add("settleorg");
        preparePropertys.add("modifier");
        preparePropertys.add("paymentchannel");
        preparePropertys.add("payee");
        preparePropertys.add("payeename");
        preparePropertys.add("itempayee");
        preparePropertys.add("itempayeetype");
        preparePropertys.add("payeebanknum");
        preparePropertys.add("payeeacctbank");
        preparePropertys.add("isdiffcur");
        preparePropertys.add("dpcurrency");
        preparePropertys.add("dpamt");
        preparePropertys.add("dpexchangerate");
        preparePropertys.add("dplocalamt");
        preparePropertys.add("lossamt");
        preparePropertys.add("iscrosspay");
        preparePropertys.add("contractno");
        preparePropertys.add("recswiftcode");
        preparePropertys.add("recbanknumber");
        preparePropertys.add("crosstrantype");
        preparePropertys.add("creator");
        preparePropertys.add("isheadpush");
        preparePropertys.add("sourcebilltype");
        preparePropertys.add("sourcebillid");
        preparePropertys.add("sourceentry");
        preparePropertys.add("entry");
        preparePropertys.add("feepayer");
        preparePropertys.add("feeactbank");
        preparePropertys.add("feecurrency");
        preparePropertys.add("fee");
        preparePropertys.add("totalpayamt");
        preparePropertys.add("e_unsettledlocalamt");
        preparePropertys.add("e_payableamt");
        preparePropertys.add("e_payablelocamt");
        preparePropertys.add("e_material");
        preparePropertys.add("e_discountamt");
        preparePropertys.add("e_discountlocamt");
        preparePropertys.add("e_actamt");
        preparePropertys.add("e_localamt");
        preparePropertys.add("e_lockamt");
        preparePropertys.add("e_unlockamt");
        preparePropertys.add("e_settledamt");
        preparePropertys.add("e_unsettledamt");
        preparePropertys.add("e_expenseitem");
        preparePropertys.add("e_fundflowitem");
        preparePropertys.add("e_corebilltype");
        preparePropertys.add("e_scheid");
        preparePropertys.add("e_corebillno");
        preparePropertys.add("e_remark");
        preparePropertys.add("entrustorg");
        preparePropertys.add("e_settleorg");
        preparePropertys.add("payquotation");
        preparePropertys.add("exratedate");
        preparePropertys.add("exratetable");
        preparePropertys.add("exchangerate");
        preparePropertys.add("dppayquotation");
        preparePropertys.add("agreedquotation");
        preparePropertys.add("basecurrency");
        preparePropertys.add("settletype");
        preparePropertys.add(String.join((CharSequence)".", "settletype", "settlementtype"));
        preparePropertys.add("settletnumber");
        preparePropertys.add("billtype");
        preparePropertys.add("singlestream");
        preparePropertys.add("paymentterm");
        preparePropertys.add("payernumber");
        preparePropertys.add("paymentidentify");
        preparePropertys.add("inforpayment");
        preparePropertys.add("recemail");
        preparePropertys.add("informrecemail");
        preparePropertys.add("paymentfps");
        preparePropertys.add("paymentareacode");
        preparePropertys.add("settlestatus");
        preparePropertys.add("unsettleamount");
        preparePropertys.add("unsettleamountbase");
        preparePropertys.add("settleamount");
        preparePropertys.add("settleamountbase");
        preparePropertys.add("e_settledlocalamt");
        return preparePropertys;
    }

    public void validate() {
        this.param.getParams().putAll(this.getOption().getVariables());
        Set orgIds = ((Stream)Arrays.stream(this.dataEntities).parallel()).filter(d -> EmptyUtil.isNoEmpty((DynamicObject)d.getDataEntity().getDynamicObject("org")) && EmptyUtil.isNoEmpty((Long)d.getDataEntity().getDynamicObject("org").getLong("id"))).map(d -> d.getDataEntity().getDynamicObject("org").getLong("id")).collect(Collectors.toSet());
        Map orgParamMap = new HashMap();
        Map casInitMap = new HashMap();
        Map orgCheckRecMap = new HashMap();
        if (EmptyUtil.isNoEmpty(orgIds)) {
            orgParamMap = SystemParameterHelper.getSystemParamsByOrgIds(new ArrayList(orgIds), (String)"cs103");
            casInitMap = SystemStatusCtrolHelper.getCurrentPeriod(orgIds);
            orgCheckRecMap = SystemParameterHelper.getSystemParamsByOrgIds(new ArrayList(orgIds), (String)"cs125");
        }
        Set cashIds = ((Stream)Arrays.stream(this.dataEntities).parallel()).filter(d -> EmptyUtil.isNoEmpty((DynamicObject)d.getDataEntity().getDynamicObject("payeracctcash")) && EmptyUtil.isNoEmpty((Long)d.getDataEntity().getDynamicObject("payeracctcash").getLong("id"))).map(d -> d.getDataEntity().getDynamicObject("payeracctcash").getLong("id")).collect(Collectors.toSet());
        List cashCcys = new ArrayList();
        if (EmptyUtil.isNoEmpty(cashIds)) {
            cashCcys = AccountCashHelper.getCurrencys(cashIds);
        }
        Set payAccIds = ((Stream)Arrays.stream(this.dataEntities).parallel()).filter(d -> EmptyUtil.isNoEmpty((DynamicObject)d.getDataEntity().getDynamicObject("payeracctbank")) && EmptyUtil.isNoEmpty((Long)d.getDataEntity().getDynamicObject("payeracctbank").getLong("id"))).map(d -> d.getDataEntity().getDynamicObject("payeracctbank").getLong("id")).collect(Collectors.toSet());
        Set bankCcys = new HashSet();
        if (EmptyUtil.isNoEmpty(payAccIds)) {
            bankCcys = AccountBankHelper.getCurrencyPks(new ArrayList(payAccIds));
        }
        Set ifmPayerAccIds = PayBillCrossHelper.getIfmAccIds(payAccIds);
        Set payeeAccIds = ((Stream)Arrays.stream(this.dataEntities).parallel()).filter(d -> EmptyUtil.isNoEmpty((Long)d.getDataEntity().getLong("payeeacctbank"))).map(d -> d.getDataEntity().getLong("payeeacctbank")).collect(Collectors.toSet());
        Set ifmPayeeAccIds = PayBillCrossHelper.getIfmAccIds(payeeAccIds);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            boolean needCheck;
            String message;
            DynamicObject org;
            DynamicObject e_paymenttype;
            Iterator iterator;
            DynamicObject e_paymenttype2;
            boolean noSettleOrg;
            BigDecimal actPayAmt;
            DynamicObject payBill = dataEntity.getDataEntity();
            PaymentErrorCode paymentErrorCode = new PaymentErrorCode();
            if (!BillStatusEnum.SAVE.getValue().equals(payBill.getString("billstatus"))) {
                this.addErrorMessage(dataEntity, paymentErrorCode.STATUS_CANNOT_SUBMIT().getMessage());
                continue;
            }
            DynamicObject billtype = payBill.getDynamicObject("billtype");
            if (EmptyUtil.isNoEmpty((DynamicObject)billtype) && BillTypeConstants.PAYBILL_DCEP.equals(billtype.getPkValue()) && BigDecimal.ZERO.compareTo(actPayAmt = payBill.getBigDecimal("actpayamt")) == 0) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u4ed8\u6b3e\u91d1\u989d\u3002", (String)"PaymentTypeValidator_5", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                continue;
            }
            DynamicObjectCollection entrys = payBill.getDynamicObjectCollection("entry");
            if (EmptyUtil.isEmpty((DynamicObjectCollection)entrys)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4ed8\u6b3e\u660e\u7ec6\u5206\u5f55\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PaymentSubmitImpl_11", (String)"fi-cas-business", (Object[])new Object[0]));
                continue;
            }
            DynamicObject settleType = payBill.getDynamicObject("settletype");
            boolean isDraftSettleType = BaseDataHelper.isSettleTypeDraft((DynamicObject)settleType);
            String errMsg = this.chkEmpty(payBill, isDraftSettleType);
            int index = errMsg.lastIndexOf("\n");
            if (index != -1) {
                errMsg = errMsg.substring(0, index);
            }
            if (!CasHelper.isEmpty((Object)errMsg)) {
                this.addErrorMessage(dataEntity, errMsg);
                continue;
            }
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)entrys) && (noSettleOrg = entrys.parallelStream().filter(e -> EmptyUtil.isNoEmpty((DynamicObject)e.getDynamicObject("e_paymenttype")) && e.getDynamicObject("e_paymenttype").getBoolean("ispartpayment") && EmptyUtil.isEmpty((DynamicObject)e.getDynamicObject("settleorg"))).findFirst().isPresent())) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53c2\u4e0e\u7ed3\u7b97\u7684\u4ed8\u6b3e\u7c7b\u578b\u7684\u4ed8\u6b3e\u5355\uff0c\u7ed3\u7b97\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PaymentTypeValidator_3", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                continue;
            }
            HashSet<DynamicObject> entryPaymentTypes = new HashSet<DynamicObject>(4);
            boolean multipaymenttype = payBill.getBoolean("multipaymenttype");
            DynamicObject paymenttype = payBill.getDynamicObject("paymenttype");
            for (DynamicObject entry : entrys) {
                e_paymenttype2 = entry.getDynamicObject("e_paymenttype");
                if (e_paymenttype2 == null) continue;
                entryPaymentTypes.add(e_paymenttype2);
            }
            if (multipaymenttype && entryPaymentTypes != null && entryPaymentTypes.size() < 2) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5206\u5f55\u4e2d\u53ea\u6709\u4e00\u79cd\u4ed8\u6b3e\u7c7b\u578b\uff0c\u8bf7\u5173\u95ed\u591a\u4ed8\u6b3e\u7c7b\u578b\u3002", (String)"PaymentSubmitImpl_18", (String)"fi-cas-business", (Object[])new Object[0]));
                continue;
            }
            if (EmptyUtil.isNoEmpty((DynamicObject)paymenttype) && "110".equals(paymenttype.getString("biztype")) && entryPaymentTypes != null && entryPaymentTypes.size() < 2) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5206\u5f55\u4e2d\u53ea\u6709\u4e00\u79cd\u4ed8\u6b3e\u7c7b\u578b\uff0c\u4f46\u57fa\u672c\u4fe1\u606f\u4e2d\u7684\u4ed8\u6b3e\u7c7b\u578b\u7684\u4e1a\u52a1\u7c7b\u578b\u4e3a\u7efc\u5408\u4ed8\u6b3e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"PaymentSubmitImpl_20", (String)"fi-cas-business", (Object[])new Object[0]));
                continue;
            }
            if (!multipaymenttype && entryPaymentTypes != null && entryPaymentTypes.size() > 1) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5206\u5f55\u4e2d\u5b58\u5728\u591a\u79cd\u4ed8\u6b3e\u7c7b\u578b\uff0c\u8bf7\u6253\u5f00\u591a\u4ed8\u6b3e\u7c7b\u578b\u3002", (String)"PaymentSubmitImpl_19", (String)"fi-cas-business", (Object[])new Object[0]));
                continue;
            }
            if (EmptyUtil.isNoEmpty((DynamicObject)paymenttype) && !"110".equals(paymenttype.getString("biztype")) && entryPaymentTypes != null && entryPaymentTypes.size() > 1) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5206\u5f55\u4e2d\u5b58\u5728\u591a\u79cd\u4ed8\u6b3e\u7c7b\u578b\uff0c\u4f46\u57fa\u672c\u4fe1\u606f\u4e2d\u7684\u4ed8\u6b3e\u7c7b\u578b\u7684\u4e1a\u52a1\u7c7b\u578b\u4e0d\u4e3a\u7efc\u5408\u4ed8\u6b3e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"PaymentSubmitImpl_21", (String)"fi-cas-business", (Object[])new Object[0]));
                continue;
            }
            if ((!multipaymenttype || entryPaymentTypes != null && entryPaymentTypes.size() == 1) && EmptyUtil.isNoEmpty((DynamicObject)paymenttype) && (iterator = entryPaymentTypes.iterator()).hasNext() && EmptyUtil.isNoEmpty((DynamicObject)(e_paymenttype = (DynamicObject)iterator.next())) && e_paymenttype.getLong("id") != paymenttype.getLong("id")) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5206\u5f55\u4e2d\u53ea\u6709\u4e00\u79cd\u4ed8\u6b3e\u7c7b\u578b\u6216\u8005\u975e\u591a\u4ed8\u6b3e\u7c7b\u578b\uff0c\u5206\u5f55\u7684\u4ed8\u6b3e\u7c7b\u578b\u5fc5\u987b\u4e0e\u57fa\u672c\u4fe1\u606f\u4e2d\u7684\u4ed8\u6b3e\u7c7b\u578b\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"PaymentSubmitImpl_22", (String)"fi-cas-business", (Object[])new Object[0]));
                continue;
            }
            iterator = entrys.iterator();
            while (iterator.hasNext()) {
                DynamicObject entry;
                entry = (DynamicObject)iterator.next();
                e_paymenttype2 = entry.getDynamicObject("e_paymenttype");
                if (e_paymenttype2 == null || !"110".equals(e_paymenttype2.getString("biztype"))) continue;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5206\u5f55\u4e2d\u4e0d\u5141\u8bb8\u542b\u6709\u4e1a\u52a1\u7c7b\u578b\u4e3a\u7efc\u5408\u4ed8\u6b3e\u7684\u4ed8\u6b3e\u7c7b\u578b\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"PaymentSubmitImpl_23", (String)"fi-cas-business", (Object[])new Object[0]));
                break;
            }
            if (EmptyUtil.isNoEmpty((DynamicObject)(org = payBill.getDynamicObject("org"))) && EmptyUtil.isNoEmpty((Long)org.getLong("id"))) {
                DynamicObject currentperiod;
                Long orgId = org.getLong("id");
                Date bizDate = payBill.getDate("bizDate");
                Object orgParam = orgParamMap.get(String.valueOf(orgId));
                DynamicObject casInit = (DynamicObject)casInitMap.get(orgId);
                DynamicObject dynamicObject = EmptyUtil.isEmpty((DynamicObject)casInit) ? null : (currentperiod = EmptyUtil.isEmpty((DynamicObject)casInit.getDynamicObject("currentperiod")) ? null : casInit.getDynamicObject("currentperiod"));
                if (currentperiod == null && !EmptyUtil.isEmpty((DynamicObject)casInit) && ExtendConfigHelper.isInitOnlySet()) {
                    currentperiod = casInit.getDynamicObject("startperiod");
                }
                Date beginDate = null;
                if (null != currentperiod) {
                    beginDate = currentperiod.getDate("beginDate");
                }
                if (EmptyUtil.isNoEmpty(orgParam) && !((Boolean)orgParam).booleanValue() && EmptyUtil.isNoEmpty((Object)bizDate) && EmptyUtil.isNoEmpty((Object)beginDate) && bizDate.before(beginDate)) {
                    this.addErrorMessage(dataEntity, paymentErrorCode.BIZDATE_BEFORE_CURRENTPERIOD().getMessage());
                    continue;
                }
            }
            if (EmptyUtil.isNoEmpty((DynamicObject)billtype) && !BillTypeConstants.PAYBILL_CASH.equals(billtype.getPkValue())) {
                PaymentFillPropHelper.fillPayeeAcctInfo((DynamicObject)payBill);
            }
            boolean isDiffCur = payBill.getBoolean("isdiffcur");
            long payCurId = payBill.getLong("currency.id");
            if (isDiffCur) {
                payCurId = payBill.getLong("dpcurrency.id");
            }
            DynamicObject cash = payBill.getDynamicObject("payeracctcash");
            DynamicObject bank = payBill.getDynamicObject("payeracctbank");
            boolean isSupport = false;
            if (EmptyUtil.isNoEmpty((DynamicObject)bank)) {
                isSupport = bankCcys.contains(payCurId);
            } else if (EmptyUtil.isNoEmpty((DynamicObject)cash)) {
                isSupport = cashCcys.contains(payCurId);
            }
            if ((EmptyUtil.isNoEmpty((DynamicObject)bank) || EmptyUtil.isNoEmpty((DynamicObject)cash)) && !isSupport) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4ed8\u6b3e\u8d26\u6237\u4e0d\u652f\u6301\u5f53\u524d\u5e01\u79cd\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"AgentPaySubmitImpl_4", (String)"fi-cas-business", (Object[])new Object[0]));
                continue;
            }
            String formId = payBill.getDataEntityType().getName();
            String type = BIZ_TYPES.contains(formId) ? "paymenttype" : "receivingtype";
            DynamicObject pt = payBill.getDynamicObject(type);
            String biztype = Optional.ofNullable(pt).map(value -> value.getString("biztype")).orElse(null);
            if (StringUtils.isEmpty((CharSequence)biztype)) {
                if (BIZ_TYPES.contains(formId)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4ed8\u6b3e\u7c7b\u578b\u7684\u4e1a\u52a1\u7c7b\u578b\u4e3a\u7a7a\uff0c\u8bf7\u5148\u7ef4\u62a4\u4ed8\u6b3e\u7c7b\u578b\u7684\u4e1a\u52a1\u7c7b\u578b\u3002", (String)"CheckUtils_6", (String)"fi-cas-common", (Object[])new Object[0]));
                    continue;
                }
                if ("cas_recbill".equals(formId)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6536\u6b3e\u7c7b\u578b\u7684\u4e1a\u52a1\u7c7b\u578b\u4e3a\u7a7a\uff0c\u8bf7\u5148\u7ef4\u62a4\u6536\u6b3e\u7c7b\u578b\u7684\u4e1a\u52a1\u7c7b\u578b\u3002", (String)"CheckUtils_7", (String)"fi-cas-common", (Object[])new Object[0]));
                    continue;
                }
            }
            if (null != (message = CheckUtils.checkAmtEqualEAmt((DynamicObject)payBill, (String)"actpayamt", (String)"e_actamt"))) {
                this.addErrorMessage(dataEntity, message);
                continue;
            }
            boolean isHeadPush = payBill.getBoolean("isheadpush");
            if (isHeadPush) {
                new BotpFixLinkHelper().fixRowLink(payBill, "entry", "sourcebilltype", payBill.getString("sourcebillid"), payBill.getString("sourceentry"), "e_sourcebillentryid");
            }
            boolean isBeiPay = this.isBeiBePay(payBill);
            boolean isCrossTranType = this.isCrossTranType(payBill);
            boolean isEmpty = CasHelper.isEmpty((Object)payBill.getString("usage")) || CasHelper.isEmpty((Object)payBill.getString("recbanknumber"));
            boolean isCheckRecBank = !EmptyUtil.isEmpty(orgCheckRecMap.get(String.valueOf(org.getLong("id")))) && (Boolean)orgCheckRecMap.get(String.valueOf(org.getLong("id"))) != false;
            String businessType = payBill.getString("businesstype");
            boolean isDcep = BaseDataHelper.isSettleTypeDcep((DynamicObject)settleType);
            boolean isCheckDcep = !isDcep || PayBusinessTypeEnum.WALLETESSAY.getValue().equals(businessType);
            boolean isCrossPay = payBill.getBoolean("iscrosspay");
            if (isBeiPay && isEmpty && !isCrossPay && !isCrossTranType && !isCheckRecBank && isCheckDcep) {
                String checkMsg = String.format(ResManager.loadKDString((String)"\u5355\u53f7%s\u7684\u4ed8\u6b3e\u5355\u652f\u4ed8\u6e20\u9053\u4e3a\u94f6\u4f01\u4e92\u8054\uff0c\u6536\u6b3e\u884c\u884c\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u8865\u5145\u3002", (String)"PaymentBeforeSubmitValidator_0", (String)"fi-cas-opplugin", (Object[])new Object[0]), payBill.getString("billno"));
                this.addErrorMessage(dataEntity, checkMsg);
                continue;
            }
            String usage = payBill.getString("usage");
            DynamicObject accountBank = payBill.getDynamicObject("payeracctbank");
            boolean isInnerAcctPay = EmptyUtil.isEmpty((DynamicObject)accountBank) ? false : ifmPayerAccIds.contains(accountBank.getLong("id"));
            boolean isPaymentIdentify = PaymentBillPluginHelper.paymentIdentify((DynamicObject)payBill);
            String sourcebilltype = payBill.getString("sourcebilltype");
            Long payeeBankId = payBill.getLong("payeeacctbank");
            boolean isInnerAccRec = EmptyUtil.isEmpty((Long)payeeBankId) ? false : ifmPayeeAccIds.contains(payeeBankId);
            boolean bl = needCheck = isPaymentIdentify && !SRCBILL_TYPES.contains(sourcebilltype) && !isInnerAccRec;
            if (!CasHelper.isEmpty((Object)usage) || !isInnerAcctPay || !needCheck) continue;
            this.addMessage(dataEntity, ResManager.loadKDString((String)"\u5185\u90e8\u8d26\u6237\u4ed8\u6b3e\u8bf7\u586b\u5199\u8f6c\u8d26\u9644\u8a00\u3002", (String)"PaymentPayPushIfmValidator_12", (String)"fi-cas-opplugin", (Object[])new Object[0]));
        }
    }

    private String chkEmpty(DynamicObject info, boolean isDraftSettleType) {
        DynamicObject innerAccount;
        boolean isLinkagePayment;
        DynamicObject settleType = info.getDynamicObject("settletype");
        boolean isCash = BaseDataHelper.isSettleTypeCash((DynamicObject)settleType);
        DynamicObject paymentIdentify = (DynamicObject)info.get("paymentidentify");
        Boolean isPositivePay = EmptyUtil.isNoEmpty((DynamicObject)paymentIdentify) && "0".equals(paymentIdentify.getString("type"));
        DynamicObject entrustorg = info.getDynamicObject("entrustorg");
        StringBuilder errMsg = new StringBuilder();
        DynamicObject org = info.getDynamicObject("org");
        if (entrustorg != null && org != null && entrustorg.getPkValue().equals(org.getPkValue())) {
            info.set("entrustorg", null);
            entrustorg = null;
        }
        if (CasHelper.isEmpty((Object)info.get("paymenttype"))) {
            errMsg.append(String.format(new PaymentErrorCode().BILL_CANNOT_NULL().getMessage(), ResManager.loadKDString((String)"\u4ed8\u6b3e\u7c7b\u578b", (String)"PaymentSubmitImpl_1", (String)"fi-cas-business", (Object[])new Object[0]))).append('\n');
        }
        if (isDraftSettleType && !CasHelper.isEmpty((Object)entrustorg)) {
            errMsg.append(new PaymentErrorCode().CDM_CANNOT_ENTR().getMessage()).append('\n');
            return errMsg.toString();
        }
        if (CasHelper.isEmpty((Object)entrustorg)) {
            boolean isCheckOurAcc = PaymentQueryHelper.isCheckOurAccBySysParam((DynamicObject)org, (DynamicObject)settleType);
            if (!isCash && !isDraftSettleType && isCheckOurAcc && CasHelper.isEmpty((Object)info.get("payeracctbank"))) {
                errMsg.append(String.format(new PaymentErrorCode().BILL_CANNOT_NULL().getMessage(), ResManager.loadKDString((String)"\u4ed8\u6b3e\u8d26\u53f7", (String)"PaymentSubmitImpl_2", (String)"fi-cas-business", (Object[])new Object[0]))).append('\n');
            } else if (!isCash && !isDraftSettleType && isCheckOurAcc && CasHelper.isEmpty((Object)info.get("payerbank"))) {
                errMsg.append(String.format(new PaymentErrorCode().BILL_CANNOT_NULL().getMessage(), ResManager.loadKDString((String)"\u4ed8\u6b3e\u94f6\u884c", (String)"PaymentSubmitImpl_3", (String)"fi-cas-business", (Object[])new Object[0]))).append('\n');
            } else if (isCash && !isDraftSettleType && CasHelper.isEmpty((Object)info.get("payeracctcash"))) {
                errMsg.append(String.format(new PaymentErrorCode().BILL_CANNOT_NULL().getMessage(), ResManager.loadKDString((String)"\u4ed8\u6b3e\u8d26\u53f7", (String)"PaymentSubmitImpl_2", (String)"fi-cas-business", (Object[])new Object[0]))).append('\n');
            }
        }
        String payeeTypeId = info.getString("payeetype");
        if (isPositivePay.booleanValue() && this.param.getParams().get("ischeckpayee") == null) {
            if (payeeTypeId.equals(AsstActTypeEnum.OTHER.getValue())) {
                if (CasHelper.isEmpty((Object)info.getString("payeename"))) {
                    errMsg.append(String.format(new PaymentErrorCode().BILL_CANNOT_NULL().getMessage(), ResManager.loadKDString((String)"\u6536\u6b3e\u4eba\u540d\u79f0", (String)"PaymentSubmitImpl_4", (String)"fi-cas-business", (Object[])new Object[0]))).append('\n');
                }
            } else if (CasHelper.isEmpty((Object)info.get("payee"))) {
                errMsg.append(String.format(new PaymentErrorCode().BILL_CANNOT_NULL().getMessage(), ResManager.loadKDString((String)"\u6536\u6b3e\u4eba\u540d\u79f0", (String)"PaymentSubmitImpl_4", (String)"fi-cas-business", (Object[])new Object[0]))).append('\n');
            }
        }
        DynamicObject billtype = info.getDynamicObject("billtype");
        String paymentchannel = info.getString("paymentchannel");
        String paymentTerm = info.getString("paymentterm");
        boolean isNumber = this.checkNumber(info);
        if (isNumber && paymentTerm.equals(ProceedsTypeEnum.ONE.getValue())) {
            if (CasHelper.isEmpty((Object)info.getString("paymentfps"))) {
                errMsg.append(String.format(new PaymentErrorCode().BILL_CANNOT_NULL().getMessage(), ResManager.loadKDString((String)"\u6536\u6b3e\u4ebaFPS\u8d26\u53f7", (String)"PaymentSubmitImpl_13", (String)"fi-cas-business", (Object[])new Object[0]))).append('\n');
            } else if (CasHelper.isEmpty((Object)info.getString("recaccbankname"))) {
                errMsg.append(ResManager.loadKDString((String)"\u6536\u6b3e\u4eba\u5b9e\u540d\u4e0d\u53ef\u4e3a\u7a7a\u3002", (String)"PaymentSubmitImpl_9", (String)"fi-cas-business", (Object[])new Object[0]));
            }
        } else if (isNumber && paymentTerm.equals(ProceedsTypeEnum.TWO.getValue())) {
            if (CasHelper.isEmpty((Object)info.getString("mobile"))) {
                errMsg.append(String.format(new PaymentErrorCode().BILL_CANNOT_NULL().getMessage(), ResManager.loadKDString((String)"\u6536\u6b3e\u4eba\u7535\u8bdd", (String)"PaymentSubmitImpl_14", (String)"fi-cas-business", (Object[])new Object[0]))).append('\n');
            } else if (CasHelper.isEmpty((Object)info.getString("paymentareacode"))) {
                errMsg.append(String.format(new PaymentErrorCode().BILL_CANNOT_NULL().getMessage(), ResManager.loadKDString((String)"\u6536\u6b3e\u4eba\u5730\u533a\u7801", (String)"PaymentSubmitImpl_15", (String)"fi-cas-business", (Object[])new Object[0]))).append('\n');
            } else if (CasHelper.isEmpty((Object)info.getString("recaccbankname"))) {
                errMsg.append(ResManager.loadKDString((String)"\u6536\u6b3e\u4eba\u5b9e\u540d\u4e0d\u53ef\u4e3a\u7a7a\u3002", (String)"PaymentSubmitImpl_9", (String)"fi-cas-business", (Object[])new Object[0]));
            }
        } else if (isNumber && paymentTerm.equals(ProceedsTypeEnum.three.getValue())) {
            if (CasHelper.isEmpty((Object)info.getString("recemail"))) {
                errMsg.append(String.format(new PaymentErrorCode().BILL_CANNOT_NULL().getMessage(), ResManager.loadKDString((String)"\u6536\u6b3e\u65b9\u90ae\u7bb1", (String)"PaymentSubmitImpl_16", (String)"fi-cas-business", (Object[])new Object[0]))).append('\n');
            } else if (CasHelper.isEmpty((Object)info.getString("recaccbankname"))) {
                errMsg.append(ResManager.loadKDString((String)"\u6536\u6b3e\u4eba\u5b9e\u540d\u4e0d\u53ef\u4e3a\u7a7a\u3002", (String)"PaymentSubmitImpl_9", (String)"fi-cas-business", (Object[])new Object[0]));
            }
        } else if ("bei".equals(paymentchannel)) {
            if (isPositivePay.booleanValue() && StringUtils.isBlank((CharSequence)info.getString("payeebanknum"))) {
                errMsg.append(String.format(new PaymentErrorCode().BILL_CANNOT_NULL().getMessage(), ResManager.loadKDString((String)"\u6536\u6b3e\u8d26\u53f7", (String)"PaymentSubmitImpl_5", (String)"fi-cas-business", (Object[])new Object[0]))).append('\n');
            } else if (CasHelper.isEmpty((Object)info.getString("recaccbankname"))) {
                errMsg.append(ResManager.loadKDString((String)"\u6536\u6b3e\u4eba\u5b9e\u540d\u4e0d\u53ef\u4e3a\u7a7a\u3002", (String)"PaymentSubmitImpl_9", (String)"fi-cas-business", (Object[])new Object[0]));
            } else if (info.get("payeebank") == null && CasHelper.isEmpty((Object)info.getString("payeebankname"))) {
                errMsg.append(String.format(new PaymentErrorCode().BILL_CANNOT_NULL().getMessage(), ResManager.loadKDString((String)"\u6536\u6b3e\u94f6\u884c", (String)"PaymentSubmitImpl_5_1", (String)"fi-cas-business", (Object[])new Object[0]))).append('\n');
            }
        } else if (BillTypeConstants.PAYBILL_CASH.equals(billtype.getPkValue())) {
            String businessType = info.getString("businesstype");
            if ("cashin".equals(businessType)) {
                if (CasHelper.isEmpty((Object)info.getString("payeebanknum"))) {
                    errMsg.append(String.format(new PaymentErrorCode().BILL_CANNOT_NULL().getMessage(), ResManager.loadKDString((String)"\u6536\u6b3e\u8d26\u53f7", (String)"PaymentSubmitImpl_5", (String)"fi-cas-business", (Object[])new Object[0]))).append('\n');
                } else if (info.get("payeebank") == null && CasHelper.isEmpty((Object)info.getString("payeebankname"))) {
                    errMsg.append(String.format(new PaymentErrorCode().BILL_CANNOT_NULL().getMessage(), ResManager.loadKDString((String)"\u6536\u6b3e\u94f6\u884c", (String)"PaymentSubmitImpl_5_1", (String)"fi-cas-business", (Object[])new Object[0]))).append('\n');
                }
            } else if ("cashout".equals(businessType) && CasHelper.isEmpty((Object)info.getString("payeebanknum"))) {
                errMsg.append(String.format(new PaymentErrorCode().BILL_CANNOT_NULL().getMessage(), ResManager.loadKDString((String)"\u6536\u6b3e\u8d26\u53f7", (String)"PaymentSubmitImpl_5", (String)"fi-cas-business", (Object[])new Object[0]))).append('\n');
            }
        }
        Boolean string = info.getBoolean("inforpayment");
        if (string.booleanValue() && CasHelper.isEmpty((Object)info.getString("informrecemail"))) {
            errMsg.append(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u901a\u77e5\u6536\u6b3e\u4eba\u90ae\u7bb1\uff1b\u5982\u4e0d\u9700\u901a\u77e5\u6536\u6b3e\u4eba\uff0c\u8bf7\u5173\u95ed\u901a\u77e5\u6536\u6b3e\u4eba\u6309\u94ae\u3002", (String)"PaymentSubmitImpl_17", (String)"fi-cas-business", (Object[])new Object[0])).append('\n');
        }
        if (!CasHelper.isEmpty((Object)entrustorg)) {
            String temp = ResManager.loadKDString((String)"\u59d4\u6258\u4ed8\u6b3e\u7ec4\u7ec7\u4e0d\u4e3a\u7a7a", (String)"PaymentSubmitImpl_7", (String)"fi-cas-business", (Object[])new Object[0]);
            String errStr = "";
            if (!CasHelper.isEmpty((Object)info.get("payeracctbank"))) {
                errStr = errStr + String.format(new PaymentErrorCode().BILL_CAN_NULL().getMessage(), ResManager.loadKDString((String)"\u4ed8\u6b3e\u8d26\u53f7", (String)"PaymentSubmitImpl_2", (String)"fi-cas-business", (Object[])new Object[0])) + "\n";
            }
            if (!CasHelper.isEmpty((Object)settleType)) {
                errStr = errStr + String.format(new PaymentErrorCode().BILL_CAN_NULL().getMessage(), ResManager.loadKDString((String)"\u7ed3\u7b97\u65b9\u5f0f", (String)"PaymentSubmitImpl_8", (String)"fi-cas-business", (Object[])new Object[0])) + "\n";
            }
            if (!CasHelper.isEmpty((Object)errStr)) {
                errMsg.append(temp).append("\uff0c").append(errStr);
            }
        } else {
            if (CasHelper.isEmpty((Object)settleType)) {
                errMsg.append(String.format(new PaymentErrorCode().BILL_CANNOT_NULL().getMessage(), ResManager.loadKDString((String)"\u7ed3\u7b97\u65b9\u5f0f", (String)"PaymentSubmitImpl_8", (String)"fi-cas-business", (Object[])new Object[0]))).append('\n');
            }
            if (CasHelper.isEmpty((Object)paymentchannel)) {
                errMsg.append(String.format(new PaymentErrorCode().BILL_CANNOT_NULL().getMessage(), ResManager.loadKDString((String)"\u652f\u4ed8\u6e20\u9053", (String)"PaymentSubmitImpl_10", (String)"fi-cas-business", (Object[])new Object[0]))).append('\n');
            }
        }
        if ("bei".equals(paymentchannel) && CasHelper.isEmpty((Object)info.getString("usage"))) {
            errMsg.append(ResManager.loadKDString((String)"\u652f\u4ed8\u6e20\u9053\u4e3a\u94f6\u4f01\u4e92\u8054\uff0c\u8f6c\u8d26\u9644\u8a00\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PaymentSubmitImpl_12", (String)"fi-cas-business", (Object[])new Object[0]));
        }
        if ((isLinkagePayment = LinkagePaymentHelper.isLinkagePayment((DynamicObject)info)) && (innerAccount = info.getDynamicObject("inneraccount")) != null && StringUtils.isBlank((CharSequence)info.getString("usage"))) {
            errMsg.append(ResManager.loadKDString((String)"\u4e0e\u7ed3\u7b97\u4e2d\u5fc3\u76f8\u5173\u7684\u8054\u52a8\u652f\u4ed8\uff0c\u8f6c\u8d26\u9644\u8a00\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PaymentBeforeSubmitValidator_1", (String)"fi-cas-opplugin", (Object[])new Object[0]));
        }
        return errMsg.toString();
    }

    private boolean checkNumber(DynamicObject info) {
        String paymentchannel = info.getString("paymentchannel");
        String type = info.getString("crosstrantype.number");
        String number = info.getString("paymentidentify.number");
        return "bei".equals(paymentchannel) && "FKBS01".equals(number) && "BOC05".equals(type);
    }

    private boolean isBeiBePay(DynamicObject info) {
        DynamicObject payerAcctBank = info.getDynamicObject("payeracctbank");
        return payerAcctBank != null && (Boolean)payerAcctBank.get("issetbankinterface") != false && "bei".equalsIgnoreCase(info.getString("paymentchannel"));
    }

    private Boolean isCrossTranType(DynamicObject info) {
        DynamicObject dentify = info.getDynamicObject("paymentidentify");
        if (null != dentify && "0".equals(dentify.getString("type"))) {
            return false;
        }
        return true;
    }
}

