/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.ai.DapVoucherUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.fi.cas.business.errorcode.PaymentErrorCode;
import kd.fi.cas.business.journal.JournalServiceAdapter;
import kd.fi.cas.business.writeback.WriteBackValidateHelper;
import kd.fi.cas.business.writeback.consts.WriteBackOperateEnum;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.helper.CasBotpHelper;
import kd.fi.cas.helper.DraftHelper;
import kd.fi.cas.helper.PaymentBillPluginHelper;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.helper.TmcAppCache;
import kd.fi.cas.helper.VoucherBookHelper;
import kd.fi.cas.pojo.BotpBackValue;
import kd.fi.cas.util.EmptyUtil;

public class PaymentCancelPayNewValidator
extends AbstractValidator {
    private static final Log logger = LogFactory.getLog(PaymentCancelPayNewValidator.class);
    private JournalServiceAdapter journalServiceAdapter;
    private Map<Long, Set<Long>> payCdmPayMap;
    private Map<Long, Set<Long>> payCdmTranMap;
    private Map<Long, Set<Long>> payRecMap;
    public static final List<String> draftTypeList = Arrays.asList("2", "5", "6", "1");
    private Map<String, String> paramMap;

    public PaymentCancelPayNewValidator(JournalServiceAdapter journalServiceAdapter) {
        this.journalServiceAdapter = journalServiceAdapter;
    }

    public Map<Long, Set<Long>> getPayCdmPayMap() {
        return this.payCdmPayMap;
    }

    public Map<Long, Set<Long>> getPayCdmTranMap() {
        return this.payCdmTranMap;
    }

    public Map<Long, Set<Long>> getPayRecMap() {
        return this.payRecMap;
    }

    public void validate() {
        this.paramMap = this.getOption().getVariables();
        List<DynamicObject> payBills = Arrays.stream(this.dataEntities).map(ExtendedDataEntity::getDataEntity).collect(Collectors.toList());
        Long[] ids = (Long[])payBills.parallelStream().map(d -> d.getLong("id")).toArray(Long[]::new);
        HashSet orgIds = new HashSet();
        HashSet<Long> sourceIds = new HashSet<Long>();
        payBills.forEach(d -> {
            if (EmptyUtil.isNoEmpty((Long)d.getDynamicObject("org").getLong("id"))) {
                orgIds.add(d.getDynamicObject("org").getLong("id"));
            }
            if (EmptyUtil.isNoEmpty((DynamicObject)d.getDynamicObject("applyorg")) && "cas_paybill".equals(d.getString("sourcebilltype"))) {
                sourceIds.add(d.getLong("sourcebillid"));
            }
        });
        Map orgSysMap = SystemParameterHelper.getSystemParamsByOrgIds(new ArrayList(orgIds), (String)"cs116");
        Map<Long, DynamicObject> srcPayBillMap = PaymentCancelPayNewValidator.queryPushedBills(sourceIds, "cas_paybill", "isvoucher");
        Map<Long, DynamicObject> srcArBillMap = PaymentCancelPayNewValidator.queryPushedBills(sourceIds, "ar_finarbill", "org.name");
        Set<Long> dbIds = Arrays.stream(ids).collect(Collectors.toSet());
        Map<Long, DynamicObject> dbPayBillMap = PaymentCancelPayNewValidator.queryBillInfoFromDb(dbIds, "cas_paybill", "isvoucher");
        Map targetBillMap = BFTrackerServiceHelper.findTargetBills((String)"cas_paybill", (Long[])ids);
        this.filterTargetBill(targetBillMap, dbIds);
        List botpValues = CasBotpHelper.getDestBillBySrcBill((String)"cas_paybill", (Long[])ids);
        this.payRecMap = CasBotpHelper.getTargetBySourceBillIdMap((String)"cas_paybill", (String)"cas_recbill", Arrays.stream(ids).collect(Collectors.toSet()), (String)"sourcebilltype", (String)"sourcebillid");
        this.payCdmPayMap = this.convert2Map(botpValues, "cdm_payablebill");
        this.payCdmTranMap = this.convert2Map(botpValues, "cdm_drafttradebill");
        HashSet<Long> recIds = new HashSet<Long>();
        HashSet<Long> cdmPayIds = new HashSet<Long>();
        HashSet<Long> cdmTransIds = new HashSet<Long>();
        for (Map.Entry entry : targetBillMap.entrySet()) {
            String entryKey = (String)entry.getKey();
            HashSet targetIds = (HashSet)entry.getValue();
            if ("cas_recbill".equals(entryKey)) {
                recIds.addAll(targetIds);
                continue;
            }
            if ("cdm_payablebill".equals(entryKey)) {
                cdmPayIds.addAll(targetIds);
                continue;
            }
            if (!"cdm_drafttradebill".equals(entryKey)) continue;
            cdmTransIds.addAll(targetIds);
        }
        Map<Long, DynamicObject> recBillMap = PaymentCancelPayNewValidator.queryBillInfoFromDb(recIds, "cas_recbill", null);
        Map<Long, DynamicObject> cdmPayBillMap = PaymentCancelPayNewValidator.queryBillInfoFromDb(cdmPayIds, "cdm_payablebill", "source");
        Map<Long, DynamicObject> cdmDraftBillMap = PaymentCancelPayNewValidator.queryBillInfoFromDb(cdmTransIds, "cdm_drafttradebill", "source,sourcebillid");
        boolean isForBE = !EmptyUtil.isEmpty((String)this.paramMap.get("isBitBack")) && Boolean.parseBoolean(this.paramMap.get("isBitBack"));
        boolean isByfca = !EmptyUtil.isEmpty((String)this.paramMap.get("byfca")) && Boolean.parseBoolean(this.paramMap.get("byfca"));
        boolean isCasApp = "cas".equals(this.paramMap.get("app"));
        IAppCache iAppCache = TmcAppCache.get((String)"cas", (String)"cancelpay", (String)"valid");
        boolean isFromCdm = this.isFromCdm();
        PaymentErrorCode errorCode = new PaymentErrorCode();
        HashMap<Long, ExtendedDataEntity> idExtendedDataEntity = new HashMap<Long, ExtendedDataEntity>(this.dataEntities.length);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            Set voucherIds;
            boolean isPost;
            int cancelType;
            KDBizException e;
            DynamicObject info = dataEntity.getDataEntity();
            long id = info.getLong("id");
            idExtendedDataEntity.put(id, dataEntity);
            Long sourceId = info.getLong("sourcebillid");
            Long orgId = info.getDynamicObject("org").getLong("id");
            if (!isForBE) {
                if (!BillStatusEnum.PAY.getValue().equals(dbPayBillMap.get(id).getString("billstatus"))) {
                    KDBizException e2 = new KDBizException(errorCode.STATUS_CANNOT_CANCELPAY(), new Object[0]);
                    this.exceptionProcess(dataEntity, (Exception)((Object)e2), ErrorLevel.Error);
                    continue;
                }
                boolean iscommitbe = info.getBoolean("iscommitbe");
                String tmcBitBackFlag = (String)iAppCache.get(String.valueOf(id), String.class);
                if (iscommitbe && !"bei_bankpaybill".equals(tmcBitBackFlag) && PaymentBillPluginHelper.paymentIdentify((DynamicObject)info)) {
                    Object e3 = new KDBizException(errorCode.COMMITBE_CANNOT_CANCELPAY(), new Object[0]);
                    this.exceptionProcess(dataEntity, (Exception)e3, ErrorLevel.Error);
                    continue;
                }
            }
            if (EmptyUtil.isNoEmpty((Long)sourceId)) {
                boolean isvoucher;
                boolean bl = isvoucher = !EmptyUtil.isEmpty((DynamicObject)srcPayBillMap.get(sourceId)) && srcPayBillMap.get(sourceId).getBoolean("isvoucher");
                if (isvoucher) {
                    KDBizException e4 = new KDBizException(errorCode.VRRCBILL_CANNOT_CANCELPAY(), new Object[0]);
                    this.exceptionProcess(dataEntity, (Exception)((Object)e4), ErrorLevel.Error);
                    continue;
                }
            }
            DynamicObject settletype = info.getDynamicObject("settletype");
            Set<Long> rbIds = this.payRecMap.get(id);
            if (!DraftHelper.isSettlePromise((Object)settletype) && EmptyUtil.isNoEmpty(rbIds)) {
                for (Long recBillId : rbIds) {
                    DynamicObject recBill = recBillMap.get(recBillId);
                    if (!EmptyUtil.isNoEmpty((DynamicObject)recBill) || !BillStatusEnum.PAY.getValue().equals(recBill.getString("billstatus"))) continue;
                    e = new KDBizException(errorCode.DESTBILL_CANNOT_CANCELPAY(), new Object[0]);
                    this.exceptionProcess(dataEntity, (Exception)((Object)e), ErrorLevel.Error);
                }
            }
            Set<Long> cpIds = this.payCdmPayMap.get(id);
            Set<Long> ctIds = this.payCdmTranMap.get(id);
            if (!isFromCdm) {
                if (EmptyUtil.isNoEmpty(cpIds)) {
                    for (Long cdmPayId : cpIds) {
                        DynamicObject cdmPayBill = cdmPayBillMap.get(cdmPayId);
                        if (!EmptyUtil.isNoEmpty((DynamicObject)cdmPayBill) || BillStatusEnum.SAVE.getValue().equals(cdmPayBill.get("billstatus")) || BillStatusEnum.DEAD.getValue().equals(cdmPayBill.get("billstatus")) || !"cas".equals(cdmPayBill.getString("source"))) continue;
                        KDBizException e5 = new KDBizException(errorCode.CDM_CANNO_CANCEL(), new Object[0]);
                        this.exceptionProcess(dataEntity, (Exception)((Object)e5), ErrorLevel.Error);
                    }
                }
                if (EmptyUtil.isNoEmpty(ctIds)) {
                    for (Long cdmTranId : ctIds) {
                        Iterator tranbill = cdmDraftBillMap.get(cdmTranId);
                        if (!EmptyUtil.isNoEmpty((DynamicObject)tranbill) || BillStatusEnum.SAVE.getValue().equals(tranbill.getString("billstatus"))) continue;
                        String source = tranbill.getString("source");
                        long sourcebillid = tranbill.getLong("sourcebillid");
                        if (!"cas".equals(source) || id != sourcebillid) continue;
                        KDBizException e6 = new KDBizException(errorCode.CDM_CANNO_CANCELDRAFT(), new Object[0]);
                        this.exceptionProcess(dataEntity, (Exception)((Object)e6), ErrorLevel.Error);
                    }
                }
            }
            if (EmptyUtil.isNoEmpty((DynamicObject)settletype) && draftTypeList.contains(settletype.getString("settlementtype"))) {
                QFilter[] payOffFilters;
                boolean isPayOff;
                DynamicObjectCollection draftBills = info.getDynamicObjectCollection("draftbill");
                HashSet<Long> dataIds = new HashSet<Long>();
                for (DynamicObject draftBill : draftBills) {
                    DynamicObject data = draftBill.getDynamicObject("fbasedataid");
                    if (data == null || !"paybill".equals(data.getString("rptype")) || !"handregister".equals(data.getString("source"))) continue;
                    dataIds.add(data.getLong("id"));
                }
                if (dataIds.size() > 0 && (isPayOff = QueryServiceHelper.exists((String)"cdm_drafttradebill", (QFilter[])(payOffFilters = new QFilter[]{new QFilter("tradetype", "=", (Object)"payoff"), new QFilter("entrys.draftbill", "in", dataIds)})))) {
                    KDBizException e7 = new KDBizException(errorCode.CDM_CANNO_CANCEL(), new Object[0]);
                    this.exceptionProcess(dataEntity, (Exception)((Object)e7), ErrorLevel.Error);
                    continue;
                }
            }
            String sourcebilltype = info.getString("sourcebilltype");
            if (!isByfca) {
                if ("fca_transupbill".equals(sourcebilltype)) {
                    e = new KDBizException(ResManager.loadKDString((String)"\u4e0a\u5212\u5355\u751f\u6210\u7684\u4ed8\u6b3e\u5355\u4e0d\u5141\u8bb8\u53d6\u6d88\u4ed8\u6b3e\u3002", (String)"PaymentCancelPayImpl_0", (String)"fi-cas-business", (Object[])new Object[0]));
                    this.exceptionProcess(dataEntity, (Exception)((Object)e), ErrorLevel.Error);
                    continue;
                }
                if ("fca_transdownbill".equals(sourcebilltype)) {
                    e = new KDBizException(ResManager.loadKDString((String)"\u4e0b\u62e8\u5355\u751f\u6210\u7684\u4ed8\u6b3e\u5355\u4e0d\u5141\u8bb8\u53d6\u6d88\u4ed8\u6b3e\u3002", (String)"PaymentCancelPayImpl_6", (String)"fi-cas-business", (Object[])new Object[0]));
                    this.exceptionProcess(dataEntity, (Exception)((Object)e), ErrorLevel.Error);
                    continue;
                }
            }
            if (!isCasApp) {
                DynamicObject arBill;
                if (EmptyUtil.isNoEmpty((String)info.getString("entrustorg"))) {
                    e = new KDBizException(errorCode.WT_NOT_CANCELPAY(), new Object[0]);
                    this.exceptionProcess(dataEntity, (Exception)((Object)e), ErrorLevel.Error);
                }
                if (EmptyUtil.isNoEmpty((DynamicObject)(arBill = srcArBillMap.get(sourceId))) && !BillStatusEnum.SAVE.getValue().equals(arBill.getString("billstatus"))) {
                    String error = String.format(errorCode.ARBILL().getMessage(), info.get("billno"), arBill.get("org.name"), arBill.get("billno"), arBill.get("billno"));
                    KDBizException e8 = new KDBizException(new ErrorCode("AR_CANNOT_DEL", error), new Object[0]);
                    this.exceptionProcess(dataEntity, (Exception)((Object)e8), ErrorLevel.Error);
                    continue;
                }
            }
            int n = cancelType = EmptyUtil.isEmpty(orgSysMap.get(String.valueOf(orgId))) ? 0 : Integer.parseInt((String)orgSysMap.get(String.valueOf(orgId)));
            if (1 == cancelType && (isPost = VoucherBookHelper.checkVoucherIsPost((Set)(voucherIds = DapVoucherUtil.getBuildVch(Collections.singleton(id), (String)"cas_paybill"))))) {
                KDBizException e9 = new KDBizException(ResManager.loadKDString((String)"\u53d6\u6d88\u4ed8\u6b3e\u5931\u8d25\uff0c\u56e0\u4e3a\u53d6\u6d88\u4ed8\u6b3e\u65f6\u51b2\u9500\u51ed\u8bc1\u5931\u8d25\uff1a\u51ed\u8bc1\u4e0d\u662f\u5df2\u8fc7\u8d26\u72b6\u6001\u3002", (String)"PaymentCancelPayImpl_5", (String)"fi-cas-business", (Object[])new Object[0]));
                this.exceptionProcess(dataEntity, (Exception)((Object)e9), ErrorLevel.Error);
                continue;
            }
            String recMag = this.checkTargetBillStatus(info, this.payRecMap, recBillMap, isFromCdm);
            String cpMsg = this.checkTargetBillStatus(info, this.payCdmPayMap, cdmPayBillMap, isFromCdm);
            String ctMsg = this.checkTargetBillStatus(info, this.payCdmTranMap, cdmDraftBillMap, isFromCdm);
            if (EmptyUtil.isNoEmpty((String)recMag) || EmptyUtil.isNoEmpty((String)cpMsg) || EmptyUtil.isNoEmpty((String)ctMsg)) {
                String errorMsg = String.join((CharSequence)"", recMag, cpMsg, ctMsg);
                this.exceptionProcess(dataEntity, (Exception)((Object)new KDBizException(errorMsg)), ErrorLevel.Error);
                continue;
            }
            Object result = DispatchServiceHelper.invokeBizService((String)"fi", (String)"ap", (String)"AutoUnSettleValidate", (String)"unSettleValidate", (Object[])new Object[]{info});
            WriteBackValidateHelper.WriteBackResultDeal((DynamicObject)info, (Object)result, (String)sourcebilltype, (WriteBackOperateEnum)WriteBackOperateEnum.UNSETTLEVALIDATE);
        }
        Map billMap = payBills.parallelStream().collect(Collectors.toMap(d -> d.getLong("id"), Function.identity()));
        HashMap errorException = new HashMap(4);
        this.journalServiceAdapter.validateCancelBooks(billMap, errorException, new HashMap(), true);
        if (errorException.size() > 0) {
            for (Map.Entry exception : errorException.entrySet()) {
                Long id = (Long)exception.getKey();
                Exception error = (Exception)exception.getValue();
                if (!idExtendedDataEntity.containsKey(id)) continue;
                this.exceptionProcess((ExtendedDataEntity)idExtendedDataEntity.get(id), (Exception)((Object)new KDBizException(error.getMessage())), ErrorLevel.Error);
            }
        }
    }

    private Map<Long, Set<Long>> convert2Map(List<BotpBackValue> botpValues, String targetEntity) {
        HashMap<Long, Set<Long>> returns = new HashMap<Long, Set<Long>>(botpValues.size());
        for (BotpBackValue botpValue : botpValues) {
            if (!targetEntity.equalsIgnoreCase(botpValue.getTargetEntity())) continue;
            Set backs = returns.computeIfAbsent(botpValue.getSrcId(), k -> new HashSet(16));
            backs.addAll(botpValue.getTargetIds());
        }
        return returns;
    }

    private boolean isFromCdm() {
        if (this.paramMap.containsKey("isfrombill") && "y".equalsIgnoreCase(this.paramMap.get("isfrombill")) || this.paramMap.containsKey("invalidcdm") && "invalidcdm".equalsIgnoreCase(this.paramMap.get("invalidcdm"))) {
            logger.info("is from bill");
            return true;
        }
        logger.info("is not from bill");
        return false;
    }

    private static Map<Long, DynamicObject> queryBillInfoFromDb(Set<Long> ids, String entityKey, String otherFileds) {
        if (ids.size() > 0) {
            String fileds = EmptyUtil.isEmpty((String)otherFileds) ? "id,billno,billstatus" : "id,billno,billstatus," + otherFileds;
            DynamicObject[] list = BusinessDataServiceHelper.load((String)entityKey, (String)fileds, (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
            return Arrays.stream(list).collect(Collectors.toMap(d -> d.getLong("id"), Function.identity()));
        }
        return new HashMap<Long, DynamicObject>(0);
    }

    private static Map<Long, DynamicObject> queryPushedBills(Set<Long> sourceIds, String entityName, String otherFileds) {
        if (sourceIds.size() > 0) {
            DynamicObjectCollection list;
            String fileds;
            String string = fileds = EmptyUtil.isEmpty((String)otherFileds) ? "id,billno,billstatus" : "id,billno,billstatus," + otherFileds;
            if ("ar_finarbill".equals(entityName)) {
                Set sourceIdsStr = sourceIds.stream().map(String::valueOf).collect(Collectors.toSet());
                list = QueryServiceHelper.query((String)entityName, (String)fileds, (QFilter[])new QFilter[]{new QFilter("sourcebillid", "in", sourceIdsStr)});
            } else {
                list = QueryServiceHelper.query((String)entityName, (String)fileds, (QFilter[])new QFilter[]{new QFilter("sourcebillid", "in", sourceIds)});
            }
            return list.parallelStream().collect(Collectors.toMap(d -> d.getLong("id"), Function.identity()));
        }
        return new HashMap<Long, DynamicObject>(0);
    }

    private void filterTargetBill(Map<String, HashSet<Long>> payTarMap, Set<Long> ids) {
        DynamicObjectCollection list = QueryServiceHelper.query((String)"cdm_draftallocation", (String)"id,sourcebillid", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "in", ids)});
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)list)) {
            Object[] dlIds = (Long[])list.parallelStream().map(d -> d.getLong("id")).toArray(Long[]::new);
            Map dlTarIdMap = BFTrackerServiceHelper.findTargetBills((String)"cdm_draftallocation", (Long[])dlIds);
            for (Map.Entry<String, HashSet<Long>> payTarEntry : payTarMap.entrySet()) {
                String targetKey = payTarEntry.getKey();
                HashSet<Long> targetIds = payTarEntry.getValue();
                HashSet dlTargetIds = (HashSet)dlTarIdMap.get(targetKey);
                if (EmptyUtil.isEmpty((Collection)dlTargetIds)) continue;
                if (EmptyUtil.isNoEmpty((Object[])dlIds)) {
                    targetIds.removeAll(dlTargetIds);
                }
                if (!"cdm_draftallocation".equals(targetKey)) continue;
                targetIds.clear();
            }
        }
    }

    private String checkTargetBillStatus(DynamicObject info, Map<Long, Set<Long>> tarBillIdMap, Map<Long, DynamicObject> tarBillMap, boolean isFromCdm) {
        String checkMsg = "";
        if (EmptyUtil.isEmpty(tarBillIdMap) || EmptyUtil.isEmpty(tarBillMap) || isFromCdm) {
            logger.info("--->> tarBillIdMap:", (Object)(tarBillIdMap.size() + ";tarBillMap:" + tarBillMap.size() + ";isFromCdm:" + isFromCdm));
            return checkMsg;
        }
        String billno = info.getString("billno");
        String billTypeName = info.getDataEntityType().getDisplayName().getLocaleValue();
        logger.info("--->> checkTarBillStatus(): current billno[{}],this job start...", (Object)billno);
        Set<Long> tarBillIds = tarBillIdMap.get(info.getLong("id"));
        if (null == tarBillIds) {
            return checkMsg;
        }
        long id = info.getLong("id");
        for (Long tarId : tarBillIds) {
            DynamicObject targetBill = tarBillMap.get(tarId);
            if (!EmptyUtil.isNoEmpty((DynamicObject)targetBill) || BillStatusEnum.SAVE.getValue().equals(targetBill.getString("billstatus"))) continue;
            String dataType = targetBill.getDataEntityType().getName();
            boolean isDraftTradeBill = "cdm_drafttradebill".equalsIgnoreCase(dataType);
            if (isDraftTradeBill) {
                String source = targetBill.getString("source");
                long sourcebillid = targetBill.getLong("sourcebillid");
                if (!"cas".equals(source) || id != sourcebillid) continue;
                checkMsg = String.format(ResManager.loadKDString((String)"\u7531%1$s%2$s\u751f\u6210\u7684%3$s%4$s\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"ValidateReclateOperation_0", (String)"fi-cas-business", (Object[])new Object[0]), billno, billTypeName, targetBill.getString("billno"), targetBill.getDataEntityType().getDisplayName().getLocaleValue());
                break;
            }
            checkMsg = String.format(ResManager.loadKDString((String)"\u7531%1$s%2$s\u751f\u6210\u7684%3$s%4$s\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"ValidateReclateOperation_0", (String)"fi-cas-business", (Object[])new Object[0]), billno, billTypeName, targetBill.getString("billno"), targetBill.getDataEntityType().getDisplayName().getLocaleValue());
            break;
        }
        return checkMsg;
    }

    protected void exceptionProcess(ExtendedDataEntity dataEntity, Exception e, ErrorLevel error) {
        this.addMessage(dataEntity, e.getMessage(), error);
        this.getValidateResult().setSuccess(false);
    }
}

